
/* 
 * 
 * generator:   org.molgenis.generators.db.EntitiesImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
package org.molgenis;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.EntitiesImporter;
import org.molgenis.framework.db.EntityImportReport;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.TableReader;
import org.molgenis.io.TableReaderFactory;
import org.molgenis.io.TupleReader;

import org.molgenis.omx.core.db.MolgenisFileEntityImporter;
import org.molgenis.omx.core.db.RuntimePropertyEntityImporter;
import org.molgenis.omx.observ.db.CharacteristicEntityImporter;
import org.molgenis.omx.observ.db.ObservationTargetEntityImporter;
import org.molgenis.omx.observ.target.db.IndividualEntityImporter;
import org.molgenis.omx.observ.target.db.OntologyEntityImporter;
import org.molgenis.omx.observ.target.db.SpeciesEntityImporter;
import org.molgenis.omx.observ.target.db.OntologyTermEntityImporter;
import org.molgenis.omx.observ.target.db.AccessionEntityImporter;
import org.molgenis.omx.observ.value.db.ValueEntityImporter;
import org.molgenis.omx.observ.value.db.BoolValueEntityImporter;
import org.molgenis.omx.observ.value.db.DateValueEntityImporter;
import org.molgenis.omx.observ.value.db.DateTimeValueEntityImporter;
import org.molgenis.omx.observ.value.db.DecimalValueEntityImporter;
import org.molgenis.omx.observ.value.db.EmailValueEntityImporter;
import org.molgenis.omx.observ.value.db.HtmlValueEntityImporter;
import org.molgenis.omx.observ.value.db.HyperlinkValueEntityImporter;
import org.molgenis.omx.observ.value.db.IntValueEntityImporter;
import org.molgenis.omx.observ.value.db.LongValueEntityImporter;
import org.molgenis.omx.observ.value.db.MrefValueEntityImporter;
import org.molgenis.omx.observ.value.db.StringValueEntityImporter;
import org.molgenis.omx.observ.value.db.TextValueEntityImporter;
import org.molgenis.omx.auth.db.PersonRoleEntityImporter;
import org.molgenis.omx.observ.db.ObservableFeatureEntityImporter;
import org.molgenis.omx.observ.db.CategoryEntityImporter;
import org.molgenis.omx.observ.db.ProtocolEntityImporter;
import org.molgenis.omx.observ.db.DataSetEntityImporter;
import org.molgenis.omx.observ.db.ObservationSetEntityImporter;
import org.molgenis.omx.observ.target.db.PanelEntityImporter;
import org.molgenis.omx.observ.target.db.PanelSourceEntityImporter;
import org.molgenis.omx.observ.value.db.CategoricalValueEntityImporter;
import org.molgenis.omx.auth.db.InstituteEntityImporter;
import org.molgenis.omx.auth.db.PersonEntityImporter;
import org.molgenis.omx.observ.value.db.XrefValueEntityImporter;
import org.molgenis.omx.observ.db.ObservedValueEntityImporter;
import org.molgenis.omx.filter.db.StudyDataRequestEntityImporter;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EntitiesImporterImpl implements EntitiesImporter
{
	/** importable entity names (lowercase) */
	private static final Map<String, EntityImporter> ENTITIES_IMPORTABLE;
	
	static {
		// entities added in import order
		ENTITIES_IMPORTABLE = new LinkedHashMap<String, EntityImporter>();
		ENTITIES_IMPORTABLE.put("molgenisfile", new MolgenisFileEntityImporter());
		ENTITIES_IMPORTABLE.put("runtimeproperty", new RuntimePropertyEntityImporter());
		ENTITIES_IMPORTABLE.put("characteristic", new CharacteristicEntityImporter());
		ENTITIES_IMPORTABLE.put("observationtarget", new ObservationTargetEntityImporter());
		ENTITIES_IMPORTABLE.put("individual", new IndividualEntityImporter());
		ENTITIES_IMPORTABLE.put("ontology", new OntologyEntityImporter());
		ENTITIES_IMPORTABLE.put("species", new SpeciesEntityImporter());
		ENTITIES_IMPORTABLE.put("ontologyterm", new OntologyTermEntityImporter());
		ENTITIES_IMPORTABLE.put("accession", new AccessionEntityImporter());
		ENTITIES_IMPORTABLE.put("value", new ValueEntityImporter());
		ENTITIES_IMPORTABLE.put("boolvalue", new BoolValueEntityImporter());
		ENTITIES_IMPORTABLE.put("datevalue", new DateValueEntityImporter());
		ENTITIES_IMPORTABLE.put("datetimevalue", new DateTimeValueEntityImporter());
		ENTITIES_IMPORTABLE.put("decimalvalue", new DecimalValueEntityImporter());
		ENTITIES_IMPORTABLE.put("emailvalue", new EmailValueEntityImporter());
		ENTITIES_IMPORTABLE.put("htmlvalue", new HtmlValueEntityImporter());
		ENTITIES_IMPORTABLE.put("hyperlinkvalue", new HyperlinkValueEntityImporter());
		ENTITIES_IMPORTABLE.put("intvalue", new IntValueEntityImporter());
		ENTITIES_IMPORTABLE.put("longvalue", new LongValueEntityImporter());
		ENTITIES_IMPORTABLE.put("mrefvalue", new MrefValueEntityImporter());
		ENTITIES_IMPORTABLE.put("stringvalue", new StringValueEntityImporter());
		ENTITIES_IMPORTABLE.put("textvalue", new TextValueEntityImporter());
		ENTITIES_IMPORTABLE.put("personrole", new PersonRoleEntityImporter());
		ENTITIES_IMPORTABLE.put("observablefeature", new ObservableFeatureEntityImporter());
		ENTITIES_IMPORTABLE.put("category", new CategoryEntityImporter());
		ENTITIES_IMPORTABLE.put("protocol", new ProtocolEntityImporter());
		ENTITIES_IMPORTABLE.put("dataset", new DataSetEntityImporter());
		ENTITIES_IMPORTABLE.put("observationset", new ObservationSetEntityImporter());
		ENTITIES_IMPORTABLE.put("panel", new PanelEntityImporter());
		ENTITIES_IMPORTABLE.put("panelsource", new PanelSourceEntityImporter());
		ENTITIES_IMPORTABLE.put("categoricalvalue", new CategoricalValueEntityImporter());
		ENTITIES_IMPORTABLE.put("institute", new InstituteEntityImporter());
		ENTITIES_IMPORTABLE.put("person", new PersonEntityImporter());
		ENTITIES_IMPORTABLE.put("xrefvalue", new XrefValueEntityImporter());
		ENTITIES_IMPORTABLE.put("observedvalue", new ObservedValueEntityImporter());
		ENTITIES_IMPORTABLE.put("studydatarequest", new StudyDataRequestEntityImporter());
	}
	
	private Database database;
	
	@Autowired
	public EntitiesImporterImpl(Database database)
	{
		if (database == null) throw new IllegalArgumentException("database is null");
		this.database = database;
	}
	
	@Override
	public EntityImportReport importEntities(File file, DatabaseAction dbAction) throws IOException, DatabaseException
	{
		return importEntities(TableReaderFactory.create(file), dbAction);
	}

	@Override
	public EntityImportReport importEntities(List<File> files, DatabaseAction dbAction) throws IOException,
			DatabaseException
	{
		return importEntities(TableReaderFactory.create(files), dbAction);
	}
	
	@Override
	public EntityImportReport importEntities(TupleReader tupleReader, String entityName, DatabaseAction dbAction) throws IOException, DatabaseException
	{
		final TupleReader reader = tupleReader;
		final String name = entityName;
		return importEntities(new TableReader()
		{
			@Override
			public Iterator<TupleReader> iterator()
			{
				return Collections.singletonList(reader).iterator();
			}

			@Override
			public void close() throws IOException
			{
				reader.close();
			}

			@Override
			public TupleReader getTupleReader(String tableName) throws IOException
			{
				return name.equals(tableName) ? reader : null;
			}

			@Override
			public Iterable<String> getTableNames() throws IOException
			{
				return Collections.singletonList(name);
			}
		}, dbAction);
	}
		
	@Override	
	public EntityImportReport importEntities(TableReader tableReader, DatabaseAction dbAction) throws IOException,
			DatabaseException
	{
		EntityImportReport importReport = new EntityImportReport();

		boolean doTx = !database.inTx();
		try
		{
			// map entity names on tuple readers
			Map<String, TupleReader> tupleReaderMap = new HashMap<String, TupleReader>();
			for (String tableName : tableReader.getTableNames())
			{
				tupleReaderMap.put(tableName.toLowerCase(), tableReader.getTupleReader(tableName));
			}

			if (doTx) database.beginTx();

			// import entities in order defined by entities map
			for (Map.Entry<String, EntityImporter> entry : ENTITIES_IMPORTABLE.entrySet())
			{
				String entityName = entry.getKey();
				TupleReader tupleReader = tupleReaderMap.get(entityName);
				if (tupleReader != null)
				{
					EntityImporter entityImporter = entry.getValue();
					int nr = entityImporter.importEntity(tupleReader, database, dbAction);
					if (nr > 0) {
						importReport.getMessages().put(entry.getKey(), "imported " + nr + " " + entityName + " entities");
						importReport.addNrImported(nr);
					}
				}
			}
			if (doTx) database.commitTx();
		}
		catch (IOException e)
		{
			if (doTx) database.rollbackTx();
			throw e;
		}
		catch (DatabaseException e)
		{
			if (doTx) database.rollbackTx();
			throw e;
		}
		finally
		{
			tableReader.close();
		}
		return importReport;
	}
}