/*
 * Created by: org.molgenis.generators.server.MolgenisGuiServiceGen
 * Date: August 21, 2013
 */

package org.molgenis.servlet;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.server.MolgenisContext;
import org.molgenis.framework.server.MolgenisService;
import org.molgenis.framework.server.MolgenisSettings;
import org.molgenis.framework.server.services.MolgenisGuiService;
import org.molgenis.framework.ui.ApplicationController;
import org.molgenis.util.ApplicationContextProvider;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class GuiService extends MolgenisGuiService implements MolgenisService
{
	private static final Logger logger = Logger.getLogger(GuiService.class);
	
	public static final String KEY_APP_NAME = "app.name";

	public GuiService(MolgenisContext mc)
	{
		super(mc);
	}

	@Override
	public ApplicationController createUserInterface()
	{
		ApplicationController app = null;
		try {
			final Database dbForController = super.db;
			app = new ApplicationController(mc)
			{
				private static final long serialVersionUID = 1L;
							
				@Override
				public Database getDatabase()
				{
					return dbForController;
				}
			};

			String appLabel;
			try
			{
				MolgenisSettings molgenisSettings = ApplicationContextProvider.getApplicationContext().getBean(MolgenisSettings.class);
				appLabel = molgenisSettings.getProperty(KEY_APP_NAME, "Molgenis");
			} 
			catch(NoSuchBeanDefinitionException e)
			{
				logger.warn(e);
				appLabel = "Molgenis";
			}
			app.getModel().setLabel(appLabel);		
			app.getModel().setVersion("4.0.0-testing");
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		new org.molgenis.ui.HeaderPluginPlugin(app);
		new org.molgenis.ui.MainMenu(app);
		return app;
	}
}
