
/* 
 * 
 * generator:   org.molgenis.generators.csv.CsvEntityExporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
package org.molgenis;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Query;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.io.csv.CsvWriter;
import org.molgenis.model.MolgenisModelException;
import org.molgenis.util.Entity;
import org.molgenis.util.tuple.EntityTuple;

import org.molgenis.omx.core.MolgenisEntity;
import org.molgenis.omx.core.MolgenisFile;
import org.molgenis.omx.core.RuntimeProperty;
import org.molgenis.omx.observ.Characteristic;
import org.molgenis.omx.observ.ObservationTarget;
import org.molgenis.omx.observ.target.Individual;
import org.molgenis.omx.observ.target.Ontology;
import org.molgenis.omx.observ.target.Species;
import org.molgenis.omx.observ.target.OntologyTerm;
import org.molgenis.omx.observ.target.Accession;
import org.molgenis.omx.observ.value.Value;
import org.molgenis.omx.observ.value.BoolValue;
import org.molgenis.omx.observ.value.DateValue;
import org.molgenis.omx.observ.value.DateTimeValue;
import org.molgenis.omx.observ.value.DecimalValue;
import org.molgenis.omx.observ.value.EmailValue;
import org.molgenis.omx.observ.value.HtmlValue;
import org.molgenis.omx.observ.value.HyperlinkValue;
import org.molgenis.omx.observ.value.IntValue;
import org.molgenis.omx.observ.value.LongValue;
import org.molgenis.omx.observ.value.MrefValue;
import org.molgenis.omx.observ.value.StringValue;
import org.molgenis.omx.observ.value.TextValue;
import org.molgenis.omx.auth.MolgenisRole;
import org.molgenis.omx.auth.MolgenisGroup;
import org.molgenis.omx.auth.PersonRole;
import org.molgenis.omx.observ.ObservableFeature;
import org.molgenis.omx.observ.Category;
import org.molgenis.omx.observ.Protocol;
import org.molgenis.omx.observ.DataSet;
import org.molgenis.omx.observ.ObservationSet;
import org.molgenis.omx.observ.target.Panel;
import org.molgenis.omx.observ.target.PanelSource;
import org.molgenis.omx.observ.value.CategoricalValue;
import org.molgenis.omx.auth.Institute;
import org.molgenis.omx.auth.Person;
import org.molgenis.omx.observ.value.XrefValue;
import org.molgenis.omx.observ.ObservedValue;
import org.molgenis.omx.auth.MolgenisUser;
import org.molgenis.omx.auth.MolgenisRoleGroupLink;
import org.molgenis.omx.auth.MolgenisPermission;
import org.molgenis.omx.study.StudyDataRequest;

public class CsvEntityExporter
{
	private static final Logger logger = Logger.getLogger(CsvEntityExporter.class);
		
	/**
	 * Default export all using a target directory and a database to export
	 * @param directory
	 * @param db
	 * @throws Exception
	 */
	public void exportAll(File directory, Database db) throws Exception
	{
		exportAll(directory, db, true, new QueryRule[]{});
	}
	
	/**
	 * Export all using a set of QueryRules used for all entities if applicable to that entity
	 * @param directory
	 * @param db
	 * @param rules
	 * @throws Exception
	 */
	public void exportAll(File directory, Database db, QueryRule ... rules) throws Exception
	{
		exportAll(directory, db, true, rules);
	}
	
	/**
	 * Export all where a boolean skip autoid fields forces an ignore of the auto id field ("id")
	 * @param directory
	 * @param db
	 * @param skipAutoId
	 * @throws Exception
	 */
	public void exportAll(File directory, Database db, boolean skipAutoId) throws Exception
	{
		exportAll(directory, db, skipAutoId, new QueryRule[]{});
	}
	
	/**
	 * Export all with both a boolean skipAutoId and a set of QueryRules to specify both the skipping of auto id, and applying of a filter
	 * @param directory
	 * @param db
	 * @param skipAutoId
	 * @param rules
	 * @throws Exception
	 */
	public void exportAll(File directory, Database db, boolean skipAutoId, QueryRule ... rules) throws Exception
	{				
		exportMolgenisEntity(db, new File(directory+"/molgenisentity.txt"), skipAutoId ? Arrays.asList(new String[]{"name","type_","className"}) : null, rules);		
		exportMolgenisFile(db, new File(directory+"/molgenisfile.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","Extension"}) : null, rules);		
		exportRuntimeProperty(db, new File(directory+"/runtimeproperty.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","Value"}) : null, rules);		
		exportCharacteristic(db, new File(directory+"/characteristic.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description"}) : null, rules);		
		exportObservationTarget(db, new File(directory+"/observationtarget.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description"}) : null, rules);		
		exportIndividual(db, new File(directory+"/individual.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description","Mother_Identifier","Father_Identifier"}) : null, rules);		
		exportOntology(db, new File(directory+"/ontology.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","ontologyAccession","ontologyURI"}) : null, rules);		
		exportSpecies(db, new File(directory+"/species.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description","ontology_Identifier","termAccession","definition"}) : null, rules);		
		exportOntologyTerm(db, new File(directory+"/ontologyterm.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description","ontology_Identifier","termAccession","definition"}) : null, rules);		
		exportAccession(db, new File(directory+"/accession.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description","ontology_Identifier","termAccession","definition"}) : null, rules);		
		exportValue(db, new File(directory+"/value.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type"}) : null, rules);		
		exportBoolValue(db, new File(directory+"/boolvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value"}) : null, rules);		
		exportDateValue(db, new File(directory+"/datevalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value"}) : null, rules);		
		exportDateTimeValue(db, new File(directory+"/datetimevalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value"}) : null, rules);		
		exportDecimalValue(db, new File(directory+"/decimalvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value"}) : null, rules);		
		exportEmailValue(db, new File(directory+"/emailvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value"}) : null, rules);		
		exportHtmlValue(db, new File(directory+"/htmlvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value"}) : null, rules);		
		exportHyperlinkValue(db, new File(directory+"/hyperlinkvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value"}) : null, rules);		
		exportIntValue(db, new File(directory+"/intvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value"}) : null, rules);		
		exportLongValue(db, new File(directory+"/longvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value"}) : null, rules);		
		exportMrefValue(db, new File(directory+"/mrefvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value_Identifier"}) : null, rules);		
		exportStringValue(db, new File(directory+"/stringvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value"}) : null, rules);		
		exportTextValue(db, new File(directory+"/textvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value"}) : null, rules);		
		exportMolgenisRole(db, new File(directory+"/molgenisrole.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type"}) : null, rules);		
		exportMolgenisGroup(db, new File(directory+"/molgenisgroup.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type"}) : null, rules);		
		exportPersonRole(db, new File(directory+"/personrole.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description","ontology_Identifier","termAccession","definition"}) : null, rules);		
		exportObservableFeature(db, new File(directory+"/observablefeature.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description","unit_Identifier","definition_Identifier","dataType","temporal"}) : null, rules);		
		exportCategory(db, new File(directory+"/category.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description","observableFeature_Identifier","valueCode","definition_Identifier","isMissing"}) : null, rules);		
		exportProtocol(db, new File(directory+"/protocol.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description","ProtocolType_Identifier","subprotocols_Identifier","Features_Identifier"}) : null, rules);		
		exportDataSet(db, new File(directory+"/dataset.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description","ProtocolUsed_Identifier","startTime","endTime","active"}) : null, rules);		
		exportObservationSet(db, new File(directory+"/observationset.txt"), skipAutoId ? Arrays.asList(new String[]{"partOfDataSet_Identifier","Time"}) : null, rules);		
		exportPanel(db, new File(directory+"/panel.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description","PanelType_Identifier","NumberOfIndividuals","Species_Identifier","Individuals_Identifier"}) : null, rules);		
		exportPanelSource(db, new File(directory+"/panelsource.txt"), skipAutoId ? Arrays.asList(new String[]{"CurrentPanel_Identifier","SourcePanel_Identifier","NumberOfIndividuals","SelectionCriteria"}) : null, rules);		
		exportCategoricalValue(db, new File(directory+"/categoricalvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value_Identifier"}) : null, rules);		
		exportInstitute(db, new File(directory+"/institute.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description","Address","Phone","Email","Fax","tollFreePhone","City","Country"}) : null, rules);		
		exportPerson(db, new File(directory+"/person.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description","Address","Phone","Email","Fax","tollFreePhone","City","Country","FirstName","MidInitials","LastName","Title","Affiliation_Name","Department","Roles_Identifier"}) : null, rules);		
		exportXrefValue(db, new File(directory+"/xrefvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value_Identifier"}) : null, rules);		
		exportObservedValue(db, new File(directory+"/observedvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"ObservationSet_id","Feature_Identifier","Value_id"}) : null, rules);		
		exportMolgenisUser(db, new File(directory+"/molgenisuser.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","Address","Phone","Email","Fax","tollFreePhone","City","Country","FirstName","MidInitials","LastName","Title","Affiliation_Name","Department","Roles_Identifier","password_","activationCode","active","superuser"}) : null, rules);		
		exportMolgenisRoleGroupLink(db, new File(directory+"/molgenisrolegrouplink.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","group__Name","role__Name"}) : null, rules);		
		exportMolgenisPermission(db, new File(directory+"/molgenispermission.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","role__Name","entity_className","permission"}) : null, rules);		
		exportStudyDataRequest(db, new File(directory+"/studydatarequest.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","RequestForm","Features_Identifier","DataSet_Identifier","MolgenisUser_Name","RequestDate","RequestStatus"}) : null, rules);		
			
		logger.debug("done");
	}
	
   /**
	* Export without system tables.
	*/
	public void exportRegular(File directory, Database db, boolean skipAutoId) throws Exception
	{
		exportRegular(directory, db, skipAutoId, new QueryRule[]{});
	}
	
   /**
	* Export without system tables.
	*/
	public void exportRegular(File directory, Database db, boolean skipAutoId, QueryRule ... rules) throws Exception
	{				
		exportMolgenisFile(db, new File(directory+"/molgenisfile.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","Extension"}) : null, rules);		
		exportRuntimeProperty(db, new File(directory+"/runtimeproperty.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","Value"}) : null, rules);		
		exportCharacteristic(db, new File(directory+"/characteristic.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description"}) : null, rules);		
		exportObservationTarget(db, new File(directory+"/observationtarget.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description"}) : null, rules);		
		exportIndividual(db, new File(directory+"/individual.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description","Mother_Identifier","Father_Identifier"}) : null, rules);		
		exportOntology(db, new File(directory+"/ontology.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","ontologyAccession","ontologyURI"}) : null, rules);		
		exportSpecies(db, new File(directory+"/species.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description","ontology_Identifier","termAccession","definition"}) : null, rules);		
		exportOntologyTerm(db, new File(directory+"/ontologyterm.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description","ontology_Identifier","termAccession","definition"}) : null, rules);		
		exportAccession(db, new File(directory+"/accession.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description","ontology_Identifier","termAccession","definition"}) : null, rules);		
		exportValue(db, new File(directory+"/value.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type"}) : null, rules);		
		exportBoolValue(db, new File(directory+"/boolvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value"}) : null, rules);		
		exportDateValue(db, new File(directory+"/datevalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value"}) : null, rules);		
		exportDateTimeValue(db, new File(directory+"/datetimevalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value"}) : null, rules);		
		exportDecimalValue(db, new File(directory+"/decimalvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value"}) : null, rules);		
		exportEmailValue(db, new File(directory+"/emailvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value"}) : null, rules);		
		exportHtmlValue(db, new File(directory+"/htmlvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value"}) : null, rules);		
		exportHyperlinkValue(db, new File(directory+"/hyperlinkvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value"}) : null, rules);		
		exportIntValue(db, new File(directory+"/intvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value"}) : null, rules);		
		exportLongValue(db, new File(directory+"/longvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value"}) : null, rules);		
		exportMrefValue(db, new File(directory+"/mrefvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value_Identifier"}) : null, rules);		
		exportStringValue(db, new File(directory+"/stringvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value"}) : null, rules);		
		exportTextValue(db, new File(directory+"/textvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value"}) : null, rules);		
		exportPersonRole(db, new File(directory+"/personrole.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description","ontology_Identifier","termAccession","definition"}) : null, rules);		
		exportObservableFeature(db, new File(directory+"/observablefeature.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description","unit_Identifier","definition_Identifier","dataType","temporal"}) : null, rules);		
		exportCategory(db, new File(directory+"/category.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description","observableFeature_Identifier","valueCode","definition_Identifier","isMissing"}) : null, rules);		
		exportProtocol(db, new File(directory+"/protocol.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description","ProtocolType_Identifier","subprotocols_Identifier","Features_Identifier"}) : null, rules);		
		exportDataSet(db, new File(directory+"/dataset.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description","ProtocolUsed_Identifier","startTime","endTime","active"}) : null, rules);		
		exportObservationSet(db, new File(directory+"/observationset.txt"), skipAutoId ? Arrays.asList(new String[]{"partOfDataSet_Identifier","Time"}) : null, rules);		
		exportPanel(db, new File(directory+"/panel.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description","PanelType_Identifier","NumberOfIndividuals","Species_Identifier","Individuals_Identifier"}) : null, rules);		
		exportPanelSource(db, new File(directory+"/panelsource.txt"), skipAutoId ? Arrays.asList(new String[]{"CurrentPanel_Identifier","SourcePanel_Identifier","NumberOfIndividuals","SelectionCriteria"}) : null, rules);		
		exportCategoricalValue(db, new File(directory+"/categoricalvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value_Identifier"}) : null, rules);		
		exportInstitute(db, new File(directory+"/institute.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description","Address","Phone","Email","Fax","tollFreePhone","City","Country"}) : null, rules);		
		exportPerson(db, new File(directory+"/person.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description","Address","Phone","Email","Fax","tollFreePhone","City","Country","FirstName","MidInitials","LastName","Title","Affiliation_Name","Department","Roles_Identifier"}) : null, rules);		
		exportXrefValue(db, new File(directory+"/xrefvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value_Identifier"}) : null, rules);		
		exportObservedValue(db, new File(directory+"/observedvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"ObservationSet_id","Feature_Identifier","Value_id"}) : null, rules);		
		exportStudyDataRequest(db, new File(directory+"/studydatarequest.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","RequestForm","Features_Identifier","DataSet_Identifier","MolgenisUser_Name","RequestDate","RequestStatus"}) : null, rules);		
			
		logger.debug("done");
	}
	
	public void exportAll(File directory, List<? extends Entity> ... entityLists) throws Exception
	{				
		for(List<? extends Entity> l: entityLists) if(l.size()>0)
		{
			if(l.get(0).getClass().equals(MolgenisEntity.class))
				exportMolgenisEntity(l, new File(directory+"/molgenisentity.txt"));		
			if(l.get(0).getClass().equals(MolgenisFile.class))
				exportMolgenisFile(l, new File(directory+"/molgenisfile.txt"));		
			if(l.get(0).getClass().equals(RuntimeProperty.class))
				exportRuntimeProperty(l, new File(directory+"/runtimeproperty.txt"));		
			if(l.get(0).getClass().equals(Characteristic.class))
				exportCharacteristic(l, new File(directory+"/characteristic.txt"));		
			if(l.get(0).getClass().equals(ObservationTarget.class))
				exportObservationTarget(l, new File(directory+"/observationtarget.txt"));		
			if(l.get(0).getClass().equals(Individual.class))
				exportIndividual(l, new File(directory+"/individual.txt"));		
			if(l.get(0).getClass().equals(Ontology.class))
				exportOntology(l, new File(directory+"/ontology.txt"));		
			if(l.get(0).getClass().equals(Species.class))
				exportSpecies(l, new File(directory+"/species.txt"));		
			if(l.get(0).getClass().equals(OntologyTerm.class))
				exportOntologyTerm(l, new File(directory+"/ontologyterm.txt"));		
			if(l.get(0).getClass().equals(Accession.class))
				exportAccession(l, new File(directory+"/accession.txt"));		
			if(l.get(0).getClass().equals(Value.class))
				exportValue(l, new File(directory+"/value.txt"));		
			if(l.get(0).getClass().equals(BoolValue.class))
				exportBoolValue(l, new File(directory+"/boolvalue.txt"));		
			if(l.get(0).getClass().equals(DateValue.class))
				exportDateValue(l, new File(directory+"/datevalue.txt"));		
			if(l.get(0).getClass().equals(DateTimeValue.class))
				exportDateTimeValue(l, new File(directory+"/datetimevalue.txt"));		
			if(l.get(0).getClass().equals(DecimalValue.class))
				exportDecimalValue(l, new File(directory+"/decimalvalue.txt"));		
			if(l.get(0).getClass().equals(EmailValue.class))
				exportEmailValue(l, new File(directory+"/emailvalue.txt"));		
			if(l.get(0).getClass().equals(HtmlValue.class))
				exportHtmlValue(l, new File(directory+"/htmlvalue.txt"));		
			if(l.get(0).getClass().equals(HyperlinkValue.class))
				exportHyperlinkValue(l, new File(directory+"/hyperlinkvalue.txt"));		
			if(l.get(0).getClass().equals(IntValue.class))
				exportIntValue(l, new File(directory+"/intvalue.txt"));		
			if(l.get(0).getClass().equals(LongValue.class))
				exportLongValue(l, new File(directory+"/longvalue.txt"));		
			if(l.get(0).getClass().equals(MrefValue.class))
				exportMrefValue(l, new File(directory+"/mrefvalue.txt"));		
			if(l.get(0).getClass().equals(StringValue.class))
				exportStringValue(l, new File(directory+"/stringvalue.txt"));		
			if(l.get(0).getClass().equals(TextValue.class))
				exportTextValue(l, new File(directory+"/textvalue.txt"));		
			if(l.get(0).getClass().equals(MolgenisRole.class))
				exportMolgenisRole(l, new File(directory+"/molgenisrole.txt"));		
			if(l.get(0).getClass().equals(MolgenisGroup.class))
				exportMolgenisGroup(l, new File(directory+"/molgenisgroup.txt"));		
			if(l.get(0).getClass().equals(PersonRole.class))
				exportPersonRole(l, new File(directory+"/personrole.txt"));		
			if(l.get(0).getClass().equals(ObservableFeature.class))
				exportObservableFeature(l, new File(directory+"/observablefeature.txt"));		
			if(l.get(0).getClass().equals(Category.class))
				exportCategory(l, new File(directory+"/category.txt"));		
			if(l.get(0).getClass().equals(Protocol.class))
				exportProtocol(l, new File(directory+"/protocol.txt"));		
			if(l.get(0).getClass().equals(DataSet.class))
				exportDataSet(l, new File(directory+"/dataset.txt"));		
			if(l.get(0).getClass().equals(ObservationSet.class))
				exportObservationSet(l, new File(directory+"/observationset.txt"));		
			if(l.get(0).getClass().equals(Panel.class))
				exportPanel(l, new File(directory+"/panel.txt"));		
			if(l.get(0).getClass().equals(PanelSource.class))
				exportPanelSource(l, new File(directory+"/panelsource.txt"));		
			if(l.get(0).getClass().equals(CategoricalValue.class))
				exportCategoricalValue(l, new File(directory+"/categoricalvalue.txt"));		
			if(l.get(0).getClass().equals(Institute.class))
				exportInstitute(l, new File(directory+"/institute.txt"));		
			if(l.get(0).getClass().equals(Person.class))
				exportPerson(l, new File(directory+"/person.txt"));		
			if(l.get(0).getClass().equals(XrefValue.class))
				exportXrefValue(l, new File(directory+"/xrefvalue.txt"));		
			if(l.get(0).getClass().equals(ObservedValue.class))
				exportObservedValue(l, new File(directory+"/observedvalue.txt"));		
			if(l.get(0).getClass().equals(MolgenisUser.class))
				exportMolgenisUser(l, new File(directory+"/molgenisuser.txt"));		
			if(l.get(0).getClass().equals(MolgenisRoleGroupLink.class))
				exportMolgenisRoleGroupLink(l, new File(directory+"/molgenisrolegrouplink.txt"));		
			if(l.get(0).getClass().equals(MolgenisPermission.class))
				exportMolgenisPermission(l, new File(directory+"/molgenispermission.txt"));		
			if(l.get(0).getClass().equals(StudyDataRequest.class))
				exportStudyDataRequest(l, new File(directory+"/studydatarequest.txt"));		
		}
			
		logger.debug("done");
	}
	
	/**
	* Export while excluding or including certain entity types. Defaults set: skip autoId, no QueryRules.
	* If exclusion is set to true, the specialCases are used to exlude those entities from the export (entities not in list are exported).
	* If exclusion is set to false, the specialCases are used to include those entities in the export (only entities in list are exported).
	*/
	public void exportSpecial(File directory, Database db, List<Class<? extends Entity>> specialCases, boolean exclusion) throws Exception
	{
		exportSpecial(directory, db, true, specialCases, exclusion, new QueryRule[]{});
	}
	
	/**
	* Export while excluding or including certain entity types.
	* If exclusion is set to true, the specialCases are used to exlude those entities from the export (entities not in list are exported).
	* If exclusion is set to false, the specialCases are used to include those entities in the export (only entities in list are exported).
	* TODO: Could maybe replace exportAll(File directory, List ... entityLists) ?
	*/
	public void exportSpecial(File directory, Database db, boolean skipAutoId, List<Class<? extends Entity>> specialCases, boolean exclusion, QueryRule ... rules) throws Exception
	{
		if((exclusion && !specialCases.contains(MolgenisEntity.class)) || (!exclusion && specialCases.contains(MolgenisEntity.class)))
			{ exportMolgenisEntity(db, new File(directory+"/molgenisentity.txt"), skipAutoId ? Arrays.asList(new String[]{"name","type_","className"}) : null, rules); }
		if((exclusion && !specialCases.contains(MolgenisFile.class)) || (!exclusion && specialCases.contains(MolgenisFile.class)))
			{ exportMolgenisFile(db, new File(directory+"/molgenisfile.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","Extension"}) : null, rules); }
		if((exclusion && !specialCases.contains(RuntimeProperty.class)) || (!exclusion && specialCases.contains(RuntimeProperty.class)))
			{ exportRuntimeProperty(db, new File(directory+"/runtimeproperty.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","Value"}) : null, rules); }
		if((exclusion && !specialCases.contains(Characteristic.class)) || (!exclusion && specialCases.contains(Characteristic.class)))
			{ exportCharacteristic(db, new File(directory+"/characteristic.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description"}) : null, rules); }
		if((exclusion && !specialCases.contains(ObservationTarget.class)) || (!exclusion && specialCases.contains(ObservationTarget.class)))
			{ exportObservationTarget(db, new File(directory+"/observationtarget.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description"}) : null, rules); }
		if((exclusion && !specialCases.contains(Individual.class)) || (!exclusion && specialCases.contains(Individual.class)))
			{ exportIndividual(db, new File(directory+"/individual.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description","Mother_Identifier","Father_Identifier"}) : null, rules); }
		if((exclusion && !specialCases.contains(Ontology.class)) || (!exclusion && specialCases.contains(Ontology.class)))
			{ exportOntology(db, new File(directory+"/ontology.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","ontologyAccession","ontologyURI"}) : null, rules); }
		if((exclusion && !specialCases.contains(Species.class)) || (!exclusion && specialCases.contains(Species.class)))
			{ exportSpecies(db, new File(directory+"/species.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description","ontology_Identifier","termAccession","definition"}) : null, rules); }
		if((exclusion && !specialCases.contains(OntologyTerm.class)) || (!exclusion && specialCases.contains(OntologyTerm.class)))
			{ exportOntologyTerm(db, new File(directory+"/ontologyterm.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description","ontology_Identifier","termAccession","definition"}) : null, rules); }
		if((exclusion && !specialCases.contains(Accession.class)) || (!exclusion && specialCases.contains(Accession.class)))
			{ exportAccession(db, new File(directory+"/accession.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description","ontology_Identifier","termAccession","definition"}) : null, rules); }
		if((exclusion && !specialCases.contains(Value.class)) || (!exclusion && specialCases.contains(Value.class)))
			{ exportValue(db, new File(directory+"/value.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type"}) : null, rules); }
		if((exclusion && !specialCases.contains(BoolValue.class)) || (!exclusion && specialCases.contains(BoolValue.class)))
			{ exportBoolValue(db, new File(directory+"/boolvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value"}) : null, rules); }
		if((exclusion && !specialCases.contains(DateValue.class)) || (!exclusion && specialCases.contains(DateValue.class)))
			{ exportDateValue(db, new File(directory+"/datevalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value"}) : null, rules); }
		if((exclusion && !specialCases.contains(DateTimeValue.class)) || (!exclusion && specialCases.contains(DateTimeValue.class)))
			{ exportDateTimeValue(db, new File(directory+"/datetimevalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value"}) : null, rules); }
		if((exclusion && !specialCases.contains(DecimalValue.class)) || (!exclusion && specialCases.contains(DecimalValue.class)))
			{ exportDecimalValue(db, new File(directory+"/decimalvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value"}) : null, rules); }
		if((exclusion && !specialCases.contains(EmailValue.class)) || (!exclusion && specialCases.contains(EmailValue.class)))
			{ exportEmailValue(db, new File(directory+"/emailvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value"}) : null, rules); }
		if((exclusion && !specialCases.contains(HtmlValue.class)) || (!exclusion && specialCases.contains(HtmlValue.class)))
			{ exportHtmlValue(db, new File(directory+"/htmlvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value"}) : null, rules); }
		if((exclusion && !specialCases.contains(HyperlinkValue.class)) || (!exclusion && specialCases.contains(HyperlinkValue.class)))
			{ exportHyperlinkValue(db, new File(directory+"/hyperlinkvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value"}) : null, rules); }
		if((exclusion && !specialCases.contains(IntValue.class)) || (!exclusion && specialCases.contains(IntValue.class)))
			{ exportIntValue(db, new File(directory+"/intvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value"}) : null, rules); }
		if((exclusion && !specialCases.contains(LongValue.class)) || (!exclusion && specialCases.contains(LongValue.class)))
			{ exportLongValue(db, new File(directory+"/longvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value"}) : null, rules); }
		if((exclusion && !specialCases.contains(MrefValue.class)) || (!exclusion && specialCases.contains(MrefValue.class)))
			{ exportMrefValue(db, new File(directory+"/mrefvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value_Identifier"}) : null, rules); }
		if((exclusion && !specialCases.contains(StringValue.class)) || (!exclusion && specialCases.contains(StringValue.class)))
			{ exportStringValue(db, new File(directory+"/stringvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value"}) : null, rules); }
		if((exclusion && !specialCases.contains(TextValue.class)) || (!exclusion && specialCases.contains(TextValue.class)))
			{ exportTextValue(db, new File(directory+"/textvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value"}) : null, rules); }
		if((exclusion && !specialCases.contains(MolgenisRole.class)) || (!exclusion && specialCases.contains(MolgenisRole.class)))
			{ exportMolgenisRole(db, new File(directory+"/molgenisrole.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type"}) : null, rules); }
		if((exclusion && !specialCases.contains(MolgenisGroup.class)) || (!exclusion && specialCases.contains(MolgenisGroup.class)))
			{ exportMolgenisGroup(db, new File(directory+"/molgenisgroup.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type"}) : null, rules); }
		if((exclusion && !specialCases.contains(PersonRole.class)) || (!exclusion && specialCases.contains(PersonRole.class)))
			{ exportPersonRole(db, new File(directory+"/personrole.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description","ontology_Identifier","termAccession","definition"}) : null, rules); }
		if((exclusion && !specialCases.contains(ObservableFeature.class)) || (!exclusion && specialCases.contains(ObservableFeature.class)))
			{ exportObservableFeature(db, new File(directory+"/observablefeature.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description","unit_Identifier","definition_Identifier","dataType","temporal"}) : null, rules); }
		if((exclusion && !specialCases.contains(Category.class)) || (!exclusion && specialCases.contains(Category.class)))
			{ exportCategory(db, new File(directory+"/category.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description","observableFeature_Identifier","valueCode","definition_Identifier","isMissing"}) : null, rules); }
		if((exclusion && !specialCases.contains(Protocol.class)) || (!exclusion && specialCases.contains(Protocol.class)))
			{ exportProtocol(db, new File(directory+"/protocol.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description","ProtocolType_Identifier","subprotocols_Identifier","Features_Identifier"}) : null, rules); }
		if((exclusion && !specialCases.contains(DataSet.class)) || (!exclusion && specialCases.contains(DataSet.class)))
			{ exportDataSet(db, new File(directory+"/dataset.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description","ProtocolUsed_Identifier","startTime","endTime","active"}) : null, rules); }
		if((exclusion && !specialCases.contains(ObservationSet.class)) || (!exclusion && specialCases.contains(ObservationSet.class)))
			{ exportObservationSet(db, new File(directory+"/observationset.txt"), skipAutoId ? Arrays.asList(new String[]{"partOfDataSet_Identifier","Time"}) : null, rules); }
		if((exclusion && !specialCases.contains(Panel.class)) || (!exclusion && specialCases.contains(Panel.class)))
			{ exportPanel(db, new File(directory+"/panel.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description","PanelType_Identifier","NumberOfIndividuals","Species_Identifier","Individuals_Identifier"}) : null, rules); }
		if((exclusion && !specialCases.contains(PanelSource.class)) || (!exclusion && specialCases.contains(PanelSource.class)))
			{ exportPanelSource(db, new File(directory+"/panelsource.txt"), skipAutoId ? Arrays.asList(new String[]{"CurrentPanel_Identifier","SourcePanel_Identifier","NumberOfIndividuals","SelectionCriteria"}) : null, rules); }
		if((exclusion && !specialCases.contains(CategoricalValue.class)) || (!exclusion && specialCases.contains(CategoricalValue.class)))
			{ exportCategoricalValue(db, new File(directory+"/categoricalvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value_Identifier"}) : null, rules); }
		if((exclusion && !specialCases.contains(Institute.class)) || (!exclusion && specialCases.contains(Institute.class)))
			{ exportInstitute(db, new File(directory+"/institute.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description","Address","Phone","Email","Fax","tollFreePhone","City","Country"}) : null, rules); }
		if((exclusion && !specialCases.contains(Person.class)) || (!exclusion && specialCases.contains(Person.class)))
			{ exportPerson(db, new File(directory+"/person.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","description","Address","Phone","Email","Fax","tollFreePhone","City","Country","FirstName","MidInitials","LastName","Title","Affiliation_Name","Department","Roles_Identifier"}) : null, rules); }
		if((exclusion && !specialCases.contains(XrefValue.class)) || (!exclusion && specialCases.contains(XrefValue.class)))
			{ exportXrefValue(db, new File(directory+"/xrefvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"__Type","Value_Identifier"}) : null, rules); }
		if((exclusion && !specialCases.contains(ObservedValue.class)) || (!exclusion && specialCases.contains(ObservedValue.class)))
			{ exportObservedValue(db, new File(directory+"/observedvalue.txt"), skipAutoId ? Arrays.asList(new String[]{"ObservationSet_id","Feature_Identifier","Value_id"}) : null, rules); }
		if((exclusion && !specialCases.contains(MolgenisUser.class)) || (!exclusion && specialCases.contains(MolgenisUser.class)))
			{ exportMolgenisUser(db, new File(directory+"/molgenisuser.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","__Type","Address","Phone","Email","Fax","tollFreePhone","City","Country","FirstName","MidInitials","LastName","Title","Affiliation_Name","Department","Roles_Identifier","password_","activationCode","active","superuser"}) : null, rules); }
		if((exclusion && !specialCases.contains(MolgenisRoleGroupLink.class)) || (!exclusion && specialCases.contains(MolgenisRoleGroupLink.class)))
			{ exportMolgenisRoleGroupLink(db, new File(directory+"/molgenisrolegrouplink.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","group__Name","role__Name"}) : null, rules); }
		if((exclusion && !specialCases.contains(MolgenisPermission.class)) || (!exclusion && specialCases.contains(MolgenisPermission.class)))
			{ exportMolgenisPermission(db, new File(directory+"/molgenispermission.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","role__Name","entity_className","permission"}) : null, rules); }
		if((exclusion && !specialCases.contains(StudyDataRequest.class)) || (!exclusion && specialCases.contains(StudyDataRequest.class)))
			{ exportStudyDataRequest(db, new File(directory+"/studydatarequest.txt"), skipAutoId ? Arrays.asList(new String[]{"Identifier","Name","RequestForm","Features_Identifier","DataSet_Identifier","MolgenisUser_Name","RequestDate","RequestStatus"}) : null, rules); }
	
		logger.debug("done");
	}
	
	private QueryRule[] matchQueryRulesToEntity(org.molgenis.model.elements.Entity e, QueryRule ... rules) throws MolgenisModelException
	{
		ArrayList<QueryRule> tmpResult = new ArrayList<QueryRule>();
		for(QueryRule q : rules){
			if(!(e.getAllField(q.getField()) == null)){
				tmpResult.add(q); //field is okay for this entity
			}
			//special case: eg. investigation.name -> if current entity is 'investigation', use field 'name'
			String[] splitField = q.getField().split("\\.");
			if(splitField.length == 2){
				if(e.getName().equals(splitField[0])){
					QueryRule copy = new QueryRule(q);
					copy.setField(splitField[1]);
					tmpResult.add(copy);
				}
			}
		}
		QueryRule[] result = new QueryRule[tmpResult.size()];
		for(int i=0; i<result.length; i++){
			result[i] = tmpResult.get(i);
		}
		return result;
	}

	/**
	 *	export MolgenisEntity to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportMolgenisEntity(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(MolgenisEntity.class) > 0)
		{
			
			Query<MolgenisEntity> query = db.query(MolgenisEntity.class);
			
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("MolgenisEntity"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter molgenisEntityWriter = new CsvWriter(f);
				try
				{
					query.find(molgenisEntityWriter, fieldsToExport);
				}
				finally
				{
					molgenisEntityWriter.close();
				}
			}
		}
	}
	
	public void exportMolgenisEntity(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter molgenisEntityWriter = new CsvWriter(file);
			try
			{
				molgenisEntityWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					molgenisEntityWriter.write(new EntityTuple(e));
				}
			}
			finally {
				molgenisEntityWriter.close();
			}
		}
	}
	/**
	 *	export MolgenisFile to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportMolgenisFile(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(MolgenisFile.class) > 0)
		{
			
			Query<MolgenisFile> query = db.query(MolgenisFile.class);
			
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("MolgenisFile"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter molgenisFileWriter = new CsvWriter(f);
				try
				{
					query.find(molgenisFileWriter, fieldsToExport);
				}
				finally
				{
					molgenisFileWriter.close();
				}
			}
		}
	}
	
	public void exportMolgenisFile(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter molgenisFileWriter = new CsvWriter(file);
			try
			{
				molgenisFileWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					molgenisFileWriter.write(new EntityTuple(e));
				}
			}
			finally {
				molgenisFileWriter.close();
			}
		}
	}
	/**
	 *	export RuntimeProperty to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportRuntimeProperty(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(RuntimeProperty.class) > 0)
		{
			
			Query<RuntimeProperty> query = db.query(RuntimeProperty.class);
			
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("RuntimeProperty"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter runtimePropertyWriter = new CsvWriter(f);
				try
				{
					query.find(runtimePropertyWriter, fieldsToExport);
				}
				finally
				{
					runtimePropertyWriter.close();
				}
			}
		}
	}
	
	public void exportRuntimeProperty(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter runtimePropertyWriter = new CsvWriter(file);
			try
			{
				runtimePropertyWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					runtimePropertyWriter.write(new EntityTuple(e));
				}
			}
			finally {
				runtimePropertyWriter.close();
			}
		}
	}
	/**
	 *	export Characteristic to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportCharacteristic(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(Characteristic.class, new QueryRule("__Type",Operator.EQUALS, "Characteristic")) > 0)
		{
			
			Query<Characteristic> query = db.query(Characteristic.class);
			QueryRule type = new QueryRule("__Type",Operator.EQUALS, "Characteristic");
			query.addRules(type);
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("Characteristic"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter characteristicWriter = new CsvWriter(f);
				try
				{
					query.find(characteristicWriter, fieldsToExport);
				}
				finally
				{
					characteristicWriter.close();
				}
			}
		}
	}
	
	public void exportCharacteristic(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter characteristicWriter = new CsvWriter(file);
			try
			{
				characteristicWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					characteristicWriter.write(new EntityTuple(e));
				}
			}
			finally {
				characteristicWriter.close();
			}
		}
	}
	/**
	 *	export ObservationTarget to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportObservationTarget(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(ObservationTarget.class, new QueryRule("__Type",Operator.EQUALS, "ObservationTarget")) > 0)
		{
			
			Query<ObservationTarget> query = db.query(ObservationTarget.class);
			QueryRule type = new QueryRule("__Type",Operator.EQUALS, "ObservationTarget");
			query.addRules(type);
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("ObservationTarget"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter observationTargetWriter = new CsvWriter(f);
				try
				{
					query.find(observationTargetWriter, fieldsToExport);
				}
				finally
				{
					observationTargetWriter.close();
				}
			}
		}
	}
	
	public void exportObservationTarget(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter observationTargetWriter = new CsvWriter(file);
			try
			{
				observationTargetWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					observationTargetWriter.write(new EntityTuple(e));
				}
			}
			finally {
				observationTargetWriter.close();
			}
		}
	}
	/**
	 *	export Individual to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportIndividual(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(Individual.class, new QueryRule("__Type",Operator.EQUALS, "Individual")) > 0)
		{
			
			Query<Individual> query = db.query(Individual.class);
			QueryRule type = new QueryRule("__Type",Operator.EQUALS, "Individual");
			query.addRules(type);
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("Individual"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter individualWriter = new CsvWriter(f);
				try
				{
					query.find(individualWriter, fieldsToExport);
				}
				finally
				{
					individualWriter.close();
				}
			}
		}
	}
	
	public void exportIndividual(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter individualWriter = new CsvWriter(file);
			try
			{
				individualWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					individualWriter.write(new EntityTuple(e));
				}
			}
			finally {
				individualWriter.close();
			}
		}
	}
	/**
	 *	export Ontology to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportOntology(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(Ontology.class) > 0)
		{
			
			Query<Ontology> query = db.query(Ontology.class);
			
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("Ontology"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter ontologyWriter = new CsvWriter(f);
				try
				{
					query.find(ontologyWriter, fieldsToExport);
				}
				finally
				{
					ontologyWriter.close();
				}
			}
		}
	}
	
	public void exportOntology(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter ontologyWriter = new CsvWriter(file);
			try
			{
				ontologyWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					ontologyWriter.write(new EntityTuple(e));
				}
			}
			finally {
				ontologyWriter.close();
			}
		}
	}
	/**
	 *	export Species to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportSpecies(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(Species.class, new QueryRule("__Type",Operator.EQUALS, "Species")) > 0)
		{
			
			Query<Species> query = db.query(Species.class);
			QueryRule type = new QueryRule("__Type",Operator.EQUALS, "Species");
			query.addRules(type);
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("Species"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter speciesWriter = new CsvWriter(f);
				try
				{
					query.find(speciesWriter, fieldsToExport);
				}
				finally
				{
					speciesWriter.close();
				}
			}
		}
	}
	
	public void exportSpecies(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter speciesWriter = new CsvWriter(file);
			try
			{
				speciesWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					speciesWriter.write(new EntityTuple(e));
				}
			}
			finally {
				speciesWriter.close();
			}
		}
	}
	/**
	 *	export OntologyTerm to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportOntologyTerm(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(OntologyTerm.class, new QueryRule("__Type",Operator.EQUALS, "OntologyTerm")) > 0)
		{
			
			Query<OntologyTerm> query = db.query(OntologyTerm.class);
			QueryRule type = new QueryRule("__Type",Operator.EQUALS, "OntologyTerm");
			query.addRules(type);
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("OntologyTerm"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter ontologyTermWriter = new CsvWriter(f);
				try
				{
					query.find(ontologyTermWriter, fieldsToExport);
				}
				finally
				{
					ontologyTermWriter.close();
				}
			}
		}
	}
	
	public void exportOntologyTerm(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter ontologyTermWriter = new CsvWriter(file);
			try
			{
				ontologyTermWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					ontologyTermWriter.write(new EntityTuple(e));
				}
			}
			finally {
				ontologyTermWriter.close();
			}
		}
	}
	/**
	 *	export Accession to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportAccession(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(Accession.class, new QueryRule("__Type",Operator.EQUALS, "Accession")) > 0)
		{
			
			Query<Accession> query = db.query(Accession.class);
			QueryRule type = new QueryRule("__Type",Operator.EQUALS, "Accession");
			query.addRules(type);
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("Accession"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter accessionWriter = new CsvWriter(f);
				try
				{
					query.find(accessionWriter, fieldsToExport);
				}
				finally
				{
					accessionWriter.close();
				}
			}
		}
	}
	
	public void exportAccession(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter accessionWriter = new CsvWriter(file);
			try
			{
				accessionWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					accessionWriter.write(new EntityTuple(e));
				}
			}
			finally {
				accessionWriter.close();
			}
		}
	}
	/**
	 *	export Value to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportValue(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(Value.class, new QueryRule("__Type",Operator.EQUALS, "Value")) > 0)
		{
			
			Query<Value> query = db.query(Value.class);
			QueryRule type = new QueryRule("__Type",Operator.EQUALS, "Value");
			query.addRules(type);
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("Value"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter valueWriter = new CsvWriter(f);
				try
				{
					query.find(valueWriter, fieldsToExport);
				}
				finally
				{
					valueWriter.close();
				}
			}
		}
	}
	
	public void exportValue(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter valueWriter = new CsvWriter(file);
			try
			{
				valueWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					valueWriter.write(new EntityTuple(e));
				}
			}
			finally {
				valueWriter.close();
			}
		}
	}
	/**
	 *	export BoolValue to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportBoolValue(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(BoolValue.class, new QueryRule("__Type",Operator.EQUALS, "BoolValue")) > 0)
		{
			
			Query<BoolValue> query = db.query(BoolValue.class);
			QueryRule type = new QueryRule("__Type",Operator.EQUALS, "BoolValue");
			query.addRules(type);
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("BoolValue"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter boolValueWriter = new CsvWriter(f);
				try
				{
					query.find(boolValueWriter, fieldsToExport);
				}
				finally
				{
					boolValueWriter.close();
				}
			}
		}
	}
	
	public void exportBoolValue(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter boolValueWriter = new CsvWriter(file);
			try
			{
				boolValueWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					boolValueWriter.write(new EntityTuple(e));
				}
			}
			finally {
				boolValueWriter.close();
			}
		}
	}
	/**
	 *	export DateValue to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportDateValue(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(DateValue.class, new QueryRule("__Type",Operator.EQUALS, "DateValue")) > 0)
		{
			
			Query<DateValue> query = db.query(DateValue.class);
			QueryRule type = new QueryRule("__Type",Operator.EQUALS, "DateValue");
			query.addRules(type);
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("DateValue"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter dateValueWriter = new CsvWriter(f);
				try
				{
					query.find(dateValueWriter, fieldsToExport);
				}
				finally
				{
					dateValueWriter.close();
				}
			}
		}
	}
	
	public void exportDateValue(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter dateValueWriter = new CsvWriter(file);
			try
			{
				dateValueWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					dateValueWriter.write(new EntityTuple(e));
				}
			}
			finally {
				dateValueWriter.close();
			}
		}
	}
	/**
	 *	export DateTimeValue to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportDateTimeValue(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(DateTimeValue.class, new QueryRule("__Type",Operator.EQUALS, "DateTimeValue")) > 0)
		{
			
			Query<DateTimeValue> query = db.query(DateTimeValue.class);
			QueryRule type = new QueryRule("__Type",Operator.EQUALS, "DateTimeValue");
			query.addRules(type);
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("DateTimeValue"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter dateTimeValueWriter = new CsvWriter(f);
				try
				{
					query.find(dateTimeValueWriter, fieldsToExport);
				}
				finally
				{
					dateTimeValueWriter.close();
				}
			}
		}
	}
	
	public void exportDateTimeValue(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter dateTimeValueWriter = new CsvWriter(file);
			try
			{
				dateTimeValueWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					dateTimeValueWriter.write(new EntityTuple(e));
				}
			}
			finally {
				dateTimeValueWriter.close();
			}
		}
	}
	/**
	 *	export DecimalValue to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportDecimalValue(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(DecimalValue.class, new QueryRule("__Type",Operator.EQUALS, "DecimalValue")) > 0)
		{
			
			Query<DecimalValue> query = db.query(DecimalValue.class);
			QueryRule type = new QueryRule("__Type",Operator.EQUALS, "DecimalValue");
			query.addRules(type);
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("DecimalValue"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter decimalValueWriter = new CsvWriter(f);
				try
				{
					query.find(decimalValueWriter, fieldsToExport);
				}
				finally
				{
					decimalValueWriter.close();
				}
			}
		}
	}
	
	public void exportDecimalValue(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter decimalValueWriter = new CsvWriter(file);
			try
			{
				decimalValueWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					decimalValueWriter.write(new EntityTuple(e));
				}
			}
			finally {
				decimalValueWriter.close();
			}
		}
	}
	/**
	 *	export EmailValue to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportEmailValue(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(EmailValue.class, new QueryRule("__Type",Operator.EQUALS, "EmailValue")) > 0)
		{
			
			Query<EmailValue> query = db.query(EmailValue.class);
			QueryRule type = new QueryRule("__Type",Operator.EQUALS, "EmailValue");
			query.addRules(type);
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("EmailValue"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter emailValueWriter = new CsvWriter(f);
				try
				{
					query.find(emailValueWriter, fieldsToExport);
				}
				finally
				{
					emailValueWriter.close();
				}
			}
		}
	}
	
	public void exportEmailValue(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter emailValueWriter = new CsvWriter(file);
			try
			{
				emailValueWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					emailValueWriter.write(new EntityTuple(e));
				}
			}
			finally {
				emailValueWriter.close();
			}
		}
	}
	/**
	 *	export HtmlValue to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportHtmlValue(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(HtmlValue.class, new QueryRule("__Type",Operator.EQUALS, "HtmlValue")) > 0)
		{
			
			Query<HtmlValue> query = db.query(HtmlValue.class);
			QueryRule type = new QueryRule("__Type",Operator.EQUALS, "HtmlValue");
			query.addRules(type);
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("HtmlValue"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter htmlValueWriter = new CsvWriter(f);
				try
				{
					query.find(htmlValueWriter, fieldsToExport);
				}
				finally
				{
					htmlValueWriter.close();
				}
			}
		}
	}
	
	public void exportHtmlValue(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter htmlValueWriter = new CsvWriter(file);
			try
			{
				htmlValueWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					htmlValueWriter.write(new EntityTuple(e));
				}
			}
			finally {
				htmlValueWriter.close();
			}
		}
	}
	/**
	 *	export HyperlinkValue to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportHyperlinkValue(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(HyperlinkValue.class, new QueryRule("__Type",Operator.EQUALS, "HyperlinkValue")) > 0)
		{
			
			Query<HyperlinkValue> query = db.query(HyperlinkValue.class);
			QueryRule type = new QueryRule("__Type",Operator.EQUALS, "HyperlinkValue");
			query.addRules(type);
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("HyperlinkValue"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter hyperlinkValueWriter = new CsvWriter(f);
				try
				{
					query.find(hyperlinkValueWriter, fieldsToExport);
				}
				finally
				{
					hyperlinkValueWriter.close();
				}
			}
		}
	}
	
	public void exportHyperlinkValue(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter hyperlinkValueWriter = new CsvWriter(file);
			try
			{
				hyperlinkValueWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					hyperlinkValueWriter.write(new EntityTuple(e));
				}
			}
			finally {
				hyperlinkValueWriter.close();
			}
		}
	}
	/**
	 *	export IntValue to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportIntValue(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(IntValue.class, new QueryRule("__Type",Operator.EQUALS, "IntValue")) > 0)
		{
			
			Query<IntValue> query = db.query(IntValue.class);
			QueryRule type = new QueryRule("__Type",Operator.EQUALS, "IntValue");
			query.addRules(type);
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("IntValue"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter intValueWriter = new CsvWriter(f);
				try
				{
					query.find(intValueWriter, fieldsToExport);
				}
				finally
				{
					intValueWriter.close();
				}
			}
		}
	}
	
	public void exportIntValue(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter intValueWriter = new CsvWriter(file);
			try
			{
				intValueWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					intValueWriter.write(new EntityTuple(e));
				}
			}
			finally {
				intValueWriter.close();
			}
		}
	}
	/**
	 *	export LongValue to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportLongValue(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(LongValue.class, new QueryRule("__Type",Operator.EQUALS, "LongValue")) > 0)
		{
			
			Query<LongValue> query = db.query(LongValue.class);
			QueryRule type = new QueryRule("__Type",Operator.EQUALS, "LongValue");
			query.addRules(type);
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("LongValue"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter longValueWriter = new CsvWriter(f);
				try
				{
					query.find(longValueWriter, fieldsToExport);
				}
				finally
				{
					longValueWriter.close();
				}
			}
		}
	}
	
	public void exportLongValue(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter longValueWriter = new CsvWriter(file);
			try
			{
				longValueWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					longValueWriter.write(new EntityTuple(e));
				}
			}
			finally {
				longValueWriter.close();
			}
		}
	}
	/**
	 *	export MrefValue to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportMrefValue(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(MrefValue.class, new QueryRule("__Type",Operator.EQUALS, "MrefValue")) > 0)
		{
			
			Query<MrefValue> query = db.query(MrefValue.class);
			QueryRule type = new QueryRule("__Type",Operator.EQUALS, "MrefValue");
			query.addRules(type);
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("MrefValue"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter mrefValueWriter = new CsvWriter(f);
				try
				{
					query.find(mrefValueWriter, fieldsToExport);
				}
				finally
				{
					mrefValueWriter.close();
				}
			}
		}
	}
	
	public void exportMrefValue(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter mrefValueWriter = new CsvWriter(file);
			try
			{
				mrefValueWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					mrefValueWriter.write(new EntityTuple(e));
				}
			}
			finally {
				mrefValueWriter.close();
			}
		}
	}
	/**
	 *	export StringValue to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportStringValue(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(StringValue.class, new QueryRule("__Type",Operator.EQUALS, "StringValue")) > 0)
		{
			
			Query<StringValue> query = db.query(StringValue.class);
			QueryRule type = new QueryRule("__Type",Operator.EQUALS, "StringValue");
			query.addRules(type);
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("StringValue"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter stringValueWriter = new CsvWriter(f);
				try
				{
					query.find(stringValueWriter, fieldsToExport);
				}
				finally
				{
					stringValueWriter.close();
				}
			}
		}
	}
	
	public void exportStringValue(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter stringValueWriter = new CsvWriter(file);
			try
			{
				stringValueWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					stringValueWriter.write(new EntityTuple(e));
				}
			}
			finally {
				stringValueWriter.close();
			}
		}
	}
	/**
	 *	export TextValue to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportTextValue(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(TextValue.class, new QueryRule("__Type",Operator.EQUALS, "TextValue")) > 0)
		{
			
			Query<TextValue> query = db.query(TextValue.class);
			QueryRule type = new QueryRule("__Type",Operator.EQUALS, "TextValue");
			query.addRules(type);
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("TextValue"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter textValueWriter = new CsvWriter(f);
				try
				{
					query.find(textValueWriter, fieldsToExport);
				}
				finally
				{
					textValueWriter.close();
				}
			}
		}
	}
	
	public void exportTextValue(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter textValueWriter = new CsvWriter(file);
			try
			{
				textValueWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					textValueWriter.write(new EntityTuple(e));
				}
			}
			finally {
				textValueWriter.close();
			}
		}
	}
	/**
	 *	export MolgenisRole to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportMolgenisRole(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(MolgenisRole.class, new QueryRule("__Type",Operator.EQUALS, "MolgenisRole")) > 0)
		{
			
			Query<MolgenisRole> query = db.query(MolgenisRole.class);
			QueryRule type = new QueryRule("__Type",Operator.EQUALS, "MolgenisRole");
			query.addRules(type);
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("MolgenisRole"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter molgenisRoleWriter = new CsvWriter(f);
				try
				{
					query.find(molgenisRoleWriter, fieldsToExport);
				}
				finally
				{
					molgenisRoleWriter.close();
				}
			}
		}
	}
	
	public void exportMolgenisRole(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter molgenisRoleWriter = new CsvWriter(file);
			try
			{
				molgenisRoleWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					molgenisRoleWriter.write(new EntityTuple(e));
				}
			}
			finally {
				molgenisRoleWriter.close();
			}
		}
	}
	/**
	 *	export MolgenisGroup to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportMolgenisGroup(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(MolgenisGroup.class, new QueryRule("__Type",Operator.EQUALS, "MolgenisGroup")) > 0)
		{
			
			Query<MolgenisGroup> query = db.query(MolgenisGroup.class);
			QueryRule type = new QueryRule("__Type",Operator.EQUALS, "MolgenisGroup");
			query.addRules(type);
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("MolgenisGroup"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter molgenisGroupWriter = new CsvWriter(f);
				try
				{
					query.find(molgenisGroupWriter, fieldsToExport);
				}
				finally
				{
					molgenisGroupWriter.close();
				}
			}
		}
	}
	
	public void exportMolgenisGroup(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter molgenisGroupWriter = new CsvWriter(file);
			try
			{
				molgenisGroupWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					molgenisGroupWriter.write(new EntityTuple(e));
				}
			}
			finally {
				molgenisGroupWriter.close();
			}
		}
	}
	/**
	 *	export PersonRole to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportPersonRole(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(PersonRole.class, new QueryRule("__Type",Operator.EQUALS, "PersonRole")) > 0)
		{
			
			Query<PersonRole> query = db.query(PersonRole.class);
			QueryRule type = new QueryRule("__Type",Operator.EQUALS, "PersonRole");
			query.addRules(type);
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("PersonRole"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter personRoleWriter = new CsvWriter(f);
				try
				{
					query.find(personRoleWriter, fieldsToExport);
				}
				finally
				{
					personRoleWriter.close();
				}
			}
		}
	}
	
	public void exportPersonRole(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter personRoleWriter = new CsvWriter(file);
			try
			{
				personRoleWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					personRoleWriter.write(new EntityTuple(e));
				}
			}
			finally {
				personRoleWriter.close();
			}
		}
	}
	/**
	 *	export ObservableFeature to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportObservableFeature(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(ObservableFeature.class, new QueryRule("__Type",Operator.EQUALS, "ObservableFeature")) > 0)
		{
			
			Query<ObservableFeature> query = db.query(ObservableFeature.class);
			QueryRule type = new QueryRule("__Type",Operator.EQUALS, "ObservableFeature");
			query.addRules(type);
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("ObservableFeature"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter observableFeatureWriter = new CsvWriter(f);
				try
				{
					query.find(observableFeatureWriter, fieldsToExport);
				}
				finally
				{
					observableFeatureWriter.close();
				}
			}
		}
	}
	
	public void exportObservableFeature(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter observableFeatureWriter = new CsvWriter(file);
			try
			{
				observableFeatureWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					observableFeatureWriter.write(new EntityTuple(e));
				}
			}
			finally {
				observableFeatureWriter.close();
			}
		}
	}
	/**
	 *	export Category to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportCategory(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(Category.class, new QueryRule("__Type",Operator.EQUALS, "Category")) > 0)
		{
			
			Query<Category> query = db.query(Category.class);
			QueryRule type = new QueryRule("__Type",Operator.EQUALS, "Category");
			query.addRules(type);
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("Category"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter categoryWriter = new CsvWriter(f);
				try
				{
					query.find(categoryWriter, fieldsToExport);
				}
				finally
				{
					categoryWriter.close();
				}
			}
		}
	}
	
	public void exportCategory(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter categoryWriter = new CsvWriter(file);
			try
			{
				categoryWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					categoryWriter.write(new EntityTuple(e));
				}
			}
			finally {
				categoryWriter.close();
			}
		}
	}
	/**
	 *	export Protocol to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportProtocol(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(Protocol.class, new QueryRule("__Type",Operator.EQUALS, "Protocol")) > 0)
		{
			
			Query<Protocol> query = db.query(Protocol.class);
			QueryRule type = new QueryRule("__Type",Operator.EQUALS, "Protocol");
			query.addRules(type);
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("Protocol"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter protocolWriter = new CsvWriter(f);
				try
				{
					query.find(protocolWriter, fieldsToExport);
				}
				finally
				{
					protocolWriter.close();
				}
			}
		}
	}
	
	public void exportProtocol(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter protocolWriter = new CsvWriter(file);
			try
			{
				protocolWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					protocolWriter.write(new EntityTuple(e));
				}
			}
			finally {
				protocolWriter.close();
			}
		}
	}
	/**
	 *	export DataSet to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportDataSet(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(DataSet.class, new QueryRule("__Type",Operator.EQUALS, "DataSet")) > 0)
		{
			
			Query<DataSet> query = db.query(DataSet.class);
			QueryRule type = new QueryRule("__Type",Operator.EQUALS, "DataSet");
			query.addRules(type);
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("DataSet"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter dataSetWriter = new CsvWriter(f);
				try
				{
					query.find(dataSetWriter, fieldsToExport);
				}
				finally
				{
					dataSetWriter.close();
				}
			}
		}
	}
	
	public void exportDataSet(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter dataSetWriter = new CsvWriter(file);
			try
			{
				dataSetWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					dataSetWriter.write(new EntityTuple(e));
				}
			}
			finally {
				dataSetWriter.close();
			}
		}
	}
	/**
	 *	export ObservationSet to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportObservationSet(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(ObservationSet.class) > 0)
		{
			
			Query<ObservationSet> query = db.query(ObservationSet.class);
			
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("ObservationSet"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter observationSetWriter = new CsvWriter(f);
				try
				{
					query.find(observationSetWriter, fieldsToExport);
				}
				finally
				{
					observationSetWriter.close();
				}
			}
		}
	}
	
	public void exportObservationSet(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter observationSetWriter = new CsvWriter(file);
			try
			{
				observationSetWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					observationSetWriter.write(new EntityTuple(e));
				}
			}
			finally {
				observationSetWriter.close();
			}
		}
	}
	/**
	 *	export Panel to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportPanel(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(Panel.class, new QueryRule("__Type",Operator.EQUALS, "Panel")) > 0)
		{
			
			Query<Panel> query = db.query(Panel.class);
			QueryRule type = new QueryRule("__Type",Operator.EQUALS, "Panel");
			query.addRules(type);
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("Panel"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter panelWriter = new CsvWriter(f);
				try
				{
					query.find(panelWriter, fieldsToExport);
				}
				finally
				{
					panelWriter.close();
				}
			}
		}
	}
	
	public void exportPanel(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter panelWriter = new CsvWriter(file);
			try
			{
				panelWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					panelWriter.write(new EntityTuple(e));
				}
			}
			finally {
				panelWriter.close();
			}
		}
	}
	/**
	 *	export PanelSource to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportPanelSource(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(PanelSource.class) > 0)
		{
			
			Query<PanelSource> query = db.query(PanelSource.class);
			
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("PanelSource"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter panelSourceWriter = new CsvWriter(f);
				try
				{
					query.find(panelSourceWriter, fieldsToExport);
				}
				finally
				{
					panelSourceWriter.close();
				}
			}
		}
	}
	
	public void exportPanelSource(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter panelSourceWriter = new CsvWriter(file);
			try
			{
				panelSourceWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					panelSourceWriter.write(new EntityTuple(e));
				}
			}
			finally {
				panelSourceWriter.close();
			}
		}
	}
	/**
	 *	export CategoricalValue to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportCategoricalValue(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(CategoricalValue.class, new QueryRule("__Type",Operator.EQUALS, "CategoricalValue")) > 0)
		{
			
			Query<CategoricalValue> query = db.query(CategoricalValue.class);
			QueryRule type = new QueryRule("__Type",Operator.EQUALS, "CategoricalValue");
			query.addRules(type);
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("CategoricalValue"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter categoricalValueWriter = new CsvWriter(f);
				try
				{
					query.find(categoricalValueWriter, fieldsToExport);
				}
				finally
				{
					categoricalValueWriter.close();
				}
			}
		}
	}
	
	public void exportCategoricalValue(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter categoricalValueWriter = new CsvWriter(file);
			try
			{
				categoricalValueWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					categoricalValueWriter.write(new EntityTuple(e));
				}
			}
			finally {
				categoricalValueWriter.close();
			}
		}
	}
	/**
	 *	export Institute to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportInstitute(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(Institute.class, new QueryRule("__Type",Operator.EQUALS, "Institute")) > 0)
		{
			
			Query<Institute> query = db.query(Institute.class);
			QueryRule type = new QueryRule("__Type",Operator.EQUALS, "Institute");
			query.addRules(type);
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("Institute"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter instituteWriter = new CsvWriter(f);
				try
				{
					query.find(instituteWriter, fieldsToExport);
				}
				finally
				{
					instituteWriter.close();
				}
			}
		}
	}
	
	public void exportInstitute(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter instituteWriter = new CsvWriter(file);
			try
			{
				instituteWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					instituteWriter.write(new EntityTuple(e));
				}
			}
			finally {
				instituteWriter.close();
			}
		}
	}
	/**
	 *	export Person to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportPerson(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(Person.class, new QueryRule("__Type",Operator.EQUALS, "Person")) > 0)
		{
			
			Query<Person> query = db.query(Person.class);
			QueryRule type = new QueryRule("__Type",Operator.EQUALS, "Person");
			query.addRules(type);
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("Person"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter personWriter = new CsvWriter(f);
				try
				{
					query.find(personWriter, fieldsToExport);
				}
				finally
				{
					personWriter.close();
				}
			}
		}
	}
	
	public void exportPerson(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter personWriter = new CsvWriter(file);
			try
			{
				personWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					personWriter.write(new EntityTuple(e));
				}
			}
			finally {
				personWriter.close();
			}
		}
	}
	/**
	 *	export XrefValue to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportXrefValue(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(XrefValue.class, new QueryRule("__Type",Operator.EQUALS, "XrefValue")) > 0)
		{
			
			Query<XrefValue> query = db.query(XrefValue.class);
			QueryRule type = new QueryRule("__Type",Operator.EQUALS, "XrefValue");
			query.addRules(type);
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("XrefValue"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter xrefValueWriter = new CsvWriter(f);
				try
				{
					query.find(xrefValueWriter, fieldsToExport);
				}
				finally
				{
					xrefValueWriter.close();
				}
			}
		}
	}
	
	public void exportXrefValue(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter xrefValueWriter = new CsvWriter(file);
			try
			{
				xrefValueWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					xrefValueWriter.write(new EntityTuple(e));
				}
			}
			finally {
				xrefValueWriter.close();
			}
		}
	}
	/**
	 *	export ObservedValue to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportObservedValue(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(ObservedValue.class) > 0)
		{
			
			Query<ObservedValue> query = db.query(ObservedValue.class);
			
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("ObservedValue"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter observedValueWriter = new CsvWriter(f);
				try
				{
					query.find(observedValueWriter, fieldsToExport);
				}
				finally
				{
					observedValueWriter.close();
				}
			}
		}
	}
	
	public void exportObservedValue(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter observedValueWriter = new CsvWriter(file);
			try
			{
				observedValueWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					observedValueWriter.write(new EntityTuple(e));
				}
			}
			finally {
				observedValueWriter.close();
			}
		}
	}
	/**
	 *	export MolgenisUser to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportMolgenisUser(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(MolgenisUser.class, new QueryRule("__Type",Operator.EQUALS, "MolgenisUser")) > 0)
		{
			
			Query<MolgenisUser> query = db.query(MolgenisUser.class);
			QueryRule type = new QueryRule("__Type",Operator.EQUALS, "MolgenisUser");
			query.addRules(type);
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("MolgenisUser"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter molgenisUserWriter = new CsvWriter(f);
				try
				{
					query.find(molgenisUserWriter, fieldsToExport);
				}
				finally
				{
					molgenisUserWriter.close();
				}
			}
		}
	}
	
	public void exportMolgenisUser(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter molgenisUserWriter = new CsvWriter(file);
			try
			{
				molgenisUserWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					molgenisUserWriter.write(new EntityTuple(e));
				}
			}
			finally {
				molgenisUserWriter.close();
			}
		}
	}
	/**
	 *	export MolgenisRoleGroupLink to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportMolgenisRoleGroupLink(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(MolgenisRoleGroupLink.class) > 0)
		{
			
			Query<MolgenisRoleGroupLink> query = db.query(MolgenisRoleGroupLink.class);
			
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("MolgenisRoleGroupLink"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter molgenisRoleGroupLinkWriter = new CsvWriter(f);
				try
				{
					query.find(molgenisRoleGroupLinkWriter, fieldsToExport);
				}
				finally
				{
					molgenisRoleGroupLinkWriter.close();
				}
			}
		}
	}
	
	public void exportMolgenisRoleGroupLink(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter molgenisRoleGroupLinkWriter = new CsvWriter(file);
			try
			{
				molgenisRoleGroupLinkWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					molgenisRoleGroupLinkWriter.write(new EntityTuple(e));
				}
			}
			finally {
				molgenisRoleGroupLinkWriter.close();
			}
		}
	}
	/**
	 *	export MolgenisPermission to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportMolgenisPermission(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(MolgenisPermission.class) > 0)
		{
			
			Query<MolgenisPermission> query = db.query(MolgenisPermission.class);
			
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("MolgenisPermission"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter molgenisPermissionWriter = new CsvWriter(f);
				try
				{
					query.find(molgenisPermissionWriter, fieldsToExport);
				}
				finally
				{
					molgenisPermissionWriter.close();
				}
			}
		}
	}
	
	public void exportMolgenisPermission(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter molgenisPermissionWriter = new CsvWriter(file);
			try
			{
				molgenisPermissionWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					molgenisPermissionWriter.write(new EntityTuple(e));
				}
			}
			finally {
				molgenisPermissionWriter.close();
			}
		}
	}
	/**
	 *	export StudyDataRequest to file.
	 *  @param db the database to export from.
	 *  @param f the file to export to.
	 */
	public void exportStudyDataRequest(Database db, File f, List<String> fieldsToExport, QueryRule ... rules) throws DatabaseException, IOException, ParseException, MolgenisModelException
	{
		if(db.count(StudyDataRequest.class) > 0)
		{
			
			Query<StudyDataRequest> query = db.query(StudyDataRequest.class);
			
			QueryRule[] newRules = matchQueryRulesToEntity(db.getMetaData().getEntity("StudyDataRequest"), rules);
			query.addRules(newRules);
			int count = query.count();
			if(count > 0){
				CsvWriter studyDataRequestWriter = new CsvWriter(f);
				try
				{
					query.find(studyDataRequestWriter, fieldsToExport);
				}
				finally
				{
					studyDataRequestWriter.close();
				}
			}
		}
	}
	
	public void exportStudyDataRequest(List<? extends Entity> entities, File file) throws IOException, MolgenisModelException
	{
		if(entities.size()>0)
		{
			//filter nulls
			List<String> fields = entities.get(0).getFields();
			List<String> notNulls = new ArrayList<String>();
			
			for(String f: fields)
			{
				for(Entity e: entities)
				{
					if(e.get(f) != null)
					{
						notNulls.add(f);
						break;
					}
				}
			}			
			
			//write
			CsvWriter studyDataRequestWriter = new CsvWriter(file);
			try
			{
				studyDataRequestWriter.writeColNames(notNulls);
				for(Entity e: entities)
				{
					studyDataRequestWriter.write(new EntityTuple(e));
				}
			}
			finally {
				studyDataRequestWriter.close();
			}
		}
	}
}