package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.observ.target.Accession;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class AccessionService
{
	private static final Logger logger = Logger.getLogger(AccessionService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	public Accession create(Accession accession) throws DatabaseException
	{
		logger.debug("creating Accession");
		db.add(accession);
		return accession;
	}

	public Accession read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving Accession");
		return db.findById(Accession.class, id);
	}

	public void update(Accession accession) throws DatabaseException
	{
		logger.debug("updating Accession");
		db.update(accession);
	}

	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting Accession");
		Accession accession = db.findById(Accession.class, id);
		return db.remove(accession) == 1;
	}
	
	public Iterable<Accession> readAll() throws DatabaseException
	{
		logger.debug("retrieving all Accession instances");
		return db.find(Accession.class);
	}
	
	public EntityPager<Accession> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all Accession instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(Accession.class, queryRules.toArray(new QueryRule[0]));
		List<Accession> accessionCollection = db.find(Accession.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<Accession>(start, num, count, accessionCollection);
	}
	
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("Accession");
	}
}