package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.observ.value.CategoricalValue;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class CategoricalValueService
{
	private static final Logger logger = Logger.getLogger(CategoricalValueService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	public CategoricalValue create(CategoricalValue categoricalValue) throws DatabaseException
	{
		logger.debug("creating CategoricalValue");
		db.add(categoricalValue);
		return categoricalValue;
	}

	public CategoricalValue read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving CategoricalValue");
		return db.findById(CategoricalValue.class, id);
	}

	public void update(CategoricalValue categoricalValue) throws DatabaseException
	{
		logger.debug("updating CategoricalValue");
		db.update(categoricalValue);
	}

	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting CategoricalValue");
		CategoricalValue categoricalValue = db.findById(CategoricalValue.class, id);
		return db.remove(categoricalValue) == 1;
	}
	
	public Iterable<CategoricalValue> readAll() throws DatabaseException
	{
		logger.debug("retrieving all CategoricalValue instances");
		return db.find(CategoricalValue.class);
	}
	
	public EntityPager<CategoricalValue> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all CategoricalValue instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(CategoricalValue.class, queryRules.toArray(new QueryRule[0]));
		List<CategoricalValue> categoricalValueCollection = db.find(CategoricalValue.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<CategoricalValue>(start, num, count, categoricalValueCollection);
	}
	
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("CategoricalValue");
	}
}