package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.observ.ObservableFeature;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class ObservableFeatureService
{
	private static final Logger logger = Logger.getLogger(ObservableFeatureService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	public ObservableFeature create(ObservableFeature observableFeature) throws DatabaseException
	{
		logger.debug("creating ObservableFeature");
		db.add(observableFeature);
		return observableFeature;
	}

	public ObservableFeature read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving ObservableFeature");
		return db.findById(ObservableFeature.class, id);
	}

	public void update(ObservableFeature observableFeature) throws DatabaseException
	{
		logger.debug("updating ObservableFeature");
		db.update(observableFeature);
	}

	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting ObservableFeature");
		ObservableFeature observableFeature = db.findById(ObservableFeature.class, id);
		return db.remove(observableFeature) == 1;
	}
	
	public Iterable<ObservableFeature> readAll() throws DatabaseException
	{
		logger.debug("retrieving all ObservableFeature instances");
		return db.find(ObservableFeature.class);
	}
	
	public EntityPager<ObservableFeature> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all ObservableFeature instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(ObservableFeature.class, queryRules.toArray(new QueryRule[0]));
		List<ObservableFeature> observableFeatureCollection = db.find(ObservableFeature.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<ObservableFeature>(start, num, count, observableFeatureCollection);
	}
	
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("ObservableFeature");
	}
}