package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.study.StudyDataRequest;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class StudyDataRequestService
{
	private static final Logger logger = Logger.getLogger(StudyDataRequestService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	public StudyDataRequest create(StudyDataRequest studyDataRequest) throws DatabaseException
	{
		logger.debug("creating StudyDataRequest");
		db.add(studyDataRequest);
		return studyDataRequest;
	}

	public StudyDataRequest read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving StudyDataRequest");
		return db.findById(StudyDataRequest.class, id);
	}

	public void update(StudyDataRequest studyDataRequest) throws DatabaseException
	{
		logger.debug("updating StudyDataRequest");
		db.update(studyDataRequest);
	}

	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting StudyDataRequest");
		StudyDataRequest studyDataRequest = db.findById(StudyDataRequest.class, id);
		return db.remove(studyDataRequest) == 1;
	}
	
	public Iterable<StudyDataRequest> readAll() throws DatabaseException
	{
		logger.debug("retrieving all StudyDataRequest instances");
		return db.find(StudyDataRequest.class);
	}
	
	public EntityPager<StudyDataRequest> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all StudyDataRequest instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(StudyDataRequest.class, queryRules.toArray(new QueryRule[0]));
		List<StudyDataRequest> studyDataRequestCollection = db.find(StudyDataRequest.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<StudyDataRequest>(start, num, count, studyDataRequestCollection);
	}
	
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("StudyDataRequest");
	}
}