package org.molgenis.controller;

import java.beans.PropertyEditorSupport;
import java.text.ParseException;
import java.lang.RuntimeException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.annotation.Nullable;
import javax.validation.Valid;

import org.apache.log4j.Logger;

import org.molgenis.omx.auth.MolgenisUser;
import org.molgenis.framework.server.EntityCollectionRequest;
import org.molgenis.framework.server.EntityCollectionResponse;
import org.molgenis.framework.db.DatabaseAccessException;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.EntityNotFoundException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.service.MolgenisUserService;
import org.molgenis.util.EntityPager;
import org.molgenis.util.ErrorMessageResponse;
import org.molgenis.util.ErrorMessageResponse.ErrorMessage;
import org.molgenis.util.MolgenisDateFormat;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import org.apache.commons.lang3.StringUtils;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;

@SuppressWarnings("unused")
@Lazy
@Controller
@RequestMapping("/api/v1/molgenisuser")
public class MolgenisUserController
{
	private static Logger logger = Logger.getLogger(MolgenisUserController.class);
	 
	@Autowired
	private MolgenisUserService molgenisUserService;

	@RequestMapping(method = RequestMethod.POST)
	@ResponseBody
	public ResponseEntity<MolgenisUserResponse> createMolgenisUser(@Valid @RequestBody MolgenisUserRequest molgenisUserRequest)
			throws DatabaseException
	{
		return _createMolgenisUser(molgenisUserRequest);
	}

	// Spring's FormHttpMessageConverter cannot bind target classes (as ModelAttribute can)
	@RequestMapping(method = RequestMethod.POST, headers = "Content-Type=application/x-www-form-urlencoded")
	@ResponseBody
	public ResponseEntity<MolgenisUserResponse> createMolgenisUserFromForm(@Valid @ModelAttribute MolgenisUserRequest molgenisUserRequest)
			throws DatabaseException
	{
		return _createMolgenisUser(molgenisUserRequest);
	}

	private ResponseEntity<MolgenisUserResponse> _createMolgenisUser(MolgenisUserRequest molgenisUserRequest) throws DatabaseException
	{
		MolgenisUser molgenisUser = molgenisUserService.create(molgenisUserRequest.toMolgenisUser());
		HttpHeaders responseHeaders = new HttpHeaders();
		responseHeaders.add("Location", "/api/v1/molgenisuser/" + molgenisUser.getId());
		return new ResponseEntity<MolgenisUserResponse>(responseHeaders, HttpStatus.CREATED);
	}

	@RequestMapping(value = "/{id}", method = RequestMethod.GET)
	@ResponseBody
	public MolgenisUserResponse retrieveMolgenisUser(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveMolgenisUser(id, expandFields);
	}
		
	@RequestMapping(value = "/{id}", method = RequestMethod.GET, params = "format=json", produces = "application/json")
	@ResponseBody
	public MolgenisUserResponse retrieveMolgenisUserJson(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveMolgenisUser(id, expandFields);
	}

	@InitBinder
	public void binder(WebDataBinder binder)
	{

		binder.registerCustomEditor(Date.class, new PropertyEditorSupport()
		{
			@Override
			public void setAsText(String value)
			{
				try
				{
					if (StringUtils.isNotBlank(value))
					{
						setValue(MolgenisDateFormat.getDateFormat().parse(value));
					}
				}
				catch (ParseException e)
				{
					throw new RuntimeException(e);
				}
			}

			@Override
			public String getAsText()
			{
				if (getValue() == null)
				{
					return null;
				}
				
				return MolgenisDateFormat.getDateFormat().format((Date) getValue());
			}

		});
	}

	private MolgenisUserResponse _retrieveMolgenisUser(Integer id, String... expandFieldsStr) throws DatabaseException
	{
		MolgenisUser molgenisUser = molgenisUserService.read(id);
		if (molgenisUser == null) throw new EntityNotFoundException("MolgenisUser " + id.toString() + " not found");
		Set<String> expandFields = expandFieldsStr != null ? new HashSet<String>(Arrays.asList(expandFieldsStr)) : null;
		return new MolgenisUserResponse(molgenisUser, expandFields);
	}
			


	@RequestMapping(value = "/{id}", method = RequestMethod.PUT)
	@ResponseStatus(HttpStatus.OK)
	public void updateMolgenisUser(@PathVariable Integer id, @Valid @RequestBody MolgenisUserRequest molgenisUserRequest)
			throws DatabaseException
	{
		_updateMolgenisUser(id, molgenisUserRequest);
	}

	// Spring's FormHttpMessageConverter cannot bind target classes (as ModelAttribute can)
	@RequestMapping(value = "/{id}", method = RequestMethod.PUT, headers = "Content-Type=application/x-www-form-urlencoded")
	@ResponseBody
	public ResponseEntity<MolgenisUserResponse> updateMolgenisUserFromForm(@PathVariable Integer id, @PathVariable String _method,
			@Valid @ModelAttribute MolgenisUserRequest molgenisUserRequest) throws DatabaseException
	{
		return _createMolgenisUser(molgenisUserRequest);
	}

	// Tunnel PUT through POST
	@RequestMapping(value = "/{id}", method = RequestMethod.POST, params = "_method=PUT")
	@ResponseStatus(HttpStatus.NO_CONTENT)
	public void updateMolgenisUserPost(@PathVariable Integer id, @Valid @RequestBody MolgenisUserRequest molgenisUserRequest)
			throws DatabaseException
	{
		_updateMolgenisUser(id, molgenisUserRequest);
	}

	// Tunnel PUT through POST
	@RequestMapping(value = "/{id}", method = RequestMethod.POST, params = "_method=PUT", headers = "Content-Type=application/x-www-form-urlencoded")
	@ResponseStatus(HttpStatus.NO_CONTENT)
	public void updateMolgenisUserFromFormPost(@PathVariable Integer id, @Valid @ModelAttribute MolgenisUserRequest molgenisUserRequest)
			throws DatabaseException
	{
		_updateMolgenisUser(id, molgenisUserRequest);
	}

	private void _updateMolgenisUser(Integer id, MolgenisUserRequest molgenisUserRequest) throws DatabaseException
	{
		MolgenisUser molgenisUser = molgenisUserRequest.toMolgenisUser();
		molgenisUser.setId(id);
		molgenisUserService.update(molgenisUser);
	}

	@RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
	@ResponseStatus(HttpStatus.NO_CONTENT)
	public void deleteMolgenisUser(@PathVariable Integer id) throws DatabaseException
	{
		_deleteMolgenisUser(id);
	}

	// Tunnel DELETE through POST
	@RequestMapping(value = "/{id}", method = RequestMethod.POST, params = "_method=DELETE")
	@ResponseStatus(HttpStatus.NO_CONTENT)
	public void deleteMolgenisUserPost(@PathVariable Integer id) throws DatabaseException
	{
		_deleteMolgenisUser(id);
	}

	private void _deleteMolgenisUser(Integer id) throws DatabaseException
	{
		boolean isDeleted = molgenisUserService.deleteById(id);
		if(!isDeleted) throw new EntityNotFoundException("MolgenisUser " + id.toString() + " not found");
	}
	
	@RequestMapping(method = RequestMethod.GET)
	@ResponseBody
	public EntityCollectionResponse<MolgenisUserResponse> retrieveMolgenisUserCollection(@Valid EntityCollectionRequest molgenisUserCollectionRequest, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveMolgenisUserCollection(molgenisUserCollectionRequest, expandFields);
	}

	@RequestMapping(method = RequestMethod.GET, params = "format=json", produces = "application/json")
	@ResponseBody
	public EntityCollectionResponse<MolgenisUserResponse> retrieveMolgenisUserCollectionJson(@Valid EntityCollectionRequest molgenisUserCollectionRequest, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveMolgenisUserCollection(molgenisUserCollectionRequest, expandFields);
	}

	// Tunnel GET with body through POST
	@RequestMapping(method = RequestMethod.POST, params = "_method=GET")
	@ResponseBody
	public EntityCollectionResponse<MolgenisUserResponse> retrieveMolgenisUserCollectionPost(@Valid @RequestBody EntityCollectionRequest molgenisUserCollectionRequest, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveMolgenisUserCollection(molgenisUserCollectionRequest, expandFields);
	}

	// Tunnel GET with body through POST
	@RequestMapping(method = RequestMethod.POST, params = {"_method=GET", "format=json"}, produces = "application/json")
	@ResponseBody
	public EntityCollectionResponse<MolgenisUserResponse> retrieveMolgenisUserCollectionJsonPost(@Valid @RequestBody EntityCollectionRequest molgenisUserCollectionRequest, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveMolgenisUserCollection(molgenisUserCollectionRequest, expandFields);
	}
	
	private EntityCollectionResponse<MolgenisUserResponse> _retrieveMolgenisUserCollection(EntityCollectionRequest entityCollectionRequest, String... expandFieldsStr) throws DatabaseException
	{
		EntityPager<MolgenisUser> molgenisUserPager = molgenisUserService.readAll(entityCollectionRequest.getStart(), entityCollectionRequest.getNum(), entityCollectionRequest.getQ());
		final Set<String> expandFields = expandFieldsStr != null ? new HashSet<String>(Arrays.asList(expandFieldsStr)) : null;
		return new EntityCollectionResponse<MolgenisUserResponse>(molgenisUserPager, Lists.newArrayList(Iterables.transform(
				molgenisUserPager.getIterable(), new Function<MolgenisUser, MolgenisUserResponse>()
				{
					@Override
					@Nullable
					public MolgenisUserResponse apply(@Nullable MolgenisUser molgenisUser)
					{
						try
						{
							return molgenisUser != null ? new MolgenisUserResponse(molgenisUser, expandFields) : null;
						} catch(DatabaseException e)
						{
							throw new RuntimeException(e);
						}
					}
				})), "/api/v1/molgenisuser");
	}

	private static class MolgenisUserRequest
	{
		private String username;
		private String password_;
		private String activationCode;
		private Boolean active = false;	
		private Boolean superuser = false;	
		private String firstName;
		private String midInitials;
		private String lastName;
		private String title;
		private String affiliation;
		private String department;
		private String role;
		private String address;
		private String phone;
		private String email;
		private String fax;
		private String tollFreePhone;
		private String city;
		private String country;
	
		public MolgenisUser toMolgenisUser()
		{
			MolgenisUser molgenisUser = new MolgenisUser();
			molgenisUser.setUsername(username);
			molgenisUser.setPassword(password_);
			molgenisUser.setActivationCode(activationCode);
			molgenisUser.setActive(active);
			molgenisUser.setSuperuser(superuser);
			molgenisUser.setFirstName(firstName);
			molgenisUser.setMidInitials(midInitials);
			molgenisUser.setLastName(lastName);
			molgenisUser.setTitle(title);
			molgenisUser.setAffiliation(affiliation);
			molgenisUser.setDepartment(department);
			molgenisUser.setRole(role);
			molgenisUser.setAddress(address);
			molgenisUser.setPhone(phone);
			molgenisUser.setEmail(email);
			molgenisUser.setFax(fax);
			molgenisUser.setTollFreePhone(tollFreePhone);
			molgenisUser.setCity(city);
			molgenisUser.setCountry(country);
			return molgenisUser;
		}
		
		public void setUsername(String username)
		{
			this.username = username;
		}
		
		public void setPassword_(String password_)
		{
			this.password_ = password_;
		}
		
		public void setActivationCode(String activationCode)
		{
			this.activationCode = activationCode;
		}
		
		public void setActive(Boolean active)
		{
			this.active = active;
		}
		
		public void setSuperuser(Boolean superuser)
		{
			this.superuser = superuser;
		}
		
		public void setFirstName(String firstName)
		{
			this.firstName = firstName;
		}
		
		public void setMidInitials(String midInitials)
		{
			this.midInitials = midInitials;
		}
		
		public void setLastName(String lastName)
		{
			this.lastName = lastName;
		}
		
		public void setTitle(String title)
		{
			this.title = title;
		}
		
		public void setAffiliation(String affiliation)
		{
			this.affiliation = affiliation;
		}
		
		public void setDepartment(String department)
		{
			this.department = department;
		}
		
		public void setRole(String role)
		{
			this.role = role;
		}
		
		public void setAddress(String address)
		{
			this.address = address;
		}
		
		public void setPhone(String phone)
		{
			this.phone = phone;
		}
		
		public void setEmail(String email)
		{
			this.email = email;
		}
		
		public void setFax(String fax)
		{
			this.fax = fax;
		}
		
		public void setTollFreePhone(String tollFreePhone)
		{
			this.tollFreePhone = tollFreePhone;
		}
		
		public void setCity(String city)
		{
			this.city = city;
		}
		
		public void setCountry(String country)
		{
			this.country = country;
		}
		
	}

	static class MolgenisUserResponse
	{
		private final String href;
		private final String username;
		private final String password_;
		private final String activationCode;
		private final Boolean active;
		private final Boolean superuser;
		private final String firstName;
		private final String midInitials;
		private final String lastName;
		private final String title;
		private final String affiliation;
		private final String department;
		private final String role;
		private final String address;
		private final String phone;
		private final String email;
		private final String fax;
		private final String tollFreePhone;
		private final String city;
		private final String country;
	
		public MolgenisUserResponse(MolgenisUser molgenisUser, final Set<String> expandFields) throws DatabaseException
		{
			this.href = "/api/v1/molgenisuser/" + molgenisUser.getId();
			this.username = molgenisUser.getUsername();
			this.password_ = molgenisUser.getPassword();
			this.activationCode = molgenisUser.getActivationCode();
			this.active = molgenisUser.getActive();
			this.superuser = molgenisUser.getSuperuser();
			this.firstName = molgenisUser.getFirstName();
			this.midInitials = molgenisUser.getMidInitials();
			this.lastName = molgenisUser.getLastName();
			this.title = molgenisUser.getTitle();
			this.affiliation = molgenisUser.getAffiliation();
			this.department = molgenisUser.getDepartment();
			this.role = molgenisUser.getRole();
			this.address = molgenisUser.getAddress();
			this.phone = molgenisUser.getPhone();
			this.email = molgenisUser.getEmail();
			this.fax = molgenisUser.getFax();
			this.tollFreePhone = molgenisUser.getTollFreePhone();
			this.city = molgenisUser.getCity();
			this.country = molgenisUser.getCountry();
		}
	
		public String getHref()
		{
			return href;
		}
	
		public String getUsername()
		{
			return username;
		}
	
		public String getPassword_()
		{
			return password_;
		}
	
		public String getActivationCode()
		{
			return activationCode;
		}
	
		public Boolean getActive()
		{
			return active;
		}
	
		public Boolean getSuperuser()
		{
			return superuser;
		}
	
		public String getFirstName()
		{
			return firstName;
		}
	
		public String getMidInitials()
		{
			return midInitials;
		}
	
		public String getLastName()
		{
			return lastName;
		}
	
		public String getTitle()
		{
			return title;
		}
	
		public String getAffiliation()
		{
			return affiliation;
		}
	
		public String getDepartment()
		{
			return department;
		}
	
		public String getRole()
		{
			return role;
		}
	
		public String getAddress()
		{
			return address;
		}
	
		public String getPhone()
		{
			return phone;
		}
	
		public String getEmail()
		{
			return email;
		}
	
		public String getFax()
		{
			return fax;
		}
	
		public String getTollFreePhone()
		{
			return tollFreePhone;
		}
	
		public String getCity()
		{
			return city;
		}
	
		public String getCountry()
		{
			return country;
		}
	
	}
	
	@ExceptionHandler(EntityNotFoundException.class)
	@ResponseStatus(value = HttpStatus.NOT_FOUND)
	@ResponseBody
	public ErrorMessageResponse handleEntityNotFoundException(EntityNotFoundException e)
	{
		logger.debug(e);
		return new ErrorMessageResponse(new ErrorMessage(e.getMessage()));
	}

	@ExceptionHandler(DatabaseException.class)
	@ResponseStatus(value = HttpStatus.INTERNAL_SERVER_ERROR)
	@ResponseBody
	public ErrorMessageResponse handleDatabaseException(DatabaseException e)
	{
		logger.error(e);
		return new ErrorMessageResponse(new ErrorMessage(e.getMessage()));
	}

	@ExceptionHandler(DatabaseAccessException.class)
	@ResponseStatus(value = HttpStatus.UNAUTHORIZED)
	@ResponseBody
	public ErrorMessageResponse handleDatabaseAccessException(DatabaseAccessException e)
	{
		logger.info(e);
		return new ErrorMessageResponse(new ErrorMessage(e.getMessage()));
	}
	
	@ExceptionHandler(RuntimeException.class)
	@ResponseStatus(value = HttpStatus.INTERNAL_SERVER_ERROR)
	@ResponseBody
	public ErrorMessageResponse handleRuntimeException(RuntimeException e)
	{
		logger.error(e);		
		return new ErrorMessageResponse(new ErrorMessage(e.getMessage()));
	}
}