
/* 
 * 
 * generator:   org.molgenis.generators.db.EntitiesImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
package org.molgenis;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.EntitySource;
import org.molgenis.data.Repository;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.EntitiesImporter;
import org.molgenis.framework.db.EntityImportReport;
import org.molgenis.framework.db.EntityImporter;

import org.molgenis.omx.core.db.MolgenisFileEntityImporter;
import org.molgenis.omx.core.db.RuntimePropertyEntityImporter;
import org.molgenis.omx.observ.db.CharacteristicEntityImporter;
import org.molgenis.omx.observ.db.ObservationTargetEntityImporter;
import org.molgenis.omx.observ.target.db.OntologyEntityImporter;
import org.molgenis.omx.observ.target.db.SpeciesEntityImporter;
import org.molgenis.omx.observ.target.db.OntologyTermEntityImporter;
import org.molgenis.omx.observ.target.db.AccessionEntityImporter;
import org.molgenis.omx.auth.db.InstituteEntityImporter;
import org.molgenis.omx.auth.db.PersonRoleEntityImporter;
import org.molgenis.omx.observ.db.ObservableFeatureEntityImporter;
import org.molgenis.omx.observ.db.CategoryEntityImporter;
import org.molgenis.omx.observ.db.ProtocolEntityImporter;
import org.molgenis.omx.observ.db.DataSetEntityImporter;
import org.molgenis.omx.observ.db.ObservationSetEntityImporter;
import org.molgenis.omx.auth.db.PersonEntityImporter;
import org.molgenis.omx.observ.value.db.ValueEntityImporter;
import org.molgenis.omx.observ.value.db.BoolValueEntityImporter;
import org.molgenis.omx.observ.value.db.CategoricalValueEntityImporter;
import org.molgenis.omx.observ.value.db.DateValueEntityImporter;
import org.molgenis.omx.observ.value.db.DateTimeValueEntityImporter;
import org.molgenis.omx.observ.value.db.DecimalValueEntityImporter;
import org.molgenis.omx.observ.value.db.EmailValueEntityImporter;
import org.molgenis.omx.observ.value.db.HtmlValueEntityImporter;
import org.molgenis.omx.observ.value.db.HyperlinkValueEntityImporter;
import org.molgenis.omx.observ.value.db.IntValueEntityImporter;
import org.molgenis.omx.observ.value.db.LongValueEntityImporter;
import org.molgenis.omx.observ.value.db.MrefValueEntityImporter;
import org.molgenis.omx.observ.value.db.StringValueEntityImporter;
import org.molgenis.omx.observ.value.db.TextValueEntityImporter;
import org.molgenis.omx.xgap.db.TrackEntityImporter;
import org.molgenis.omx.xgap.db.ChromosomeEntityImporter;
import org.molgenis.omx.xgap.db.VariantEntityImporter;
import org.molgenis.omx.xgap.db.NMRBinEntityImporter;
import org.molgenis.omx.xgap.db.CloneEntityImporter;
import org.molgenis.omx.xgap.db.DerivedTraitEntityImporter;
import org.molgenis.omx.xgap.db.EnvironmentalFactorEntityImporter;
import org.molgenis.omx.xgap.db.GeneEntityImporter;
import org.molgenis.omx.xgap.db.TranscriptEntityImporter;
import org.molgenis.omx.xgap.db.ProteinEntityImporter;
import org.molgenis.omx.xgap.db.MetaboliteEntityImporter;
import org.molgenis.omx.xgap.db.MarkerEntityImporter;
import org.molgenis.omx.xgap.db.PolymorphismEntityImporter;
import org.molgenis.omx.xgap.db.SNPEntityImporter;
import org.molgenis.omx.xgap.db.ProbeSetEntityImporter;
import org.molgenis.omx.xgap.db.ProbeEntityImporter;
import org.molgenis.omx.xgap.db.SpotEntityImporter;
import org.molgenis.omx.xgap.db.MassPeakEntityImporter;
import org.molgenis.omx.study.db.StudyDataRequestEntityImporter;
import org.molgenis.omx.workflow.db.ProtocolFlowEntityImporter;
import org.molgenis.omx.workflow.db.ObservationSetFlowEntityImporter;
import org.molgenis.omx.observ.db.ObservedValueEntityImporter;
import org.molgenis.omx.observ.target.db.IndividualEntityImporter;
import org.molgenis.omx.observ.target.db.PanelEntityImporter;
import org.molgenis.omx.observ.target.db.PanelSourceEntityImporter;
import org.molgenis.omx.observ.value.db.XrefValueEntityImporter;
import org.molgenis.omx.xgap.db.SampleEntityImporter;
import org.molgenis.omx.xgap.db.PairedSampleEntityImporter;
import org.molgenis.omx.patient.db.PatientEntityImporter;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class EntitiesImporterImpl implements EntitiesImporter
{
	/** importable entity names (lowercase) */
	private static final Map<String, EntityImporter> ENTITIES_IMPORTABLE;
	
	static {
		// entities added in import order
		ENTITIES_IMPORTABLE = new LinkedHashMap<String, EntityImporter>();
		ENTITIES_IMPORTABLE.put("molgenisfile", new MolgenisFileEntityImporter());
		ENTITIES_IMPORTABLE.put("runtimeproperty", new RuntimePropertyEntityImporter());
		ENTITIES_IMPORTABLE.put("characteristic", new CharacteristicEntityImporter());
		ENTITIES_IMPORTABLE.put("observationtarget", new ObservationTargetEntityImporter());
		ENTITIES_IMPORTABLE.put("ontology", new OntologyEntityImporter());
		ENTITIES_IMPORTABLE.put("species", new SpeciesEntityImporter());
		ENTITIES_IMPORTABLE.put("ontologyterm", new OntologyTermEntityImporter());
		ENTITIES_IMPORTABLE.put("accession", new AccessionEntityImporter());
		ENTITIES_IMPORTABLE.put("institute", new InstituteEntityImporter());
		ENTITIES_IMPORTABLE.put("personrole", new PersonRoleEntityImporter());
		ENTITIES_IMPORTABLE.put("observablefeature", new ObservableFeatureEntityImporter());
		ENTITIES_IMPORTABLE.put("category", new CategoryEntityImporter());
		ENTITIES_IMPORTABLE.put("protocol", new ProtocolEntityImporter());
		ENTITIES_IMPORTABLE.put("dataset", new DataSetEntityImporter());
		ENTITIES_IMPORTABLE.put("observationset", new ObservationSetEntityImporter());
		ENTITIES_IMPORTABLE.put("person", new PersonEntityImporter());
		ENTITIES_IMPORTABLE.put("value", new ValueEntityImporter());
		ENTITIES_IMPORTABLE.put("boolvalue", new BoolValueEntityImporter());
		ENTITIES_IMPORTABLE.put("categoricalvalue", new CategoricalValueEntityImporter());
		ENTITIES_IMPORTABLE.put("datevalue", new DateValueEntityImporter());
		ENTITIES_IMPORTABLE.put("datetimevalue", new DateTimeValueEntityImporter());
		ENTITIES_IMPORTABLE.put("decimalvalue", new DecimalValueEntityImporter());
		ENTITIES_IMPORTABLE.put("emailvalue", new EmailValueEntityImporter());
		ENTITIES_IMPORTABLE.put("htmlvalue", new HtmlValueEntityImporter());
		ENTITIES_IMPORTABLE.put("hyperlinkvalue", new HyperlinkValueEntityImporter());
		ENTITIES_IMPORTABLE.put("intvalue", new IntValueEntityImporter());
		ENTITIES_IMPORTABLE.put("longvalue", new LongValueEntityImporter());
		ENTITIES_IMPORTABLE.put("mrefvalue", new MrefValueEntityImporter());
		ENTITIES_IMPORTABLE.put("stringvalue", new StringValueEntityImporter());
		ENTITIES_IMPORTABLE.put("textvalue", new TextValueEntityImporter());
		ENTITIES_IMPORTABLE.put("track", new TrackEntityImporter());
		ENTITIES_IMPORTABLE.put("chromosome", new ChromosomeEntityImporter());
		ENTITIES_IMPORTABLE.put("variant", new VariantEntityImporter());
		ENTITIES_IMPORTABLE.put("nmrbin", new NMRBinEntityImporter());
		ENTITIES_IMPORTABLE.put("clone", new CloneEntityImporter());
		ENTITIES_IMPORTABLE.put("derivedtrait", new DerivedTraitEntityImporter());
		ENTITIES_IMPORTABLE.put("environmentalfactor", new EnvironmentalFactorEntityImporter());
		ENTITIES_IMPORTABLE.put("gene", new GeneEntityImporter());
		ENTITIES_IMPORTABLE.put("transcript", new TranscriptEntityImporter());
		ENTITIES_IMPORTABLE.put("protein", new ProteinEntityImporter());
		ENTITIES_IMPORTABLE.put("metabolite", new MetaboliteEntityImporter());
		ENTITIES_IMPORTABLE.put("marker", new MarkerEntityImporter());
		ENTITIES_IMPORTABLE.put("polymorphism", new PolymorphismEntityImporter());
		ENTITIES_IMPORTABLE.put("snp", new SNPEntityImporter());
		ENTITIES_IMPORTABLE.put("probeset", new ProbeSetEntityImporter());
		ENTITIES_IMPORTABLE.put("probe", new ProbeEntityImporter());
		ENTITIES_IMPORTABLE.put("spot", new SpotEntityImporter());
		ENTITIES_IMPORTABLE.put("masspeak", new MassPeakEntityImporter());
		ENTITIES_IMPORTABLE.put("studydatarequest", new StudyDataRequestEntityImporter());
		ENTITIES_IMPORTABLE.put("protocolflow", new ProtocolFlowEntityImporter());
		ENTITIES_IMPORTABLE.put("observationsetflow", new ObservationSetFlowEntityImporter());
		ENTITIES_IMPORTABLE.put("observedvalue", new ObservedValueEntityImporter());
		ENTITIES_IMPORTABLE.put("individual", new IndividualEntityImporter());
		ENTITIES_IMPORTABLE.put("panel", new PanelEntityImporter());
		ENTITIES_IMPORTABLE.put("panelsource", new PanelSourceEntityImporter());
		ENTITIES_IMPORTABLE.put("xrefvalue", new XrefValueEntityImporter());
		ENTITIES_IMPORTABLE.put("sample", new SampleEntityImporter());
		ENTITIES_IMPORTABLE.put("pairedsample", new PairedSampleEntityImporter());
		ENTITIES_IMPORTABLE.put("patient", new PatientEntityImporter());
	}
	
	private final Database database;
	private final DataService dataService;

	@Autowired
	public EntitiesImporterImpl(Database database, DataService dataService)
	{
		if (database == null) throw new IllegalArgumentException("database is null");
		if (dataService == null) throw new IllegalArgumentException("dataService is null");
		this.database = database;
		this.dataService = dataService;
	}

	@Override
	@Transactional(rollbackFor =
	{ IOException.class, DatabaseException.class })
	public EntityImportReport importEntities(File file, DatabaseAction dbAction) throws IOException, DatabaseException
	{
		return importEntities(dataService.createEntitySource(file), dbAction);
	}
	
	@Override
	@Transactional(rollbackFor =
	{ IOException.class, DatabaseException.class })
	public EntityImportReport importEntities(final Repository<? extends Entity> repository, final String entityName,
			DatabaseAction dbAction) throws IOException, DatabaseException
	{

		return importEntities(new EntitySource()
		{

			@Override
			public Iterable<String> getEntityNames()
			{
				return Collections.singleton(entityName);
			}

			@Override
			public Repository<? extends Entity> getRepositoryByEntityName(String name)
			{
				return repository;
			}

			@Override
			public void close() throws IOException
			{
				repository.close();
			}

			@Override
			public String getUrl()
			{
				return null;
			}

		}, dbAction);
	}

	@Override
	@Transactional(rollbackFor =
	{ IOException.class, DatabaseException.class })
	public EntityImportReport importEntities(EntitySource entitySource, DatabaseAction dbAction) throws IOException,
			DatabaseException
	{
		EntityImportReport importReport = new EntityImportReport();

		try
		{
			// map entity names on repositories
			Map<String, Repository<? extends Entity>> repositoryMap = new HashMap<String, Repository<? extends Entity>>();
			for (String entityName : entitySource.getEntityNames())
			{
				repositoryMap.put(entityName.toLowerCase(), entitySource.getRepositoryByEntityName(entityName));
			}

			// import entities in order defined by entities map
			for (Map.Entry<String, EntityImporter> entry : ENTITIES_IMPORTABLE.entrySet())
			{
				String entityName = entry.getKey();
				Repository<? extends Entity> repository = repositoryMap.get(entityName);
				if (repository != null)
				{
					EntityImporter entityImporter = entry.getValue();
					int nr = entityImporter.importEntity(repository, database, dbAction);
					if (nr > 0)
					{
						importReport.getMessages().put(entry.getKey(),
								"imported " + nr + " " + entityName + " entities");
						importReport.addNrImported(nr);
					}
				}

			}
		}
		finally
		{
			entitySource.close();
		}

		return importReport;
	}
}