
package org.molgenis;

import org.molgenis.omx.auth.MolgenisUser;	
import org.molgenis.omx.auth.MolgenisGroup;	
import org.molgenis.omx.auth.MolgenisGroupMember;	
import org.molgenis.omx.auth.UserAuthority;	
import org.molgenis.omx.auth.GroupAuthority;	
import org.molgenis.omx.core.MolgenisEntity;	
import org.molgenis.omx.core.MolgenisFile;	
import org.molgenis.omx.core.RuntimeProperty;	
import org.molgenis.omx.observ.Characteristic;	
import org.molgenis.omx.observ.ObservationTarget;	
import org.molgenis.omx.observ.ObservableFeature;	
import org.molgenis.omx.observ.Category;	
import org.molgenis.omx.observ.Protocol;	
import org.molgenis.omx.observ.DataSet;	
import org.molgenis.omx.observ.ObservationSet;	
import org.molgenis.omx.observ.ObservedValue;	
import org.molgenis.omx.observ.target.Species;	
import org.molgenis.omx.observ.target.Individual;	
import org.molgenis.omx.observ.target.Panel;	
import org.molgenis.omx.observ.target.PanelSource;	
import org.molgenis.omx.observ.target.Ontology;	
import org.molgenis.omx.observ.target.OntologyTerm;	
import org.molgenis.omx.observ.target.Accession;	
import org.molgenis.omx.auth.Institute;	
import org.molgenis.omx.auth.Person;	
import org.molgenis.omx.auth.PersonRole;	
import org.molgenis.omx.observ.value.Value;	
import org.molgenis.omx.observ.value.BoolValue;	
import org.molgenis.omx.observ.value.CategoricalValue;	
import org.molgenis.omx.observ.value.DateValue;	
import org.molgenis.omx.observ.value.DateTimeValue;	
import org.molgenis.omx.observ.value.DecimalValue;	
import org.molgenis.omx.observ.value.EmailValue;	
import org.molgenis.omx.observ.value.HtmlValue;	
import org.molgenis.omx.observ.value.HyperlinkValue;	
import org.molgenis.omx.observ.value.IntValue;	
import org.molgenis.omx.observ.value.LongValue;	
import org.molgenis.omx.observ.value.MrefValue;	
import org.molgenis.omx.observ.value.StringValue;	
import org.molgenis.omx.observ.value.TextValue;	
import org.molgenis.omx.observ.value.XrefValue;	
import org.molgenis.omx.xgap.Track;	
import org.molgenis.omx.xgap.Variant;	
import org.molgenis.omx.xgap.Chromosome;	
import org.molgenis.omx.xgap.NMRBin;	
import org.molgenis.omx.xgap.Clone;	
import org.molgenis.omx.xgap.DerivedTrait;	
import org.molgenis.omx.xgap.EnvironmentalFactor;	
import org.molgenis.omx.xgap.Gene;	
import org.molgenis.omx.xgap.Transcript;	
import org.molgenis.omx.xgap.Protein;	
import org.molgenis.omx.xgap.Metabolite;	
import org.molgenis.omx.xgap.Marker;	
import org.molgenis.omx.xgap.SNP;	
import org.molgenis.omx.xgap.Polymorphism;	
import org.molgenis.omx.xgap.Probe;	
import org.molgenis.omx.xgap.Spot;	
import org.molgenis.omx.xgap.ProbeSet;	
import org.molgenis.omx.xgap.MassPeak;	
import org.molgenis.omx.xgap.Sample;	
import org.molgenis.omx.xgap.PairedSample;	
import org.molgenis.omx.patient.Patient;	
import org.molgenis.omx.study.StudyDataRequest;	
import org.molgenis.omx.workflow.ProtocolFlow;	
import org.molgenis.omx.workflow.ObservationSetFlow;	

import org.springframework.beans.factory.annotation.Autowired;

public class SecuredJpaDatabase extends org.molgenis.framework.db.jpa.JpaDatabase
{    
	@Autowired
	public SecuredJpaDatabase(JDBCMetaDatabase jdbcMetaDatabase) throws org.molgenis.framework.db.DatabaseException
	{
		super(jdbcMetaDatabase);
        initMappers();
	}
	    
	private void initMappers()
	{
		this.putMapper(MolgenisUser.class, new org.molgenis.omx.auth.db.MolgenisUserSecurityDecorator<MolgenisUser>(new org.molgenis.omx.auth.db.MolgenisUserJpaMapper(this)));
		this.putMapper(MolgenisGroup.class, new org.molgenis.omx.auth.db.MolgenisGroupSecurityDecorator<MolgenisGroup>(new org.molgenis.omx.auth.db.MolgenisGroupJpaMapper(this)));
		this.putMapper(MolgenisGroupMember.class, new org.molgenis.omx.auth.db.MolgenisGroupMemberSecurityDecorator<MolgenisGroupMember>(new org.molgenis.omx.auth.db.MolgenisGroupMemberJpaMapper(this)));
		this.putMapper(UserAuthority.class, new org.molgenis.omx.auth.db.UserAuthoritySecurityDecorator<UserAuthority>(new org.molgenis.omx.auth.db.UserAuthorityJpaMapper(this)));
		this.putMapper(GroupAuthority.class, new org.molgenis.omx.auth.db.GroupAuthoritySecurityDecorator<GroupAuthority>(new org.molgenis.omx.auth.db.GroupAuthorityJpaMapper(this)));
		this.putMapper(MolgenisEntity.class, new org.molgenis.omx.core.db.MolgenisEntitySecurityDecorator<MolgenisEntity>(new org.molgenis.omx.core.db.MolgenisEntityJpaMapper(this)));
		this.putMapper(MolgenisFile.class, new org.molgenis.omx.decorators.MolgenisFileDecorator<MolgenisFile>(new org.molgenis.omx.core.db.MolgenisFileSecurityDecorator<MolgenisFile>(new org.molgenis.omx.core.db.MolgenisFileJpaMapper(this))));
		this.putMapper(RuntimeProperty.class, new org.molgenis.omx.core.db.RuntimePropertySecurityDecorator<RuntimeProperty>(new org.molgenis.omx.core.db.RuntimePropertyJpaMapper(this)));
		this.putMapper(Characteristic.class, new org.molgenis.omx.observ.db.CharacteristicSecurityDecorator<Characteristic>(new org.molgenis.omx.observ.db.CharacteristicJpaMapper(this)));
		this.putMapper(ObservationTarget.class, new org.molgenis.omx.observ.db.ObservationTargetSecurityDecorator<ObservationTarget>(new org.molgenis.omx.observ.db.ObservationTargetJpaMapper(this)));
		this.putMapper(ObservableFeature.class, new org.molgenis.omx.observ.db.ObservableFeatureSecurityDecorator<ObservableFeature>(new org.molgenis.omx.observ.db.ObservableFeatureJpaMapper(this)));
		this.putMapper(Category.class, new org.molgenis.omx.observ.db.CategorySecurityDecorator<Category>(new org.molgenis.omx.observ.db.CategoryJpaMapper(this)));
		this.putMapper(Protocol.class, new org.molgenis.omx.observ.db.ProtocolSecurityDecorator<Protocol>(new org.molgenis.omx.observ.db.ProtocolJpaMapper(this)));
		this.putMapper(DataSet.class, new org.molgenis.omx.observ.db.DataSetSecurityDecorator<DataSet>(new org.molgenis.omx.observ.db.DataSetJpaMapper(this)));
		this.putMapper(ObservationSet.class, new org.molgenis.omx.observ.db.ObservationSetSecurityDecorator<ObservationSet>(new org.molgenis.omx.observ.db.ObservationSetJpaMapper(this)));
		this.putMapper(ObservedValue.class, new org.molgenis.omx.observ.db.ObservedValueSecurityDecorator<ObservedValue>(new org.molgenis.omx.observ.db.ObservedValueJpaMapper(this)));
		this.putMapper(Species.class, new org.molgenis.omx.observ.target.db.SpeciesSecurityDecorator<Species>(new org.molgenis.omx.observ.target.db.SpeciesJpaMapper(this)));
		this.putMapper(Individual.class, new org.molgenis.omx.observ.target.db.IndividualSecurityDecorator<Individual>(new org.molgenis.omx.observ.target.db.IndividualJpaMapper(this)));
		this.putMapper(Panel.class, new org.molgenis.omx.observ.target.db.PanelSecurityDecorator<Panel>(new org.molgenis.omx.observ.target.db.PanelJpaMapper(this)));
		this.putMapper(PanelSource.class, new org.molgenis.omx.observ.target.db.PanelSourceSecurityDecorator<PanelSource>(new org.molgenis.omx.observ.target.db.PanelSourceJpaMapper(this)));
		this.putMapper(Ontology.class, new org.molgenis.omx.observ.target.db.OntologySecurityDecorator<Ontology>(new org.molgenis.omx.observ.target.db.OntologyJpaMapper(this)));
		this.putMapper(OntologyTerm.class, new org.molgenis.omx.observ.target.db.OntologyTermSecurityDecorator<OntologyTerm>(new org.molgenis.omx.observ.target.db.OntologyTermJpaMapper(this)));
		this.putMapper(Accession.class, new org.molgenis.omx.observ.target.db.AccessionSecurityDecorator<Accession>(new org.molgenis.omx.observ.target.db.AccessionJpaMapper(this)));
		this.putMapper(Institute.class, new org.molgenis.omx.auth.db.InstituteSecurityDecorator<Institute>(new org.molgenis.omx.auth.db.InstituteJpaMapper(this)));
		this.putMapper(Person.class, new org.molgenis.omx.auth.db.PersonSecurityDecorator<Person>(new org.molgenis.omx.auth.db.PersonJpaMapper(this)));
		this.putMapper(PersonRole.class, new org.molgenis.omx.auth.db.PersonRoleSecurityDecorator<PersonRole>(new org.molgenis.omx.auth.db.PersonRoleJpaMapper(this)));
		this.putMapper(Value.class, new org.molgenis.omx.observ.value.db.ValueSecurityDecorator<Value>(new org.molgenis.omx.observ.value.db.ValueJpaMapper(this)));
		this.putMapper(BoolValue.class, new org.molgenis.omx.observ.value.db.BoolValueSecurityDecorator<BoolValue>(new org.molgenis.omx.observ.value.db.BoolValueJpaMapper(this)));
		this.putMapper(CategoricalValue.class, new org.molgenis.omx.observ.value.db.CategoricalValueSecurityDecorator<CategoricalValue>(new org.molgenis.omx.observ.value.db.CategoricalValueJpaMapper(this)));
		this.putMapper(DateValue.class, new org.molgenis.omx.observ.value.db.DateValueSecurityDecorator<DateValue>(new org.molgenis.omx.observ.value.db.DateValueJpaMapper(this)));
		this.putMapper(DateTimeValue.class, new org.molgenis.omx.observ.value.db.DateTimeValueSecurityDecorator<DateTimeValue>(new org.molgenis.omx.observ.value.db.DateTimeValueJpaMapper(this)));
		this.putMapper(DecimalValue.class, new org.molgenis.omx.observ.value.db.DecimalValueSecurityDecorator<DecimalValue>(new org.molgenis.omx.observ.value.db.DecimalValueJpaMapper(this)));
		this.putMapper(EmailValue.class, new org.molgenis.omx.decorators.EmailValueDecorator<EmailValue>(new org.molgenis.omx.observ.value.db.EmailValueSecurityDecorator<EmailValue>(new org.molgenis.omx.observ.value.db.EmailValueJpaMapper(this))));
		this.putMapper(HtmlValue.class, new org.molgenis.omx.observ.value.db.HtmlValueSecurityDecorator<HtmlValue>(new org.molgenis.omx.observ.value.db.HtmlValueJpaMapper(this)));
		this.putMapper(HyperlinkValue.class, new org.molgenis.omx.decorators.HyperlinkValueDecorator<HyperlinkValue>(new org.molgenis.omx.observ.value.db.HyperlinkValueSecurityDecorator<HyperlinkValue>(new org.molgenis.omx.observ.value.db.HyperlinkValueJpaMapper(this))));
		this.putMapper(IntValue.class, new org.molgenis.omx.observ.value.db.IntValueSecurityDecorator<IntValue>(new org.molgenis.omx.observ.value.db.IntValueJpaMapper(this)));
		this.putMapper(LongValue.class, new org.molgenis.omx.observ.value.db.LongValueSecurityDecorator<LongValue>(new org.molgenis.omx.observ.value.db.LongValueJpaMapper(this)));
		this.putMapper(MrefValue.class, new org.molgenis.omx.observ.value.db.MrefValueSecurityDecorator<MrefValue>(new org.molgenis.omx.observ.value.db.MrefValueJpaMapper(this)));
		this.putMapper(StringValue.class, new org.molgenis.omx.observ.value.db.StringValueSecurityDecorator<StringValue>(new org.molgenis.omx.observ.value.db.StringValueJpaMapper(this)));
		this.putMapper(TextValue.class, new org.molgenis.omx.observ.value.db.TextValueSecurityDecorator<TextValue>(new org.molgenis.omx.observ.value.db.TextValueJpaMapper(this)));
		this.putMapper(XrefValue.class, new org.molgenis.omx.observ.value.db.XrefValueSecurityDecorator<XrefValue>(new org.molgenis.omx.observ.value.db.XrefValueJpaMapper(this)));
		this.putMapper(Track.class, new org.molgenis.omx.xgap.db.TrackSecurityDecorator<Track>(new org.molgenis.omx.xgap.db.TrackJpaMapper(this)));
		this.putMapper(Variant.class, new org.molgenis.omx.xgap.db.VariantSecurityDecorator<Variant>(new org.molgenis.omx.xgap.db.VariantJpaMapper(this)));
		this.putMapper(Chromosome.class, new org.molgenis.omx.xgap.db.ChromosomeSecurityDecorator<Chromosome>(new org.molgenis.omx.xgap.db.ChromosomeJpaMapper(this)));
		this.putMapper(NMRBin.class, new org.molgenis.omx.xgap.db.NMRBinSecurityDecorator<NMRBin>(new org.molgenis.omx.xgap.db.NMRBinJpaMapper(this)));
		this.putMapper(Clone.class, new org.molgenis.omx.xgap.db.CloneSecurityDecorator<Clone>(new org.molgenis.omx.xgap.db.CloneJpaMapper(this)));
		this.putMapper(DerivedTrait.class, new org.molgenis.omx.xgap.db.DerivedTraitSecurityDecorator<DerivedTrait>(new org.molgenis.omx.xgap.db.DerivedTraitJpaMapper(this)));
		this.putMapper(EnvironmentalFactor.class, new org.molgenis.omx.xgap.db.EnvironmentalFactorSecurityDecorator<EnvironmentalFactor>(new org.molgenis.omx.xgap.db.EnvironmentalFactorJpaMapper(this)));
		this.putMapper(Gene.class, new org.molgenis.omx.xgap.db.GeneSecurityDecorator<Gene>(new org.molgenis.omx.xgap.db.GeneJpaMapper(this)));
		this.putMapper(Transcript.class, new org.molgenis.omx.xgap.db.TranscriptSecurityDecorator<Transcript>(new org.molgenis.omx.xgap.db.TranscriptJpaMapper(this)));
		this.putMapper(Protein.class, new org.molgenis.omx.xgap.db.ProteinSecurityDecorator<Protein>(new org.molgenis.omx.xgap.db.ProteinJpaMapper(this)));
		this.putMapper(Metabolite.class, new org.molgenis.omx.xgap.db.MetaboliteSecurityDecorator<Metabolite>(new org.molgenis.omx.xgap.db.MetaboliteJpaMapper(this)));
		this.putMapper(Marker.class, new org.molgenis.omx.xgap.db.MarkerSecurityDecorator<Marker>(new org.molgenis.omx.xgap.db.MarkerJpaMapper(this)));
		this.putMapper(SNP.class, new org.molgenis.omx.xgap.db.SNPSecurityDecorator<SNP>(new org.molgenis.omx.xgap.db.SNPJpaMapper(this)));
		this.putMapper(Polymorphism.class, new org.molgenis.omx.xgap.db.PolymorphismSecurityDecorator<Polymorphism>(new org.molgenis.omx.xgap.db.PolymorphismJpaMapper(this)));
		this.putMapper(Probe.class, new org.molgenis.omx.xgap.db.ProbeSecurityDecorator<Probe>(new org.molgenis.omx.xgap.db.ProbeJpaMapper(this)));
		this.putMapper(Spot.class, new org.molgenis.omx.xgap.db.SpotSecurityDecorator<Spot>(new org.molgenis.omx.xgap.db.SpotJpaMapper(this)));
		this.putMapper(ProbeSet.class, new org.molgenis.omx.xgap.db.ProbeSetSecurityDecorator<ProbeSet>(new org.molgenis.omx.xgap.db.ProbeSetJpaMapper(this)));
		this.putMapper(MassPeak.class, new org.molgenis.omx.xgap.db.MassPeakSecurityDecorator<MassPeak>(new org.molgenis.omx.xgap.db.MassPeakJpaMapper(this)));
		this.putMapper(Sample.class, new org.molgenis.omx.xgap.db.SampleSecurityDecorator<Sample>(new org.molgenis.omx.xgap.db.SampleJpaMapper(this)));
		this.putMapper(PairedSample.class, new org.molgenis.omx.xgap.db.PairedSampleSecurityDecorator<PairedSample>(new org.molgenis.omx.xgap.db.PairedSampleJpaMapper(this)));
		this.putMapper(Patient.class, new org.molgenis.omx.patient.db.PatientSecurityDecorator<Patient>(new org.molgenis.omx.patient.db.PatientJpaMapper(this)));
		this.putMapper(StudyDataRequest.class, new org.molgenis.omx.study.StudyDataRequestDecorator<StudyDataRequest>(new org.molgenis.omx.study.db.StudyDataRequestSecurityDecorator<StudyDataRequest>(new org.molgenis.omx.study.db.StudyDataRequestJpaMapper(this))));
		this.putMapper(ProtocolFlow.class, new org.molgenis.omx.workflow.db.ProtocolFlowSecurityDecorator<ProtocolFlow>(new org.molgenis.omx.workflow.db.ProtocolFlowJpaMapper(this)));
		this.putMapper(ObservationSetFlow.class, new org.molgenis.omx.workflow.db.ObservationSetFlowSecurityDecorator<ObservationSetFlow>(new org.molgenis.omx.workflow.db.ObservationSetFlowJpaMapper(this)));
	}
}
