package org.molgenis.controller;

import java.beans.PropertyEditorSupport;
import java.text.ParseException;
import java.lang.RuntimeException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.annotation.Nullable;
import javax.validation.Valid;

import org.apache.log4j.Logger;

import org.molgenis.omx.workflow.ObservationSetFlow;
import org.molgenis.framework.server.EntityCollectionRequest;
import org.molgenis.framework.server.EntityCollectionResponse;
import org.molgenis.framework.db.DatabaseAccessException;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.EntityNotFoundException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.service.ObservationSetFlowService;
import org.molgenis.omx.observ.ObservationSet;
import org.molgenis.controller.ObservationSetController.ObservationSetResponse;
import org.molgenis.service.ObservationSetService;
import org.molgenis.util.EntityPager;
import org.molgenis.util.ErrorMessageResponse;
import org.molgenis.util.ErrorMessageResponse.ErrorMessage;
import org.molgenis.util.MolgenisDateFormat;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import org.apache.commons.lang3.StringUtils;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;

@SuppressWarnings("unused")
@Lazy
@Controller
@RequestMapping("/api/v1/observationsetflow")
public class ObservationSetFlowController
{
	private static Logger logger = Logger.getLogger(ObservationSetFlowController.class);
	 
	@Autowired
	private ObservationSetFlowService observationSetFlowService;

	@Autowired
	private ObservationSetService observationSetService;
		
	@RequestMapping(method = RequestMethod.POST)
	@ResponseBody
	public ResponseEntity<ObservationSetFlowResponse> createObservationSetFlow(@Valid @RequestBody ObservationSetFlowRequest observationSetFlowRequest)
			throws DatabaseException
	{
		return _createObservationSetFlow(observationSetFlowRequest);
	}

	// Spring's FormHttpMessageConverter cannot bind target classes (as ModelAttribute can)
	@RequestMapping(method = RequestMethod.POST, headers = "Content-Type=application/x-www-form-urlencoded")
	@ResponseBody
	public ResponseEntity<ObservationSetFlowResponse> createObservationSetFlowFromForm(@Valid @ModelAttribute ObservationSetFlowRequest observationSetFlowRequest)
			throws DatabaseException
	{
		return _createObservationSetFlow(observationSetFlowRequest);
	}

	private ResponseEntity<ObservationSetFlowResponse> _createObservationSetFlow(ObservationSetFlowRequest observationSetFlowRequest) throws DatabaseException
	{
		ObservationSetFlow observationSetFlow = observationSetFlowService.create(observationSetFlowRequest.toObservationSetFlow());
		HttpHeaders responseHeaders = new HttpHeaders();
		responseHeaders.add("Location", "/api/v1/observationsetflow/" + observationSetFlow.getId());
		return new ResponseEntity<ObservationSetFlowResponse>(responseHeaders, HttpStatus.CREATED);
	}

	@RequestMapping(value = "/{id}", method = RequestMethod.GET)
	@ResponseBody
	public ObservationSetFlowResponse retrieveObservationSetFlow(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveObservationSetFlow(id, expandFields);
	}
		
	@RequestMapping(value = "/{id}", method = RequestMethod.GET, params = "format=json", produces = "application/json")
	@ResponseBody
	public ObservationSetFlowResponse retrieveObservationSetFlowJson(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveObservationSetFlow(id, expandFields);
	}

	@InitBinder
	public void binder(WebDataBinder binder)
	{

		binder.registerCustomEditor(Date.class, new PropertyEditorSupport()
		{
			@Override
			public void setAsText(String value)
			{
				try
				{
					if (StringUtils.isNotBlank(value))
					{
						setValue(MolgenisDateFormat.getDateFormat().parse(value));
					}
				}
				catch (ParseException e)
				{
					throw new RuntimeException(e);
				}
			}

			@Override
			public String getAsText()
			{
				if (getValue() == null)
				{
					return null;
				}
				
				return MolgenisDateFormat.getDateFormat().format((Date) getValue());
			}

		});
	}

	private ObservationSetFlowResponse _retrieveObservationSetFlow(Integer id, String... expandFieldsStr) throws DatabaseException
	{
		ObservationSetFlow observationSetFlow = observationSetFlowService.read(id);
		if (observationSetFlow == null) throw new EntityNotFoundException("ObservationSetFlow " + id.toString() + " not found");
		Set<String> expandFields = expandFieldsStr != null ? new HashSet<String>(Arrays.asList(expandFieldsStr)) : null;
		return new ObservationSetFlowResponse(observationSetFlow, expandFields);
	}
			
	@RequestMapping(value = "/{id}/source", method = RequestMethod.GET)
	public String retrieveObservationSetFlowXrefSource(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveObservationSetFlowXrefSource(id, null, expandFields);
	}
	
	@RequestMapping(value = "/{id}/source", method = RequestMethod.GET, params = "format=json", produces = "application/json")
	public String retrieveObservationSetFlowXrefSourceJson(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveObservationSetFlowXrefSource(id, "json", expandFields);
	}
	
	private String _retrieveObservationSetFlowXrefSource(Integer id, String format, String... expandFieldsStr) throws DatabaseException
	{
		ObservationSetFlow observationSetFlow = observationSetFlowService.read(id);
		if (observationSetFlow == null) throw new EntityNotFoundException("ObservationSetFlow " + id.toString() + " not found");
		Integer observationSetId = observationSetFlow.getSource_Id();
		String redirectUri = "redirect:/api/v1/observationset/" + observationSetId.toString();
		StringBuilder qsBuilder = new StringBuilder();
		if(format != null) qsBuilder.append(qsBuilder.length() == 0 ? '?' : '&').append("format=").append(format);
		if(expandFieldsStr != null) qsBuilder.append(qsBuilder.length() == 0 ? '?' : '&').append("expand=").append(Joiner.on(',').join(expandFieldsStr));
		return qsBuilder.length() == 0 ? redirectUri : redirectUri + qsBuilder.toString();
	}
	
	@RequestMapping(value = "/{id}/destination", method = RequestMethod.GET)
	public String retrieveObservationSetFlowXrefDestination(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveObservationSetFlowXrefDestination(id, null, expandFields);
	}
	
	@RequestMapping(value = "/{id}/destination", method = RequestMethod.GET, params = "format=json", produces = "application/json")
	public String retrieveObservationSetFlowXrefDestinationJson(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveObservationSetFlowXrefDestination(id, "json", expandFields);
	}
	
	private String _retrieveObservationSetFlowXrefDestination(Integer id, String format, String... expandFieldsStr) throws DatabaseException
	{
		ObservationSetFlow observationSetFlow = observationSetFlowService.read(id);
		if (observationSetFlow == null) throw new EntityNotFoundException("ObservationSetFlow " + id.toString() + " not found");
		Integer observationSetId = observationSetFlow.getDestination_Id();
		String redirectUri = "redirect:/api/v1/observationset/" + observationSetId.toString();
		StringBuilder qsBuilder = new StringBuilder();
		if(format != null) qsBuilder.append(qsBuilder.length() == 0 ? '?' : '&').append("format=").append(format);
		if(expandFieldsStr != null) qsBuilder.append(qsBuilder.length() == 0 ? '?' : '&').append("expand=").append(Joiner.on(',').join(expandFieldsStr));
		return qsBuilder.length() == 0 ? redirectUri : redirectUri + qsBuilder.toString();
	}
	


	@RequestMapping(value = "/{id}", method = RequestMethod.PUT)
	@ResponseStatus(HttpStatus.OK)
	public void updateObservationSetFlow(@PathVariable Integer id, @Valid @RequestBody ObservationSetFlowRequest observationSetFlowRequest)
			throws DatabaseException
	{
		_updateObservationSetFlow(id, observationSetFlowRequest);
	}

	// Spring's FormHttpMessageConverter cannot bind target classes (as ModelAttribute can)
	@RequestMapping(value = "/{id}", method = RequestMethod.PUT, headers = "Content-Type=application/x-www-form-urlencoded")
	@ResponseBody
	public ResponseEntity<ObservationSetFlowResponse> updateObservationSetFlowFromForm(@PathVariable Integer id, @PathVariable String _method,
			@Valid @ModelAttribute ObservationSetFlowRequest observationSetFlowRequest) throws DatabaseException
	{
		return _createObservationSetFlow(observationSetFlowRequest);
	}

	// Tunnel PUT through POST
	@RequestMapping(value = "/{id}", method = RequestMethod.POST, params = "_method=PUT")
	@ResponseStatus(HttpStatus.NO_CONTENT)
	public void updateObservationSetFlowPost(@PathVariable Integer id, @Valid @RequestBody ObservationSetFlowRequest observationSetFlowRequest)
			throws DatabaseException
	{
		_updateObservationSetFlow(id, observationSetFlowRequest);
	}

	// Tunnel PUT through POST
	@RequestMapping(value = "/{id}", method = RequestMethod.POST, params = "_method=PUT", headers = "Content-Type=application/x-www-form-urlencoded")
	@ResponseStatus(HttpStatus.NO_CONTENT)
	public void updateObservationSetFlowFromFormPost(@PathVariable Integer id, @Valid @ModelAttribute ObservationSetFlowRequest observationSetFlowRequest)
			throws DatabaseException
	{
		_updateObservationSetFlow(id, observationSetFlowRequest);
	}

	private void _updateObservationSetFlow(Integer id, ObservationSetFlowRequest observationSetFlowRequest) throws DatabaseException
	{
		ObservationSetFlow observationSetFlow = observationSetFlowRequest.toObservationSetFlow();
		observationSetFlow.setId(id);
		observationSetFlowService.update(observationSetFlow);
	}

	@RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
	@ResponseStatus(HttpStatus.NO_CONTENT)
	public void deleteObservationSetFlow(@PathVariable Integer id) throws DatabaseException
	{
		_deleteObservationSetFlow(id);
	}

	// Tunnel DELETE through POST
	@RequestMapping(value = "/{id}", method = RequestMethod.POST, params = "_method=DELETE")
	@ResponseStatus(HttpStatus.NO_CONTENT)
	public void deleteObservationSetFlowPost(@PathVariable Integer id) throws DatabaseException
	{
		_deleteObservationSetFlow(id);
	}

	private void _deleteObservationSetFlow(Integer id) throws DatabaseException
	{
		boolean isDeleted = observationSetFlowService.deleteById(id);
		if(!isDeleted) throw new EntityNotFoundException("ObservationSetFlow " + id.toString() + " not found");
	}
	
	@RequestMapping(method = RequestMethod.GET)
	@ResponseBody
	public EntityCollectionResponse<ObservationSetFlowResponse> retrieveObservationSetFlowCollection(@Valid EntityCollectionRequest observationSetFlowCollectionRequest, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveObservationSetFlowCollection(observationSetFlowCollectionRequest, expandFields);
	}

	@RequestMapping(method = RequestMethod.GET, params = "format=json", produces = "application/json")
	@ResponseBody
	public EntityCollectionResponse<ObservationSetFlowResponse> retrieveObservationSetFlowCollectionJson(@Valid EntityCollectionRequest observationSetFlowCollectionRequest, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveObservationSetFlowCollection(observationSetFlowCollectionRequest, expandFields);
	}

	// Tunnel GET with body through POST
	@RequestMapping(method = RequestMethod.POST, params = "_method=GET")
	@ResponseBody
	public EntityCollectionResponse<ObservationSetFlowResponse> retrieveObservationSetFlowCollectionPost(@Valid @RequestBody EntityCollectionRequest observationSetFlowCollectionRequest, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveObservationSetFlowCollection(observationSetFlowCollectionRequest, expandFields);
	}

	// Tunnel GET with body through POST
	@RequestMapping(method = RequestMethod.POST, params = {"_method=GET", "format=json"}, produces = "application/json")
	@ResponseBody
	public EntityCollectionResponse<ObservationSetFlowResponse> retrieveObservationSetFlowCollectionJsonPost(@Valid @RequestBody EntityCollectionRequest observationSetFlowCollectionRequest, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveObservationSetFlowCollection(observationSetFlowCollectionRequest, expandFields);
	}
	
	private EntityCollectionResponse<ObservationSetFlowResponse> _retrieveObservationSetFlowCollection(EntityCollectionRequest entityCollectionRequest, String... expandFieldsStr) throws DatabaseException
	{
		EntityPager<ObservationSetFlow> observationSetFlowPager = observationSetFlowService.readAll(entityCollectionRequest.getStart(), entityCollectionRequest.getNum(), entityCollectionRequest.getQ());
		final Set<String> expandFields = expandFieldsStr != null ? new HashSet<String>(Arrays.asList(expandFieldsStr)) : null;
		return new EntityCollectionResponse<ObservationSetFlowResponse>(observationSetFlowPager, Lists.newArrayList(Iterables.transform(
				observationSetFlowPager.getIterable(), new Function<ObservationSetFlow, ObservationSetFlowResponse>()
				{
					@Override
					@Nullable
					public ObservationSetFlowResponse apply(@Nullable ObservationSetFlow observationSetFlow)
					{
						try
						{
							return observationSetFlow != null ? new ObservationSetFlowResponse(observationSetFlow, expandFields) : null;
						} catch(DatabaseException e)
						{
							throw new RuntimeException(e);
						}
					}
				})), "/api/v1/observationsetflow");
	}

	private static class ObservationSetFlowRequest
	{
		private Integer source;
		private Integer destination;
	
		public ObservationSetFlow toObservationSetFlow()
		{
			ObservationSetFlow observationSetFlow = new ObservationSetFlow();
			observationSetFlow.setSource_Id(source);
			observationSetFlow.setDestination_Id(destination);
			return observationSetFlow;
		}
		
		public void setSource(Integer source)
		{
			this.source = source;
		}
		
		public void setDestination(Integer destination)
		{
			this.destination = destination;
		}
		
	}

	static class ObservationSetFlowResponse
	{
		private final String href;
		private final Object source;
		private final Object destination;
	
		public ObservationSetFlowResponse(ObservationSetFlow observationSetFlow, final Set<String> expandFields) throws DatabaseException
		{
			this.href = "/api/v1/observationsetflow/" + observationSetFlow.getId();
			if (expandFields != null && expandFields.contains("source")) this.source = new ObservationSetResponse(observationSetFlow.getSource(), null);
			else this.source = java.util.Collections.singletonMap("href", "/api/v1/observationsetflow/" + observationSetFlow.getId() + "/source");
			if (expandFields != null && expandFields.contains("destination")) this.destination = new ObservationSetResponse(observationSetFlow.getDestination(), null);
			else this.destination = java.util.Collections.singletonMap("href", "/api/v1/observationsetflow/" + observationSetFlow.getId() + "/destination");
		}
	
		public String getHref()
		{
			return href;
		}
	
		public Object getSource()
		{
			return source;
		}
	
		public Object getDestination()
		{
			return destination;
		}
	
	}
	
	@ExceptionHandler(EntityNotFoundException.class)
	@ResponseStatus(value = HttpStatus.NOT_FOUND)
	@ResponseBody
	public ErrorMessageResponse handleEntityNotFoundException(EntityNotFoundException e)
	{
		logger.debug(e);
		return new ErrorMessageResponse(new ErrorMessage(e.getMessage()));
	}

	@ExceptionHandler(DatabaseException.class)
	@ResponseStatus(value = HttpStatus.INTERNAL_SERVER_ERROR)
	@ResponseBody
	public ErrorMessageResponse handleDatabaseException(DatabaseException e)
	{
		logger.error(e);
		return new ErrorMessageResponse(new ErrorMessage(e.getMessage()));
	}

	@ExceptionHandler(DatabaseAccessException.class)
	@ResponseStatus(value = HttpStatus.UNAUTHORIZED)
	@ResponseBody
	public ErrorMessageResponse handleDatabaseAccessException(DatabaseAccessException e)
	{
		logger.info(e);
		return new ErrorMessageResponse(new ErrorMessage(e.getMessage()));
	}
	
	@ExceptionHandler(RuntimeException.class)
	@ResponseStatus(value = HttpStatus.INTERNAL_SERVER_ERROR)
	@ResponseBody
	public ErrorMessageResponse handleRuntimeException(RuntimeException e)
	{
		logger.error(e);		
		return new ErrorMessageResponse(new ErrorMessage(e.getMessage()));
	}
}