package org.molgenis.controller;

import java.beans.PropertyEditorSupport;
import java.text.ParseException;
import java.lang.RuntimeException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.annotation.Nullable;
import javax.validation.Valid;

import org.apache.log4j.Logger;

import org.molgenis.omx.auth.MolgenisGroup;
import org.molgenis.framework.server.EntityCollectionRequest;
import org.molgenis.framework.server.EntityCollectionResponse;
import org.molgenis.framework.db.DatabaseAccessException;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.EntityNotFoundException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.service.MolgenisGroupService;
import org.molgenis.util.EntityPager;
import org.molgenis.util.ErrorMessageResponse;
import org.molgenis.util.ErrorMessageResponse.ErrorMessage;
import org.molgenis.util.MolgenisDateFormat;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import org.apache.commons.lang3.StringUtils;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;

@SuppressWarnings("unused")
@Lazy
@Controller
@RequestMapping("/api/v1/molgenisgroup")
public class MolgenisGroupController
{
	private static Logger logger = Logger.getLogger(MolgenisGroupController.class);
	 
	@Autowired
	private MolgenisGroupService molgenisGroupService;

	@RequestMapping(method = RequestMethod.POST)
	@ResponseBody
	public ResponseEntity<MolgenisGroupResponse> createMolgenisGroup(@Valid @RequestBody MolgenisGroupRequest molgenisGroupRequest)
			throws DatabaseException
	{
		return _createMolgenisGroup(molgenisGroupRequest);
	}

	// Spring's FormHttpMessageConverter cannot bind target classes (as ModelAttribute can)
	@RequestMapping(method = RequestMethod.POST, headers = "Content-Type=application/x-www-form-urlencoded")
	@ResponseBody
	public ResponseEntity<MolgenisGroupResponse> createMolgenisGroupFromForm(@Valid @ModelAttribute MolgenisGroupRequest molgenisGroupRequest)
			throws DatabaseException
	{
		return _createMolgenisGroup(molgenisGroupRequest);
	}

	private ResponseEntity<MolgenisGroupResponse> _createMolgenisGroup(MolgenisGroupRequest molgenisGroupRequest) throws DatabaseException
	{
		MolgenisGroup molgenisGroup = molgenisGroupService.create(molgenisGroupRequest.toMolgenisGroup());
		HttpHeaders responseHeaders = new HttpHeaders();
		responseHeaders.add("Location", "/api/v1/molgenisgroup/" + molgenisGroup.getId());
		return new ResponseEntity<MolgenisGroupResponse>(responseHeaders, HttpStatus.CREATED);
	}

	@RequestMapping(value = "/{id}", method = RequestMethod.GET)
	@ResponseBody
	public MolgenisGroupResponse retrieveMolgenisGroup(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveMolgenisGroup(id, expandFields);
	}
		
	@RequestMapping(value = "/{id}", method = RequestMethod.GET, params = "format=json", produces = "application/json")
	@ResponseBody
	public MolgenisGroupResponse retrieveMolgenisGroupJson(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveMolgenisGroup(id, expandFields);
	}

	@InitBinder
	public void binder(WebDataBinder binder)
	{

		binder.registerCustomEditor(Date.class, new PropertyEditorSupport()
		{
			@Override
			public void setAsText(String value)
			{
				try
				{
					if (StringUtils.isNotBlank(value))
					{
						setValue(MolgenisDateFormat.getDateFormat().parse(value));
					}
				}
				catch (ParseException e)
				{
					throw new RuntimeException(e);
				}
			}

			@Override
			public String getAsText()
			{
				if (getValue() == null)
				{
					return null;
				}
				
				return MolgenisDateFormat.getDateFormat().format((Date) getValue());
			}

		});
	}

	private MolgenisGroupResponse _retrieveMolgenisGroup(Integer id, String... expandFieldsStr) throws DatabaseException
	{
		MolgenisGroup molgenisGroup = molgenisGroupService.read(id);
		if (molgenisGroup == null) throw new EntityNotFoundException("MolgenisGroup " + id.toString() + " not found");
		Set<String> expandFields = expandFieldsStr != null ? new HashSet<String>(Arrays.asList(expandFieldsStr)) : null;
		return new MolgenisGroupResponse(molgenisGroup, expandFields);
	}
			


	@RequestMapping(value = "/{id}", method = RequestMethod.PUT)
	@ResponseStatus(HttpStatus.OK)
	public void updateMolgenisGroup(@PathVariable Integer id, @Valid @RequestBody MolgenisGroupRequest molgenisGroupRequest)
			throws DatabaseException
	{
		_updateMolgenisGroup(id, molgenisGroupRequest);
	}

	// Spring's FormHttpMessageConverter cannot bind target classes (as ModelAttribute can)
	@RequestMapping(value = "/{id}", method = RequestMethod.PUT, headers = "Content-Type=application/x-www-form-urlencoded")
	@ResponseBody
	public ResponseEntity<MolgenisGroupResponse> updateMolgenisGroupFromForm(@PathVariable Integer id, @PathVariable String _method,
			@Valid @ModelAttribute MolgenisGroupRequest molgenisGroupRequest) throws DatabaseException
	{
		return _createMolgenisGroup(molgenisGroupRequest);
	}

	// Tunnel PUT through POST
	@RequestMapping(value = "/{id}", method = RequestMethod.POST, params = "_method=PUT")
	@ResponseStatus(HttpStatus.NO_CONTENT)
	public void updateMolgenisGroupPost(@PathVariable Integer id, @Valid @RequestBody MolgenisGroupRequest molgenisGroupRequest)
			throws DatabaseException
	{
		_updateMolgenisGroup(id, molgenisGroupRequest);
	}

	// Tunnel PUT through POST
	@RequestMapping(value = "/{id}", method = RequestMethod.POST, params = "_method=PUT", headers = "Content-Type=application/x-www-form-urlencoded")
	@ResponseStatus(HttpStatus.NO_CONTENT)
	public void updateMolgenisGroupFromFormPost(@PathVariable Integer id, @Valid @ModelAttribute MolgenisGroupRequest molgenisGroupRequest)
			throws DatabaseException
	{
		_updateMolgenisGroup(id, molgenisGroupRequest);
	}

	private void _updateMolgenisGroup(Integer id, MolgenisGroupRequest molgenisGroupRequest) throws DatabaseException
	{
		MolgenisGroup molgenisGroup = molgenisGroupRequest.toMolgenisGroup();
		molgenisGroup.setId(id);
		molgenisGroupService.update(molgenisGroup);
	}

	@RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
	@ResponseStatus(HttpStatus.NO_CONTENT)
	public void deleteMolgenisGroup(@PathVariable Integer id) throws DatabaseException
	{
		_deleteMolgenisGroup(id);
	}

	// Tunnel DELETE through POST
	@RequestMapping(value = "/{id}", method = RequestMethod.POST, params = "_method=DELETE")
	@ResponseStatus(HttpStatus.NO_CONTENT)
	public void deleteMolgenisGroupPost(@PathVariable Integer id) throws DatabaseException
	{
		_deleteMolgenisGroup(id);
	}

	private void _deleteMolgenisGroup(Integer id) throws DatabaseException
	{
		boolean isDeleted = molgenisGroupService.deleteById(id);
		if(!isDeleted) throw new EntityNotFoundException("MolgenisGroup " + id.toString() + " not found");
	}
	
	@RequestMapping(method = RequestMethod.GET)
	@ResponseBody
	public EntityCollectionResponse<MolgenisGroupResponse> retrieveMolgenisGroupCollection(@Valid EntityCollectionRequest molgenisGroupCollectionRequest, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveMolgenisGroupCollection(molgenisGroupCollectionRequest, expandFields);
	}

	@RequestMapping(method = RequestMethod.GET, params = "format=json", produces = "application/json")
	@ResponseBody
	public EntityCollectionResponse<MolgenisGroupResponse> retrieveMolgenisGroupCollectionJson(@Valid EntityCollectionRequest molgenisGroupCollectionRequest, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveMolgenisGroupCollection(molgenisGroupCollectionRequest, expandFields);
	}

	// Tunnel GET with body through POST
	@RequestMapping(method = RequestMethod.POST, params = "_method=GET")
	@ResponseBody
	public EntityCollectionResponse<MolgenisGroupResponse> retrieveMolgenisGroupCollectionPost(@Valid @RequestBody EntityCollectionRequest molgenisGroupCollectionRequest, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveMolgenisGroupCollection(molgenisGroupCollectionRequest, expandFields);
	}

	// Tunnel GET with body through POST
	@RequestMapping(method = RequestMethod.POST, params = {"_method=GET", "format=json"}, produces = "application/json")
	@ResponseBody
	public EntityCollectionResponse<MolgenisGroupResponse> retrieveMolgenisGroupCollectionJsonPost(@Valid @RequestBody EntityCollectionRequest molgenisGroupCollectionRequest, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveMolgenisGroupCollection(molgenisGroupCollectionRequest, expandFields);
	}
	
	private EntityCollectionResponse<MolgenisGroupResponse> _retrieveMolgenisGroupCollection(EntityCollectionRequest entityCollectionRequest, String... expandFieldsStr) throws DatabaseException
	{
		EntityPager<MolgenisGroup> molgenisGroupPager = molgenisGroupService.readAll(entityCollectionRequest.getStart(), entityCollectionRequest.getNum(), entityCollectionRequest.getQ());
		final Set<String> expandFields = expandFieldsStr != null ? new HashSet<String>(Arrays.asList(expandFieldsStr)) : null;
		return new EntityCollectionResponse<MolgenisGroupResponse>(molgenisGroupPager, Lists.newArrayList(Iterables.transform(
				molgenisGroupPager.getIterable(), new Function<MolgenisGroup, MolgenisGroupResponse>()
				{
					@Override
					@Nullable
					public MolgenisGroupResponse apply(@Nullable MolgenisGroup molgenisGroup)
					{
						try
						{
							return molgenisGroup != null ? new MolgenisGroupResponse(molgenisGroup, expandFields) : null;
						} catch(DatabaseException e)
						{
							throw new RuntimeException(e);
						}
					}
				})), "/api/v1/molgenisgroup");
	}

	private static class MolgenisGroupRequest
	{
		private String name;
	
		public MolgenisGroup toMolgenisGroup()
		{
			MolgenisGroup molgenisGroup = new MolgenisGroup();
			molgenisGroup.setName(name);
			return molgenisGroup;
		}
		
		public void setName(String name)
		{
			this.name = name;
		}
		
	}

	static class MolgenisGroupResponse
	{
		private final String href;
		private final String name;
	
		public MolgenisGroupResponse(MolgenisGroup molgenisGroup, final Set<String> expandFields) throws DatabaseException
		{
			this.href = "/api/v1/molgenisgroup/" + molgenisGroup.getId();
			this.name = molgenisGroup.getName();
		}
	
		public String getHref()
		{
			return href;
		}
	
		public String getName()
		{
			return name;
		}
	
	}
	
	@ExceptionHandler(EntityNotFoundException.class)
	@ResponseStatus(value = HttpStatus.NOT_FOUND)
	@ResponseBody
	public ErrorMessageResponse handleEntityNotFoundException(EntityNotFoundException e)
	{
		logger.debug(e);
		return new ErrorMessageResponse(new ErrorMessage(e.getMessage()));
	}

	@ExceptionHandler(DatabaseException.class)
	@ResponseStatus(value = HttpStatus.INTERNAL_SERVER_ERROR)
	@ResponseBody
	public ErrorMessageResponse handleDatabaseException(DatabaseException e)
	{
		logger.error(e);
		return new ErrorMessageResponse(new ErrorMessage(e.getMessage()));
	}

	@ExceptionHandler(DatabaseAccessException.class)
	@ResponseStatus(value = HttpStatus.UNAUTHORIZED)
	@ResponseBody
	public ErrorMessageResponse handleDatabaseAccessException(DatabaseAccessException e)
	{
		logger.info(e);
		return new ErrorMessageResponse(new ErrorMessage(e.getMessage()));
	}
	
	@ExceptionHandler(RuntimeException.class)
	@ResponseStatus(value = HttpStatus.INTERNAL_SERVER_ERROR)
	@ResponseBody
	public ErrorMessageResponse handleRuntimeException(RuntimeException e)
	{
		logger.error(e);		
		return new ErrorMessageResponse(new ErrorMessage(e.getMessage()));
	}
}