package org.molgenis.controller;

import java.beans.PropertyEditorSupport;
import java.text.ParseException;
import java.lang.RuntimeException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.annotation.Nullable;
import javax.validation.Valid;

import org.apache.log4j.Logger;

import org.molgenis.omx.auth.MolgenisGroupMember;
import org.molgenis.framework.server.EntityCollectionRequest;
import org.molgenis.framework.server.EntityCollectionResponse;
import org.molgenis.framework.db.DatabaseAccessException;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.EntityNotFoundException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.service.MolgenisGroupMemberService;
import org.molgenis.util.EntityPager;
import org.molgenis.util.ErrorMessageResponse;
import org.molgenis.util.ErrorMessageResponse.ErrorMessage;
import org.molgenis.util.MolgenisDateFormat;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import org.apache.commons.lang3.StringUtils;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;

@SuppressWarnings("unused")
@Lazy
@Controller
@RequestMapping("/api/v1/molgenisgroupmember")
public class MolgenisGroupMemberController
{
	private static Logger logger = Logger.getLogger(MolgenisGroupMemberController.class);
	 
	@Autowired
	private MolgenisGroupMemberService molgenisGroupMemberService;

	@RequestMapping(method = RequestMethod.POST)
	@ResponseBody
	public ResponseEntity<MolgenisGroupMemberResponse> createMolgenisGroupMember(@Valid @RequestBody MolgenisGroupMemberRequest molgenisGroupMemberRequest)
			throws DatabaseException
	{
		return _createMolgenisGroupMember(molgenisGroupMemberRequest);
	}

	// Spring's FormHttpMessageConverter cannot bind target classes (as ModelAttribute can)
	@RequestMapping(method = RequestMethod.POST, headers = "Content-Type=application/x-www-form-urlencoded")
	@ResponseBody
	public ResponseEntity<MolgenisGroupMemberResponse> createMolgenisGroupMemberFromForm(@Valid @ModelAttribute MolgenisGroupMemberRequest molgenisGroupMemberRequest)
			throws DatabaseException
	{
		return _createMolgenisGroupMember(molgenisGroupMemberRequest);
	}

	private ResponseEntity<MolgenisGroupMemberResponse> _createMolgenisGroupMember(MolgenisGroupMemberRequest molgenisGroupMemberRequest) throws DatabaseException
	{
		MolgenisGroupMember molgenisGroupMember = molgenisGroupMemberService.create(molgenisGroupMemberRequest.toMolgenisGroupMember());
		HttpHeaders responseHeaders = new HttpHeaders();
		responseHeaders.add("Location", "/api/v1/molgenisgroupmember/" + molgenisGroupMember.getId());
		return new ResponseEntity<MolgenisGroupMemberResponse>(responseHeaders, HttpStatus.CREATED);
	}

	@RequestMapping(value = "/{id}", method = RequestMethod.GET)
	@ResponseBody
	public MolgenisGroupMemberResponse retrieveMolgenisGroupMember(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveMolgenisGroupMember(id, expandFields);
	}
		
	@RequestMapping(value = "/{id}", method = RequestMethod.GET, params = "format=json", produces = "application/json")
	@ResponseBody
	public MolgenisGroupMemberResponse retrieveMolgenisGroupMemberJson(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveMolgenisGroupMember(id, expandFields);
	}

	@InitBinder
	public void binder(WebDataBinder binder)
	{

		binder.registerCustomEditor(Date.class, new PropertyEditorSupport()
		{
			@Override
			public void setAsText(String value)
			{
				try
				{
					if (StringUtils.isNotBlank(value))
					{
						setValue(MolgenisDateFormat.getDateFormat().parse(value));
					}
				}
				catch (ParseException e)
				{
					throw new RuntimeException(e);
				}
			}

			@Override
			public String getAsText()
			{
				if (getValue() == null)
				{
					return null;
				}
				
				return MolgenisDateFormat.getDateFormat().format((Date) getValue());
			}

		});
	}

	private MolgenisGroupMemberResponse _retrieveMolgenisGroupMember(Integer id, String... expandFieldsStr) throws DatabaseException
	{
		MolgenisGroupMember molgenisGroupMember = molgenisGroupMemberService.read(id);
		if (molgenisGroupMember == null) throw new EntityNotFoundException("MolgenisGroupMember " + id.toString() + " not found");
		Set<String> expandFields = expandFieldsStr != null ? new HashSet<String>(Arrays.asList(expandFieldsStr)) : null;
		return new MolgenisGroupMemberResponse(molgenisGroupMember, expandFields);
	}
			
	@RequestMapping(value = "/{id}/molgenisUser", method = RequestMethod.GET)
	public String retrieveMolgenisGroupMemberXrefMolgenisUser(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveMolgenisGroupMemberXrefMolgenisUser(id, null, expandFields);
	}
	
	@RequestMapping(value = "/{id}/molgenisUser", method = RequestMethod.GET, params = "format=json", produces = "application/json")
	public String retrieveMolgenisGroupMemberXrefMolgenisUserJson(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveMolgenisGroupMemberXrefMolgenisUser(id, "json", expandFields);
	}
	
	private String _retrieveMolgenisGroupMemberXrefMolgenisUser(Integer id, String format, String... expandFieldsStr) throws DatabaseException
	{
		MolgenisGroupMember molgenisGroupMember = molgenisGroupMemberService.read(id);
		if (molgenisGroupMember == null) throw new EntityNotFoundException("MolgenisGroupMember " + id.toString() + " not found");
		Integer molgenisUserId = molgenisGroupMember.getMolgenisUser_Id();
		String redirectUri = "redirect:/api/v1/molgenisuser/" + molgenisUserId.toString();
		StringBuilder qsBuilder = new StringBuilder();
		if(format != null) qsBuilder.append(qsBuilder.length() == 0 ? '?' : '&').append("format=").append(format);
		if(expandFieldsStr != null) qsBuilder.append(qsBuilder.length() == 0 ? '?' : '&').append("expand=").append(Joiner.on(',').join(expandFieldsStr));
		return qsBuilder.length() == 0 ? redirectUri : redirectUri + qsBuilder.toString();
	}
	
	@RequestMapping(value = "/{id}/molgenisGroup", method = RequestMethod.GET)
	public String retrieveMolgenisGroupMemberXrefMolgenisGroup(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveMolgenisGroupMemberXrefMolgenisGroup(id, null, expandFields);
	}
	
	@RequestMapping(value = "/{id}/molgenisGroup", method = RequestMethod.GET, params = "format=json", produces = "application/json")
	public String retrieveMolgenisGroupMemberXrefMolgenisGroupJson(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveMolgenisGroupMemberXrefMolgenisGroup(id, "json", expandFields);
	}
	
	private String _retrieveMolgenisGroupMemberXrefMolgenisGroup(Integer id, String format, String... expandFieldsStr) throws DatabaseException
	{
		MolgenisGroupMember molgenisGroupMember = molgenisGroupMemberService.read(id);
		if (molgenisGroupMember == null) throw new EntityNotFoundException("MolgenisGroupMember " + id.toString() + " not found");
		Integer molgenisGroupId = molgenisGroupMember.getMolgenisGroup_Id();
		String redirectUri = "redirect:/api/v1/molgenisgroup/" + molgenisGroupId.toString();
		StringBuilder qsBuilder = new StringBuilder();
		if(format != null) qsBuilder.append(qsBuilder.length() == 0 ? '?' : '&').append("format=").append(format);
		if(expandFieldsStr != null) qsBuilder.append(qsBuilder.length() == 0 ? '?' : '&').append("expand=").append(Joiner.on(',').join(expandFieldsStr));
		return qsBuilder.length() == 0 ? redirectUri : redirectUri + qsBuilder.toString();
	}
	


	@RequestMapping(value = "/{id}", method = RequestMethod.PUT)
	@ResponseStatus(HttpStatus.OK)
	public void updateMolgenisGroupMember(@PathVariable Integer id, @Valid @RequestBody MolgenisGroupMemberRequest molgenisGroupMemberRequest)
			throws DatabaseException
	{
		_updateMolgenisGroupMember(id, molgenisGroupMemberRequest);
	}

	// Spring's FormHttpMessageConverter cannot bind target classes (as ModelAttribute can)
	@RequestMapping(value = "/{id}", method = RequestMethod.PUT, headers = "Content-Type=application/x-www-form-urlencoded")
	@ResponseBody
	public ResponseEntity<MolgenisGroupMemberResponse> updateMolgenisGroupMemberFromForm(@PathVariable Integer id, @PathVariable String _method,
			@Valid @ModelAttribute MolgenisGroupMemberRequest molgenisGroupMemberRequest) throws DatabaseException
	{
		return _createMolgenisGroupMember(molgenisGroupMemberRequest);
	}

	// Tunnel PUT through POST
	@RequestMapping(value = "/{id}", method = RequestMethod.POST, params = "_method=PUT")
	@ResponseStatus(HttpStatus.NO_CONTENT)
	public void updateMolgenisGroupMemberPost(@PathVariable Integer id, @Valid @RequestBody MolgenisGroupMemberRequest molgenisGroupMemberRequest)
			throws DatabaseException
	{
		_updateMolgenisGroupMember(id, molgenisGroupMemberRequest);
	}

	// Tunnel PUT through POST
	@RequestMapping(value = "/{id}", method = RequestMethod.POST, params = "_method=PUT", headers = "Content-Type=application/x-www-form-urlencoded")
	@ResponseStatus(HttpStatus.NO_CONTENT)
	public void updateMolgenisGroupMemberFromFormPost(@PathVariable Integer id, @Valid @ModelAttribute MolgenisGroupMemberRequest molgenisGroupMemberRequest)
			throws DatabaseException
	{
		_updateMolgenisGroupMember(id, molgenisGroupMemberRequest);
	}

	private void _updateMolgenisGroupMember(Integer id, MolgenisGroupMemberRequest molgenisGroupMemberRequest) throws DatabaseException
	{
		MolgenisGroupMember molgenisGroupMember = molgenisGroupMemberRequest.toMolgenisGroupMember();
		molgenisGroupMember.setId(id);
		molgenisGroupMemberService.update(molgenisGroupMember);
	}

	@RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
	@ResponseStatus(HttpStatus.NO_CONTENT)
	public void deleteMolgenisGroupMember(@PathVariable Integer id) throws DatabaseException
	{
		_deleteMolgenisGroupMember(id);
	}

	// Tunnel DELETE through POST
	@RequestMapping(value = "/{id}", method = RequestMethod.POST, params = "_method=DELETE")
	@ResponseStatus(HttpStatus.NO_CONTENT)
	public void deleteMolgenisGroupMemberPost(@PathVariable Integer id) throws DatabaseException
	{
		_deleteMolgenisGroupMember(id);
	}

	private void _deleteMolgenisGroupMember(Integer id) throws DatabaseException
	{
		boolean isDeleted = molgenisGroupMemberService.deleteById(id);
		if(!isDeleted) throw new EntityNotFoundException("MolgenisGroupMember " + id.toString() + " not found");
	}
	
	@RequestMapping(method = RequestMethod.GET)
	@ResponseBody
	public EntityCollectionResponse<MolgenisGroupMemberResponse> retrieveMolgenisGroupMemberCollection(@Valid EntityCollectionRequest molgenisGroupMemberCollectionRequest, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveMolgenisGroupMemberCollection(molgenisGroupMemberCollectionRequest, expandFields);
	}

	@RequestMapping(method = RequestMethod.GET, params = "format=json", produces = "application/json")
	@ResponseBody
	public EntityCollectionResponse<MolgenisGroupMemberResponse> retrieveMolgenisGroupMemberCollectionJson(@Valid EntityCollectionRequest molgenisGroupMemberCollectionRequest, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveMolgenisGroupMemberCollection(molgenisGroupMemberCollectionRequest, expandFields);
	}

	// Tunnel GET with body through POST
	@RequestMapping(method = RequestMethod.POST, params = "_method=GET")
	@ResponseBody
	public EntityCollectionResponse<MolgenisGroupMemberResponse> retrieveMolgenisGroupMemberCollectionPost(@Valid @RequestBody EntityCollectionRequest molgenisGroupMemberCollectionRequest, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveMolgenisGroupMemberCollection(molgenisGroupMemberCollectionRequest, expandFields);
	}

	// Tunnel GET with body through POST
	@RequestMapping(method = RequestMethod.POST, params = {"_method=GET", "format=json"}, produces = "application/json")
	@ResponseBody
	public EntityCollectionResponse<MolgenisGroupMemberResponse> retrieveMolgenisGroupMemberCollectionJsonPost(@Valid @RequestBody EntityCollectionRequest molgenisGroupMemberCollectionRequest, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrieveMolgenisGroupMemberCollection(molgenisGroupMemberCollectionRequest, expandFields);
	}
	
	private EntityCollectionResponse<MolgenisGroupMemberResponse> _retrieveMolgenisGroupMemberCollection(EntityCollectionRequest entityCollectionRequest, String... expandFieldsStr) throws DatabaseException
	{
		EntityPager<MolgenisGroupMember> molgenisGroupMemberPager = molgenisGroupMemberService.readAll(entityCollectionRequest.getStart(), entityCollectionRequest.getNum(), entityCollectionRequest.getQ());
		final Set<String> expandFields = expandFieldsStr != null ? new HashSet<String>(Arrays.asList(expandFieldsStr)) : null;
		return new EntityCollectionResponse<MolgenisGroupMemberResponse>(molgenisGroupMemberPager, Lists.newArrayList(Iterables.transform(
				molgenisGroupMemberPager.getIterable(), new Function<MolgenisGroupMember, MolgenisGroupMemberResponse>()
				{
					@Override
					@Nullable
					public MolgenisGroupMemberResponse apply(@Nullable MolgenisGroupMember molgenisGroupMember)
					{
						try
						{
							return molgenisGroupMember != null ? new MolgenisGroupMemberResponse(molgenisGroupMember, expandFields) : null;
						} catch(DatabaseException e)
						{
							throw new RuntimeException(e);
						}
					}
				})), "/api/v1/molgenisgroupmember");
	}

	private static class MolgenisGroupMemberRequest
	{
	
		public MolgenisGroupMember toMolgenisGroupMember()
		{
			MolgenisGroupMember molgenisGroupMember = new MolgenisGroupMember();
			return molgenisGroupMember;
		}
		
		
		
	}

	static class MolgenisGroupMemberResponse
	{
		private final String href;
	
		public MolgenisGroupMemberResponse(MolgenisGroupMember molgenisGroupMember, final Set<String> expandFields) throws DatabaseException
		{
			this.href = "/api/v1/molgenisgroupmember/" + molgenisGroupMember.getId();
		}
	
		public String getHref()
		{
			return href;
		}
	
	
	
	}
	
	@ExceptionHandler(EntityNotFoundException.class)
	@ResponseStatus(value = HttpStatus.NOT_FOUND)
	@ResponseBody
	public ErrorMessageResponse handleEntityNotFoundException(EntityNotFoundException e)
	{
		logger.debug(e);
		return new ErrorMessageResponse(new ErrorMessage(e.getMessage()));
	}

	@ExceptionHandler(DatabaseException.class)
	@ResponseStatus(value = HttpStatus.INTERNAL_SERVER_ERROR)
	@ResponseBody
	public ErrorMessageResponse handleDatabaseException(DatabaseException e)
	{
		logger.error(e);
		return new ErrorMessageResponse(new ErrorMessage(e.getMessage()));
	}

	@ExceptionHandler(DatabaseAccessException.class)
	@ResponseStatus(value = HttpStatus.UNAUTHORIZED)
	@ResponseBody
	public ErrorMessageResponse handleDatabaseAccessException(DatabaseAccessException e)
	{
		logger.info(e);
		return new ErrorMessageResponse(new ErrorMessage(e.getMessage()));
	}
	
	@ExceptionHandler(RuntimeException.class)
	@ResponseStatus(value = HttpStatus.INTERNAL_SERVER_ERROR)
	@ResponseBody
	public ErrorMessageResponse handleRuntimeException(RuntimeException e)
	{
		logger.error(e);		
		return new ErrorMessageResponse(new ErrorMessage(e.getMessage()));
	}
}