package org.molgenis.controller;

import java.beans.PropertyEditorSupport;
import java.text.ParseException;
import java.lang.RuntimeException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.annotation.Nullable;
import javax.validation.Valid;

import org.apache.log4j.Logger;

import org.molgenis.omx.xgap.PairedSample;
import org.molgenis.framework.server.EntityCollectionRequest;
import org.molgenis.framework.server.EntityCollectionResponse;
import org.molgenis.framework.db.DatabaseAccessException;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.EntityNotFoundException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.service.PairedSampleService;
import org.molgenis.omx.observ.target.Individual;
import org.molgenis.controller.IndividualController.IndividualResponse;
import org.molgenis.service.IndividualService;
import org.molgenis.omx.observ.target.OntologyTerm;
import org.molgenis.controller.OntologyTermController.OntologyTermResponse;
import org.molgenis.service.OntologyTermService;
import org.molgenis.util.EntityPager;
import org.molgenis.util.ErrorMessageResponse;
import org.molgenis.util.ErrorMessageResponse.ErrorMessage;
import org.molgenis.util.MolgenisDateFormat;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import org.apache.commons.lang3.StringUtils;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;

@SuppressWarnings("unused")
@Lazy
@Controller
@RequestMapping("/api/v1/pairedsample")
public class PairedSampleController
{
	private static Logger logger = Logger.getLogger(PairedSampleController.class);
	 
	@Autowired
	private PairedSampleService pairedSampleService;

	@Autowired
	private IndividualService individualService;
		
	@Autowired
	private OntologyTermService ontologyTermService;
		
	@RequestMapping(method = RequestMethod.POST)
	@ResponseBody
	public ResponseEntity<PairedSampleResponse> createPairedSample(@Valid @RequestBody PairedSampleRequest pairedSampleRequest)
			throws DatabaseException
	{
		return _createPairedSample(pairedSampleRequest);
	}

	// Spring's FormHttpMessageConverter cannot bind target classes (as ModelAttribute can)
	@RequestMapping(method = RequestMethod.POST, headers = "Content-Type=application/x-www-form-urlencoded")
	@ResponseBody
	public ResponseEntity<PairedSampleResponse> createPairedSampleFromForm(@Valid @ModelAttribute PairedSampleRequest pairedSampleRequest)
			throws DatabaseException
	{
		return _createPairedSample(pairedSampleRequest);
	}

	private ResponseEntity<PairedSampleResponse> _createPairedSample(PairedSampleRequest pairedSampleRequest) throws DatabaseException
	{
		PairedSample pairedSample = pairedSampleService.create(pairedSampleRequest.toPairedSample());
		HttpHeaders responseHeaders = new HttpHeaders();
		responseHeaders.add("Location", "/api/v1/pairedsample/" + pairedSample.getId());
		return new ResponseEntity<PairedSampleResponse>(responseHeaders, HttpStatus.CREATED);
	}

	@RequestMapping(value = "/{id}", method = RequestMethod.GET)
	@ResponseBody
	public PairedSampleResponse retrievePairedSample(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrievePairedSample(id, expandFields);
	}
		
	@RequestMapping(value = "/{id}", method = RequestMethod.GET, params = "format=json", produces = "application/json")
	@ResponseBody
	public PairedSampleResponse retrievePairedSampleJson(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrievePairedSample(id, expandFields);
	}

	@InitBinder
	public void binder(WebDataBinder binder)
	{

		binder.registerCustomEditor(Date.class, new PropertyEditorSupport()
		{
			@Override
			public void setAsText(String value)
			{
				try
				{
					if (StringUtils.isNotBlank(value))
					{
						setValue(MolgenisDateFormat.getDateFormat().parse(value));
					}
				}
				catch (ParseException e)
				{
					throw new RuntimeException(e);
				}
			}

			@Override
			public String getAsText()
			{
				if (getValue() == null)
				{
					return null;
				}
				
				return MolgenisDateFormat.getDateFormat().format((Date) getValue());
			}

		});
	}

	private PairedSampleResponse _retrievePairedSample(Integer id, String... expandFieldsStr) throws DatabaseException
	{
		PairedSample pairedSample = pairedSampleService.read(id);
		if (pairedSample == null) throw new EntityNotFoundException("PairedSample " + id.toString() + " not found");
		Set<String> expandFields = expandFieldsStr != null ? new HashSet<String>(Arrays.asList(expandFieldsStr)) : null;
		return new PairedSampleResponse(pairedSample, expandFields);
	}
			
	@RequestMapping(value = "/{id}/subject1", method = RequestMethod.GET)
	public String retrievePairedSampleXrefSubject1(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrievePairedSampleXrefSubject1(id, null, expandFields);
	}
	
	@RequestMapping(value = "/{id}/subject1", method = RequestMethod.GET, params = "format=json", produces = "application/json")
	public String retrievePairedSampleXrefSubject1Json(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrievePairedSampleXrefSubject1(id, "json", expandFields);
	}
	
	private String _retrievePairedSampleXrefSubject1(Integer id, String format, String... expandFieldsStr) throws DatabaseException
	{
		PairedSample pairedSample = pairedSampleService.read(id);
		if (pairedSample == null) throw new EntityNotFoundException("PairedSample " + id.toString() + " not found");
		Integer individualId = pairedSample.getSubject1_Id();
		String redirectUri = "redirect:/api/v1/individual/" + individualId.toString();
		StringBuilder qsBuilder = new StringBuilder();
		if(format != null) qsBuilder.append(qsBuilder.length() == 0 ? '?' : '&').append("format=").append(format);
		if(expandFieldsStr != null) qsBuilder.append(qsBuilder.length() == 0 ? '?' : '&').append("expand=").append(Joiner.on(',').join(expandFieldsStr));
		return qsBuilder.length() == 0 ? redirectUri : redirectUri + qsBuilder.toString();
	}
	
	@RequestMapping(value = "/{id}/label1", method = RequestMethod.GET)
	public String retrievePairedSampleXrefLabel1(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrievePairedSampleXrefLabel1(id, null, expandFields);
	}
	
	@RequestMapping(value = "/{id}/label1", method = RequestMethod.GET, params = "format=json", produces = "application/json")
	public String retrievePairedSampleXrefLabel1Json(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrievePairedSampleXrefLabel1(id, "json", expandFields);
	}
	
	private String _retrievePairedSampleXrefLabel1(Integer id, String format, String... expandFieldsStr) throws DatabaseException
	{
		PairedSample pairedSample = pairedSampleService.read(id);
		if (pairedSample == null) throw new EntityNotFoundException("PairedSample " + id.toString() + " not found");
		Integer ontologyTermId = pairedSample.getLabel1_Id();
		String redirectUri = "redirect:/api/v1/ontologyterm/" + ontologyTermId.toString();
		StringBuilder qsBuilder = new StringBuilder();
		if(format != null) qsBuilder.append(qsBuilder.length() == 0 ? '?' : '&').append("format=").append(format);
		if(expandFieldsStr != null) qsBuilder.append(qsBuilder.length() == 0 ? '?' : '&').append("expand=").append(Joiner.on(',').join(expandFieldsStr));
		return qsBuilder.length() == 0 ? redirectUri : redirectUri + qsBuilder.toString();
	}
	
	@RequestMapping(value = "/{id}/subject2", method = RequestMethod.GET)
	public String retrievePairedSampleXrefSubject2(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrievePairedSampleXrefSubject2(id, null, expandFields);
	}
	
	@RequestMapping(value = "/{id}/subject2", method = RequestMethod.GET, params = "format=json", produces = "application/json")
	public String retrievePairedSampleXrefSubject2Json(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrievePairedSampleXrefSubject2(id, "json", expandFields);
	}
	
	private String _retrievePairedSampleXrefSubject2(Integer id, String format, String... expandFieldsStr) throws DatabaseException
	{
		PairedSample pairedSample = pairedSampleService.read(id);
		if (pairedSample == null) throw new EntityNotFoundException("PairedSample " + id.toString() + " not found");
		Integer individualId = pairedSample.getSubject2_Id();
		String redirectUri = "redirect:/api/v1/individual/" + individualId.toString();
		StringBuilder qsBuilder = new StringBuilder();
		if(format != null) qsBuilder.append(qsBuilder.length() == 0 ? '?' : '&').append("format=").append(format);
		if(expandFieldsStr != null) qsBuilder.append(qsBuilder.length() == 0 ? '?' : '&').append("expand=").append(Joiner.on(',').join(expandFieldsStr));
		return qsBuilder.length() == 0 ? redirectUri : redirectUri + qsBuilder.toString();
	}
	
	@RequestMapping(value = "/{id}/label2", method = RequestMethod.GET)
	public String retrievePairedSampleXrefLabel2(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrievePairedSampleXrefLabel2(id, null, expandFields);
	}
	
	@RequestMapping(value = "/{id}/label2", method = RequestMethod.GET, params = "format=json", produces = "application/json")
	public String retrievePairedSampleXrefLabel2Json(@PathVariable Integer id, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrievePairedSampleXrefLabel2(id, "json", expandFields);
	}
	
	private String _retrievePairedSampleXrefLabel2(Integer id, String format, String... expandFieldsStr) throws DatabaseException
	{
		PairedSample pairedSample = pairedSampleService.read(id);
		if (pairedSample == null) throw new EntityNotFoundException("PairedSample " + id.toString() + " not found");
		Integer ontologyTermId = pairedSample.getLabel2_Id();
		String redirectUri = "redirect:/api/v1/ontologyterm/" + ontologyTermId.toString();
		StringBuilder qsBuilder = new StringBuilder();
		if(format != null) qsBuilder.append(qsBuilder.length() == 0 ? '?' : '&').append("format=").append(format);
		if(expandFieldsStr != null) qsBuilder.append(qsBuilder.length() == 0 ? '?' : '&').append("expand=").append(Joiner.on(',').join(expandFieldsStr));
		return qsBuilder.length() == 0 ? redirectUri : redirectUri + qsBuilder.toString();
	}
	


	@RequestMapping(value = "/{id}", method = RequestMethod.PUT)
	@ResponseStatus(HttpStatus.OK)
	public void updatePairedSample(@PathVariable Integer id, @Valid @RequestBody PairedSampleRequest pairedSampleRequest)
			throws DatabaseException
	{
		_updatePairedSample(id, pairedSampleRequest);
	}

	// Spring's FormHttpMessageConverter cannot bind target classes (as ModelAttribute can)
	@RequestMapping(value = "/{id}", method = RequestMethod.PUT, headers = "Content-Type=application/x-www-form-urlencoded")
	@ResponseBody
	public ResponseEntity<PairedSampleResponse> updatePairedSampleFromForm(@PathVariable Integer id, @PathVariable String _method,
			@Valid @ModelAttribute PairedSampleRequest pairedSampleRequest) throws DatabaseException
	{
		return _createPairedSample(pairedSampleRequest);
	}

	// Tunnel PUT through POST
	@RequestMapping(value = "/{id}", method = RequestMethod.POST, params = "_method=PUT")
	@ResponseStatus(HttpStatus.NO_CONTENT)
	public void updatePairedSamplePost(@PathVariable Integer id, @Valid @RequestBody PairedSampleRequest pairedSampleRequest)
			throws DatabaseException
	{
		_updatePairedSample(id, pairedSampleRequest);
	}

	// Tunnel PUT through POST
	@RequestMapping(value = "/{id}", method = RequestMethod.POST, params = "_method=PUT", headers = "Content-Type=application/x-www-form-urlencoded")
	@ResponseStatus(HttpStatus.NO_CONTENT)
	public void updatePairedSampleFromFormPost(@PathVariable Integer id, @Valid @ModelAttribute PairedSampleRequest pairedSampleRequest)
			throws DatabaseException
	{
		_updatePairedSample(id, pairedSampleRequest);
	}

	private void _updatePairedSample(Integer id, PairedSampleRequest pairedSampleRequest) throws DatabaseException
	{
		PairedSample pairedSample = pairedSampleRequest.toPairedSample();
		pairedSample.setId(id);
		pairedSampleService.update(pairedSample);
	}

	@RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
	@ResponseStatus(HttpStatus.NO_CONTENT)
	public void deletePairedSample(@PathVariable Integer id) throws DatabaseException
	{
		_deletePairedSample(id);
	}

	// Tunnel DELETE through POST
	@RequestMapping(value = "/{id}", method = RequestMethod.POST, params = "_method=DELETE")
	@ResponseStatus(HttpStatus.NO_CONTENT)
	public void deletePairedSamplePost(@PathVariable Integer id) throws DatabaseException
	{
		_deletePairedSample(id);
	}

	private void _deletePairedSample(Integer id) throws DatabaseException
	{
		boolean isDeleted = pairedSampleService.deleteById(id);
		if(!isDeleted) throw new EntityNotFoundException("PairedSample " + id.toString() + " not found");
	}
	
	@RequestMapping(method = RequestMethod.GET)
	@ResponseBody
	public EntityCollectionResponse<PairedSampleResponse> retrievePairedSampleCollection(@Valid EntityCollectionRequest pairedSampleCollectionRequest, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrievePairedSampleCollection(pairedSampleCollectionRequest, expandFields);
	}

	@RequestMapping(method = RequestMethod.GET, params = "format=json", produces = "application/json")
	@ResponseBody
	public EntityCollectionResponse<PairedSampleResponse> retrievePairedSampleCollectionJson(@Valid EntityCollectionRequest pairedSampleCollectionRequest, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrievePairedSampleCollection(pairedSampleCollectionRequest, expandFields);
	}

	// Tunnel GET with body through POST
	@RequestMapping(method = RequestMethod.POST, params = "_method=GET")
	@ResponseBody
	public EntityCollectionResponse<PairedSampleResponse> retrievePairedSampleCollectionPost(@Valid @RequestBody EntityCollectionRequest pairedSampleCollectionRequest, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrievePairedSampleCollection(pairedSampleCollectionRequest, expandFields);
	}

	// Tunnel GET with body through POST
	@RequestMapping(method = RequestMethod.POST, params = {"_method=GET", "format=json"}, produces = "application/json")
	@ResponseBody
	public EntityCollectionResponse<PairedSampleResponse> retrievePairedSampleCollectionJsonPost(@Valid @RequestBody EntityCollectionRequest pairedSampleCollectionRequest, @RequestParam(value="expand", required=false) String... expandFields) throws DatabaseException
	{
		return _retrievePairedSampleCollection(pairedSampleCollectionRequest, expandFields);
	}
	
	private EntityCollectionResponse<PairedSampleResponse> _retrievePairedSampleCollection(EntityCollectionRequest entityCollectionRequest, String... expandFieldsStr) throws DatabaseException
	{
		EntityPager<PairedSample> pairedSamplePager = pairedSampleService.readAll(entityCollectionRequest.getStart(), entityCollectionRequest.getNum(), entityCollectionRequest.getQ());
		final Set<String> expandFields = expandFieldsStr != null ? new HashSet<String>(Arrays.asList(expandFieldsStr)) : null;
		return new EntityCollectionResponse<PairedSampleResponse>(pairedSamplePager, Lists.newArrayList(Iterables.transform(
				pairedSamplePager.getIterable(), new Function<PairedSample, PairedSampleResponse>()
				{
					@Override
					@Nullable
					public PairedSampleResponse apply(@Nullable PairedSample pairedSample)
					{
						try
						{
							return pairedSample != null ? new PairedSampleResponse(pairedSample, expandFields) : null;
						} catch(DatabaseException e)
						{
							throw new RuntimeException(e);
						}
					}
				})), "/api/v1/pairedsample");
	}

	private static class PairedSampleRequest
	{
		private String identifier;
		private String name;
		private String description;
		private Integer subject1;
		private Integer label1;
		private Integer subject2;
		private Integer label2;
	
		public PairedSample toPairedSample()
		{
			PairedSample pairedSample = new PairedSample();
			pairedSample.setIdentifier(identifier);
			pairedSample.setName(name);
			pairedSample.setDescription(description);
			pairedSample.setSubject1_Id(subject1);
			pairedSample.setLabel1_Id(label1);
			pairedSample.setSubject2_Id(subject2);
			pairedSample.setLabel2_Id(label2);
			return pairedSample;
		}
		
		public void setIdentifier(String identifier)
		{
			this.identifier = identifier;
		}
		
		public void setName(String name)
		{
			this.name = name;
		}
		
		public void setDescription(String description)
		{
			this.description = description;
		}
		
		public void setSubject1(Integer subject1)
		{
			this.subject1 = subject1;
		}
		
		public void setLabel1(Integer label1)
		{
			this.label1 = label1;
		}
		
		public void setSubject2(Integer subject2)
		{
			this.subject2 = subject2;
		}
		
		public void setLabel2(Integer label2)
		{
			this.label2 = label2;
		}
		
	}

	static class PairedSampleResponse
	{
		private final String href;
		private final String identifier;
		private final String name;
		private final String description;
		private final Object subject1;
		private final Object label1;
		private final Object subject2;
		private final Object label2;
	
		public PairedSampleResponse(PairedSample pairedSample, final Set<String> expandFields) throws DatabaseException
		{
			this.href = "/api/v1/pairedsample/" + pairedSample.getId();
			this.identifier = pairedSample.getIdentifier();
			this.name = pairedSample.getName();
			this.description = pairedSample.getDescription();
			if (expandFields != null && expandFields.contains("subject1")) this.subject1 = new IndividualResponse(pairedSample.getSubject1(), null);
			else this.subject1 = java.util.Collections.singletonMap("href", "/api/v1/pairedsample/" + pairedSample.getId() + "/subject1");
			if (expandFields != null && expandFields.contains("label1")) this.label1 = pairedSample.getLabel1() == null ? null : new OntologyTermResponse(pairedSample.getLabel1(), null);
			else this.label1 = pairedSample.getLabel1() == null ? null : java.util.Collections.singletonMap("href", "/api/v1/pairedsample/" + pairedSample.getId() + "/label1");
			if (expandFields != null && expandFields.contains("subject2")) this.subject2 = new IndividualResponse(pairedSample.getSubject2(), null);
			else this.subject2 = java.util.Collections.singletonMap("href", "/api/v1/pairedsample/" + pairedSample.getId() + "/subject2");
			if (expandFields != null && expandFields.contains("label2")) this.label2 = pairedSample.getLabel2() == null ? null : new OntologyTermResponse(pairedSample.getLabel2(), null);
			else this.label2 = pairedSample.getLabel2() == null ? null : java.util.Collections.singletonMap("href", "/api/v1/pairedsample/" + pairedSample.getId() + "/label2");
		}
	
		public String getHref()
		{
			return href;
		}
	
		public String getIdentifier()
		{
			return identifier;
		}
	
		public String getName()
		{
			return name;
		}
	
	
		public String getDescription()
		{
			return description;
		}
	
		public Object getSubject1()
		{
			return subject1;
		}
	
		public Object getLabel1()
		{
			return label1;
		}
	
		public Object getSubject2()
		{
			return subject2;
		}
	
		public Object getLabel2()
		{
			return label2;
		}
	
	}
	
	@ExceptionHandler(EntityNotFoundException.class)
	@ResponseStatus(value = HttpStatus.NOT_FOUND)
	@ResponseBody
	public ErrorMessageResponse handleEntityNotFoundException(EntityNotFoundException e)
	{
		logger.debug(e);
		return new ErrorMessageResponse(new ErrorMessage(e.getMessage()));
	}

	@ExceptionHandler(DatabaseException.class)
	@ResponseStatus(value = HttpStatus.INTERNAL_SERVER_ERROR)
	@ResponseBody
	public ErrorMessageResponse handleDatabaseException(DatabaseException e)
	{
		logger.error(e);
		return new ErrorMessageResponse(new ErrorMessage(e.getMessage()));
	}

	@ExceptionHandler(DatabaseAccessException.class)
	@ResponseStatus(value = HttpStatus.UNAUTHORIZED)
	@ResponseBody
	public ErrorMessageResponse handleDatabaseAccessException(DatabaseAccessException e)
	{
		logger.info(e);
		return new ErrorMessageResponse(new ErrorMessage(e.getMessage()));
	}
	
	@ExceptionHandler(RuntimeException.class)
	@ResponseStatus(value = HttpStatus.INTERNAL_SERVER_ERROR)
	@ResponseBody
	public ErrorMessageResponse handleRuntimeException(RuntimeException e)
	{
		logger.error(e);		
		return new ErrorMessageResponse(new ErrorMessage(e.getMessage()));
	}
}