/* File:        molgenis/model/JDBCDatabase
 * Copyright:   Inventory 2000-2015, GBIC 2002-2015, all rights reserved
 * Date:        May 4, 2015
 * 
 * generator:   org.molgenis.generators.db.JDBCMetaDatabaseGen 4.0.0-testing
 *
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
package org.molgenis;

import java.lang.RuntimeException;
import java.util.Arrays;
import java.util.Vector;

import org.molgenis.MolgenisFieldTypes;
import org.molgenis.model.elements.Entity;
import org.molgenis.model.elements.Model;
import org.molgenis.model.elements.Field;
import org.molgenis.model.MolgenisModelException;

/**
 * This class is an in memory representation of the contents of your *_db.xml file
 * Utility of this class is to allow for dynamic querying and/or user interfacing
 * for example within a query tool or a security module.
 */
public class JDBCMetaDatabase extends Model
{
	private static final long serialVersionUID = 1L;
	
	public JDBCMetaDatabase()
	{
		super("molgenis");
		try
		{
			//MolgenisUser
			Entity molgenisUser_entity = new Entity("MolgenisUser",this.getDatabase());
			molgenisUser_entity.setSystem(true);
			molgenisUser_entity.setAbstract(false);
			molgenisUser_entity.setDescription("Anyone who can login");
			molgenisUser_entity.setXrefLabels(Arrays.asList(new String[]{"username"}));
			Field molgenisUser_id_field = new Field(molgenisUser_entity, "id", MolgenisFieldTypes.getType("int"));
			molgenisUser_id_field.setAuto(true);
			molgenisUser_id_field.setDescription("automatically generated internal id, only for internal use.");
			molgenisUser_id_field.setNillable(false);
			molgenisUser_entity.addField(molgenisUser_id_field);
			Field molgenisUser_username_field = new Field(molgenisUser_entity, "username", MolgenisFieldTypes.getType("string"));
			molgenisUser_username_field.setNillable(false);
			molgenisUser_entity.addField(molgenisUser_username_field);
			Field molgenisUser_password__field = new Field(molgenisUser_entity, "password_", MolgenisFieldTypes.getType("string"));
			molgenisUser_password__field.setDescription("big fixme: password type");
			molgenisUser_password__field.setNillable(false);
			molgenisUser_entity.addField(molgenisUser_password__field);
			Field molgenisUser_activationCode_field = new Field(molgenisUser_entity, "activationCode", MolgenisFieldTypes.getType("string"));
			molgenisUser_activationCode_field.setDescription("Used as alternative authentication mechanism to verify user email and/or if user has lost password.");
			molgenisUser_activationCode_field.setNillable(true);
			molgenisUser_entity.addField(molgenisUser_activationCode_field);
			Field molgenisUser_active_field = new Field(molgenisUser_entity, "active", MolgenisFieldTypes.getType("bool"));
			molgenisUser_active_field.setDevaultValue("false");
			molgenisUser_active_field.setDescription("Boolean to indicate if this account can be used to login");
			molgenisUser_active_field.setNillable(false);
			molgenisUser_entity.addField(molgenisUser_active_field);
			Field molgenisUser_superuser_field = new Field(molgenisUser_entity, "superuser", MolgenisFieldTypes.getType("bool"));
			molgenisUser_superuser_field.setDevaultValue("false");
			molgenisUser_superuser_field.setNillable(false);
			molgenisUser_entity.addField(molgenisUser_superuser_field);
			Field molgenisUser_firstName_field = new Field(molgenisUser_entity, "FirstName", MolgenisFieldTypes.getType("string"));
			molgenisUser_firstName_field.setNillable(false);
			molgenisUser_entity.addField(molgenisUser_firstName_field);
			Field molgenisUser_middleNames_field = new Field(molgenisUser_entity, "MiddleNames", MolgenisFieldTypes.getType("string"));
			molgenisUser_middleNames_field.setNillable(true);
			molgenisUser_entity.addField(molgenisUser_middleNames_field);
			Field molgenisUser_lastName_field = new Field(molgenisUser_entity, "LastName", MolgenisFieldTypes.getType("string"));
			molgenisUser_lastName_field.setNillable(false);
			molgenisUser_entity.addField(molgenisUser_lastName_field);
			Field molgenisUser_title_field = new Field(molgenisUser_entity, "Title", MolgenisFieldTypes.getType("string"));
			molgenisUser_title_field.setDescription("An academic title, e.g. Prof.dr, PhD");
			molgenisUser_title_field.setNillable(true);
			molgenisUser_entity.addField(molgenisUser_title_field);
			Field molgenisUser_affiliation_field = new Field(molgenisUser_entity, "Affiliation", MolgenisFieldTypes.getType("string"));
			molgenisUser_affiliation_field.setNillable(true);
			molgenisUser_entity.addField(molgenisUser_affiliation_field);
			Field molgenisUser_department_field = new Field(molgenisUser_entity, "Department", MolgenisFieldTypes.getType("string"));
			molgenisUser_department_field.setDescription("Added from the old definition of MolgenisUser. Department of this contact.");
			molgenisUser_department_field.setNillable(true);
			molgenisUser_entity.addField(molgenisUser_department_field);
			Field molgenisUser_role_field = new Field(molgenisUser_entity, "Role", MolgenisFieldTypes.getType("string"));
			molgenisUser_role_field.setDescription("Indicate role of the contact, e.g. lab worker or PI.");
			molgenisUser_role_field.setNillable(true);
			molgenisUser_entity.addField(molgenisUser_role_field);
			Field molgenisUser_address_field = new Field(molgenisUser_entity, "Address", MolgenisFieldTypes.getType("text"));
			molgenisUser_address_field.setDescription("The address of the Contact.");
			molgenisUser_address_field.setNillable(true);
			molgenisUser_entity.addField(molgenisUser_address_field);
			Field molgenisUser_phone_field = new Field(molgenisUser_entity, "Phone", MolgenisFieldTypes.getType("string"));
			molgenisUser_phone_field.setDescription("The telephone number of the Contact including the suitable area codes.");
			molgenisUser_phone_field.setNillable(true);
			molgenisUser_entity.addField(molgenisUser_phone_field);
			Field molgenisUser_email_field = new Field(molgenisUser_entity, "Email", MolgenisFieldTypes.getType("string"));
			molgenisUser_email_field.setDescription("The email address of the Contact.");
			molgenisUser_email_field.setNillable(false);
			molgenisUser_entity.addField(molgenisUser_email_field);
			Field molgenisUser_fax_field = new Field(molgenisUser_entity, "Fax", MolgenisFieldTypes.getType("string"));
			molgenisUser_fax_field.setDescription("The fax number of the Contact.");
			molgenisUser_fax_field.setNillable(true);
			molgenisUser_entity.addField(molgenisUser_fax_field);
			Field molgenisUser_tollFreePhone_field = new Field(molgenisUser_entity, "tollFreePhone", MolgenisFieldTypes.getType("string"));
			molgenisUser_tollFreePhone_field.setDescription("A toll free phone number for the Contact, including suitable area codes.");
			molgenisUser_tollFreePhone_field.setNillable(true);
			molgenisUser_entity.addField(molgenisUser_tollFreePhone_field);
			Field molgenisUser_city_field = new Field(molgenisUser_entity, "City", MolgenisFieldTypes.getType("string"));
			molgenisUser_city_field.setDescription("Added from the old definition of MolgenisUser. City of this contact.");
			molgenisUser_city_field.setNillable(true);
			molgenisUser_entity.addField(molgenisUser_city_field);
			Field molgenisUser_country_field = new Field(molgenisUser_entity, "Country", MolgenisFieldTypes.getType("string"));
			molgenisUser_country_field.setDescription("Added from the old definition of MolgenisUser. Country of this contact.");
			molgenisUser_country_field.setNillable(true);
			molgenisUser_entity.addField(molgenisUser_country_field);
			Field molgenisUser_changePassword_field = new Field(molgenisUser_entity, "changePassword", MolgenisFieldTypes.getType("bool"));
			molgenisUser_changePassword_field.setDevaultValue("false");
			molgenisUser_changePassword_field.setDescription("If true the user must first change his password before he can proceed");
			molgenisUser_changePassword_field.setNillable(false);
			molgenisUser_entity.addField(molgenisUser_changePassword_field);
			molgenisUser_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			molgenisUser_entity.addKey(Arrays.asList(new String[]{"username"}),false,"");
			molgenisUser_entity.addKey(Arrays.asList(new String[]{"Email"}),false,"");
			
			//MolgenisGroup
			Entity molgenisGroup_entity = new Entity("MolgenisGroup",this.getDatabase());
			molgenisGroup_entity.setSystem(true);
			molgenisGroup_entity.setAbstract(false);
			molgenisGroup_entity.setDescription("");
			molgenisGroup_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field molgenisGroup_id_field = new Field(molgenisGroup_entity, "id", MolgenisFieldTypes.getType("int"));
			molgenisGroup_id_field.setAuto(true);
			molgenisGroup_id_field.setNillable(false);
			molgenisGroup_entity.addField(molgenisGroup_id_field);
			Field molgenisGroup_name_field = new Field(molgenisGroup_entity, "name", MolgenisFieldTypes.getType("string"));
			molgenisGroup_name_field.setNillable(false);
			molgenisGroup_entity.addField(molgenisGroup_name_field);
			Field molgenisGroup_active_field = new Field(molgenisGroup_entity, "active", MolgenisFieldTypes.getType("bool"));
			molgenisGroup_active_field.setDevaultValue("true");
			molgenisGroup_active_field.setDescription("Boolean to indicate whether this group is in use.");
			molgenisGroup_active_field.setNillable(false);
			molgenisGroup_entity.addField(molgenisGroup_active_field);
			molgenisGroup_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//MolgenisGroupMember
			Entity molgenisGroupMember_entity = new Entity("MolgenisGroupMember",this.getDatabase());
			molgenisGroupMember_entity.setSystem(true);
			molgenisGroupMember_entity.setAbstract(false);
			molgenisGroupMember_entity.setDescription("");
			molgenisGroupMember_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field molgenisGroupMember_id_field = new Field(molgenisGroupMember_entity, "id", MolgenisFieldTypes.getType("int"));
			molgenisGroupMember_id_field.setAuto(true);
			molgenisGroupMember_id_field.setNillable(false);
			molgenisGroupMember_entity.addField(molgenisGroupMember_id_field);
			Field molgenisGroupMember_molgenisUser_field = new Field(molgenisGroupMember_entity, "molgenisUser", MolgenisFieldTypes.getType("xref"));
			molgenisGroupMember_molgenisUser_field.setNillable(false);
			molgenisGroupMember_molgenisUser_field.setXRefVariables("MolgenisUser", "id",Arrays.asList(new String[]{"username"}));
			molgenisGroupMember_entity.addField(molgenisGroupMember_molgenisUser_field);
			Field molgenisGroupMember_molgenisGroup_field = new Field(molgenisGroupMember_entity, "molgenisGroup", MolgenisFieldTypes.getType("xref"));
			molgenisGroupMember_molgenisGroup_field.setNillable(false);
			molgenisGroupMember_molgenisGroup_field.setXRefVariables("MolgenisGroup", "id",Arrays.asList(new String[]{"id"}));
			molgenisGroupMember_entity.addField(molgenisGroupMember_molgenisGroup_field);
			molgenisGroupMember_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//Authority
			Entity authority_entity = new Entity("Authority",this.getDatabase());
			authority_entity.setSystem(true);
			authority_entity.setAbstract(true);
			authority_entity.setDescription("");
			Field authority_role_field = new Field(authority_entity, "role", MolgenisFieldTypes.getType("string"));
			authority_role_field.setNillable(false);
			authority_entity.addField(authority_role_field);
			
			//UserAuthority
			Entity userAuthority_entity = new Entity("UserAuthority",this.getDatabase());
			userAuthority_entity.setSystem(true);
			userAuthority_entity.setAbstract(false);
			userAuthority_entity.setImplements(new String[]{"Authority"});
			userAuthority_entity.setDescription("");
			userAuthority_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field userAuthority_id_field = new Field(userAuthority_entity, "id", MolgenisFieldTypes.getType("int"));
			userAuthority_id_field.setAuto(true);
			userAuthority_id_field.setNillable(false);
			userAuthority_entity.addField(userAuthority_id_field);
			Field userAuthority_molgenisUser_field = new Field(userAuthority_entity, "molgenisUser", MolgenisFieldTypes.getType("xref"));
			userAuthority_molgenisUser_field.setNillable(false);
			userAuthority_molgenisUser_field.setXRefVariables("MolgenisUser", "id",Arrays.asList(new String[]{"username"}));
			userAuthority_entity.addField(userAuthority_molgenisUser_field);
			Field userAuthority_role_field = new Field(userAuthority_entity, "role", MolgenisFieldTypes.getType("string"));
			userAuthority_role_field.setNillable(false);
			userAuthority_entity.addField(userAuthority_role_field);
			userAuthority_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//GroupAuthority
			Entity groupAuthority_entity = new Entity("GroupAuthority",this.getDatabase());
			groupAuthority_entity.setSystem(true);
			groupAuthority_entity.setAbstract(false);
			groupAuthority_entity.setImplements(new String[]{"Authority"});
			groupAuthority_entity.setDescription("");
			groupAuthority_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field groupAuthority_id_field = new Field(groupAuthority_entity, "id", MolgenisFieldTypes.getType("int"));
			groupAuthority_id_field.setAuto(true);
			groupAuthority_id_field.setNillable(false);
			groupAuthority_entity.addField(groupAuthority_id_field);
			Field groupAuthority_molgenisGroup_field = new Field(groupAuthority_entity, "molgenisGroup", MolgenisFieldTypes.getType("xref"));
			groupAuthority_molgenisGroup_field.setNillable(false);
			groupAuthority_molgenisGroup_field.setXRefVariables("MolgenisGroup", "id",Arrays.asList(new String[]{"id"}));
			groupAuthority_entity.addField(groupAuthority_molgenisGroup_field);
			Field groupAuthority_role_field = new Field(groupAuthority_entity, "role", MolgenisFieldTypes.getType("string"));
			groupAuthority_role_field.setNillable(false);
			groupAuthority_entity.addField(groupAuthority_role_field);
			groupAuthority_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//Autoid
			Entity autoid_entity = new Entity("Autoid",this.getDatabase());
			autoid_entity.setSystem(true);
			autoid_entity.setAbstract(true);
			autoid_entity.setDescription("This interface assigns an automatic 'id'.\n\t\t\t");
			autoid_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field autoid_id_field = new Field(autoid_entity, "id", MolgenisFieldTypes.getType("int"));
			autoid_id_field.setAuto(true);
			autoid_id_field.setDescription("automatically generated internal id, only for internal use.");
			autoid_id_field.setNillable(false);
			autoid_entity.addField(autoid_id_field);
			autoid_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//Identifiable
			Entity identifiable_entity = new Entity("Identifiable",this.getDatabase());
			identifiable_entity.setSystem(true);
			identifiable_entity.setAbstract(true);
			identifiable_entity.setImplements(new String[]{"Autoid"});
			identifiable_entity.setDescription("This interface assigns an automatic 'id', globally\n\t\t\t\tunique identifier\n\t\t\t\t'identifier' field, and possibly not unique 'name'\n\t\t\t\tto all entities that implement it.\n\t\t\t");
			identifiable_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field identifiable_identifier_field = new Field(identifiable_entity, "Identifier", MolgenisFieldTypes.getType("string"));
			identifiable_identifier_field.setDescription("user supplied or automatically assigned (using a decorator) unique and short identifier, e.g. MA1234");
			identifiable_identifier_field.setNillable(false);
			identifiable_entity.addField(identifiable_identifier_field);
			Field identifiable_name_field = new Field(identifiable_entity, "Name", MolgenisFieldTypes.getType("string"));
			identifiable_name_field.setDescription("human readible name, not necessary unique.");
			identifiable_name_field.setNillable(false);
			identifiable_entity.addField(identifiable_name_field);
			Field identifiable_id_field = new Field(identifiable_entity, "id", MolgenisFieldTypes.getType("int"));
			identifiable_id_field.setAuto(true);
			identifiable_id_field.setDescription("automatically generated internal id, only for internal use.");
			identifiable_id_field.setNillable(false);
			identifiable_entity.addField(identifiable_id_field);
			identifiable_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			identifiable_entity.addKey(Arrays.asList(new String[]{"Identifier"}),false,"");
			
			//MolgenisEntity
			Entity molgenisEntity_entity = new Entity("MolgenisEntity",this.getDatabase());
			molgenisEntity_entity.setSystem(true);
			molgenisEntity_entity.setAbstract(false);
			molgenisEntity_entity.setImplements(new String[]{"Autoid"});
			molgenisEntity_entity.setDescription("Referenceable catalog of entity names, menus, forms and\n\t\t\t\tplugins.\n\t\t\t");
			molgenisEntity_entity.setXrefLabels(Arrays.asList(new String[]{"className"}));
			Field molgenisEntity_name_field = new Field(molgenisEntity_entity, "name", MolgenisFieldTypes.getType("string"));
			molgenisEntity_name_field.setDescription("Name of the entity");
			molgenisEntity_name_field.setNillable(false);
			molgenisEntity_entity.addField(molgenisEntity_name_field);
			Field molgenisEntity_type__field = new Field(molgenisEntity_entity, "type_", MolgenisFieldTypes.getType("string"));
			molgenisEntity_type__field.setDescription("Type of the entity");
			molgenisEntity_type__field.setNillable(false);
			molgenisEntity_entity.addField(molgenisEntity_type__field);
			Field molgenisEntity_className_field = new Field(molgenisEntity_entity, "className", MolgenisFieldTypes.getType("string"));
			molgenisEntity_className_field.setDescription("Full name of the entity");
			molgenisEntity_className_field.setNillable(false);
			molgenisEntity_entity.addField(molgenisEntity_className_field);
			Field molgenisEntity_id_field = new Field(molgenisEntity_entity, "id", MolgenisFieldTypes.getType("int"));
			molgenisEntity_id_field.setAuto(true);
			molgenisEntity_id_field.setDescription("automatically generated internal id, only for internal use.");
			molgenisEntity_id_field.setNillable(false);
			molgenisEntity_entity.addField(molgenisEntity_id_field);
			molgenisEntity_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			molgenisEntity_entity.addKey(Arrays.asList(new String[]{"className"}),false,"");
			molgenisEntity_entity.addKey(Arrays.asList(new String[]{"name","type_"}),false,"");
			
			//RuntimeProperty
			Entity runtimeProperty_entity = new Entity("RuntimeProperty",this.getDatabase());
			runtimeProperty_entity.setSystem(false);
			runtimeProperty_entity.setAbstract(false);
			runtimeProperty_entity.setImplements(new String[]{"Identifiable"});
			runtimeProperty_entity.setDescription("");
			runtimeProperty_entity.setXrefLabels(Arrays.asList(new String[]{"Name"}));
			Field runtimeProperty_value_field = new Field(runtimeProperty_entity, "Value", MolgenisFieldTypes.getType("text"));
			runtimeProperty_value_field.setNillable(false);
			runtimeProperty_entity.addField(runtimeProperty_value_field);
			Field runtimeProperty_identifier_field = new Field(runtimeProperty_entity, "Identifier", MolgenisFieldTypes.getType("string"));
			runtimeProperty_identifier_field.setDescription("user supplied or automatically assigned (using a decorator) unique and short identifier, e.g. MA1234");
			runtimeProperty_identifier_field.setNillable(false);
			runtimeProperty_entity.addField(runtimeProperty_identifier_field);
			Field runtimeProperty_name_field = new Field(runtimeProperty_entity, "Name", MolgenisFieldTypes.getType("string"));
			runtimeProperty_name_field.setDescription("human readible name, not necessary unique.");
			runtimeProperty_name_field.setNillable(false);
			runtimeProperty_entity.addField(runtimeProperty_name_field);
			Field runtimeProperty_id_field = new Field(runtimeProperty_entity, "id", MolgenisFieldTypes.getType("int"));
			runtimeProperty_id_field.setAuto(true);
			runtimeProperty_id_field.setDescription("automatically generated internal id, only for internal use.");
			runtimeProperty_id_field.setNillable(false);
			runtimeProperty_entity.addField(runtimeProperty_id_field);
			runtimeProperty_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			runtimeProperty_entity.addKey(Arrays.asList(new String[]{"Identifier"}),false,"");
			runtimeProperty_entity.addKey(Arrays.asList(new String[]{"Name"}),false,"");
			
			//FreemarkerTemplate
			Entity freemarkerTemplate_entity = new Entity("FreemarkerTemplate",this.getDatabase());
			freemarkerTemplate_entity.setSystem(false);
			freemarkerTemplate_entity.setAbstract(false);
			freemarkerTemplate_entity.setImplements(new String[]{"Autoid"});
			freemarkerTemplate_entity.setDescription("");
			freemarkerTemplate_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field freemarkerTemplate_name_field = new Field(freemarkerTemplate_entity, "Name", MolgenisFieldTypes.getType("string"));
			freemarkerTemplate_name_field.setDescription("Name of the entity");
			freemarkerTemplate_name_field.setNillable(false);
			freemarkerTemplate_entity.addField(freemarkerTemplate_name_field);
			Field freemarkerTemplate_value_field = new Field(freemarkerTemplate_entity, "Value", MolgenisFieldTypes.getType("script"));
			freemarkerTemplate_value_field.setNillable(false);
			freemarkerTemplate_entity.addField(freemarkerTemplate_value_field);
			Field freemarkerTemplate_id_field = new Field(freemarkerTemplate_entity, "id", MolgenisFieldTypes.getType("int"));
			freemarkerTemplate_id_field.setAuto(true);
			freemarkerTemplate_id_field.setDescription("automatically generated internal id, only for internal use.");
			freemarkerTemplate_id_field.setNillable(false);
			freemarkerTemplate_entity.addField(freemarkerTemplate_id_field);
			freemarkerTemplate_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			freemarkerTemplate_entity.addKey(Arrays.asList(new String[]{"Name"}),false,"");
			
			//Characteristic
			Entity characteristic_entity = new Entity("Characteristic",this.getDatabase());
			characteristic_entity.setSystem(false);
			characteristic_entity.setAbstract(false);
			characteristic_entity.setImplements(new String[]{"Identifiable"});
			characteristic_entity.setDescription(" Characteristics are yes-no statements about things in\n\t\t\t\tthe world. These can be used as part of an observation, as parameter\n\t\t\t\tof ObservableFeature ('measuredCharacteristic'). For example: 'What\n\t\t\t\tis allele of [Marker]', here the [Marker] is a characteristic. Also,\n\t\t\t\tCharacteristics can be used as target of observation. Typical\n\t\t\t\texamples are 'Individual' or 'Panel'. But also 'Marker' can be an\n\t\t\t\tTarget when asked the question 'QTL p-value for [phenotype]': here\n\t\t\t\tboth target and feature are characteristic, for example 'leave\n\t\t\t\tcount'\n\t\t\t\t(phenotype characteristic) and 'PVV4' (marker characteristic).\n\t\t\t");
			characteristic_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field characteristic_description_field = new Field(characteristic_entity, "description", MolgenisFieldTypes.getType("text"));
			characteristic_description_field.setDescription("(Optional) Rudimentary meta data about the observable feature. Use of ontology       terms references to establish unambigious descriptions is recommended");
			characteristic_description_field.setNillable(true);
			characteristic_entity.addField(characteristic_description_field);
			Field characteristic_identifier_field = new Field(characteristic_entity, "Identifier", MolgenisFieldTypes.getType("string"));
			characteristic_identifier_field.setDescription("user supplied or automatically assigned (using a decorator) unique and short identifier, e.g. MA1234");
			characteristic_identifier_field.setNillable(false);
			characteristic_entity.addField(characteristic_identifier_field);
			Field characteristic_name_field = new Field(characteristic_entity, "Name", MolgenisFieldTypes.getType("string"));
			characteristic_name_field.setDescription("human readible name, not necessary unique.");
			characteristic_name_field.setNillable(false);
			characteristic_entity.addField(characteristic_name_field);
			Field characteristic_id_field = new Field(characteristic_entity, "id", MolgenisFieldTypes.getType("int"));
			characteristic_id_field.setAuto(true);
			characteristic_id_field.setDescription("automatically generated internal id, only for internal use.");
			characteristic_id_field.setNillable(false);
			characteristic_entity.addField(characteristic_id_field);
			characteristic_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			characteristic_entity.addKey(Arrays.asList(new String[]{"Identifier"}),false,"");
			
			//ObservationTarget
			Entity observationTarget_entity = new Entity("ObservationTarget",this.getDatabase());
			observationTarget_entity.setSystem(false);
			observationTarget_entity.setAbstract(false);
			observationTarget_entity.setParents(new String[]{"Characteristic"});
			observationTarget_entity.setDescription(" ObservationTarget defines subjects of observation, such\n\t\t\t\tas Individual, Panel, Sample, etc. For instance: 'target 1' IS A\n\t\t\t\t'Individual'.\n\t\t\t");
			observationTarget_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field observationTarget_id_field = new Field(observationTarget_entity, "id", MolgenisFieldTypes.getType("int"));
			observationTarget_id_field.setAuto(true);
			observationTarget_id_field.setDescription("automatically generated internal id, only for internal use.");
			observationTarget_id_field.setNillable(false);
			observationTarget_entity.addField(observationTarget_id_field);
			observationTarget_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//Ontology
			Entity ontology_entity = new Entity("Ontology",this.getDatabase());
			ontology_entity.setSystem(false);
			ontology_entity.setAbstract(false);
			ontology_entity.setImplements(new String[]{"Identifiable"});
			ontology_entity.setDescription(" Ontology defines a reference to an ontology or\n\t\t\t\tcontrolled vocabulary from which well-defined and stable (ontology)\n\t\t\t\tterms can be obtained. Each Ontology should have a unique identifer,\n\t\t\t\tfor instance: Gene Ontology, Mammalian Phenotype, Human Phenotype\n\t\t\t\tOntology, Unified Medical Language System, Medical Subject Headings,\n\t\t\t\tetc. Also a abbreviation is required, for instance: GO, MP, HPO,\n\t\t\t\tUMLS, MeSH, etc. Use of existing ontologies/vocabularies is\n\t\t\t\trecommended to harmonize phenotypic feature and value descriptions.\n\t\t\t\tBut one can also create a 'local' Ontology. The Ontology class maps\n\t\t\t\tto FuGE::Ontology, MAGE-TAB::TermSourceREF.\n\t\t\t");
			ontology_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field ontology_ontologyAccession_field = new Field(ontology_entity, "ontologyAccession", MolgenisFieldTypes.getType("string"));
			ontology_ontologyAccession_field.setDescription("A accession that uniquely identifies the ontology (typically an acronym). E.g. GO, MeSH, HPO.");
			ontology_ontologyAccession_field.setNillable(true);
			ontology_entity.addField(ontology_ontologyAccession_field);
			Field ontology_ontologyURI_field = new Field(ontology_entity, "ontologyURI", MolgenisFieldTypes.getType("hyperlink"));
			ontology_ontologyURI_field.setDescription("(Optional) A URI that references the location of the ontology.");
			ontology_ontologyURI_field.setNillable(true);
			ontology_entity.addField(ontology_ontologyURI_field);
			Field ontology_identifier_field = new Field(ontology_entity, "Identifier", MolgenisFieldTypes.getType("string"));
			ontology_identifier_field.setDescription("user supplied or automatically assigned (using a decorator) unique and short identifier, e.g. MA1234");
			ontology_identifier_field.setNillable(false);
			ontology_entity.addField(ontology_identifier_field);
			Field ontology_name_field = new Field(ontology_entity, "Name", MolgenisFieldTypes.getType("string"));
			ontology_name_field.setDescription("human readible name, not necessary unique.");
			ontology_name_field.setNillable(false);
			ontology_entity.addField(ontology_name_field);
			Field ontology_id_field = new Field(ontology_entity, "id", MolgenisFieldTypes.getType("int"));
			ontology_id_field.setAuto(true);
			ontology_id_field.setDescription("automatically generated internal id, only for internal use.");
			ontology_id_field.setNillable(false);
			ontology_entity.addField(ontology_id_field);
			ontology_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			ontology_entity.addKey(Arrays.asList(new String[]{"Identifier"}),false,"");
			
			//Species
			Entity species_entity = new Entity("Species",this.getDatabase());
			species_entity.setSystem(false);
			species_entity.setAbstract(false);
			species_entity.setParents(new String[]{"OntologyTerm"});
			species_entity.setDescription("Ontology terms for species. E.g. Arabidopsis thaliana.\n\t\t\t\tDISCUSSION: should we avoid subclasses of OntologyTerm and instead\n\t\t\t\tmake a 'tag' filter on terms so we can make pulldowns context\n\t\t\t\tdependent (e.g. to only show particular subqueries of ontologies).\n\t\t\t");
			species_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field species_id_field = new Field(species_entity, "id", MolgenisFieldTypes.getType("int"));
			species_id_field.setAuto(true);
			species_id_field.setDescription("automatically generated internal id, only for internal use.");
			species_id_field.setNillable(false);
			species_entity.addField(species_id_field);
			species_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//OntologyTerm
			Entity ontologyTerm_entity = new Entity("OntologyTerm",this.getDatabase());
			ontologyTerm_entity.setSystem(false);
			ontologyTerm_entity.setAbstract(false);
			ontologyTerm_entity.setParents(new String[]{"Characteristic"});
			ontologyTerm_entity.setDescription("\n\t\t\t\tOntologyTerm defines a single entry (term) from an\n\t\t\t\tontology or a controlled vocabulary (defined by Ontology). The\n\t\t\t\tidentifier is the ontology term is unique. E.g. 'NCI:Antigen Gene'.\n\t\t\t\tOther data entities can reference to this OntologyTerm to harmonize\n\t\t\t\tnaming of concepts. If no suitable ontology term exists then one can\n\t\t\t\tdefine new terms locally (in which case there is no formal accession\n\t\t\t\tfor the term limiting its use for cross-Investigation queries).\n\t\t\t");
			ontologyTerm_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field ontologyTerm_ontology_field = new Field(ontologyTerm_entity, "ontology", MolgenisFieldTypes.getType("xref"));
			ontologyTerm_ontology_field.setDescription("(Optional) The source ontology or controlled vocabulary list that ontology terms have been obtained from.");
			ontologyTerm_ontology_field.setNillable(true);
			ontologyTerm_ontology_field.setXRefVariables("Ontology", "id",Arrays.asList(new String[]{"Identifier"}));
			ontologyTerm_entity.addField(ontologyTerm_ontology_field);
			Field ontologyTerm_termAccession_field = new Field(ontologyTerm_entity, "termAccession", MolgenisFieldTypes.getType("string"));
			ontologyTerm_termAccession_field.setDescription("(Optional) The accession number assigned to the ontology term in its source ontology. If empty it is assumed to be a locally defined term.");
			ontologyTerm_termAccession_field.setNillable(true);
			ontologyTerm_entity.addField(ontologyTerm_termAccession_field);
			Field ontologyTerm_definition_field = new Field(ontologyTerm_entity, "definition", MolgenisFieldTypes.getType("string"));
			ontologyTerm_definition_field.setDescription("(Optional) The definition of the term.");
			ontologyTerm_definition_field.setNillable(true);
			ontologyTerm_entity.addField(ontologyTerm_definition_field);
			Field ontologyTerm_id_field = new Field(ontologyTerm_entity, "id", MolgenisFieldTypes.getType("int"));
			ontologyTerm_id_field.setAuto(true);
			ontologyTerm_id_field.setDescription("automatically generated internal id, only for internal use.");
			ontologyTerm_id_field.setNillable(false);
			ontologyTerm_entity.addField(ontologyTerm_id_field);
			ontologyTerm_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			ontologyTerm_entity.addKey(Arrays.asList(new String[]{"ontology","termAccession"}),false,"");
			
			//Accession
			Entity accession_entity = new Entity("Accession",this.getDatabase());
			accession_entity.setSystem(false);
			accession_entity.setAbstract(false);
			accession_entity.setParents(new String[]{"OntologyTerm"});
			accession_entity.setDescription("\n\t\t\t\tAn external identifier for an annotation. For example:\n\t\t\t\tname='R13H8.1', ontology='ensembl' or name='WBgene00000912',\n\t\t\t\tontology='wormbase'.\n\t\t\t");
			accession_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field accession_id_field = new Field(accession_entity, "id", MolgenisFieldTypes.getType("int"));
			accession_id_field.setAuto(true);
			accession_id_field.setDescription("automatically generated internal id, only for internal use.");
			accession_id_field.setNillable(false);
			accession_entity.addField(accession_id_field);
			accession_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//ContactInterface
			Entity contactInterface_entity = new Entity("ContactInterface",this.getDatabase());
			contactInterface_entity.setSystem(false);
			contactInterface_entity.setAbstract(true);
			contactInterface_entity.setDescription(" A contact is either a person or an organization. Copied\n\t\t\t\tfrom FuGE::Contact.\n\t\t\t");
			Field contactInterface_address_field = new Field(contactInterface_entity, "Address", MolgenisFieldTypes.getType("text"));
			contactInterface_address_field.setDescription("The address of the Contact.");
			contactInterface_address_field.setNillable(true);
			contactInterface_entity.addField(contactInterface_address_field);
			Field contactInterface_phone_field = new Field(contactInterface_entity, "Phone", MolgenisFieldTypes.getType("string"));
			contactInterface_phone_field.setDescription("The telephone number of the Contact including the suitable area codes.");
			contactInterface_phone_field.setNillable(true);
			contactInterface_entity.addField(contactInterface_phone_field);
			Field contactInterface_email_field = new Field(contactInterface_entity, "Email", MolgenisFieldTypes.getType("string"));
			contactInterface_email_field.setDescription("The email address of the Contact.");
			contactInterface_email_field.setNillable(true);
			contactInterface_entity.addField(contactInterface_email_field);
			Field contactInterface_fax_field = new Field(contactInterface_entity, "Fax", MolgenisFieldTypes.getType("string"));
			contactInterface_fax_field.setDescription("The fax number of the Contact.");
			contactInterface_fax_field.setNillable(true);
			contactInterface_entity.addField(contactInterface_fax_field);
			Field contactInterface_tollFreePhone_field = new Field(contactInterface_entity, "tollFreePhone", MolgenisFieldTypes.getType("string"));
			contactInterface_tollFreePhone_field.setDescription("A toll free phone number for the Contact, including suitable area codes.");
			contactInterface_tollFreePhone_field.setNillable(true);
			contactInterface_entity.addField(contactInterface_tollFreePhone_field);
			Field contactInterface_city_field = new Field(contactInterface_entity, "City", MolgenisFieldTypes.getType("string"));
			contactInterface_city_field.setDescription("Added from the old definition of MolgenisUser. City of this contact.");
			contactInterface_city_field.setNillable(true);
			contactInterface_entity.addField(contactInterface_city_field);
			Field contactInterface_country_field = new Field(contactInterface_entity, "Country", MolgenisFieldTypes.getType("string"));
			contactInterface_country_field.setDescription("Added from the old definition of MolgenisUser. Country of this contact.");
			contactInterface_country_field.setNillable(true);
			contactInterface_entity.addField(contactInterface_country_field);
			
			//Institute
			Entity institute_entity = new Entity("Institute",this.getDatabase());
			institute_entity.setSystem(false);
			institute_entity.setAbstract(false);
			institute_entity.setImplements(new String[]{"ContactInterface"});
			institute_entity.setParents(new String[]{"Characteristic"});
			institute_entity.setDescription(" A contact is either a person or an organization. Copied\n\t\t\t\tfrom FuGE::Contact.\n\t\t\t");
			institute_entity.setXrefLabels(Arrays.asList(new String[]{"Name"}));
			Field institute_name_field = new Field(institute_entity, "Name", MolgenisFieldTypes.getType("string"));
			institute_name_field.setNillable(false);
			institute_entity.addField(institute_name_field);
			Field institute_id_field = new Field(institute_entity, "id", MolgenisFieldTypes.getType("int"));
			institute_id_field.setAuto(true);
			institute_id_field.setDescription("automatically generated internal id, only for internal use.");
			institute_id_field.setNillable(false);
			institute_entity.addField(institute_id_field);
			Field institute_address_field = new Field(institute_entity, "Address", MolgenisFieldTypes.getType("text"));
			institute_address_field.setDescription("The address of the Contact.");
			institute_address_field.setNillable(true);
			institute_entity.addField(institute_address_field);
			Field institute_phone_field = new Field(institute_entity, "Phone", MolgenisFieldTypes.getType("string"));
			institute_phone_field.setDescription("The telephone number of the Contact including the suitable area codes.");
			institute_phone_field.setNillable(true);
			institute_entity.addField(institute_phone_field);
			Field institute_email_field = new Field(institute_entity, "Email", MolgenisFieldTypes.getType("string"));
			institute_email_field.setDescription("The email address of the Contact.");
			institute_email_field.setNillable(true);
			institute_entity.addField(institute_email_field);
			Field institute_fax_field = new Field(institute_entity, "Fax", MolgenisFieldTypes.getType("string"));
			institute_fax_field.setDescription("The fax number of the Contact.");
			institute_fax_field.setNillable(true);
			institute_entity.addField(institute_fax_field);
			Field institute_tollFreePhone_field = new Field(institute_entity, "tollFreePhone", MolgenisFieldTypes.getType("string"));
			institute_tollFreePhone_field.setDescription("A toll free phone number for the Contact, including suitable area codes.");
			institute_tollFreePhone_field.setNillable(true);
			institute_entity.addField(institute_tollFreePhone_field);
			Field institute_city_field = new Field(institute_entity, "City", MolgenisFieldTypes.getType("string"));
			institute_city_field.setDescription("Added from the old definition of MolgenisUser. City of this contact.");
			institute_city_field.setNillable(true);
			institute_entity.addField(institute_city_field);
			Field institute_country_field = new Field(institute_entity, "Country", MolgenisFieldTypes.getType("string"));
			institute_country_field.setDescription("Added from the old definition of MolgenisUser. Country of this contact.");
			institute_country_field.setNillable(true);
			institute_entity.addField(institute_country_field);
			institute_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			institute_entity.addKey(Arrays.asList(new String[]{"Name"}),false,"");
			
			//PersonRole
			Entity personRole_entity = new Entity("PersonRole",this.getDatabase());
			personRole_entity.setSystem(false);
			personRole_entity.setAbstract(false);
			personRole_entity.setParents(new String[]{"OntologyTerm"});
			personRole_entity.setDescription("Seperate type of ontologyTerm to administrate roles.\n\t\t\t");
			personRole_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field personRole_id_field = new Field(personRole_entity, "id", MolgenisFieldTypes.getType("int"));
			personRole_id_field.setAuto(true);
			personRole_id_field.setDescription("automatically generated internal id, only for internal use.");
			personRole_id_field.setNillable(false);
			personRole_entity.addField(personRole_id_field);
			personRole_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//ObservableFeature
			Entity observableFeature_entity = new Entity("ObservableFeature",this.getDatabase());
			observableFeature_entity.setSystem(false);
			observableFeature_entity.setAbstract(false);
			observableFeature_entity.setParents(new String[]{"Characteristic"});
			observableFeature_entity.setDescription("\n\t\t\t\tObservableFeature defines anything that can be observed.\n\t\t\t\t<p/>\n\t\t\t\tIn other words, ObservableFeature are the questions asked, e.g.\n\t\t\t\t'What\n\t\t\t\tis Height?', 'What is Systolic blood pressure?', or 'Has blue\n\t\t\t\teyes?'.\n\t\t\t\t<p/>\n\t\t\t\tSome questions may be repeated for multiple characteristics. For\n\t\t\t\texample 'What is [MarkerAllele] observed?' can be applied to all\n\t\t\t\telements of a MarkerSet, and 'What is [medicin codes] uses' can be\n\t\t\t\tapplied to a set of Medicine codes. This can be specified using the\n\t\t\t\tmeasuredCharacteristic field.\n\t\t\t\t<p/>\n\t\t\t\tThe identifier of ObservableFeature is globally unique. It is\n\t\t\t\trecommended that each ObservableFeature is named according to a\n\t\t\t\twell-defined ontology term or database accession.\n\t\t\t");
			observableFeature_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field observableFeature_unit_field = new Field(observableFeature_entity, "unit", MolgenisFieldTypes.getType("xref"));
			observableFeature_unit_field.setDescription("(Optional) Reference to the well-defined measurement unit used to observe this feature       (if feature is that concrete). E.g. mmHg");
			observableFeature_unit_field.setNillable(true);
			observableFeature_unit_field.setXRefVariables("OntologyTerm", "id",Arrays.asList(new String[]{"Identifier"}));
			observableFeature_entity.addField(observableFeature_unit_field);
			Field observableFeature_definitions_field = new Field(observableFeature_entity, "definitions", MolgenisFieldTypes.getType("mref"));
			observableFeature_definitions_field.setDescription("The concept that is being measured in a specific way.");
			observableFeature_definitions_field.setNillable(true);
			observableFeature_definitions_field.setXRefVariables("OntologyTerm", "id",Arrays.asList(new String[]{"Identifier"}));
			observableFeature_entity.addField(observableFeature_definitions_field);
			Field observableFeature_dataType_field = new Field(observableFeature_entity, "dataType", MolgenisFieldTypes.getType("enum"));
			Vector<String> observableFeature_dataType_field_enumoptions = new Vector<String>();
			observableFeature_dataType_field_enumoptions.add("bool");
			observableFeature_dataType_field_enumoptions.add("categorical");
			observableFeature_dataType_field_enumoptions.add("date");
			observableFeature_dataType_field_enumoptions.add("datetime");
			observableFeature_dataType_field_enumoptions.add("decimal");
			observableFeature_dataType_field_enumoptions.add("email");
			observableFeature_dataType_field_enumoptions.add("enum");
			observableFeature_dataType_field_enumoptions.add("file");
			observableFeature_dataType_field_enumoptions.add("html");
			observableFeature_dataType_field_enumoptions.add("hyperlink");
			observableFeature_dataType_field_enumoptions.add("image");
			observableFeature_dataType_field_enumoptions.add("int");
			observableFeature_dataType_field_enumoptions.add("long");
			observableFeature_dataType_field_enumoptions.add("mref");
			observableFeature_dataType_field_enumoptions.add("string");
			observableFeature_dataType_field_enumoptions.add("text");
			observableFeature_dataType_field_enumoptions.add("xref");
			observableFeature_dataType_field.setEnumOptions(observableFeature_dataType_field_enumoptions);
			observableFeature_dataType_field.setDevaultValue("string");
			observableFeature_dataType_field.setDescription("(Optional) Reference to the technical data type. E.g. 'int'");
			observableFeature_dataType_field.setNillable(false);
			observableFeature_entity.addField(observableFeature_dataType_field);
			Field observableFeature_temporal_field = new Field(observableFeature_entity, "temporal", MolgenisFieldTypes.getType("bool"));
			observableFeature_temporal_field.setDevaultValue("false");
			observableFeature_temporal_field.setDescription("Whether this feature is time dependent and can have different values when measured       on different times (e.g. weight, temporal=true) or generally only measured once (e.g. birth date,       temporal=false)");
			observableFeature_temporal_field.setNillable(false);
			observableFeature_entity.addField(observableFeature_temporal_field);
			Field observableFeature_minRange_field = new Field(observableFeature_entity, "minRange", MolgenisFieldTypes.getType("long"));
			observableFeature_minRange_field.setDescription("for numeric values this is used to set the 'min' value of the slider user interface");
			observableFeature_minRange_field.setNillable(true);
			observableFeature_entity.addField(observableFeature_minRange_field);
			Field observableFeature_maxRange_field = new Field(observableFeature_entity, "maxRange", MolgenisFieldTypes.getType("long"));
			observableFeature_maxRange_field.setDescription("for numeric values this is used to set the 'max' value of the slider user interface");
			observableFeature_maxRange_field.setNillable(true);
			observableFeature_entity.addField(observableFeature_maxRange_field);
			Field observableFeature_id_field = new Field(observableFeature_entity, "id", MolgenisFieldTypes.getType("int"));
			observableFeature_id_field.setAuto(true);
			observableFeature_id_field.setDescription("automatically generated internal id, only for internal use.");
			observableFeature_id_field.setNillable(false);
			observableFeature_entity.addField(observableFeature_id_field);
			observableFeature_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//Category
			Entity category_entity = new Entity("Category",this.getDatabase());
			category_entity.setSystem(false);
			category_entity.setAbstract(false);
			category_entity.setParents(new String[]{"Characteristic"});
			category_entity.setDescription("Category is partOf ObservableFeature to define\n\t\t\t\tcategories for an\n\t\t\t\tObservableFeature, such as the categorical answer\n\t\t\t\tcodes that are often used in Questionaires.\n\t\t\t\tFor example the ObservableFeature 'sex' has {code_string = 1,\n\t\t\t\tlabel=male} and {code_string\n\t\t\t\t= 2, label=female}. Category can be\n\t\t\t\tlinked to well-defined ontology terms via the\n\t\t\t\tontologyReference.\n\t\t\t\tCategory extends ObservationElement such that it\n\t\t\t\tcan be referenced by\n\t\t\t\tObservedValue.value.\n\t\t\t\tThe Category class maps to METABASE::Category\n\t\t\t");
			category_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field category_observableFeature_field = new Field(category_entity, "observableFeature", MolgenisFieldTypes.getType("xref"));
			category_observableFeature_field.setDescription("The Measurement these permitted values are part of.");
			category_observableFeature_field.setNillable(false);
			category_observableFeature_field.setXRefVariables("ObservableFeature", "id",Arrays.asList(new String[]{"Identifier"}));
			category_entity.addField(category_observableFeature_field);
			Field category_valueCode_field = new Field(category_entity, "valueCode", MolgenisFieldTypes.getType("string"));
			category_valueCode_field.setDescription("The value used to store this category in ObservedValue. For example '1', '2'.");
			category_valueCode_field.setNillable(true);
			category_entity.addField(category_valueCode_field);
			Field category_definition_field = new Field(category_entity, "definition", MolgenisFieldTypes.getType("xref"));
			category_definition_field.setDescription("The category that is being measured in a specific way.");
			category_definition_field.setNillable(true);
			category_definition_field.setXRefVariables("OntologyTerm", "id",Arrays.asList(new String[]{"Identifier"}));
			category_entity.addField(category_definition_field);
			Field category_isMissing_field = new Field(category_entity, "isMissing", MolgenisFieldTypes.getType("bool"));
			category_isMissing_field.setDevaultValue("false");
			category_isMissing_field.setDescription("whether this value should be treated as missing value.");
			category_isMissing_field.setNillable(false);
			category_entity.addField(category_isMissing_field);
			Field category_id_field = new Field(category_entity, "id", MolgenisFieldTypes.getType("int"));
			category_id_field.setAuto(true);
			category_id_field.setDescription("automatically generated internal id, only for internal use.");
			category_id_field.setNillable(false);
			category_entity.addField(category_id_field);
			category_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//Protocol
			Entity protocol_entity = new Entity("Protocol",this.getDatabase());
			protocol_entity.setSystem(false);
			protocol_entity.setAbstract(false);
			protocol_entity.setParents(new String[]{"Characteristic"});
			protocol_entity.setDescription("\n\t\t\t\tThe Protocol class defines parameterizable descriptions\n\t\t\t\tof\n\t\t\t\t(analysis)methods. Examples of protocols are: Questionaires, SOPs,\n\t\t\t\tAssay platforms, Statistical analyses, etc.\n\t\t\t\tEach protocol has a\n\t\t\t\tunique identifier.\n\t\t\t\tProtocol has an association to OntologyTerm to\n\t\t\t\trepresent the type of protocol.\n\t\t\t");
			protocol_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field protocol_protocolType_field = new Field(protocol_entity, "ProtocolType", MolgenisFieldTypes.getType("xref"));
			protocol_protocolType_field.setDescription("classification of protocol");
			protocol_protocolType_field.setNillable(true);
			protocol_protocolType_field.setXRefVariables("OntologyTerm", "id",Arrays.asList(new String[]{"Identifier"}));
			protocol_entity.addField(protocol_protocolType_field);
			Field protocol_subprotocols_field = new Field(protocol_entity, "subprotocols", MolgenisFieldTypes.getType("mref"));
			protocol_subprotocols_field.setDescription("Subprotocols of this protocol");
			protocol_subprotocols_field.setNillable(true);
			protocol_subprotocols_field.setXRefVariables("Protocol", "id",Arrays.asList(new String[]{"Identifier"}));
			protocol_entity.addField(protocol_subprotocols_field);
			Field protocol_features_field = new Field(protocol_entity, "Features", MolgenisFieldTypes.getType("mref"));
			protocol_features_field.setDescription("parameters (in/out) that are used or produced by this protocol.");
			protocol_features_field.setNillable(true);
			protocol_features_field.setXRefVariables("ObservableFeature", "id",Arrays.asList(new String[]{"Identifier"}));
			protocol_entity.addField(protocol_features_field);
			Field protocol_requiredFeatures_field = new Field(protocol_entity, "RequiredFeatures", MolgenisFieldTypes.getType("mref"));
			protocol_requiredFeatures_field.setDescription("..........");
			protocol_requiredFeatures_field.setNillable(true);
			protocol_requiredFeatures_field.setXRefVariables("ObservableFeature", "id",Arrays.asList(new String[]{"Identifier"}));
			protocol_entity.addField(protocol_requiredFeatures_field);
			Field protocol_root_field = new Field(protocol_entity, "root", MolgenisFieldTypes.getType("bool"));
			protocol_root_field.setDevaultValue("false");
			protocol_root_field.setDescription("Indicator whether this protocol defines a workflow (e.g is the first protocol of a workflow).");
			protocol_root_field.setNillable(false);
			protocol_entity.addField(protocol_root_field);
			Field protocol_active_field = new Field(protocol_entity, "active", MolgenisFieldTypes.getType("bool"));
			protocol_active_field.setDevaultValue("true");
			protocol_active_field.setDescription("whether this protocol is considered active/inactive");
			protocol_active_field.setNillable(false);
			protocol_entity.addField(protocol_active_field);
			Field protocol_id_field = new Field(protocol_entity, "id", MolgenisFieldTypes.getType("int"));
			protocol_id_field.setAuto(true);
			protocol_id_field.setDescription("automatically generated internal id, only for internal use.");
			protocol_id_field.setNillable(false);
			protocol_entity.addField(protocol_id_field);
			protocol_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//DataSet
			Entity dataSet_entity = new Entity("DataSet",this.getDatabase());
			dataSet_entity.setSystem(false);
			dataSet_entity.setAbstract(false);
			dataSet_entity.setParents(new String[]{"Characteristic"});
			dataSet_entity.setDescription("Container for one or more observations that are measured\n\t\t\t\tusing the same protocol and by the same performer(s). The data set\n\t\t\t\tmay be a file (having the same identifier) but in most cases it is a\n\t\t\t\tdata table consisting of rows (Observation).\n\t\t\t\tThis entity replaces\n\t\t\t\tProtocolApplication.\n\t\t\t");
			dataSet_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field dataSet_protocolUsed_field = new Field(dataSet_entity, "ProtocolUsed", MolgenisFieldTypes.getType("xref"));
			dataSet_protocolUsed_field.setDescription("Reference to the protocol that is being used (if available)");
			dataSet_protocolUsed_field.setNillable(false);
			dataSet_protocolUsed_field.setXRefVariables("Protocol", "id",Arrays.asList(new String[]{"Identifier"}));
			dataSet_entity.addField(dataSet_protocolUsed_field);
			Field dataSet_startTime_field = new Field(dataSet_entity, "startTime", MolgenisFieldTypes.getType("datetime"));
			dataSet_startTime_field.setAuto(true);
			dataSet_startTime_field.setDescription("time when the protocol started.");
			dataSet_startTime_field.setNillable(false);
			dataSet_entity.addField(dataSet_startTime_field);
			Field dataSet_endTime_field = new Field(dataSet_entity, "endTime", MolgenisFieldTypes.getType("datetime"));
			dataSet_endTime_field.setAuto(true);
			dataSet_endTime_field.setDescription("(Optional) time when the protocol ended.");
			dataSet_endTime_field.setNillable(true);
			dataSet_entity.addField(dataSet_endTime_field);
			Field dataSet_id_field = new Field(dataSet_entity, "id", MolgenisFieldTypes.getType("int"));
			dataSet_id_field.setAuto(true);
			dataSet_id_field.setDescription("automatically generated internal id, only for internal use.");
			dataSet_id_field.setNillable(false);
			dataSet_entity.addField(dataSet_id_field);
			dataSet_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//ObservationSet
			Entity observationSet_entity = new Entity("ObservationSet",this.getDatabase());
			observationSet_entity.setSystem(false);
			observationSet_entity.setAbstract(false);
			observationSet_entity.setImplements(new String[]{"Autoid"});
			observationSet_entity.setDescription("In practice: Observation is one row within a DataSet.\n\t\t\t");
			observationSet_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field observationSet_identifier_field = new Field(observationSet_entity, "Identifier", MolgenisFieldTypes.getType("string"));
			observationSet_identifier_field.setDescription("user supplied or automatically assigned (using a decorator) unique and short identifier, e.g. MA1234");
			observationSet_identifier_field.setNillable(false);
			observationSet_entity.addField(observationSet_identifier_field);
			Field observationSet_partOfDataSet_field = new Field(observationSet_entity, "partOfDataSet", MolgenisFieldTypes.getType("xref"));
			observationSet_partOfDataSet_field.setDescription("DataSet this ValueSet is part of.");
			observationSet_partOfDataSet_field.setNillable(false);
			observationSet_partOfDataSet_field.setXRefVariables("DataSet", "id",Arrays.asList(new String[]{"Identifier"}));
			observationSet_entity.addField(observationSet_partOfDataSet_field);
			Field observationSet_time_field = new Field(observationSet_entity, "Time", MolgenisFieldTypes.getType("datetime"));
			observationSet_time_field.setDescription("Time of this observationSet");
			observationSet_time_field.setNillable(true);
			observationSet_entity.addField(observationSet_time_field);
			Field observationSet_id_field = new Field(observationSet_entity, "id", MolgenisFieldTypes.getType("int"));
			observationSet_id_field.setAuto(true);
			observationSet_id_field.setDescription("automatically generated internal id, only for internal use.");
			observationSet_id_field.setNillable(false);
			observationSet_entity.addField(observationSet_id_field);
			observationSet_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			observationSet_entity.addKey(Arrays.asList(new String[]{"Identifier"}),false,"");
			observationSet_entity.addKey(Arrays.asList(new String[]{"partOfDataSet","Time"}),false,"");
			
			//PersonInterface
			Entity personInterface_entity = new Entity("PersonInterface",this.getDatabase());
			personInterface_entity.setSystem(false);
			personInterface_entity.setAbstract(true);
			personInterface_entity.setDescription(" A contact is either a person or an organization. Copied\n\t\t\t\tfrom FuGE::Contact.\n\t\t\t");
			Field personInterface_address_field = new Field(personInterface_entity, "Address", MolgenisFieldTypes.getType("text"));
			personInterface_address_field.setDescription("The address of the Contact.");
			personInterface_address_field.setNillable(true);
			personInterface_entity.addField(personInterface_address_field);
			Field personInterface_phone_field = new Field(personInterface_entity, "Phone", MolgenisFieldTypes.getType("string"));
			personInterface_phone_field.setDescription("The telephone number of the Contact including the suitable area codes.");
			personInterface_phone_field.setNillable(true);
			personInterface_entity.addField(personInterface_phone_field);
			Field personInterface_email_field = new Field(personInterface_entity, "Email", MolgenisFieldTypes.getType("string"));
			personInterface_email_field.setDescription("The email address of the Contact.");
			personInterface_email_field.setNillable(true);
			personInterface_entity.addField(personInterface_email_field);
			Field personInterface_fax_field = new Field(personInterface_entity, "Fax", MolgenisFieldTypes.getType("string"));
			personInterface_fax_field.setDescription("The fax number of the Contact.");
			personInterface_fax_field.setNillable(true);
			personInterface_entity.addField(personInterface_fax_field);
			Field personInterface_tollFreePhone_field = new Field(personInterface_entity, "tollFreePhone", MolgenisFieldTypes.getType("string"));
			personInterface_tollFreePhone_field.setDescription("A toll free phone number for the Contact, including suitable area codes.");
			personInterface_tollFreePhone_field.setNillable(true);
			personInterface_entity.addField(personInterface_tollFreePhone_field);
			Field personInterface_city_field = new Field(personInterface_entity, "City", MolgenisFieldTypes.getType("string"));
			personInterface_city_field.setDescription("Added from the old definition of MolgenisUser. City of this contact.");
			personInterface_city_field.setNillable(true);
			personInterface_entity.addField(personInterface_city_field);
			Field personInterface_country_field = new Field(personInterface_entity, "Country", MolgenisFieldTypes.getType("string"));
			personInterface_country_field.setDescription("Added from the old definition of MolgenisUser. Country of this contact.");
			personInterface_country_field.setNillable(true);
			personInterface_entity.addField(personInterface_country_field);
			Field personInterface_firstName_field = new Field(personInterface_entity, "FirstName", MolgenisFieldTypes.getType("string"));
			personInterface_firstName_field.setNillable(true);
			personInterface_entity.addField(personInterface_firstName_field);
			Field personInterface_midInitials_field = new Field(personInterface_entity, "MidInitials", MolgenisFieldTypes.getType("string"));
			personInterface_midInitials_field.setNillable(true);
			personInterface_entity.addField(personInterface_midInitials_field);
			Field personInterface_lastName_field = new Field(personInterface_entity, "LastName", MolgenisFieldTypes.getType("string"));
			personInterface_lastName_field.setNillable(true);
			personInterface_entity.addField(personInterface_lastName_field);
			Field personInterface_title_field = new Field(personInterface_entity, "Title", MolgenisFieldTypes.getType("string"));
			personInterface_title_field.setDescription("An academic title, e.g. Prof.dr, PhD");
			personInterface_title_field.setNillable(true);
			personInterface_entity.addField(personInterface_title_field);
			Field personInterface_affiliation_field = new Field(personInterface_entity, "Affiliation", MolgenisFieldTypes.getType("xref"));
			personInterface_affiliation_field.setNillable(true);
			personInterface_affiliation_field.setXRefVariables("Institute", "id",Arrays.asList(new String[]{"Name"}));
			personInterface_entity.addField(personInterface_affiliation_field);
			Field personInterface_department_field = new Field(personInterface_entity, "Department", MolgenisFieldTypes.getType("string"));
			personInterface_department_field.setDescription("Added from the old definition of MolgenisUser. Department of this contact.");
			personInterface_department_field.setNillable(true);
			personInterface_entity.addField(personInterface_department_field);
			Field personInterface_roles_field = new Field(personInterface_entity, "Roles", MolgenisFieldTypes.getType("xref"));
			personInterface_roles_field.setDescription("Indicate role of the contact, e.g. lab worker or PI. Changed from mref to xref in oct 2011.");
			personInterface_roles_field.setNillable(true);
			personInterface_roles_field.setXRefVariables("PersonRole", "id",Arrays.asList(new String[]{"Identifier"}));
			personInterface_entity.addField(personInterface_roles_field);
			
			//Person
			Entity person_entity = new Entity("Person",this.getDatabase());
			person_entity.setSystem(false);
			person_entity.setAbstract(false);
			person_entity.setImplements(new String[]{"PersonInterface"});
			person_entity.setParents(new String[]{"Characteristic"});
			person_entity.setDescription("\n\t\t\t\tPerson represents one or more people involved with an Investigation.\n\t\t\t\tThis may include authors on a paper, lab personnel or PIs. Person\n\t\t\t\thas last name, firstname, mid initial, address, contact and email. A\n\t\t\t\tPerson role is included to represent how a Person is involved with\n\t\t\t\tan investigation. For submission to repository purposes an allowed\n\t\t\t\tvalue is 'submitter' and the term is present in the MGED Ontology,\n\t\t\t\tan alternative use could represent job title. An Example from\n\t\t\t\tArrayExpress is E-MTAB-506\n\t\t\t\t<a href=\"ftp://ftp.ebi.ac.uk/pub/databases/microarray/data/experiment/TABM/E-TABM-506/E-TABM-506.idf.txt\">\n\t\t\t\t\tftp://ftp.ebi.ac.uk/pub/databases/microarray/data/experiment/TABM/E-TABM-506/E-TABM-506.idf.txt.\n\t\t\t\t</a>\n\t\t\t\t.\n\t\t\t\t<br/>\n\t\t\t\tThe FUGE equivalent to Person is FuGE::Person.\n\t\t\t");
			person_entity.setXrefLabels(Arrays.asList(new String[]{"Name"}));
			Field person_id_field = new Field(person_entity, "id", MolgenisFieldTypes.getType("int"));
			person_id_field.setAuto(true);
			person_id_field.setDescription("automatically generated internal id, only for internal use.");
			person_id_field.setNillable(false);
			person_entity.addField(person_id_field);
			Field person_address_field = new Field(person_entity, "Address", MolgenisFieldTypes.getType("text"));
			person_address_field.setDescription("The address of the Contact.");
			person_address_field.setNillable(true);
			person_entity.addField(person_address_field);
			Field person_phone_field = new Field(person_entity, "Phone", MolgenisFieldTypes.getType("string"));
			person_phone_field.setDescription("The telephone number of the Contact including the suitable area codes.");
			person_phone_field.setNillable(true);
			person_entity.addField(person_phone_field);
			Field person_email_field = new Field(person_entity, "Email", MolgenisFieldTypes.getType("string"));
			person_email_field.setDescription("The email address of the Contact.");
			person_email_field.setNillable(true);
			person_entity.addField(person_email_field);
			Field person_fax_field = new Field(person_entity, "Fax", MolgenisFieldTypes.getType("string"));
			person_fax_field.setDescription("The fax number of the Contact.");
			person_fax_field.setNillable(true);
			person_entity.addField(person_fax_field);
			Field person_tollFreePhone_field = new Field(person_entity, "tollFreePhone", MolgenisFieldTypes.getType("string"));
			person_tollFreePhone_field.setDescription("A toll free phone number for the Contact, including suitable area codes.");
			person_tollFreePhone_field.setNillable(true);
			person_entity.addField(person_tollFreePhone_field);
			Field person_city_field = new Field(person_entity, "City", MolgenisFieldTypes.getType("string"));
			person_city_field.setDescription("Added from the old definition of MolgenisUser. City of this contact.");
			person_city_field.setNillable(true);
			person_entity.addField(person_city_field);
			Field person_country_field = new Field(person_entity, "Country", MolgenisFieldTypes.getType("string"));
			person_country_field.setDescription("Added from the old definition of MolgenisUser. Country of this contact.");
			person_country_field.setNillable(true);
			person_entity.addField(person_country_field);
			Field person_firstName_field = new Field(person_entity, "FirstName", MolgenisFieldTypes.getType("string"));
			person_firstName_field.setNillable(true);
			person_entity.addField(person_firstName_field);
			Field person_midInitials_field = new Field(person_entity, "MidInitials", MolgenisFieldTypes.getType("string"));
			person_midInitials_field.setNillable(true);
			person_entity.addField(person_midInitials_field);
			Field person_lastName_field = new Field(person_entity, "LastName", MolgenisFieldTypes.getType("string"));
			person_lastName_field.setNillable(true);
			person_entity.addField(person_lastName_field);
			Field person_title_field = new Field(person_entity, "Title", MolgenisFieldTypes.getType("string"));
			person_title_field.setDescription("An academic title, e.g. Prof.dr, PhD");
			person_title_field.setNillable(true);
			person_entity.addField(person_title_field);
			Field person_affiliation_field = new Field(person_entity, "Affiliation", MolgenisFieldTypes.getType("xref"));
			person_affiliation_field.setNillable(true);
			person_affiliation_field.setXRefVariables("Institute", "id",Arrays.asList(new String[]{"Name"}));
			person_entity.addField(person_affiliation_field);
			Field person_department_field = new Field(person_entity, "Department", MolgenisFieldTypes.getType("string"));
			person_department_field.setDescription("Added from the old definition of MolgenisUser. Department of this contact.");
			person_department_field.setNillable(true);
			person_entity.addField(person_department_field);
			Field person_roles_field = new Field(person_entity, "Roles", MolgenisFieldTypes.getType("xref"));
			person_roles_field.setDescription("Indicate role of the contact, e.g. lab worker or PI. Changed from mref to xref in oct 2011.");
			person_roles_field.setNillable(true);
			person_roles_field.setXRefVariables("PersonRole", "id",Arrays.asList(new String[]{"Identifier"}));
			person_entity.addField(person_roles_field);
			person_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			person_entity.addKey(Arrays.asList(new String[]{"Email"}),false,"");
			
			//Value
			Entity value_entity = new Entity("Value",this.getDatabase());
			value_entity.setSystem(false);
			value_entity.setAbstract(false);
			value_entity.setImplements(new String[]{"Autoid"});
			value_entity.setDescription("");
			value_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field value_id_field = new Field(value_entity, "id", MolgenisFieldTypes.getType("int"));
			value_id_field.setAuto(true);
			value_id_field.setDescription("automatically generated internal id, only for internal use.");
			value_id_field.setNillable(false);
			value_entity.addField(value_id_field);
			value_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//BoolValue
			Entity boolValue_entity = new Entity("BoolValue",this.getDatabase());
			boolValue_entity.setSystem(false);
			boolValue_entity.setAbstract(false);
			boolValue_entity.setParents(new String[]{"Value"});
			boolValue_entity.setDescription("");
			boolValue_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field boolValue_value_field = new Field(boolValue_entity, "Value", MolgenisFieldTypes.getType("bool"));
			boolValue_value_field.setNillable(false);
			boolValue_entity.addField(boolValue_value_field);
			Field boolValue_id_field = new Field(boolValue_entity, "id", MolgenisFieldTypes.getType("int"));
			boolValue_id_field.setAuto(true);
			boolValue_id_field.setDescription("automatically generated internal id, only for internal use.");
			boolValue_id_field.setNillable(false);
			boolValue_entity.addField(boolValue_id_field);
			boolValue_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//CategoricalValue
			Entity categoricalValue_entity = new Entity("CategoricalValue",this.getDatabase());
			categoricalValue_entity.setSystem(false);
			categoricalValue_entity.setAbstract(false);
			categoricalValue_entity.setParents(new String[]{"Value"});
			categoricalValue_entity.setDescription("");
			categoricalValue_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field categoricalValue_value_field = new Field(categoricalValue_entity, "Value", MolgenisFieldTypes.getType("xref"));
			categoricalValue_value_field.setNillable(false);
			categoricalValue_value_field.setXRefVariables("Category", "id",Arrays.asList(new String[]{"Identifier"}));
			categoricalValue_entity.addField(categoricalValue_value_field);
			Field categoricalValue_id_field = new Field(categoricalValue_entity, "id", MolgenisFieldTypes.getType("int"));
			categoricalValue_id_field.setAuto(true);
			categoricalValue_id_field.setDescription("automatically generated internal id, only for internal use.");
			categoricalValue_id_field.setNillable(false);
			categoricalValue_entity.addField(categoricalValue_id_field);
			categoricalValue_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//DateValue
			Entity dateValue_entity = new Entity("DateValue",this.getDatabase());
			dateValue_entity.setSystem(false);
			dateValue_entity.setAbstract(false);
			dateValue_entity.setParents(new String[]{"Value"});
			dateValue_entity.setDescription("");
			dateValue_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field dateValue_value_field = new Field(dateValue_entity, "Value", MolgenisFieldTypes.getType("date"));
			dateValue_value_field.setNillable(false);
			dateValue_entity.addField(dateValue_value_field);
			Field dateValue_id_field = new Field(dateValue_entity, "id", MolgenisFieldTypes.getType("int"));
			dateValue_id_field.setAuto(true);
			dateValue_id_field.setDescription("automatically generated internal id, only for internal use.");
			dateValue_id_field.setNillable(false);
			dateValue_entity.addField(dateValue_id_field);
			dateValue_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//DateTimeValue
			Entity dateTimeValue_entity = new Entity("DateTimeValue",this.getDatabase());
			dateTimeValue_entity.setSystem(false);
			dateTimeValue_entity.setAbstract(false);
			dateTimeValue_entity.setParents(new String[]{"Value"});
			dateTimeValue_entity.setDescription("");
			dateTimeValue_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field dateTimeValue_value_field = new Field(dateTimeValue_entity, "Value", MolgenisFieldTypes.getType("datetime"));
			dateTimeValue_value_field.setNillable(false);
			dateTimeValue_entity.addField(dateTimeValue_value_field);
			Field dateTimeValue_id_field = new Field(dateTimeValue_entity, "id", MolgenisFieldTypes.getType("int"));
			dateTimeValue_id_field.setAuto(true);
			dateTimeValue_id_field.setDescription("automatically generated internal id, only for internal use.");
			dateTimeValue_id_field.setNillable(false);
			dateTimeValue_entity.addField(dateTimeValue_id_field);
			dateTimeValue_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//DecimalValue
			Entity decimalValue_entity = new Entity("DecimalValue",this.getDatabase());
			decimalValue_entity.setSystem(false);
			decimalValue_entity.setAbstract(false);
			decimalValue_entity.setParents(new String[]{"Value"});
			decimalValue_entity.setDescription("");
			decimalValue_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field decimalValue_value_field = new Field(decimalValue_entity, "Value", MolgenisFieldTypes.getType("decimal"));
			decimalValue_value_field.setNillable(false);
			decimalValue_entity.addField(decimalValue_value_field);
			Field decimalValue_id_field = new Field(decimalValue_entity, "id", MolgenisFieldTypes.getType("int"));
			decimalValue_id_field.setAuto(true);
			decimalValue_id_field.setDescription("automatically generated internal id, only for internal use.");
			decimalValue_id_field.setNillable(false);
			decimalValue_entity.addField(decimalValue_id_field);
			decimalValue_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//EmailValue
			Entity emailValue_entity = new Entity("EmailValue",this.getDatabase());
			emailValue_entity.setSystem(false);
			emailValue_entity.setAbstract(false);
			emailValue_entity.setParents(new String[]{"Value"});
			emailValue_entity.setDescription("");
			emailValue_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field emailValue_value_field = new Field(emailValue_entity, "Value", MolgenisFieldTypes.getType("email"));
			emailValue_value_field.setNillable(false);
			emailValue_entity.addField(emailValue_value_field);
			Field emailValue_id_field = new Field(emailValue_entity, "id", MolgenisFieldTypes.getType("int"));
			emailValue_id_field.setAuto(true);
			emailValue_id_field.setDescription("automatically generated internal id, only for internal use.");
			emailValue_id_field.setNillable(false);
			emailValue_entity.addField(emailValue_id_field);
			emailValue_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//HtmlValue
			Entity htmlValue_entity = new Entity("HtmlValue",this.getDatabase());
			htmlValue_entity.setSystem(false);
			htmlValue_entity.setAbstract(false);
			htmlValue_entity.setParents(new String[]{"Value"});
			htmlValue_entity.setDescription("");
			htmlValue_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field htmlValue_value_field = new Field(htmlValue_entity, "Value", MolgenisFieldTypes.getType("text"));
			htmlValue_value_field.setNillable(false);
			htmlValue_entity.addField(htmlValue_value_field);
			Field htmlValue_id_field = new Field(htmlValue_entity, "id", MolgenisFieldTypes.getType("int"));
			htmlValue_id_field.setAuto(true);
			htmlValue_id_field.setDescription("automatically generated internal id, only for internal use.");
			htmlValue_id_field.setNillable(false);
			htmlValue_entity.addField(htmlValue_id_field);
			htmlValue_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//HyperlinkValue
			Entity hyperlinkValue_entity = new Entity("HyperlinkValue",this.getDatabase());
			hyperlinkValue_entity.setSystem(false);
			hyperlinkValue_entity.setAbstract(false);
			hyperlinkValue_entity.setParents(new String[]{"Value"});
			hyperlinkValue_entity.setDescription("");
			hyperlinkValue_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field hyperlinkValue_value_field = new Field(hyperlinkValue_entity, "Value", MolgenisFieldTypes.getType("hyperlink"));
			hyperlinkValue_value_field.setNillable(false);
			hyperlinkValue_entity.addField(hyperlinkValue_value_field);
			Field hyperlinkValue_id_field = new Field(hyperlinkValue_entity, "id", MolgenisFieldTypes.getType("int"));
			hyperlinkValue_id_field.setAuto(true);
			hyperlinkValue_id_field.setDescription("automatically generated internal id, only for internal use.");
			hyperlinkValue_id_field.setNillable(false);
			hyperlinkValue_entity.addField(hyperlinkValue_id_field);
			hyperlinkValue_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//IntValue
			Entity intValue_entity = new Entity("IntValue",this.getDatabase());
			intValue_entity.setSystem(false);
			intValue_entity.setAbstract(false);
			intValue_entity.setParents(new String[]{"Value"});
			intValue_entity.setDescription("");
			intValue_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field intValue_value_field = new Field(intValue_entity, "Value", MolgenisFieldTypes.getType("int"));
			intValue_value_field.setNillable(false);
			intValue_entity.addField(intValue_value_field);
			Field intValue_id_field = new Field(intValue_entity, "id", MolgenisFieldTypes.getType("int"));
			intValue_id_field.setAuto(true);
			intValue_id_field.setDescription("automatically generated internal id, only for internal use.");
			intValue_id_field.setNillable(false);
			intValue_entity.addField(intValue_id_field);
			intValue_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//LongValue
			Entity longValue_entity = new Entity("LongValue",this.getDatabase());
			longValue_entity.setSystem(false);
			longValue_entity.setAbstract(false);
			longValue_entity.setParents(new String[]{"Value"});
			longValue_entity.setDescription("");
			longValue_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field longValue_value_field = new Field(longValue_entity, "Value", MolgenisFieldTypes.getType("long"));
			longValue_value_field.setNillable(false);
			longValue_entity.addField(longValue_value_field);
			Field longValue_id_field = new Field(longValue_entity, "id", MolgenisFieldTypes.getType("int"));
			longValue_id_field.setAuto(true);
			longValue_id_field.setDescription("automatically generated internal id, only for internal use.");
			longValue_id_field.setNillable(false);
			longValue_entity.addField(longValue_id_field);
			longValue_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//MrefValue
			Entity mrefValue_entity = new Entity("MrefValue",this.getDatabase());
			mrefValue_entity.setSystem(false);
			mrefValue_entity.setAbstract(false);
			mrefValue_entity.setParents(new String[]{"Value"});
			mrefValue_entity.setDescription("");
			mrefValue_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field mrefValue_value_field = new Field(mrefValue_entity, "Value", MolgenisFieldTypes.getType("mref"));
			mrefValue_value_field.setNillable(false);
			mrefValue_value_field.setXRefVariables("Characteristic", "id",Arrays.asList(new String[]{"Identifier"}));
			mrefValue_entity.addField(mrefValue_value_field);
			Field mrefValue_id_field = new Field(mrefValue_entity, "id", MolgenisFieldTypes.getType("int"));
			mrefValue_id_field.setAuto(true);
			mrefValue_id_field.setDescription("automatically generated internal id, only for internal use.");
			mrefValue_id_field.setNillable(false);
			mrefValue_entity.addField(mrefValue_id_field);
			mrefValue_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//StringValue
			Entity stringValue_entity = new Entity("StringValue",this.getDatabase());
			stringValue_entity.setSystem(false);
			stringValue_entity.setAbstract(false);
			stringValue_entity.setParents(new String[]{"Value"});
			stringValue_entity.setDescription("");
			stringValue_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field stringValue_value_field = new Field(stringValue_entity, "Value", MolgenisFieldTypes.getType("string"));
			stringValue_value_field.setNillable(false);
			stringValue_entity.addField(stringValue_value_field);
			Field stringValue_id_field = new Field(stringValue_entity, "id", MolgenisFieldTypes.getType("int"));
			stringValue_id_field.setAuto(true);
			stringValue_id_field.setDescription("automatically generated internal id, only for internal use.");
			stringValue_id_field.setNillable(false);
			stringValue_entity.addField(stringValue_id_field);
			stringValue_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//TextValue
			Entity textValue_entity = new Entity("TextValue",this.getDatabase());
			textValue_entity.setSystem(false);
			textValue_entity.setAbstract(false);
			textValue_entity.setParents(new String[]{"Value"});
			textValue_entity.setDescription("");
			textValue_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field textValue_value_field = new Field(textValue_entity, "Value", MolgenisFieldTypes.getType("text"));
			textValue_value_field.setNillable(false);
			textValue_entity.addField(textValue_value_field);
			Field textValue_id_field = new Field(textValue_entity, "id", MolgenisFieldTypes.getType("int"));
			textValue_id_field.setAuto(true);
			textValue_id_field.setDescription("automatically generated internal id, only for internal use.");
			textValue_id_field.setNillable(false);
			textValue_entity.addField(textValue_id_field);
			textValue_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//StudyDataRequest
			Entity studyDataRequest_entity = new Entity("StudyDataRequest",this.getDatabase());
			studyDataRequest_entity.setSystem(false);
			studyDataRequest_entity.setAbstract(false);
			studyDataRequest_entity.setImplements(new String[]{"Identifiable"});
			studyDataRequest_entity.setDescription("");
			studyDataRequest_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field studyDataRequest_requestForm_field = new Field(studyDataRequest_entity, "RequestForm", MolgenisFieldTypes.getType("string"));
			studyDataRequest_requestForm_field.setDescription("request form filename");
			studyDataRequest_requestForm_field.setNillable(false);
			studyDataRequest_entity.addField(studyDataRequest_requestForm_field);
			Field studyDataRequest_protocol_field = new Field(studyDataRequest_entity, "Protocol", MolgenisFieldTypes.getType("xref"));
			studyDataRequest_protocol_field.setDescription("protocol used to create request");
			studyDataRequest_protocol_field.setNillable(false);
			studyDataRequest_protocol_field.setXRefVariables("Protocol", "id",Arrays.asList(new String[]{"Identifier"}));
			studyDataRequest_entity.addField(studyDataRequest_protocol_field);
			Field studyDataRequest_protocols_field = new Field(studyDataRequest_entity, "Protocols", MolgenisFieldTypes.getType("mref"));
			studyDataRequest_protocols_field.setDescription("selected protocols in Protocol");
			studyDataRequest_protocols_field.setNillable(false);
			studyDataRequest_protocols_field.setXRefVariables("Protocol", "id",Arrays.asList(new String[]{"Identifier"}));
			studyDataRequest_entity.addField(studyDataRequest_protocols_field);
			Field studyDataRequest_molgenisUser_field = new Field(studyDataRequest_entity, "MolgenisUser", MolgenisFieldTypes.getType("xref"));
			studyDataRequest_molgenisUser_field.setNillable(false);
			studyDataRequest_molgenisUser_field.setXRefVariables("MolgenisUser", "id",Arrays.asList(new String[]{"username"}));
			studyDataRequest_entity.addField(studyDataRequest_molgenisUser_field);
			Field studyDataRequest_requestDate_field = new Field(studyDataRequest_entity, "RequestDate", MolgenisFieldTypes.getType("datetime"));
			studyDataRequest_requestDate_field.setDescription("request date");
			studyDataRequest_requestDate_field.setNillable(false);
			studyDataRequest_entity.addField(studyDataRequest_requestDate_field);
			Field studyDataRequest_requestStatus_field = new Field(studyDataRequest_entity, "RequestStatus", MolgenisFieldTypes.getType("enum"));
			Vector<String> studyDataRequest_requestStatus_field_enumoptions = new Vector<String>();
			studyDataRequest_requestStatus_field_enumoptions.add("draft");
			studyDataRequest_requestStatus_field_enumoptions.add("submitted");
			studyDataRequest_requestStatus_field_enumoptions.add("approved");
			studyDataRequest_requestStatus_field_enumoptions.add("rejected");
			studyDataRequest_requestStatus_field.setEnumOptions(studyDataRequest_requestStatus_field_enumoptions);
			studyDataRequest_requestStatus_field.setNillable(false);
			studyDataRequest_entity.addField(studyDataRequest_requestStatus_field);
			Field studyDataRequest_externalId_field = new Field(studyDataRequest_entity, "ExternalId", MolgenisFieldTypes.getType("string"));
			studyDataRequest_externalId_field.setDescription("External identifier");
			studyDataRequest_externalId_field.setNillable(true);
			studyDataRequest_entity.addField(studyDataRequest_externalId_field);
			Field studyDataRequest_identifier_field = new Field(studyDataRequest_entity, "Identifier", MolgenisFieldTypes.getType("string"));
			studyDataRequest_identifier_field.setDescription("user supplied or automatically assigned (using a decorator) unique and short identifier, e.g. MA1234");
			studyDataRequest_identifier_field.setNillable(false);
			studyDataRequest_entity.addField(studyDataRequest_identifier_field);
			Field studyDataRequest_name_field = new Field(studyDataRequest_entity, "Name", MolgenisFieldTypes.getType("string"));
			studyDataRequest_name_field.setDescription("human readible name, not necessary unique.");
			studyDataRequest_name_field.setNillable(false);
			studyDataRequest_entity.addField(studyDataRequest_name_field);
			Field studyDataRequest_id_field = new Field(studyDataRequest_entity, "id", MolgenisFieldTypes.getType("int"));
			studyDataRequest_id_field.setAuto(true);
			studyDataRequest_id_field.setDescription("automatically generated internal id, only for internal use.");
			studyDataRequest_id_field.setNillable(false);
			studyDataRequest_entity.addField(studyDataRequest_id_field);
			studyDataRequest_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			studyDataRequest_entity.addKey(Arrays.asList(new String[]{"Identifier"}),false,"");
			
			//ProtocolFlow
			Entity protocolFlow_entity = new Entity("ProtocolFlow",this.getDatabase());
			protocolFlow_entity.setSystem(false);
			protocolFlow_entity.setAbstract(false);
			protocolFlow_entity.setImplements(new String[]{"Autoid"});
			protocolFlow_entity.setDescription("");
			protocolFlow_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field protocolFlow_inputFeature_field = new Field(protocolFlow_entity, "inputFeature", MolgenisFieldTypes.getType("xref"));
			protocolFlow_inputFeature_field.setNillable(false);
			protocolFlow_inputFeature_field.setXRefVariables("ObservableFeature", "id",Arrays.asList(new String[]{"Identifier"}));
			protocolFlow_entity.addField(protocolFlow_inputFeature_field);
			Field protocolFlow_outputFeature_field = new Field(protocolFlow_entity, "outputFeature", MolgenisFieldTypes.getType("xref"));
			protocolFlow_outputFeature_field.setNillable(false);
			protocolFlow_outputFeature_field.setXRefVariables("ObservableFeature", "id",Arrays.asList(new String[]{"Identifier"}));
			protocolFlow_entity.addField(protocolFlow_outputFeature_field);
			Field protocolFlow_source_field = new Field(protocolFlow_entity, "source", MolgenisFieldTypes.getType("xref"));
			protocolFlow_source_field.setNillable(false);
			protocolFlow_source_field.setXRefVariables("Protocol", "id",Arrays.asList(new String[]{"Identifier"}));
			protocolFlow_entity.addField(protocolFlow_source_field);
			Field protocolFlow_destination_field = new Field(protocolFlow_entity, "destination", MolgenisFieldTypes.getType("xref"));
			protocolFlow_destination_field.setNillable(false);
			protocolFlow_destination_field.setXRefVariables("Protocol", "id",Arrays.asList(new String[]{"Identifier"}));
			protocolFlow_entity.addField(protocolFlow_destination_field);
			Field protocolFlow_id_field = new Field(protocolFlow_entity, "id", MolgenisFieldTypes.getType("int"));
			protocolFlow_id_field.setAuto(true);
			protocolFlow_id_field.setDescription("automatically generated internal id, only for internal use.");
			protocolFlow_id_field.setNillable(false);
			protocolFlow_entity.addField(protocolFlow_id_field);
			protocolFlow_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//ObservationSetFlow
			Entity observationSetFlow_entity = new Entity("ObservationSetFlow",this.getDatabase());
			observationSetFlow_entity.setSystem(false);
			observationSetFlow_entity.setAbstract(false);
			observationSetFlow_entity.setImplements(new String[]{"Autoid"});
			observationSetFlow_entity.setDescription("");
			observationSetFlow_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field observationSetFlow_source_field = new Field(observationSetFlow_entity, "source", MolgenisFieldTypes.getType("xref"));
			observationSetFlow_source_field.setNillable(false);
			observationSetFlow_source_field.setXRefVariables("ObservationSet", "id",Arrays.asList(new String[]{"Identifier"}));
			observationSetFlow_entity.addField(observationSetFlow_source_field);
			Field observationSetFlow_destination_field = new Field(observationSetFlow_entity, "destination", MolgenisFieldTypes.getType("xref"));
			observationSetFlow_destination_field.setNillable(false);
			observationSetFlow_destination_field.setXRefVariables("ObservationSet", "id",Arrays.asList(new String[]{"Identifier"}));
			observationSetFlow_entity.addField(observationSetFlow_destination_field);
			Field observationSetFlow_id_field = new Field(observationSetFlow_entity, "id", MolgenisFieldTypes.getType("int"));
			observationSetFlow_id_field.setAuto(true);
			observationSetFlow_id_field.setDescription("automatically generated internal id, only for internal use.");
			observationSetFlow_id_field.setNillable(false);
			observationSetFlow_entity.addField(observationSetFlow_id_field);
			observationSetFlow_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//Track
			Entity track_entity = new Entity("Track",this.getDatabase());
			track_entity.setSystem(false);
			track_entity.setAbstract(false);
			track_entity.setParents(new String[]{"Characteristic"});
			track_entity.setDescription("");
			track_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field track_id_field = new Field(track_entity, "id", MolgenisFieldTypes.getType("int"));
			track_id_field.setAuto(true);
			track_id_field.setDescription("automatically generated internal id, only for internal use.");
			track_id_field.setNillable(false);
			track_entity.addField(track_id_field);
			track_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//Chromosome
			Entity chromosome_entity = new Entity("Chromosome",this.getDatabase());
			chromosome_entity.setSystem(false);
			chromosome_entity.setAbstract(false);
			chromosome_entity.setParents(new String[]{"ObservationTarget"});
			chromosome_entity.setDescription("");
			chromosome_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field chromosome_orderNr_field = new Field(chromosome_entity, "orderNr", MolgenisFieldTypes.getType("int"));
			chromosome_orderNr_field.setNillable(false);
			chromosome_entity.addField(chromosome_orderNr_field);
			Field chromosome_isAutosomal_field = new Field(chromosome_entity, "isAutosomal", MolgenisFieldTypes.getType("bool"));
			chromosome_isAutosomal_field.setDescription("Is 'yes' when number of chromosomes is equal in male and female individuals, i.e., if not a sex chromosome.");
			chromosome_isAutosomal_field.setNillable(false);
			chromosome_entity.addField(chromosome_isAutosomal_field);
			Field chromosome_bpLength_field = new Field(chromosome_entity, "bpLength", MolgenisFieldTypes.getType("int"));
			chromosome_bpLength_field.setDescription("Lenght of the chromsome in base pairs.");
			chromosome_bpLength_field.setNillable(true);
			chromosome_entity.addField(chromosome_bpLength_field);
			Field chromosome_species_field = new Field(chromosome_entity, "Species", MolgenisFieldTypes.getType("xref"));
			chromosome_species_field.setDescription("Reference to the species this     chromosome belongs to.");
			chromosome_species_field.setNillable(true);
			chromosome_species_field.setXRefVariables("OntologyTerm", "id",Arrays.asList(new String[]{"Identifier"}));
			chromosome_entity.addField(chromosome_species_field);
			Field chromosome_id_field = new Field(chromosome_entity, "id", MolgenisFieldTypes.getType("int"));
			chromosome_id_field.setAuto(true);
			chromosome_id_field.setDescription("automatically generated internal id, only for internal use.");
			chromosome_id_field.setNillable(false);
			chromosome_entity.addField(chromosome_id_field);
			chromosome_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//Variant
			Entity variant_entity = new Entity("Variant",this.getDatabase());
			variant_entity.setSystem(false);
			variant_entity.setAbstract(false);
			variant_entity.setImplements(new String[]{"Locus"});
			variant_entity.setParents(new String[]{"ObservationTarget"});
			variant_entity.setDescription("A SNP is a special kind of Marker, but can also be seen as a phenotype to map against in some cases. A single-nucleotide polymorphism is a DNA sequence variation occurring when a single nucleotide in the genome (or other shared sequence) differs between members of a biological species or paired chromosomes in an individual.");
			variant_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field variant_mutationPosition_field = new Field(variant_entity, "MutationPosition", MolgenisFieldTypes.getType("int"));
			variant_mutationPosition_field.setNillable(true);
			variant_entity.addField(variant_mutationPosition_field);
			Field variant_cdnaPosition_field = new Field(variant_entity, "CdnaPosition", MolgenisFieldTypes.getType("int"));
			variant_cdnaPosition_field.setNillable(true);
			variant_entity.addField(variant_cdnaPosition_field);
			Field variant_aaPosition_field = new Field(variant_entity, "AaPosition", MolgenisFieldTypes.getType("int"));
			variant_aaPosition_field.setNillable(true);
			variant_entity.addField(variant_aaPosition_field);
			Field variant_variantLength_field = new Field(variant_entity, "VariantLength", MolgenisFieldTypes.getType("int"));
			variant_variantLength_field.setNillable(true);
			variant_entity.addField(variant_variantLength_field);
			Field variant_event_field = new Field(variant_entity, "Event", MolgenisFieldTypes.getType("string"));
			variant_event_field.setNillable(true);
			variant_entity.addField(variant_event_field);
			Field variant_ntChange_field = new Field(variant_entity, "NtChange", MolgenisFieldTypes.getType("string"));
			variant_ntChange_field.setNillable(true);
			variant_entity.addField(variant_ntChange_field);
			Field variant_codonchange_field = new Field(variant_entity, "Codonchange", MolgenisFieldTypes.getType("string"));
			variant_codonchange_field.setNillable(true);
			variant_entity.addField(variant_codonchange_field);
			Field variant_cdnaNotation_field = new Field(variant_entity, "CdnaNotation", MolgenisFieldTypes.getType("string"));
			variant_cdnaNotation_field.setNillable(true);
			variant_entity.addField(variant_cdnaNotation_field);
			Field variant_gdnaNotation_field = new Field(variant_entity, "GdnaNotation", MolgenisFieldTypes.getType("string"));
			variant_gdnaNotation_field.setNillable(true);
			variant_entity.addField(variant_gdnaNotation_field);
			Field variant_aaNotation_field = new Field(variant_entity, "AaNotation", MolgenisFieldTypes.getType("string"));
			variant_aaNotation_field.setNillable(true);
			variant_entity.addField(variant_aaNotation_field);
			Field variant_exon_field = new Field(variant_entity, "Exon", MolgenisFieldTypes.getType("string"));
			variant_exon_field.setNillable(true);
			variant_entity.addField(variant_exon_field);
			Field variant_consequence_field = new Field(variant_entity, "Consequence", MolgenisFieldTypes.getType("string"));
			variant_consequence_field.setNillable(true);
			variant_entity.addField(variant_consequence_field);
			Field variant_inheritance_field = new Field(variant_entity, "Inheritance", MolgenisFieldTypes.getType("string"));
			variant_inheritance_field.setNillable(true);
			variant_entity.addField(variant_inheritance_field);
			Field variant_reportedSNP_field = new Field(variant_entity, "ReportedSNP", MolgenisFieldTypes.getType("bool"));
			variant_reportedSNP_field.setNillable(true);
			variant_entity.addField(variant_reportedSNP_field);
			Field variant_effectOnSplicing_field = new Field(variant_entity, "EffectOnSplicing", MolgenisFieldTypes.getType("bool"));
			variant_effectOnSplicing_field.setNillable(true);
			variant_entity.addField(variant_effectOnSplicing_field);
			Field variant_pathogenicity_field = new Field(variant_entity, "Pathogenicity", MolgenisFieldTypes.getType("string"));
			variant_pathogenicity_field.setNillable(true);
			variant_entity.addField(variant_pathogenicity_field);
			Field variant_gene_field = new Field(variant_entity, "Gene", MolgenisFieldTypes.getType("string"));
			variant_gene_field.setNillable(true);
			variant_entity.addField(variant_gene_field);
			Field variant_idMutation_field = new Field(variant_entity, "IdMutation", MolgenisFieldTypes.getType("int"));
			variant_idMutation_field.setNillable(true);
			variant_entity.addField(variant_idMutation_field);
			Field variant_detailsForMutation_field = new Field(variant_entity, "DetailsForMutation", MolgenisFieldTypes.getType("hyperlink"));
			variant_detailsForMutation_field.setNillable(true);
			variant_entity.addField(variant_detailsForMutation_field);
			Field variant_track_field = new Field(variant_entity, "Track", MolgenisFieldTypes.getType("xref"));
			variant_track_field.setNillable(false);
			variant_track_field.setXRefVariables("Track", "id",Arrays.asList(new String[]{"Identifier"}));
			variant_entity.addField(variant_track_field);
			Field variant_id_field = new Field(variant_entity, "id", MolgenisFieldTypes.getType("int"));
			variant_id_field.setAuto(true);
			variant_id_field.setDescription("automatically generated internal id, only for internal use.");
			variant_id_field.setNillable(false);
			variant_entity.addField(variant_id_field);
			Field variant_chromosome_field = new Field(variant_entity, "Chromosome", MolgenisFieldTypes.getType("xref"));
			variant_chromosome_field.setDescription("Reference to the chromosome this     position belongs to.");
			variant_chromosome_field.setNillable(true);
			variant_chromosome_field.setXRefVariables("Chromosome", "id",Arrays.asList(new String[]{"Identifier"}));
			variant_entity.addField(variant_chromosome_field);
			Field variant_cM_field = new Field(variant_entity, "cM", MolgenisFieldTypes.getType("decimal"));
			variant_cM_field.setDescription("genetic map position in centi morgan (cM).");
			variant_cM_field.setNillable(true);
			variant_entity.addField(variant_cM_field);
			Field variant_bpStart_field = new Field(variant_entity, "bpStart", MolgenisFieldTypes.getType("long"));
			variant_bpStart_field.setDescription("numeric basepair postion (5') on the chromosome");
			variant_bpStart_field.setNillable(true);
			variant_entity.addField(variant_bpStart_field);
			Field variant_bpEnd_field = new Field(variant_entity, "bpEnd", MolgenisFieldTypes.getType("long"));
			variant_bpEnd_field.setDescription("numeric basepair postion (3') on the chromosome");
			variant_bpEnd_field.setNillable(true);
			variant_entity.addField(variant_bpEnd_field);
			Field variant_seq_field = new Field(variant_entity, "Seq", MolgenisFieldTypes.getType("text"));
			variant_seq_field.setDescription("The FASTA text representation of the sequence.");
			variant_seq_field.setNillable(true);
			variant_entity.addField(variant_seq_field);
			Field variant_symbol_field = new Field(variant_entity, "Symbol", MolgenisFieldTypes.getType("string"));
			variant_symbol_field.setDescription("todo");
			variant_symbol_field.setNillable(true);
			variant_entity.addField(variant_symbol_field);
			variant_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//Locus
			Entity locus_entity = new Entity("Locus",this.getDatabase());
			locus_entity.setSystem(false);
			locus_entity.setAbstract(true);
			locus_entity.setDescription(" position. Typical examples of such traits are genes,\n\t\t\t\tprobes and markers. Common structure for entities that have a\n\t\t\t\tgenomic");
			Field locus_chromosome_field = new Field(locus_entity, "Chromosome", MolgenisFieldTypes.getType("xref"));
			locus_chromosome_field.setDescription("Reference to the chromosome this     position belongs to.");
			locus_chromosome_field.setNillable(true);
			locus_chromosome_field.setXRefVariables("Chromosome", "id",Arrays.asList(new String[]{"Identifier"}));
			locus_entity.addField(locus_chromosome_field);
			Field locus_cM_field = new Field(locus_entity, "cM", MolgenisFieldTypes.getType("decimal"));
			locus_cM_field.setDescription("genetic map position in centi morgan (cM).");
			locus_cM_field.setNillable(true);
			locus_entity.addField(locus_cM_field);
			Field locus_bpStart_field = new Field(locus_entity, "bpStart", MolgenisFieldTypes.getType("long"));
			locus_bpStart_field.setDescription("numeric basepair postion (5') on the chromosome");
			locus_bpStart_field.setNillable(true);
			locus_entity.addField(locus_bpStart_field);
			Field locus_bpEnd_field = new Field(locus_entity, "bpEnd", MolgenisFieldTypes.getType("long"));
			locus_bpEnd_field.setDescription("numeric basepair postion (3') on the chromosome");
			locus_bpEnd_field.setNillable(true);
			locus_entity.addField(locus_bpEnd_field);
			Field locus_seq_field = new Field(locus_entity, "Seq", MolgenisFieldTypes.getType("text"));
			locus_seq_field.setDescription("The FASTA text representation of the sequence.");
			locus_seq_field.setNillable(true);
			locus_entity.addField(locus_seq_field);
			Field locus_symbol_field = new Field(locus_entity, "Symbol", MolgenisFieldTypes.getType("string"));
			locus_symbol_field.setDescription("todo");
			locus_symbol_field.setNillable(true);
			locus_entity.addField(locus_symbol_field);
			
			//NMRBin
			Entity nMRBin_entity = new Entity("NMRBin",this.getDatabase());
			nMRBin_entity.setSystem(false);
			nMRBin_entity.setAbstract(false);
			nMRBin_entity.setParents(new String[]{"ObservationTarget"});
			nMRBin_entity.setDescription(" Shift of the NMR frequency due to the chemical\n\t\t\t\tenvironment.");
			nMRBin_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field nMRBin_id_field = new Field(nMRBin_entity, "id", MolgenisFieldTypes.getType("int"));
			nMRBin_id_field.setAuto(true);
			nMRBin_id_field.setDescription("automatically generated internal id, only for internal use.");
			nMRBin_id_field.setNillable(false);
			nMRBin_entity.addField(nMRBin_id_field);
			nMRBin_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//Clone
			Entity clone_entity = new Entity("Clone",this.getDatabase());
			clone_entity.setSystem(false);
			clone_entity.setAbstract(false);
			clone_entity.setImplements(new String[]{"Locus"});
			clone_entity.setParents(new String[]{"ObservationTarget"});
			clone_entity.setDescription(" BAC clone fragment.");
			clone_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field clone_id_field = new Field(clone_entity, "id", MolgenisFieldTypes.getType("int"));
			clone_id_field.setAuto(true);
			clone_id_field.setDescription("automatically generated internal id, only for internal use.");
			clone_id_field.setNillable(false);
			clone_entity.addField(clone_id_field);
			Field clone_chromosome_field = new Field(clone_entity, "Chromosome", MolgenisFieldTypes.getType("xref"));
			clone_chromosome_field.setDescription("Reference to the chromosome this     position belongs to.");
			clone_chromosome_field.setNillable(true);
			clone_chromosome_field.setXRefVariables("Chromosome", "id",Arrays.asList(new String[]{"Identifier"}));
			clone_entity.addField(clone_chromosome_field);
			Field clone_cM_field = new Field(clone_entity, "cM", MolgenisFieldTypes.getType("decimal"));
			clone_cM_field.setDescription("genetic map position in centi morgan (cM).");
			clone_cM_field.setNillable(true);
			clone_entity.addField(clone_cM_field);
			Field clone_bpStart_field = new Field(clone_entity, "bpStart", MolgenisFieldTypes.getType("long"));
			clone_bpStart_field.setDescription("numeric basepair postion (5') on the chromosome");
			clone_bpStart_field.setNillable(true);
			clone_entity.addField(clone_bpStart_field);
			Field clone_bpEnd_field = new Field(clone_entity, "bpEnd", MolgenisFieldTypes.getType("long"));
			clone_bpEnd_field.setDescription("numeric basepair postion (3') on the chromosome");
			clone_bpEnd_field.setNillable(true);
			clone_entity.addField(clone_bpEnd_field);
			Field clone_seq_field = new Field(clone_entity, "Seq", MolgenisFieldTypes.getType("text"));
			clone_seq_field.setDescription("The FASTA text representation of the sequence.");
			clone_seq_field.setNillable(true);
			clone_entity.addField(clone_seq_field);
			Field clone_symbol_field = new Field(clone_entity, "Symbol", MolgenisFieldTypes.getType("string"));
			clone_symbol_field.setDescription("todo");
			clone_symbol_field.setNillable(true);
			clone_entity.addField(clone_symbol_field);
			clone_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//DerivedTrait
			Entity derivedTrait_entity = new Entity("DerivedTrait",this.getDatabase());
			derivedTrait_entity.setSystem(false);
			derivedTrait_entity.setAbstract(false);
			derivedTrait_entity.setParents(new String[]{"ObservationTarget"});
			derivedTrait_entity.setDescription(" Any meta trait, eg. false discovery rates, P-values,\n\t\t\t\tthresholds.");
			derivedTrait_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field derivedTrait_id_field = new Field(derivedTrait_entity, "id", MolgenisFieldTypes.getType("int"));
			derivedTrait_id_field.setAuto(true);
			derivedTrait_id_field.setDescription("automatically generated internal id, only for internal use.");
			derivedTrait_id_field.setNillable(false);
			derivedTrait_entity.addField(derivedTrait_id_field);
			derivedTrait_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//EnvironmentalFactor
			Entity environmentalFactor_entity = new Entity("EnvironmentalFactor",this.getDatabase());
			environmentalFactor_entity.setSystem(false);
			environmentalFactor_entity.setAbstract(false);
			environmentalFactor_entity.setParents(new String[]{"ObservationTarget"});
			environmentalFactor_entity.setDescription("Experimental conditions,\n\t\t\tsuch as temperature differences, batch effects etc.");
			environmentalFactor_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field environmentalFactor_id_field = new Field(environmentalFactor_entity, "id", MolgenisFieldTypes.getType("int"));
			environmentalFactor_id_field.setAuto(true);
			environmentalFactor_id_field.setDescription("automatically generated internal id, only for internal use.");
			environmentalFactor_id_field.setNillable(false);
			environmentalFactor_entity.addField(environmentalFactor_id_field);
			environmentalFactor_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//Gene
			Entity gene_entity = new Entity("Gene",this.getDatabase());
			gene_entity.setSystem(false);
			gene_entity.setAbstract(false);
			gene_entity.setImplements(new String[]{"Locus"});
			gene_entity.setParents(new String[]{"ObservationTarget"});
			gene_entity.setDescription(" Trait annotations specific for genes.");
			gene_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field gene_symbol_field = new Field(gene_entity, "Symbol", MolgenisFieldTypes.getType("string"));
			gene_symbol_field.setDescription("Main symbol this gene is known by (not necessarily unique, in constrast to 'name')");
			gene_symbol_field.setNillable(true);
			gene_entity.addField(gene_symbol_field);
			Field gene_orientation_field = new Field(gene_entity, "Orientation", MolgenisFieldTypes.getType("enum"));
			Vector<String> gene_orientation_field_enumoptions = new Vector<String>();
			gene_orientation_field_enumoptions.add("F");
			gene_orientation_field_enumoptions.add("R");
			gene_orientation_field.setEnumOptions(gene_orientation_field_enumoptions);
			gene_orientation_field.setDescription("Orientation of the gene on the genome (F=forward, R=reverse)");
			gene_orientation_field.setNillable(true);
			gene_entity.addField(gene_orientation_field);
			Field gene_control_field = new Field(gene_entity, "Control", MolgenisFieldTypes.getType("bool"));
			gene_control_field.setDescription("Indicating whether this is a 'housekeeping' gene that can be used as control.");
			gene_control_field.setNillable(true);
			gene_entity.addField(gene_control_field);
			Field gene_id_field = new Field(gene_entity, "id", MolgenisFieldTypes.getType("int"));
			gene_id_field.setAuto(true);
			gene_id_field.setDescription("automatically generated internal id, only for internal use.");
			gene_id_field.setNillable(false);
			gene_entity.addField(gene_id_field);
			Field gene_chromosome_field = new Field(gene_entity, "Chromosome", MolgenisFieldTypes.getType("xref"));
			gene_chromosome_field.setDescription("Reference to the chromosome this     position belongs to.");
			gene_chromosome_field.setNillable(true);
			gene_chromosome_field.setXRefVariables("Chromosome", "id",Arrays.asList(new String[]{"Identifier"}));
			gene_entity.addField(gene_chromosome_field);
			Field gene_cM_field = new Field(gene_entity, "cM", MolgenisFieldTypes.getType("decimal"));
			gene_cM_field.setDescription("genetic map position in centi morgan (cM).");
			gene_cM_field.setNillable(true);
			gene_entity.addField(gene_cM_field);
			Field gene_bpStart_field = new Field(gene_entity, "bpStart", MolgenisFieldTypes.getType("long"));
			gene_bpStart_field.setDescription("numeric basepair postion (5') on the chromosome");
			gene_bpStart_field.setNillable(true);
			gene_entity.addField(gene_bpStart_field);
			Field gene_bpEnd_field = new Field(gene_entity, "bpEnd", MolgenisFieldTypes.getType("long"));
			gene_bpEnd_field.setDescription("numeric basepair postion (3') on the chromosome");
			gene_bpEnd_field.setNillable(true);
			gene_entity.addField(gene_bpEnd_field);
			Field gene_seq_field = new Field(gene_entity, "Seq", MolgenisFieldTypes.getType("text"));
			gene_seq_field.setDescription("The FASTA text representation of the sequence.");
			gene_seq_field.setNillable(true);
			gene_entity.addField(gene_seq_field);
			gene_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//Transcript
			Entity transcript_entity = new Entity("Transcript",this.getDatabase());
			transcript_entity.setSystem(false);
			transcript_entity.setAbstract(false);
			transcript_entity.setParents(new String[]{"ObservationTarget"});
			transcript_entity.setDescription(" Trait annotations specific for transcripts.\n\t\t\t");
			transcript_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field transcript_gene_field = new Field(transcript_entity, "Gene", MolgenisFieldTypes.getType("xref"));
			transcript_gene_field.setDescription("The gene that produces this protein");
			transcript_gene_field.setNillable(true);
			transcript_gene_field.setXRefVariables("Gene", "id",Arrays.asList(new String[]{"Identifier"}));
			transcript_entity.addField(transcript_gene_field);
			Field transcript_id_field = new Field(transcript_entity, "id", MolgenisFieldTypes.getType("int"));
			transcript_id_field.setAuto(true);
			transcript_id_field.setDescription("automatically generated internal id, only for internal use.");
			transcript_id_field.setNillable(false);
			transcript_entity.addField(transcript_id_field);
			transcript_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//Protein
			Entity protein_entity = new Entity("Protein",this.getDatabase());
			protein_entity.setSystem(false);
			protein_entity.setAbstract(false);
			protein_entity.setParents(new String[]{"ObservationTarget"});
			protein_entity.setDescription(" Trait annotations specific for proteins.");
			protein_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field protein_gene_field = new Field(protein_entity, "Gene", MolgenisFieldTypes.getType("xref"));
			protein_gene_field.setDescription("The gene that produces this protein");
			protein_gene_field.setNillable(true);
			protein_gene_field.setXRefVariables("Gene", "id",Arrays.asList(new String[]{"Identifier"}));
			protein_entity.addField(protein_gene_field);
			Field protein_transcript_field = new Field(protein_entity, "Transcript", MolgenisFieldTypes.getType("xref"));
			protein_transcript_field.setDescription("The transcript variant that produces this protein");
			protein_transcript_field.setNillable(true);
			protein_transcript_field.setXRefVariables("Transcript", "id",Arrays.asList(new String[]{"Identifier"}));
			protein_entity.addField(protein_transcript_field);
			Field protein_aminoSequence_field = new Field(protein_entity, "AminoSequence", MolgenisFieldTypes.getType("text"));
			protein_aminoSequence_field.setDescription("The aminoacid sequence.");
			protein_aminoSequence_field.setNillable(true);
			protein_entity.addField(protein_aminoSequence_field);
			Field protein_mass_field = new Field(protein_entity, "Mass", MolgenisFieldTypes.getType("decimal"));
			protein_mass_field.setDescription("The mass of this metabolite");
			protein_mass_field.setNillable(true);
			protein_entity.addField(protein_mass_field);
			Field protein_id_field = new Field(protein_entity, "id", MolgenisFieldTypes.getType("int"));
			protein_id_field.setAuto(true);
			protein_id_field.setDescription("automatically generated internal id, only for internal use.");
			protein_id_field.setNillable(false);
			protein_entity.addField(protein_id_field);
			protein_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//Metabolite
			Entity metabolite_entity = new Entity("Metabolite",this.getDatabase());
			metabolite_entity.setSystem(false);
			metabolite_entity.setAbstract(false);
			metabolite_entity.setParents(new String[]{"ObservationTarget"});
			metabolite_entity.setDescription(" Trait annotations specific for metabolites.\n\t\t\t");
			metabolite_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field metabolite_formula_field = new Field(metabolite_entity, "Formula", MolgenisFieldTypes.getType("string"));
			metabolite_formula_field.setDescription("The chemical formula of a metabolite.");
			metabolite_formula_field.setNillable(true);
			metabolite_entity.addField(metabolite_formula_field);
			Field metabolite_mass_field = new Field(metabolite_entity, "Mass", MolgenisFieldTypes.getType("decimal"));
			metabolite_mass_field.setDescription("The mass of this metabolite");
			metabolite_mass_field.setNillable(true);
			metabolite_entity.addField(metabolite_mass_field);
			Field metabolite_structure_field = new Field(metabolite_entity, "Structure", MolgenisFieldTypes.getType("text"));
			metabolite_structure_field.setDescription("The chemical structure of a metabolite (in SMILES representation).");
			metabolite_structure_field.setNillable(true);
			metabolite_entity.addField(metabolite_structure_field);
			Field metabolite_id_field = new Field(metabolite_entity, "id", MolgenisFieldTypes.getType("int"));
			metabolite_id_field.setAuto(true);
			metabolite_id_field.setDescription("automatically generated internal id, only for internal use.");
			metabolite_id_field.setNillable(false);
			metabolite_entity.addField(metabolite_id_field);
			metabolite_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//Marker
			Entity marker_entity = new Entity("Marker",this.getDatabase());
			marker_entity.setSystem(false);
			marker_entity.setAbstract(false);
			marker_entity.setImplements(new String[]{"Locus"});
			marker_entity.setParents(new String[]{"ObservationTarget"});
			marker_entity.setDescription(" Trait annotations specific for markers.");
			marker_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field marker_reportsFor_field = new Field(marker_entity, "ReportsFor", MolgenisFieldTypes.getType("mref"));
			marker_reportsFor_field.setDescription("The marker (or a subclass like 'SNP') this marker (or a subclass like 'SNP') reports for.");
			marker_reportsFor_field.setNillable(true);
			marker_reportsFor_field.setXRefVariables("Marker", "id",Arrays.asList(new String[]{"Identifier"}));
			marker_entity.addField(marker_reportsFor_field);
			Field marker_id_field = new Field(marker_entity, "id", MolgenisFieldTypes.getType("int"));
			marker_id_field.setAuto(true);
			marker_id_field.setDescription("automatically generated internal id, only for internal use.");
			marker_id_field.setNillable(false);
			marker_entity.addField(marker_id_field);
			Field marker_chromosome_field = new Field(marker_entity, "Chromosome", MolgenisFieldTypes.getType("xref"));
			marker_chromosome_field.setDescription("Reference to the chromosome this     position belongs to.");
			marker_chromosome_field.setNillable(true);
			marker_chromosome_field.setXRefVariables("Chromosome", "id",Arrays.asList(new String[]{"Identifier"}));
			marker_entity.addField(marker_chromosome_field);
			Field marker_cM_field = new Field(marker_entity, "cM", MolgenisFieldTypes.getType("decimal"));
			marker_cM_field.setDescription("genetic map position in centi morgan (cM).");
			marker_cM_field.setNillable(true);
			marker_entity.addField(marker_cM_field);
			Field marker_bpStart_field = new Field(marker_entity, "bpStart", MolgenisFieldTypes.getType("long"));
			marker_bpStart_field.setDescription("numeric basepair postion (5') on the chromosome");
			marker_bpStart_field.setNillable(true);
			marker_entity.addField(marker_bpStart_field);
			Field marker_bpEnd_field = new Field(marker_entity, "bpEnd", MolgenisFieldTypes.getType("long"));
			marker_bpEnd_field.setDescription("numeric basepair postion (3') on the chromosome");
			marker_bpEnd_field.setNillable(true);
			marker_entity.addField(marker_bpEnd_field);
			Field marker_seq_field = new Field(marker_entity, "Seq", MolgenisFieldTypes.getType("text"));
			marker_seq_field.setDescription("The FASTA text representation of the sequence.");
			marker_seq_field.setNillable(true);
			marker_entity.addField(marker_seq_field);
			Field marker_symbol_field = new Field(marker_entity, "Symbol", MolgenisFieldTypes.getType("string"));
			marker_symbol_field.setDescription("todo");
			marker_symbol_field.setNillable(true);
			marker_entity.addField(marker_symbol_field);
			marker_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//Polymorphism
			Entity polymorphism_entity = new Entity("Polymorphism",this.getDatabase());
			polymorphism_entity.setSystem(false);
			polymorphism_entity.setAbstract(false);
			polymorphism_entity.setParents(new String[]{"ObservationTarget"});
			polymorphism_entity.setDescription("The difference of a single base discovered between two sequenced individuals.");
			polymorphism_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field polymorphism_base_field = new Field(polymorphism_entity, "Base", MolgenisFieldTypes.getType("enum"));
			Vector<String> polymorphism_base_field_enumoptions = new Vector<String>();
			polymorphism_base_field_enumoptions.add("Reference");
			polymorphism_base_field_enumoptions.add("A");
			polymorphism_base_field_enumoptions.add("T");
			polymorphism_base_field_enumoptions.add("C");
			polymorphism_base_field_enumoptions.add("G");
			polymorphism_base_field.setEnumOptions(polymorphism_base_field_enumoptions);
			polymorphism_base_field.setDescription("The affected DNA base. Note that you can select the reference base here.");
			polymorphism_base_field.setNillable(false);
			polymorphism_entity.addField(polymorphism_base_field);
			Field polymorphism_value_field = new Field(polymorphism_entity, "Value", MolgenisFieldTypes.getType("string"));
			polymorphism_value_field.setDescription("The strain/genotype for which this polymorphism was discovered. E.g. 'N2' or 'CB4856'.");
			polymorphism_value_field.setNillable(true);
			polymorphism_entity.addField(polymorphism_value_field);
			Field polymorphism_id_field = new Field(polymorphism_entity, "id", MolgenisFieldTypes.getType("int"));
			polymorphism_id_field.setAuto(true);
			polymorphism_id_field.setDescription("automatically generated internal id, only for internal use.");
			polymorphism_id_field.setNillable(false);
			polymorphism_entity.addField(polymorphism_id_field);
			polymorphism_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//SNP
			Entity sNP_entity = new Entity("SNP",this.getDatabase());
			sNP_entity.setSystem(false);
			sNP_entity.setAbstract(false);
			sNP_entity.setParents(new String[]{"Marker"});
			sNP_entity.setDescription("A SNP is a special kind of Marker, but can also be seen as a phenotype to map against in some cases. A single-nucleotide polymorphism is a DNA sequence variation occurring when a single nucleotide in the genome (or other shared sequence) differs between members of a biological species or paired chromosomes in an individual.");
			sNP_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field sNP_status_field = new Field(sNP_entity, "Status", MolgenisFieldTypes.getType("string"));
			sNP_status_field.setDescription("The status of this SNP, eg 'confirmed'.");
			sNP_status_field.setNillable(true);
			sNP_entity.addField(sNP_status_field);
			Field sNP_polymorphism_field = new Field(sNP_entity, "Polymorphism", MolgenisFieldTypes.getType("mref"));
			sNP_polymorphism_field.setDescription("The polymorphism that belongs to this SNP.");
			sNP_polymorphism_field.setNillable(true);
			sNP_polymorphism_field.setXRefVariables("Polymorphism", "id",Arrays.asList(new String[]{"Identifier"}));
			sNP_entity.addField(sNP_polymorphism_field);
			Field sNP_id_field = new Field(sNP_entity, "id", MolgenisFieldTypes.getType("int"));
			sNP_id_field.setAuto(true);
			sNP_id_field.setDescription("automatically generated internal id, only for internal use.");
			sNP_id_field.setNillable(false);
			sNP_entity.addField(sNP_id_field);
			sNP_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//ProbeSet
			Entity probeSet_entity = new Entity("ProbeSet",this.getDatabase());
			probeSet_entity.setSystem(false);
			probeSet_entity.setAbstract(false);
			probeSet_entity.setImplements(new String[]{"Locus"});
			probeSet_entity.setParents(new String[]{"ObservationTarget"});
			probeSet_entity.setDescription(" A set of Probes. E.g. an Affymetrix probeset has multiple\n\t\t\t\tprobes. It implements locus because sometimes you want to give the complete set of probes a range,\n\t\t\t\tfor example: indicating that this set of probes spans basepair 0 through 10.000.000 on chromosome 3.\n\t\t\t\tThe same information could arguably also be queried from the probes themselves, but if you have 40k probes,\n\t\t\t\tretrieving the same information from only ProbeSet (if annotated so) would be much faster.");
			probeSet_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field probeSet_id_field = new Field(probeSet_entity, "id", MolgenisFieldTypes.getType("int"));
			probeSet_id_field.setAuto(true);
			probeSet_id_field.setDescription("automatically generated internal id, only for internal use.");
			probeSet_id_field.setNillable(false);
			probeSet_entity.addField(probeSet_id_field);
			Field probeSet_chromosome_field = new Field(probeSet_entity, "Chromosome", MolgenisFieldTypes.getType("xref"));
			probeSet_chromosome_field.setDescription("Reference to the chromosome this     position belongs to.");
			probeSet_chromosome_field.setNillable(true);
			probeSet_chromosome_field.setXRefVariables("Chromosome", "id",Arrays.asList(new String[]{"Identifier"}));
			probeSet_entity.addField(probeSet_chromosome_field);
			Field probeSet_cM_field = new Field(probeSet_entity, "cM", MolgenisFieldTypes.getType("decimal"));
			probeSet_cM_field.setDescription("genetic map position in centi morgan (cM).");
			probeSet_cM_field.setNillable(true);
			probeSet_entity.addField(probeSet_cM_field);
			Field probeSet_bpStart_field = new Field(probeSet_entity, "bpStart", MolgenisFieldTypes.getType("long"));
			probeSet_bpStart_field.setDescription("numeric basepair postion (5') on the chromosome");
			probeSet_bpStart_field.setNillable(true);
			probeSet_entity.addField(probeSet_bpStart_field);
			Field probeSet_bpEnd_field = new Field(probeSet_entity, "bpEnd", MolgenisFieldTypes.getType("long"));
			probeSet_bpEnd_field.setDescription("numeric basepair postion (3') on the chromosome");
			probeSet_bpEnd_field.setNillable(true);
			probeSet_entity.addField(probeSet_bpEnd_field);
			Field probeSet_seq_field = new Field(probeSet_entity, "Seq", MolgenisFieldTypes.getType("text"));
			probeSet_seq_field.setDescription("The FASTA text representation of the sequence.");
			probeSet_seq_field.setNillable(true);
			probeSet_entity.addField(probeSet_seq_field);
			Field probeSet_symbol_field = new Field(probeSet_entity, "Symbol", MolgenisFieldTypes.getType("string"));
			probeSet_symbol_field.setDescription("todo");
			probeSet_symbol_field.setNillable(true);
			probeSet_entity.addField(probeSet_symbol_field);
			probeSet_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//Probe
			Entity probe_entity = new Entity("Probe",this.getDatabase());
			probe_entity.setSystem(false);
			probe_entity.setAbstract(false);
			probe_entity.setImplements(new String[]{"Locus"});
			probe_entity.setParents(new String[]{"ObservationTarget"});
			probe_entity.setDescription(" A piece of sequence that reports for the expression of\n\t\t\t\ta gene, typically spotted onto a microarray.");
			probe_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field probe_mismatch_field = new Field(probe_entity, "Mismatch", MolgenisFieldTypes.getType("bool"));
			probe_mismatch_field.setDevaultValue("false");
			probe_mismatch_field.setDescription("Indicating whether the probe is a match");
			probe_mismatch_field.setNillable(false);
			probe_entity.addField(probe_mismatch_field);
			Field probe_probeSet_field = new Field(probe_entity, "ProbeSet", MolgenisFieldTypes.getType("xref"));
			probe_probeSet_field.setDescription("Optional: probeset this probe belongs to (e.g., in Affymetrix assays).");
			probe_probeSet_field.setNillable(true);
			probe_probeSet_field.setXRefVariables("ProbeSet", "id",Arrays.asList(new String[]{"Identifier"}));
			probe_entity.addField(probe_probeSet_field);
			Field probe_reportsFor_field = new Field(probe_entity, "ReportsFor", MolgenisFieldTypes.getType("xref"));
			probe_reportsFor_field.setDescription("The gene this probe reports for.");
			probe_reportsFor_field.setNillable(true);
			probe_reportsFor_field.setXRefVariables("Gene", "id",Arrays.asList(new String[]{"Identifier"}));
			probe_entity.addField(probe_reportsFor_field);
			Field probe_id_field = new Field(probe_entity, "id", MolgenisFieldTypes.getType("int"));
			probe_id_field.setAuto(true);
			probe_id_field.setDescription("automatically generated internal id, only for internal use.");
			probe_id_field.setNillable(false);
			probe_entity.addField(probe_id_field);
			Field probe_chromosome_field = new Field(probe_entity, "Chromosome", MolgenisFieldTypes.getType("xref"));
			probe_chromosome_field.setDescription("Reference to the chromosome this     position belongs to.");
			probe_chromosome_field.setNillable(true);
			probe_chromosome_field.setXRefVariables("Chromosome", "id",Arrays.asList(new String[]{"Identifier"}));
			probe_entity.addField(probe_chromosome_field);
			Field probe_cM_field = new Field(probe_entity, "cM", MolgenisFieldTypes.getType("decimal"));
			probe_cM_field.setDescription("genetic map position in centi morgan (cM).");
			probe_cM_field.setNillable(true);
			probe_entity.addField(probe_cM_field);
			Field probe_bpStart_field = new Field(probe_entity, "bpStart", MolgenisFieldTypes.getType("long"));
			probe_bpStart_field.setDescription("numeric basepair postion (5') on the chromosome");
			probe_bpStart_field.setNillable(true);
			probe_entity.addField(probe_bpStart_field);
			Field probe_bpEnd_field = new Field(probe_entity, "bpEnd", MolgenisFieldTypes.getType("long"));
			probe_bpEnd_field.setDescription("numeric basepair postion (3') on the chromosome");
			probe_bpEnd_field.setNillable(true);
			probe_entity.addField(probe_bpEnd_field);
			Field probe_seq_field = new Field(probe_entity, "Seq", MolgenisFieldTypes.getType("text"));
			probe_seq_field.setDescription("The FASTA text representation of the sequence.");
			probe_seq_field.setNillable(true);
			probe_entity.addField(probe_seq_field);
			Field probe_symbol_field = new Field(probe_entity, "Symbol", MolgenisFieldTypes.getType("string"));
			probe_symbol_field.setDescription("todo");
			probe_symbol_field.setNillable(true);
			probe_entity.addField(probe_symbol_field);
			probe_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//Spot
			Entity spot_entity = new Entity("Spot",this.getDatabase());
			spot_entity.setSystem(false);
			spot_entity.setAbstract(false);
			spot_entity.setParents(new String[]{"Probe"});
			spot_entity.setDescription("\n\t\t\t\tThis is the spot on a microarray.\n\t\t\t\t<br/>\n\t\t\t\tNote: We don't distinquish between probes (the sequence) and spots\n\t\t\t\t(the sequence as spotted on the array).\n\t\t\t");
			spot_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field spot_x_field = new Field(spot_entity, "x", MolgenisFieldTypes.getType("int"));
			spot_x_field.setDescription("Row");
			spot_x_field.setNillable(false);
			spot_entity.addField(spot_x_field);
			Field spot_y_field = new Field(spot_entity, "y", MolgenisFieldTypes.getType("int"));
			spot_y_field.setDescription("Column");
			spot_y_field.setNillable(false);
			spot_entity.addField(spot_y_field);
			Field spot_gridX_field = new Field(spot_entity, "GridX", MolgenisFieldTypes.getType("int"));
			spot_gridX_field.setDescription("Meta Row");
			spot_gridX_field.setNillable(true);
			spot_entity.addField(spot_gridX_field);
			Field spot_gridY_field = new Field(spot_entity, "GridY", MolgenisFieldTypes.getType("int"));
			spot_gridY_field.setDescription("Meta Column");
			spot_gridY_field.setNillable(true);
			spot_entity.addField(spot_gridY_field);
			Field spot_id_field = new Field(spot_entity, "id", MolgenisFieldTypes.getType("int"));
			spot_id_field.setAuto(true);
			spot_id_field.setDescription("automatically generated internal id, only for internal use.");
			spot_id_field.setNillable(false);
			spot_entity.addField(spot_id_field);
			spot_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			spot_entity.addKey(Arrays.asList(new String[]{"x","y","GridX","GridY"}),false,"");
			
			//MassPeak
			Entity massPeak_entity = new Entity("MassPeak",this.getDatabase());
			massPeak_entity.setSystem(false);
			massPeak_entity.setAbstract(false);
			massPeak_entity.setParents(new String[]{"ObservationTarget"});
			massPeak_entity.setDescription(" A peak that has been selected within a mass\n\t\t\t\tspectrometry experiment.");
			massPeak_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field massPeak_mZ_field = new Field(massPeak_entity, "MZ", MolgenisFieldTypes.getType("decimal"));
			massPeak_mZ_field.setDescription("Mass over charge ratio of this peak.");
			massPeak_mZ_field.setNillable(true);
			massPeak_entity.addField(massPeak_mZ_field);
			Field massPeak_retentionTime_field = new Field(massPeak_entity, "RetentionTime", MolgenisFieldTypes.getType("decimal"));
			massPeak_retentionTime_field.setDescription("The retention-time of this peak in minutes.");
			massPeak_retentionTime_field.setNillable(true);
			massPeak_entity.addField(massPeak_retentionTime_field);
			Field massPeak_id_field = new Field(massPeak_entity, "id", MolgenisFieldTypes.getType("int"));
			massPeak_id_field.setAuto(true);
			massPeak_id_field.setDescription("automatically generated internal id, only for internal use.");
			massPeak_id_field.setNillable(false);
			massPeak_entity.addField(massPeak_id_field);
			massPeak_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//EntityClass
			Entity entityClass_entity = new Entity("EntityClass",this.getDatabase());
			entityClass_entity.setSystem(false);
			entityClass_entity.setAbstract(false);
			entityClass_entity.setDescription("");
			entityClass_entity.setXrefLabels(Arrays.asList(new String[]{"entityClassIdentifier"}));
			Field entityClass_id_field = new Field(entityClass_entity, "id", MolgenisFieldTypes.getType("int"));
			entityClass_id_field.setAuto(true);
			entityClass_id_field.setDescription("automatically generated internal id, only for internal use.");
			entityClass_id_field.setNillable(false);
			entityClass_entity.addField(entityClass_id_field);
			Field entityClass_entityClassIdentifier_field = new Field(entityClass_entity, "entityClassIdentifier", MolgenisFieldTypes.getType("string"));
			entityClass_entityClassIdentifier_field.setDescription("Unique identifier for an entityclass");
			entityClass_entityClassIdentifier_field.setNillable(false);
			entityClass_entity.addField(entityClass_entityClassIdentifier_field);
			Field entityClass_fullName_field = new Field(entityClass_entity, "fullName", MolgenisFieldTypes.getType("string"));
			entityClass_fullName_field.setNillable(false);
			entityClass_entity.addField(entityClass_fullName_field);
			Field entityClass_type_field = new Field(entityClass_entity, "type", MolgenisFieldTypes.getType("enum"));
			Vector<String> entityClass_type_field_enumoptions = new Vector<String>();
			entityClass_type_field_enumoptions.add("dataset");
			entityClass_type_field_enumoptions.add("model");
			entityClass_type_field_enumoptions.add("format");
			entityClass_type_field_enumoptions.add("guideline");
			entityClass_type_field_enumoptions.add("undefined");
			entityClass_type_field.setEnumOptions(entityClass_type_field_enumoptions);
			entityClass_type_field.setDevaultValue("undefined");
			entityClass_type_field.setNillable(false);
			entityClass_entity.addField(entityClass_type_field);
			Field entityClass_description_field = new Field(entityClass_entity, "description", MolgenisFieldTypes.getType("text"));
			entityClass_description_field.setNillable(true);
			entityClass_entity.addField(entityClass_description_field);
			Field entityClass_tags_field = new Field(entityClass_entity, "tags", MolgenisFieldTypes.getType("mref"));
			entityClass_tags_field.setNillable(true);
			entityClass_tags_field.setXRefVariables("OntologyTerm", "id",Arrays.asList(new String[]{"Identifier"}));
			entityClass_entity.addField(entityClass_tags_field);
			Field entityClass_subEntityClasses_field = new Field(entityClass_entity, "subEntityClasses", MolgenisFieldTypes.getType("mref"));
			entityClass_subEntityClasses_field.setNillable(true);
			entityClass_subEntityClasses_field.setXRefVariables("EntityClass", "id",Arrays.asList(new String[]{"entityClassIdentifier"}));
			entityClass_entity.addField(entityClass_subEntityClasses_field);
			Field entityClass_homepage_field = new Field(entityClass_entity, "homepage", MolgenisFieldTypes.getType("hyperlink"));
			entityClass_homepage_field.setNillable(true);
			entityClass_entity.addField(entityClass_homepage_field);
			entityClass_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			entityClass_entity.addKey(Arrays.asList(new String[]{"entityClassIdentifier"}),false,"");
			entityClass_entity.addKey(Arrays.asList(new String[]{"fullName"}),false,"");
			
			//AttributeClass
			Entity attributeClass_entity = new Entity("AttributeClass",this.getDatabase());
			attributeClass_entity.setSystem(false);
			attributeClass_entity.setAbstract(false);
			attributeClass_entity.setDescription("");
			attributeClass_entity.setXrefLabels(Arrays.asList(new String[]{"attributeClassIdentifier"}));
			Field attributeClass_id_field = new Field(attributeClass_entity, "id", MolgenisFieldTypes.getType("int"));
			attributeClass_id_field.setAuto(true);
			attributeClass_id_field.setDescription("automatically generated internal id, only for internal use.");
			attributeClass_id_field.setNillable(false);
			attributeClass_entity.addField(attributeClass_id_field);
			Field attributeClass_attributeClassIdentifier_field = new Field(attributeClass_entity, "attributeClassIdentifier", MolgenisFieldTypes.getType("string"));
			attributeClass_attributeClassIdentifier_field.setDescription("Unique identifier for an attributeclass");
			attributeClass_attributeClassIdentifier_field.setNillable(false);
			attributeClass_entity.addField(attributeClass_attributeClassIdentifier_field);
			Field attributeClass_entityClass_field = new Field(attributeClass_entity, "entityClass", MolgenisFieldTypes.getType("xref"));
			attributeClass_entityClass_field.setNillable(false);
			attributeClass_entityClass_field.setXRefVariables("EntityClass", "id",Arrays.asList(new String[]{"entityClassIdentifier"}));
			attributeClass_entity.addField(attributeClass_entityClass_field);
			Field attributeClass_fullName_field = new Field(attributeClass_entity, "fullName", MolgenisFieldTypes.getType("string"));
			attributeClass_fullName_field.setNillable(false);
			attributeClass_entity.addField(attributeClass_fullName_field);
			Field attributeClass_description_field = new Field(attributeClass_entity, "description", MolgenisFieldTypes.getType("text"));
			attributeClass_description_field.setNillable(true);
			attributeClass_entity.addField(attributeClass_description_field);
			Field attributeClass_nillable_field = new Field(attributeClass_entity, "nillable", MolgenisFieldTypes.getType("bool"));
			attributeClass_nillable_field.setDevaultValue("false");
			attributeClass_nillable_field.setNillable(false);
			attributeClass_entity.addField(attributeClass_nillable_field);
			Field attributeClass_dataType_field = new Field(attributeClass_entity, "dataType", MolgenisFieldTypes.getType("enum"));
			Vector<String> attributeClass_dataType_field_enumoptions = new Vector<String>();
			attributeClass_dataType_field_enumoptions.add("bool");
			attributeClass_dataType_field_enumoptions.add("categorical");
			attributeClass_dataType_field_enumoptions.add("compound");
			attributeClass_dataType_field_enumoptions.add("date");
			attributeClass_dataType_field_enumoptions.add("datetime");
			attributeClass_dataType_field_enumoptions.add("decimal");
			attributeClass_dataType_field_enumoptions.add("email");
			attributeClass_dataType_field_enumoptions.add("enum");
			attributeClass_dataType_field_enumoptions.add("file");
			attributeClass_dataType_field_enumoptions.add("html");
			attributeClass_dataType_field_enumoptions.add("hyperlink");
			attributeClass_dataType_field_enumoptions.add("image");
			attributeClass_dataType_field_enumoptions.add("int");
			attributeClass_dataType_field_enumoptions.add("long");
			attributeClass_dataType_field_enumoptions.add("mref");
			attributeClass_dataType_field_enumoptions.add("string");
			attributeClass_dataType_field_enumoptions.add("text");
			attributeClass_dataType_field_enumoptions.add("xref");
			attributeClass_dataType_field.setEnumOptions(attributeClass_dataType_field_enumoptions);
			attributeClass_dataType_field.setDevaultValue("string");
			attributeClass_dataType_field.setNillable(false);
			attributeClass_entity.addField(attributeClass_dataType_field);
			attributeClass_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			attributeClass_entity.addKey(Arrays.asList(new String[]{"attributeClassIdentifier"}),false,"");
			
			//MolgenisToken
			Entity molgenisToken_entity = new Entity("MolgenisToken",this.getDatabase());
			molgenisToken_entity.setSystem(false);
			molgenisToken_entity.setAbstract(false);
			molgenisToken_entity.setDescription("");
			molgenisToken_entity.setXrefLabels(Arrays.asList(new String[]{"token"}));
			Field molgenisToken_id_field = new Field(molgenisToken_entity, "id", MolgenisFieldTypes.getType("int"));
			molgenisToken_id_field.setAuto(true);
			molgenisToken_id_field.setNillable(false);
			molgenisToken_entity.addField(molgenisToken_id_field);
			Field molgenisToken_molgenisUser_field = new Field(molgenisToken_entity, "molgenisUser", MolgenisFieldTypes.getType("xref"));
			molgenisToken_molgenisUser_field.setNillable(false);
			molgenisToken_molgenisUser_field.setXRefVariables("MolgenisUser", "id",Arrays.asList(new String[]{"username"}));
			molgenisToken_entity.addField(molgenisToken_molgenisUser_field);
			Field molgenisToken_token_field = new Field(molgenisToken_entity, "token", MolgenisFieldTypes.getType("string"));
			molgenisToken_token_field.setNillable(false);
			molgenisToken_entity.addField(molgenisToken_token_field);
			Field molgenisToken_expirationDate_field = new Field(molgenisToken_entity, "expirationDate", MolgenisFieldTypes.getType("datetime"));
			molgenisToken_expirationDate_field.setDescription("When expiration date is null it will never expire");
			molgenisToken_expirationDate_field.setNillable(true);
			molgenisToken_entity.addField(molgenisToken_expirationDate_field);
			Field molgenisToken_creationDate_field = new Field(molgenisToken_entity, "creationDate", MolgenisFieldTypes.getType("datetime"));
			molgenisToken_creationDate_field.setAuto(true);
			molgenisToken_creationDate_field.setNillable(false);
			molgenisToken_entity.addField(molgenisToken_creationDate_field);
			Field molgenisToken_description_field = new Field(molgenisToken_entity, "description", MolgenisFieldTypes.getType("text"));
			molgenisToken_description_field.setNillable(true);
			molgenisToken_entity.addField(molgenisToken_description_field);
			molgenisToken_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			molgenisToken_entity.addKey(Arrays.asList(new String[]{"token"}),false,"");
			
			//DiseaseMapping
			Entity diseaseMapping_entity = new Entity("DiseaseMapping",this.getDatabase());
			diseaseMapping_entity.setSystem(false);
			diseaseMapping_entity.setAbstract(false);
			diseaseMapping_entity.setDescription("Mapping of OMIM/ORPHANET diseases to HGNC genes to HPO terms.");
			diseaseMapping_entity.setXrefLabels(Arrays.asList(new String[]{"identifier"}));
			Field diseaseMapping_id_field = new Field(diseaseMapping_entity, "id", MolgenisFieldTypes.getType("int"));
			diseaseMapping_id_field.setAuto(true);
			diseaseMapping_id_field.setDescription("automatically generated internal id, only for internal use");
			diseaseMapping_id_field.setNillable(false);
			diseaseMapping_entity.addField(diseaseMapping_id_field);
			Field diseaseMapping_identifier_field = new Field(diseaseMapping_entity, "identifier", MolgenisFieldTypes.getType("string"));
			diseaseMapping_identifier_field.setDescription("Combination of diseaseId, geneSymbol and HPOId to get unique identifer");
			diseaseMapping_identifier_field.setNillable(false);
			diseaseMapping_entity.addField(diseaseMapping_identifier_field);
			Field diseaseMapping_diseaseId_field = new Field(diseaseMapping_entity, "diseaseId", MolgenisFieldTypes.getType("string"));
			diseaseMapping_diseaseId_field.setDescription("OMIM or ORPHANET identifier");
			diseaseMapping_diseaseId_field.setNillable(false);
			diseaseMapping_entity.addField(diseaseMapping_diseaseId_field);
			Field diseaseMapping_geneSymbol_field = new Field(diseaseMapping_entity, "geneSymbol", MolgenisFieldTypes.getType("string"));
			diseaseMapping_geneSymbol_field.setDescription("Gene symbol");
			diseaseMapping_geneSymbol_field.setNillable(false);
			diseaseMapping_entity.addField(diseaseMapping_geneSymbol_field);
			Field diseaseMapping_geneId_field = new Field(diseaseMapping_entity, "geneId", MolgenisFieldTypes.getType("string"));
			diseaseMapping_geneId_field.setDescription("Entrez gene identifier");
			diseaseMapping_geneId_field.setNillable(false);
			diseaseMapping_entity.addField(diseaseMapping_geneId_field);
			Field diseaseMapping_hPOId_field = new Field(diseaseMapping_entity, "HPOId", MolgenisFieldTypes.getType("string"));
			diseaseMapping_hPOId_field.setDescription("HPO term identifier");
			diseaseMapping_hPOId_field.setNillable(false);
			diseaseMapping_entity.addField(diseaseMapping_hPOId_field);
			Field diseaseMapping_hPODescription_field = new Field(diseaseMapping_entity, "HPODescription", MolgenisFieldTypes.getType("string"));
			diseaseMapping_hPODescription_field.setDescription("Description of the HPO term");
			diseaseMapping_hPODescription_field.setNillable(false);
			diseaseMapping_entity.addField(diseaseMapping_hPODescription_field);
			Field diseaseMapping_isTypical_field = new Field(diseaseMapping_entity, "isTypical", MolgenisFieldTypes.getType("bool"));
			diseaseMapping_isTypical_field.setDescription("Boolean to indicate if this term is only found in the TYPICAL disease-gene-phenotype set");
			diseaseMapping_isTypical_field.setNillable(false);
			diseaseMapping_entity.addField(diseaseMapping_isTypical_field);
			diseaseMapping_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			diseaseMapping_entity.addKey(Arrays.asList(new String[]{"identifier"}),false,"");
			
			//Disease
			Entity disease_entity = new Entity("Disease",this.getDatabase());
			disease_entity.setSystem(false);
			disease_entity.setAbstract(false);
			disease_entity.setDescription("Mapping of OMIM/ORPHANET disease id's to disease names.");
			disease_entity.setXrefLabels(Arrays.asList(new String[]{"identifier"}));
			Field disease_id_field = new Field(disease_entity, "id", MolgenisFieldTypes.getType("int"));
			disease_id_field.setAuto(true);
			disease_id_field.setDescription("automatically generated internal id, only for internal use");
			disease_id_field.setNillable(false);
			disease_entity.addField(disease_id_field);
			Field disease_identifier_field = new Field(disease_entity, "identifier", MolgenisFieldTypes.getType("string"));
			disease_identifier_field.setDescription("Combination of diseaseName, diseaseId and mappingMethod");
			disease_identifier_field.setNillable(false);
			disease_entity.addField(disease_identifier_field);
			Field disease_diseaseId_field = new Field(disease_entity, "diseaseId", MolgenisFieldTypes.getType("string"));
			disease_diseaseId_field.setDescription("OMIM or ORPHANET identifier");
			disease_diseaseId_field.setNillable(false);
			disease_entity.addField(disease_diseaseId_field);
			Field disease_diseaseName_field = new Field(disease_entity, "diseaseName", MolgenisFieldTypes.getType("string"));
			disease_diseaseName_field.setDescription("OMIM or ORPHANET disease name");
			disease_diseaseName_field.setNillable(false);
			disease_entity.addField(disease_diseaseName_field);
			Field disease_mappingMethod_field = new Field(disease_entity, "mappingMethod", MolgenisFieldTypes.getType("string"));
			disease_mappingMethod_field.setDescription("The phenotype mapping method");
			disease_mappingMethod_field.setNillable(false);
			disease_entity.addField(disease_mappingMethod_field);
			disease_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			disease_entity.addKey(Arrays.asList(new String[]{"identifier"}),false,"");
			
			//ObservedValue
			Entity observedValue_entity = new Entity("ObservedValue",this.getDatabase());
			observedValue_entity.setSystem(false);
			observedValue_entity.setAbstract(false);
			observedValue_entity.setImplements(new String[]{"Autoid"});
			observedValue_entity.setDescription("\n\t\t\t\tGeneric storage of values as part of one observation\n\t\t\t\tevent. Values are atomatic observations,\n\t\t\t\te.g., length (feature) of\n\t\t\t\tindividual 1 (valueset.target) = 179cm (value).\n\t\t\t\tValues can also be\n\t\t\t\tqualified by some characteristic,\n\t\t\t\te.g., QTL p-value (feature) between\n\t\t\t\tphenotype 'leaf count'\n\t\t\t\t(characteristic) and marker 'PVV4'\n\t\t\t\t(valueset.target) = 0.1^10+3 (value).\n\t\t\t");
			observedValue_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field observedValue_observationSet_field = new Field(observedValue_entity, "ObservationSet", MolgenisFieldTypes.getType("xref"));
			observedValue_observationSet_field.setDescription("Reference to the observation. For example a particular patient visit or the application of a microarray or the calculation of a QTL model");
			observedValue_observationSet_field.setNillable(false);
			observedValue_observationSet_field.setXRefVariables("ObservationSet", "id",Arrays.asList(new String[]{"Identifier"}));
			observedValue_entity.addField(observedValue_observationSet_field);
			Field observedValue_feature_field = new Field(observedValue_entity, "Feature", MolgenisFieldTypes.getType("xref"));
			observedValue_feature_field.setDescription("References the ObservableFeature that this observation was made on. For example 'probe123'.");
			observedValue_feature_field.setNillable(false);
			observedValue_feature_field.setXRefVariables("ObservableFeature", "id",Arrays.asList(new String[]{"Identifier"}));
			observedValue_entity.addField(observedValue_feature_field);
			Field observedValue_value_field = new Field(observedValue_entity, "Value", MolgenisFieldTypes.getType("xref"));
			observedValue_value_field.setDescription("The value observed");
			observedValue_value_field.setNillable(true);
			observedValue_value_field.setXRefVariables("Value", "id",Arrays.asList(new String[]{"id"}));
			observedValue_entity.addField(observedValue_value_field);
			Field observedValue_id_field = new Field(observedValue_entity, "id", MolgenisFieldTypes.getType("int"));
			observedValue_id_field.setAuto(true);
			observedValue_id_field.setDescription("automatically generated internal id, only for internal use.");
			observedValue_id_field.setNillable(false);
			observedValue_entity.addField(observedValue_id_field);
			observedValue_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//Individual
			Entity individual_entity = new Entity("Individual",this.getDatabase());
			individual_entity.setSystem(false);
			individual_entity.setAbstract(false);
			individual_entity.setParents(new String[]{"ObservationTarget"});
			individual_entity.setDescription(" The Individuals class defines the subjects that are\n\t\t\t\tused\n\t\t\t\tas observation target. The Individual class maps to\n\t\t\t\tXGAP:Individual\n\t\t\t\tand PaGE:Individual. Groups of individuals can be\n\t\t\t\tdefined via\n\t\t\t\tPanel.\n\t\t\t");
			individual_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field individual_mother_field = new Field(individual_entity, "Mother", MolgenisFieldTypes.getType("xref"));
			individual_mother_field.setDescription("Refers to the mother of the individual.");
			individual_mother_field.setNillable(true);
			individual_mother_field.setXRefVariables("Individual", "id",Arrays.asList(new String[]{"Identifier"}));
			individual_entity.addField(individual_mother_field);
			Field individual_father_field = new Field(individual_entity, "Father", MolgenisFieldTypes.getType("xref"));
			individual_father_field.setDescription("Refers to the father of the individual.");
			individual_father_field.setNillable(true);
			individual_father_field.setXRefVariables("Individual", "id",Arrays.asList(new String[]{"Identifier"}));
			individual_entity.addField(individual_father_field);
			Field individual_id_field = new Field(individual_entity, "id", MolgenisFieldTypes.getType("int"));
			individual_id_field.setAuto(true);
			individual_id_field.setDescription("automatically generated internal id, only for internal use.");
			individual_id_field.setNillable(false);
			individual_entity.addField(individual_id_field);
			individual_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//Panel
			Entity panel_entity = new Entity("Panel",this.getDatabase());
			panel_entity.setSystem(false);
			panel_entity.setAbstract(false);
			panel_entity.setParents(new String[]{"ObservationTarget"});
			panel_entity.setDescription("The Panel class defines groups of individuals based on\n\t\t\t\tcohort design, case/controls, families, etc. For instance:\n\t\t\t\t'LifeLines\n\t\t\t\tcohort', 'middle aged man', 'recombinant mouse inbred Line\n\t\t\t\tdba x b6'\n\t\t\t\tor 'Smith family'. A Panel can act as a single\n\t\t\t\tObservationTarget.\n\t\t\t\tFor example: average height (Measurement) in the\n\t\t\t\tLifeLines cohort\n\t\t\t\t(Panel) is 174cm (ObservedValue). The Panel class\n\t\t\t\tmaps to XGAP:Strain and PaGE:Panel\n\t\t\t\tclasses. In METABASE this is\n\t\t\t\tassumed there is one panel per study.\n\t\t\t");
			panel_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field panel_panelType_field = new Field(panel_entity, "PanelType", MolgenisFieldTypes.getType("xref"));
			panel_panelType_field.setDescription("Indicate the type of Panel (example: Sample panel, AssayedPanel, Natural=wild type, Parental=parents of a cross, F1=First generation of cross, RCC=Recombinant congenic, CSS=chromosome substitution)");
			panel_panelType_field.setNillable(true);
			panel_panelType_field.setXRefVariables("OntologyTerm", "id",Arrays.asList(new String[]{"Identifier"}));
			panel_entity.addField(panel_panelType_field);
			Field panel_numberOfIndividuals_field = new Field(panel_entity, "NumberOfIndividuals", MolgenisFieldTypes.getType("int"));
			panel_numberOfIndividuals_field.setNillable(false);
			panel_entity.addField(panel_numberOfIndividuals_field);
			Field panel_species_field = new Field(panel_entity, "Species", MolgenisFieldTypes.getType("xref"));
			panel_species_field.setDescription("The species this panel is an instance of/part of/extracted from.");
			panel_species_field.setNillable(true);
			panel_species_field.setXRefVariables("Species", "id",Arrays.asList(new String[]{"Identifier"}));
			panel_entity.addField(panel_species_field);
			Field panel_individuals_field = new Field(panel_entity, "Individuals", MolgenisFieldTypes.getType("mref"));
			panel_individuals_field.setDescription("The list of individuals in this panel");
			panel_individuals_field.setNillable(true);
			panel_individuals_field.setXRefVariables("Individual", "id",Arrays.asList(new String[]{"Identifier"}));
			panel_entity.addField(panel_individuals_field);
			Field panel_id_field = new Field(panel_entity, "id", MolgenisFieldTypes.getType("int"));
			panel_id_field.setAuto(true);
			panel_id_field.setDescription("automatically generated internal id, only for internal use.");
			panel_id_field.setNillable(false);
			panel_entity.addField(panel_id_field);
			panel_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//PanelSource
			Entity panelSource_entity = new Entity("PanelSource",this.getDatabase());
			panelSource_entity.setSystem(false);
			panelSource_entity.setAbstract(false);
			panelSource_entity.setImplements(new String[]{"Autoid"});
			panelSource_entity.setDescription("PanelSources is partOf Panel to define how panels are\n\t\t\t\trelated panels, founder panels,\n\t\t\t\tsuch as overlap,\n\t\t\t\tselection criteria,\n\t\t\t\tgetting assayed panel from a\n\t\t\t\tsample panel, etc.\n\t\t\t");
			panelSource_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field panelSource_currentPanel_field = new Field(panelSource_entity, "CurrentPanel", MolgenisFieldTypes.getType("xref"));
			panelSource_currentPanel_field.setDescription("Panel for which these sources are defined.");
			panelSource_currentPanel_field.setNillable(false);
			panelSource_currentPanel_field.setXRefVariables("Panel", "id",Arrays.asList(new String[]{"Identifier"}));
			panelSource_entity.addField(panelSource_currentPanel_field);
			Field panelSource_sourcePanel_field = new Field(panelSource_entity, "SourcePanel", MolgenisFieldTypes.getType("xref"));
			panelSource_sourcePanel_field.setDescription("Source that contributed individuals to current panel");
			panelSource_sourcePanel_field.setNillable(false);
			panelSource_sourcePanel_field.setXRefVariables("Panel", "id",Arrays.asList(new String[]{"Identifier"}));
			panelSource_entity.addField(panelSource_sourcePanel_field);
			Field panelSource_numberOfIndividuals_field = new Field(panelSource_entity, "NumberOfIndividuals", MolgenisFieldTypes.getType("int"));
			panelSource_numberOfIndividuals_field.setDescription("Number of individuals lifted over from this source");
			panelSource_numberOfIndividuals_field.setNillable(true);
			panelSource_entity.addField(panelSource_numberOfIndividuals_field);
			Field panelSource_selectionCriteria_field = new Field(panelSource_entity, "SelectionCriteria", MolgenisFieldTypes.getType("text"));
			panelSource_selectionCriteria_field.setDescription("Inclusion/exclusion criteria used to select these individuals from source into current panel");
			panelSource_selectionCriteria_field.setNillable(false);
			panelSource_entity.addField(panelSource_selectionCriteria_field);
			Field panelSource_id_field = new Field(panelSource_entity, "id", MolgenisFieldTypes.getType("int"));
			panelSource_id_field.setAuto(true);
			panelSource_id_field.setDescription("automatically generated internal id, only for internal use.");
			panelSource_id_field.setNillable(false);
			panelSource_entity.addField(panelSource_id_field);
			panelSource_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//XrefValue
			Entity xrefValue_entity = new Entity("XrefValue",this.getDatabase());
			xrefValue_entity.setSystem(false);
			xrefValue_entity.setAbstract(false);
			xrefValue_entity.setParents(new String[]{"Value"});
			xrefValue_entity.setDescription("");
			xrefValue_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field xrefValue_value_field = new Field(xrefValue_entity, "Value", MolgenisFieldTypes.getType("xref"));
			xrefValue_value_field.setNillable(false);
			xrefValue_value_field.setXRefVariables("Characteristic", "id",Arrays.asList(new String[]{"Identifier"}));
			xrefValue_entity.addField(xrefValue_value_field);
			Field xrefValue_id_field = new Field(xrefValue_entity, "id", MolgenisFieldTypes.getType("int"));
			xrefValue_id_field.setAuto(true);
			xrefValue_id_field.setDescription("automatically generated internal id, only for internal use.");
			xrefValue_id_field.setNillable(false);
			xrefValue_entity.addField(xrefValue_id_field);
			xrefValue_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//Sample
			Entity sample_entity = new Entity("Sample",this.getDatabase());
			sample_entity.setSystem(false);
			sample_entity.setAbstract(false);
			sample_entity.setParents(new String[]{"ObservationTarget"});
			sample_entity.setDescription("");
			sample_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field sample_individual_field = new Field(sample_entity, "Individual", MolgenisFieldTypes.getType("xref"));
			sample_individual_field.setDescription("The individual from which this sample was taken.");
			sample_individual_field.setNillable(true);
			sample_individual_field.setXRefVariables("Individual", "id",Arrays.asList(new String[]{"Identifier"}));
			sample_entity.addField(sample_individual_field);
			Field sample_tissue_field = new Field(sample_entity, "Tissue", MolgenisFieldTypes.getType("xref"));
			sample_tissue_field.setDescription("The tissue from which this sample was taken.");
			sample_tissue_field.setNillable(true);
			sample_tissue_field.setXRefVariables("OntologyTerm", "id",Arrays.asList(new String[]{"Identifier"}));
			sample_entity.addField(sample_tissue_field);
			Field sample_id_field = new Field(sample_entity, "id", MolgenisFieldTypes.getType("int"));
			sample_id_field.setAuto(true);
			sample_id_field.setDescription("automatically generated internal id, only for internal use.");
			sample_id_field.setNillable(false);
			sample_entity.addField(sample_id_field);
			sample_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//PairedSample
			Entity pairedSample_entity = new Entity("PairedSample",this.getDatabase());
			pairedSample_entity.setSystem(false);
			pairedSample_entity.setAbstract(false);
			pairedSample_entity.setParents(new String[]{"ObservationTarget"});
			pairedSample_entity.setDescription(" A pair of samples labeled for a two-color microarray\n\t\t\t\texperiment.");
			pairedSample_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field pairedSample_subject1_field = new Field(pairedSample_entity, "Subject1", MolgenisFieldTypes.getType("xref"));
			pairedSample_subject1_field.setDescription("The first subject");
			pairedSample_subject1_field.setNillable(false);
			pairedSample_subject1_field.setXRefVariables("Individual", "id",Arrays.asList(new String[]{"Identifier"}));
			pairedSample_entity.addField(pairedSample_subject1_field);
			Field pairedSample_label1_field = new Field(pairedSample_entity, "Label1", MolgenisFieldTypes.getType("xref"));
			pairedSample_label1_field.setDescription("Which channel or Fluorescent labeling is associated with the first subject");
			pairedSample_label1_field.setNillable(true);
			pairedSample_label1_field.setXRefVariables("OntologyTerm", "id",Arrays.asList(new String[]{"Identifier"}));
			pairedSample_entity.addField(pairedSample_label1_field);
			Field pairedSample_subject2_field = new Field(pairedSample_entity, "Subject2", MolgenisFieldTypes.getType("xref"));
			pairedSample_subject2_field.setDescription("The second sample");
			pairedSample_subject2_field.setNillable(false);
			pairedSample_subject2_field.setXRefVariables("Individual", "id",Arrays.asList(new String[]{"Identifier"}));
			pairedSample_entity.addField(pairedSample_subject2_field);
			Field pairedSample_label2_field = new Field(pairedSample_entity, "Label2", MolgenisFieldTypes.getType("xref"));
			pairedSample_label2_field.setDescription("Which channel or Fluorescent labeling is associated with the second subject");
			pairedSample_label2_field.setNillable(true);
			pairedSample_label2_field.setXRefVariables("OntologyTerm", "id",Arrays.asList(new String[]{"Identifier"}));
			pairedSample_entity.addField(pairedSample_label2_field);
			Field pairedSample_id_field = new Field(pairedSample_entity, "id", MolgenisFieldTypes.getType("int"));
			pairedSample_id_field.setAuto(true);
			pairedSample_id_field.setDescription("automatically generated internal id, only for internal use.");
			pairedSample_id_field.setNillable(false);
			pairedSample_entity.addField(pairedSample_id_field);
			pairedSample_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//Patient
			Entity patient_entity = new Entity("Patient",this.getDatabase());
			patient_entity.setSystem(false);
			patient_entity.setAbstract(false);
			patient_entity.setParents(new String[]{"Individual"});
			patient_entity.setDescription("");
			patient_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field patient_allele1_field = new Field(patient_entity, "Allele1", MolgenisFieldTypes.getType("xref"));
			patient_allele1_field.setNillable(true);
			patient_allele1_field.setXRefVariables("Variant", "id",Arrays.asList(new String[]{"Identifier"}));
			patient_entity.addField(patient_allele1_field);
			Field patient_allele2_field = new Field(patient_entity, "Allele2", MolgenisFieldTypes.getType("xref"));
			patient_allele2_field.setNillable(true);
			patient_allele2_field.setXRefVariables("Variant", "id",Arrays.asList(new String[]{"Identifier"}));
			patient_entity.addField(patient_allele2_field);
			Field patient_pheno_field = new Field(patient_entity, "Pheno", MolgenisFieldTypes.getType("string"));
			patient_pheno_field.setNillable(true);
			patient_entity.addField(patient_pheno_field);
			Field patient_pubMedID_field = new Field(patient_entity, "PubMedID", MolgenisFieldTypes.getType("string"));
			patient_pubMedID_field.setNillable(true);
			patient_entity.addField(patient_pubMedID_field);
			Field patient_reference_field = new Field(patient_entity, "Reference", MolgenisFieldTypes.getType("string"));
			patient_reference_field.setNillable(true);
			patient_entity.addField(patient_reference_field);
			Field patient_id_field = new Field(patient_entity, "id", MolgenisFieldTypes.getType("int"));
			patient_id_field.setAuto(true);
			patient_id_field.setDescription("automatically generated internal id, only for internal use.");
			patient_id_field.setNillable(false);
			patient_entity.addField(patient_id_field);
			patient_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
		} catch (MolgenisModelException e)
		{
			throw new RuntimeException(e);
		}
	}
}