/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.app;

import org.molgenis.auth.AuthorityMetaData;
import org.molgenis.auth.GroupAuthorityMetaData;
import org.molgenis.auth.MolgenisGroupMemberMetaData;
import org.molgenis.auth.MolgenisGroupMetaData;
import org.molgenis.auth.MolgenisUser;
import org.molgenis.auth.MolgenisUserMetaData;
import org.molgenis.auth.RuntimePropertyMetaData;
import org.molgenis.auth.UserAuthority;
import org.molgenis.auth.UserAuthorityMetaData;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.Query;
import org.molgenis.data.jobs.JobExecutionMetaData;
import org.molgenis.data.meta.system.FreemarkerTemplateMetaData;
import org.molgenis.data.meta.system.ImportRunMetaData;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.framework.db.WebAppDatabasePopulatorService;
import org.molgenis.security.MolgenisSecurityWebAppDatabasePopulatorService;
import org.molgenis.security.core.runas.RunAsSystem;
import org.molgenis.security.core.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WebAppDatabasePopulatorServiceImpl
implements WebAppDatabasePopulatorService {
    private final DataService dataService;
    private final MolgenisSecurityWebAppDatabasePopulatorService molgenisSecurityWebAppDatabasePopulatorService;

    @Autowired
    public WebAppDatabasePopulatorServiceImpl(DataService dataService, MolgenisSecurityWebAppDatabasePopulatorService molgenisSecurityWebAppDatabasePopulatorService) {
        if (dataService == null) {
            throw new IllegalArgumentException("DataService is null");
        }
        this.dataService = dataService;
        if (molgenisSecurityWebAppDatabasePopulatorService == null) {
            throw new IllegalArgumentException("MolgenisSecurityWebAppDatabasePopulator is null");
        }
        this.molgenisSecurityWebAppDatabasePopulatorService = molgenisSecurityWebAppDatabasePopulatorService;
    }

    @Transactional
    @RunAsSystem
    public void populateDatabase() {
        this.dataService.getMeta().addEntityMeta((EntityMetaData)new AuthorityMetaData());
        this.dataService.getMeta().addEntityMeta((EntityMetaData)new RuntimePropertyMetaData());
        this.dataService.getMeta().addEntityMeta((EntityMetaData)new FreemarkerTemplateMetaData());
        this.dataService.getMeta().addEntityMeta((EntityMetaData)new GroupAuthorityMetaData());
        this.dataService.getMeta().addEntityMeta((EntityMetaData)new UserAuthorityMetaData());
        this.dataService.getMeta().addEntityMeta((EntityMetaData)new MolgenisUserMetaData());
        this.dataService.getMeta().addEntityMeta((EntityMetaData)new MolgenisGroupMetaData());
        this.dataService.getMeta().addEntityMeta((EntityMetaData)new MolgenisGroupMemberMetaData());
        this.dataService.getMeta().addEntityMeta((EntityMetaData)new ImportRunMetaData());
        this.dataService.getMeta().addEntityMeta((EntityMetaData)new JobExecutionMetaData());
        this.molgenisSecurityWebAppDatabasePopulatorService.populateDatabase(this.dataService, "home");
        MolgenisUser anonymousUser = this.molgenisSecurityWebAppDatabasePopulatorService.getAnonymousUser();
        UserAuthority anonymousHomeAuthority = new UserAuthority();
        anonymousHomeAuthority.setMolgenisUser(anonymousUser);
        anonymousHomeAuthority.setRole(SecurityUtils.AUTHORITY_PLUGIN_WRITE_PREFIX + "home".toUpperCase());
        this.dataService.add("UserAuthority", (Entity)anonymousHomeAuthority);
    }

    @Transactional
    @RunAsSystem
    public boolean isDatabasePopulated() {
        return this.dataService.count("molgenisUser", (Query)new QueryImpl()) > 0L;
    }
}

