/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.gaf;

import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.gaf.GafListSettings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GafListDbSettings
implements GafListSettings {
    private static final String GAF_LIST_VALIDATOR_PREFIX = "gafList.validator.";
    private static final String GAF_LIST_VALIDATOR_EXAMPLE_PREFIX = "gafList.validator.example.";
    private final DataService dataService;

    @Autowired
    public GafListDbSettings(DataService dataService) {
        this.dataService = dataService;
    }

    public String getEntityName() {
        return this.getValue("gafList.protocol.name");
    }

    public String getExample(String columnName) {
        return this.getValue(GAF_LIST_VALIDATOR_EXAMPLE_PREFIX + columnName);
    }

    public String getRegExpPattern(String columnName) {
        return this.getValue(GAF_LIST_VALIDATOR_PREFIX + columnName);
    }

    private String getValue(String name) {
        Entity entity = this.dataService.findOne("GafListSettings", (Object)name);
        return entity != null ? entity.getString("Value") : null;
    }
}

