/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.tools.compare;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.data.csv.CsvRepository;
import org.molgenis.data.csv.CsvWriter;
import org.molgenis.data.processor.TrimProcessor;
import org.molgenis.data.support.MapEntity;

public class IBDParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        IBDParser vc = new IBDParser();
        String path = args[0];
        String inputFolder = path + "dataset/";
        String categoryFilePath = path + "category.csv";
        String featureFilePath = path + "observablefeature.csv";
        try (PrintWriter logfile = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(path + "logfile.txt")), Charset.forName("UTF-8")));){
            File dir = new File(inputFolder);
            String datasetName = null;
            HashMap<String, String> consultMap = new HashMap<String, String>();
            consultMap.put("BB", "IDAABB");
            consultMap.put("BC", "IDAABC");
            consultMap.put("BE", "IDAABE");
            consultMap.put("BF", "IDAABF");
            consultMap.put("BG", "IDAABG");
            consultMap.put("BH", "IDAABH");
            consultMap.put("BI", "IDAABI");
            consultMap.put("BJ", "IDAABJ");
            consultMap.put("CA", "IDAABC");
            consultMap.put("CB", "IDAABC");
            consultMap.put("CD", "IDAABJ");
            consultMap.put("CE", "IDAABI");
            for (File child : dir.listFiles()) {
                String fileName;
                String[] splitFileName;
                if (child.isHidden() || (datasetName = (splitFileName = (fileName = FilenameUtils.removeExtension((String)child.toString())).split("_"))[2]).equals("CD")) continue;
                vc.checkForMultipleConsults(datasetName, (String)consultMap.get(datasetName), logfile);
            }
            vc.filterCategories(categoryFilePath, featureFilePath, logfile);
            System.out.println("logfile can be found at: " + path + "logfile.txt");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForMultipleConsults(String datasetName, String consultDateName, PrintWriter logfile) throws IOException {
        ArrayList<TrimProcessor> processors = new ArrayList<TrimProcessor>();
        processors.add(new TrimProcessor());
        String file2 = "/Users/Roan/Work/IBDParelsnoer/convert/dataset/dataset_VW_" + datasetName + "_.csv";
        CsvRepository csvRepository = new CsvRepository(new File(file2), processors);
        CsvRepository csvRepository2 = new CsvRepository(new File(file2), processors);
        CsvWriter csvWriter = new CsvWriter(new File("/Users/Roan/Work/IBDParelsnoer/convert/output/dataset_VW_" + datasetName + "_.csv"));
        try {
            String lastIDAA = null;
            HashMap<String, String> mapID = new HashMap<String, String>();
            ArrayList<String> storedIDs = new ArrayList<String>();
            Iterable listOfAttributeNames = null;
            String oldRowID = null;
            for (Entity entity : csvRepository) {
                String id = entity.getString("IDAA");
                String consultDate = entity.getString(consultDateName);
                listOfAttributeNames = entity.getAttributeNames();
                if (!id.equals(lastIDAA)) {
                    mapID.put(id, consultDate);
                    lastIDAA = id;
                    oldRowID = entity.getString(datasetName + "_ID");
                    storedIDs.add(oldRowID);
                    continue;
                }
                String storedID = this.compareDate(oldRowID, entity.getString(datasetName + "_ID"), (String)mapID.get(id), consultDate, logfile);
                if (storedIDs.contains(storedID)) continue;
                storedIDs.add(storedID);
            }
            csvWriter.writeAttributeNames(listOfAttributeNames);
            MapEntity writeEntity = null;
            int counter = 0;
            for (Entity entity2 : csvRepository2) {
                ++counter;
                writeEntity = new MapEntity();
                if (!storedIDs.contains(entity2.getString(datasetName + "_ID"))) continue;
                for (String value : entity2.getAttributeNames()) {
                    writeEntity.set(value, (Object)entity2.getString(value));
                }
                csvWriter.add((Entity)writeEntity);
            }
            logfile.println("----------------------------------------------------------------");
            logfile.println(datasetName + " finished, total number of entities: " + counter);
        }
        finally {
            csvWriter.close();
            csvRepository.close();
            csvRepository2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterCategories(String categoryFile, String featureFile, PrintWriter logfile) throws IOException {
        logfile.println("########");
        logfile.println("Categories will be filtered");
        ArrayList<TrimProcessor> processors = new ArrayList<TrimProcessor>();
        processors.add(new TrimProcessor());
        CsvRepository repositoryCategoryCsvSourceInput = new CsvRepository(new File(categoryFile), processors);
        CsvRepository repositoryCategoryCsvSourceOutput = new CsvRepository(new File(categoryFile), processors);
        CsvRepository repositoryFeatureCsvSourceOutput = new CsvRepository(new File(featureFile), processors);
        try {
            Iterable listOfAttributeNames = null;
            HashMap mapOfStrings = new HashMap();
            ArrayList<String> listOfStrings = new ArrayList<String>();
            for (Entity entity : repositoryCategoryCsvSourceInput) {
                listOfAttributeNames = entity.getAttributeNames();
                String feature = entity.getString("observablefeature_identifier");
                String valueCode = entity.getString("valuecode");
                if (!mapOfStrings.containsKey(feature)) {
                    listOfStrings = new ArrayList();
                    listOfStrings.add(valueCode);
                    mapOfStrings.put(feature, listOfStrings);
                    continue;
                }
                ((List)mapOfStrings.get(feature)).add(valueCode);
            }
            ArrayList listOfFeatures = new ArrayList();
            block4: for (Map.Entry entry : mapOfStrings.entrySet()) {
                boolean cat = false;
                for (String valueCode : (List)entry.getValue()) {
                    if (!(valueCode.startsWith("-") || valueCode.contains("1808") || valueCode.contains("1809") || valueCode.contains("1810"))) {
                        cat = true;
                    }
                    if (!cat) continue;
                    listOfFeatures.add(entry.getKey());
                    continue block4;
                }
            }
            this.writeCategoryOutput(listOfAttributeNames, (Repository)repositoryCategoryCsvSourceOutput, listOfFeatures);
            logfile.println("category output done");
            this.writeFeatureOutput(listOfAttributeNames, (Repository)repositoryFeatureCsvSourceOutput, listOfFeatures);
            logfile.println("feature output done");
        }
        finally {
            repositoryCategoryCsvSourceOutput.close();
            repositoryCategoryCsvSourceInput.close();
            repositoryFeatureCsvSourceOutput.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCategoryOutput(Iterable<String> listOfAttributeNames, Repository categoryCsvOutput, List<String> listOfFeatures) throws IOException {
        try (CsvWriter csvWriter = new CsvWriter(new File("/Users/Roan/Work/IBDParelsnoer/convert/output/category.csv"));){
            csvWriter.writeAttributeNames(listOfAttributeNames);
            MapEntity writeEntity = null;
            for (Entity entity2 : categoryCsvOutput) {
                writeEntity = new MapEntity();
                if (!listOfFeatures.contains(entity2.getString("observablefeature_identifier"))) continue;
                for (String value : entity2.getAttributeNames()) {
                    writeEntity.set(value, (Object)entity2.getString(value));
                }
                csvWriter.add((Entity)writeEntity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFeatureOutput(Iterable<String> listOfAttributeNames, Repository featureCsvInput, List<String> listOfFeatures) throws IOException {
        List<String> headers = Arrays.asList("identifier", "name", "dataType", "description");
        try (CsvWriter csvWriterFeature = new CsvWriter(new File("/Users/Roan/Work/IBDParelsnoer/convert/output/observablefeature.csv"));){
            csvWriterFeature.writeAttributeNames(headers);
            MapEntity writeEntityFeature = null;
            for (Entity entity : featureCsvInput) {
                writeEntityFeature = new MapEntity();
                if (listOfFeatures.contains(entity.getString("identifier"))) {
                    for (String value : entity.getAttributeNames()) {
                        writeEntityFeature.set(value, (Object)entity.getString(value));
                    }
                    csvWriterFeature.add((Entity)writeEntityFeature);
                    continue;
                }
                if (entity.getString("dataType") == null || entity.getString("dataType").equals("categorical")) {
                    writeEntityFeature.set("identifier", (Object)entity.getString("identifier"));
                    writeEntityFeature.set("name", (Object)entity.getString("name"));
                    writeEntityFeature.set("dataType", (Object)"string");
                    writeEntityFeature.set("description", (Object)entity.getString("description"));
                    csvWriterFeature.add((Entity)writeEntityFeature);
                    continue;
                }
                for (String value : entity.getAttributeNames()) {
                    writeEntityFeature.set(value, (Object)entity.getString(value));
                }
                csvWriterFeature.add((Entity)writeEntityFeature);
            }
        }
    }

    public String compareDate(String oldId, String newId, String date1, String date2, PrintWriter logfile) {
        if (!date1.contains("-") || !date2.contains("-")) {
            logfile.println("NO REAL DATES: " + oldId + ":" + date1 + "\t" + newId + ":" + date2);
            return date1;
        }
        String[] consult1 = date1.substring(0, 10).split("-");
        String[] consult2 = date2.substring(0, 10).split("-");
        int yearConsult1 = Integer.parseInt(consult1[0]);
        int yearConsult2 = Integer.parseInt(consult2[0]);
        int monthConsult1 = Integer.parseInt(consult1[1]);
        int monthConsult2 = Integer.parseInt(consult2[1]);
        int dayConsult1 = Integer.parseInt(consult1[2]);
        int dayConsult2 = Integer.parseInt(consult2[2]);
        if (yearConsult1 < yearConsult2) {
            return oldId;
        }
        if (yearConsult1 > yearConsult2) {
            return newId;
        }
        if (monthConsult1 < monthConsult2) {
            return oldId;
        }
        if (monthConsult1 > monthConsult2) {
            return newId;
        }
        if (dayConsult1 < dayConsult2) {
            return oldId;
        }
        if (dayConsult1 > dayConsult2) {
            return newId;
        }
        logfile.println("Dates are identical. OldID:" + oldId + ":" + yearConsult1 + "-" + monthConsult1 + "-" + dayConsult1 + "\t" + "NewID:" + newId + ":" + yearConsult2 + "-" + monthConsult2 + "-" + dayConsult2);
        return oldId;
    }
}

