/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.app;

import java.util.ArrayList;
import java.util.List;
import org.molgenis.security.MolgenisRoleHierarchy;
import org.molgenis.security.MolgenisWebAppSecurityConfig;
import org.molgenis.security.core.utils.SecurityUtils;
import org.molgenis.ui.security.MolgenisAccessDecisionVoter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.access.vote.AffirmativeBased;
import org.springframework.security.access.vote.RoleVoter;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.web.access.expression.WebExpressionVoter;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
public class WebAppSecurityConfig
extends MolgenisWebAppSecurityConfig {
    @Autowired
    private MolgenisAccessDecisionVoter molgenisAccessDecisionVoter;
    @Autowired
    private RoleVoter roleVoter;

    protected void configureUrlAuthorization(ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry) {
        ArrayList<Object> listOfVoters = new ArrayList<Object>();
        listOfVoters.add(new WebExpressionVoter());
        listOfVoters.add(new MolgenisAccessDecisionVoter());
        expressionInterceptUrlRegistry.accessDecisionManager((AccessDecisionManager)new AffirmativeBased(listOfVoters));
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)expressionInterceptUrlRegistry.antMatchers(new String[]{"/"})).permitAll().antMatchers(new String[]{"/das/**"})).permitAll().antMatchers(new String[]{"/myDas/**"})).permitAll().antMatchers(new String[]{"/fdp/**"})).permitAll().antMatchers(new String[]{"/annotators/**"})).authenticated().antMatchers(new String[]{"/charts/**"})).authenticated();
    }

    protected List<GrantedAuthority> createAnonymousUserAuthorities() {
        String s = SecurityUtils.getPluginReadAuthority((String)"home");
        return AuthorityUtils.createAuthorityList((String[])new String[]{s});
    }

    public RoleHierarchy roleHierarchy() {
        return new MolgenisRoleHierarchy();
    }

    @Bean
    public MolgenisAccessDecisionVoter molgenisAccessDecisionVoter() {
        return new MolgenisAccessDecisionVoter();
    }
}

