/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.app;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.molgenis.auth.Group;
import org.molgenis.auth.GroupAuthority;
import org.molgenis.auth.GroupAuthorityFactory;
import org.molgenis.auth.User;
import org.molgenis.auth.UserAuthority;
import org.molgenis.auth.UserAuthorityFactory;
import org.molgenis.bootstrap.populate.SystemEntityRegistry;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.security.core.utils.SecurityUtils;
import org.springframework.stereotype.Component;

@Component
public class WebAppSystemEntityRegistry
implements SystemEntityRegistry {
    private final DataService dataService;
    private final UserAuthorityFactory userAuthorityFactory;
    private final GroupAuthorityFactory groupAuthorityFactory;

    public WebAppSystemEntityRegistry(DataService dataService, UserAuthorityFactory userAuthorityFactory, GroupAuthorityFactory groupAuthorityFactory) {
        this.dataService = Objects.requireNonNull(dataService);
        this.userAuthorityFactory = Objects.requireNonNull(userAuthorityFactory);
        this.groupAuthorityFactory = Objects.requireNonNull(groupAuthorityFactory);
    }

    public Collection<Entity> getEntities() {
        User anonymousUser = (User)this.dataService.query("sys_sec_User", User.class).eq("username", (Object)"anonymous").findOne();
        UserAuthority anonymousHomeAuthority = (UserAuthority)this.userAuthorityFactory.create();
        anonymousHomeAuthority.setUser(anonymousUser);
        anonymousHomeAuthority.setRole(SecurityUtils.AUTHORITY_PLUGIN_READ_PREFIX + "home");
        Group allUsersGroup = (Group)this.dataService.query("sys_sec_Group", Group.class).eq("name", (Object)"All Users").findOne();
        GroupAuthority usersGroupHomeAuthority = (GroupAuthority)this.groupAuthorityFactory.create();
        usersGroupHomeAuthority.setGroup(allUsersGroup);
        usersGroupHomeAuthority.setRole(SecurityUtils.AUTHORITY_PLUGIN_READ_PREFIX + "home");
        return Arrays.asList(anonymousHomeAuthority, usersGroupHomeAuthority);
    }
}

