/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.app;

import freemarker.cache.TemplateLoader;
import org.molgenis.app.WebAppSecurityConfig;
import org.molgenis.core.ui.MolgenisWebAppConfig;
import org.molgenis.core.ui.data.config.HttpClientConfig;
import org.molgenis.core.ui.freemarker.RepositoryTemplateLoader;
import org.molgenis.core.ui.util.GsonConfig;
import org.molgenis.data.DataService;
import org.molgenis.data.elasticsearch.client.ElasticsearchConfig;
import org.molgenis.data.postgresql.DatabaseConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

@Configuration
@EnableTransactionManagement
@EnableAspectJAutoProxy
@EnableWebMvc
@EnableAsync
@ComponentScan(basePackages={"org.molgenis"})
@Import(value={WebAppSecurityConfig.class, DatabaseConfig.class, HttpClientConfig.class, ElasticsearchConfig.class, GsonConfig.class})
public class WebAppConfig
extends MolgenisWebAppConfig {
    @Autowired
    private DataService dataService;

    public FreeMarkerConfigurer freeMarkerConfigurer() {
        FreeMarkerConfigurer result = super.freeMarkerConfigurer();
        result.setPostTemplateLoaders(new TemplateLoader[]{new RepositoryTemplateLoader(this.dataService)});
        return result;
    }
}

