/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.app;

import java.util.ArrayList;
import java.util.Objects;
import org.molgenis.core.ui.security.MolgenisAccessDecisionVoter;
import org.molgenis.data.DataService;
import org.molgenis.data.security.DataserviceRoleHierarchy;
import org.molgenis.data.support.DataServiceImpl;
import org.molgenis.security.MolgenisWebAppSecurityConfig;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.access.vote.AffirmativeBased;
import org.springframework.security.acls.jdbc.AclConfig;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.web.access.expression.WebExpressionVoter;

@Configuration
@Import(value={AclConfig.class, DataServiceImpl.class})
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
public class WebAppSecurityConfig
extends MolgenisWebAppSecurityConfig {
    private final DataService dataService;

    public WebAppSecurityConfig(DataService dataService) {
        this.dataService = Objects.requireNonNull(dataService);
    }

    protected void configureUrlAuthorization(ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry) {
        ArrayList<Object> listOfVoters = new ArrayList<Object>();
        listOfVoters.add(new WebExpressionVoter());
        listOfVoters.add(new MolgenisAccessDecisionVoter());
        expressionInterceptUrlRegistry.accessDecisionManager((AccessDecisionManager)new AffirmativeBased(listOfVoters));
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)expressionInterceptUrlRegistry.antMatchers(new String[]{"/"})).permitAll();
    }

    public RoleHierarchy roleHierarchy() {
        return new DataserviceRoleHierarchy(this.dataService);
    }

    @Bean
    public MolgenisAccessDecisionVoter molgenisAccessDecisionVoter() {
        return new MolgenisAccessDecisionVoter();
    }
}

