/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.app;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.io.Serializable;
import org.molgenis.bootstrap.populate.PermissionRegistry;
import org.molgenis.data.security.auth.GroupService;
import org.molgenis.security.core.PermissionSet;
import org.molgenis.security.core.SidUtils;
import org.molgenis.util.Pair;
import org.springframework.security.acls.domain.ObjectIdentityImpl;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.Sid;
import org.springframework.stereotype.Component;

@Component
public class WebAppPermissionRegistry
implements PermissionRegistry {
    private ImmutableMultimap.Builder<ObjectIdentity, Pair<PermissionSet, Sid>> builder = new ImmutableMultimap.Builder();

    WebAppPermissionRegistry() {
        Sid anonymousRole = SidUtils.createAnonymousSid();
        Sid user = SidUtils.createAuthoritySid((String)"ROLE_USER");
        Sid viewer = SidUtils.createAuthoritySid((String)GroupService.AUTHORITY_VIEWER);
        Sid editor = SidUtils.createAuthoritySid((String)GroupService.AUTHORITY_EDITOR);
        Sid manager = SidUtils.createAuthoritySid((String)GroupService.AUTHORITY_MANAGER);
        this.register("plugin", "home", anonymousRole, PermissionSet.READ);
        this.register("plugin", "useraccount", user, PermissionSet.READ);
        this.register("plugin", "app", anonymousRole, PermissionSet.READ);
        this.register("package", "sys_beacons", anonymousRole, PermissionSet.READ);
        this.register("plugin", "feedback", user, PermissionSet.READ);
        this.register("plugin", "redirect", anonymousRole, PermissionSet.READ);
        this.register("plugin", "importwizard", editor, PermissionSet.READ);
        this.register("entityType", "sys_FreemarkerTemplate", anonymousRole, PermissionSet.READ);
        this.register("entityType", "sys_FreemarkerTemplate", editor, PermissionSet.WRITE);
        this.register("plugin", "dataexplorer", viewer, PermissionSet.READ);
        this.register("entityType", "sys_set_dataexplorer", viewer, PermissionSet.READ);
        this.register("plugin", "directory", viewer, PermissionSet.READ);
        this.register("package", "sys_negotiator", viewer, PermissionSet.READ);
        this.register("plugin", "searchAll", viewer, PermissionSet.READ);
        this.register("plugin", "data-row-edit", editor, PermissionSet.READ);
        this.register("plugin", "jobs", editor, PermissionSet.READ);
        this.register("entityType", "sys_ImportRun", editor, PermissionSet.WRITE);
        this.register("entityType", "sys_ont_MatchingTaskContent", editor, PermissionSet.WRITE);
        this.register("entityType", "sys_ont_OntologyTermHit", editor, PermissionSet.WRITE);
        this.register("package", "sys_ont", user, PermissionSet.READ);
        this.register("plugin", "questionnaires", editor, PermissionSet.READ);
        this.register("package", "sys_genomebrowser", viewer, PermissionSet.READ);
        this.register("entityType", "sys_Language", anonymousRole, PermissionSet.READ);
        this.register("entityType", "sys_L10nString", anonymousRole, PermissionSet.READ);
        this.register("package", "sys_md", user, PermissionSet.READ);
        this.register("entityType", "sys_dec_DecoratorConfiguration", anonymousRole, PermissionSet.READ);
        this.register("package", "sys_md", manager, PermissionSet.WRITE);
        this.register("plugin", "navigator", viewer, PermissionSet.READ);
        this.register("entityType", "sys_job_ResourceDownloadJobExecution", editor, PermissionSet.WRITE);
        this.register("entityType", "sys_FileMeta", editor, PermissionSet.WRITE);
        this.register("plugin", "one-click-importer", manager, PermissionSet.READ);
        this.register("entityType", "sys_job_OneClickImportJobExecution", manager, PermissionSet.WRITE);
        this.register("package", "sys", user, PermissionSet.READMETA);
        this.register("plugin", "security-ui", manager, PermissionSet.READ);
        this.register("plugin", "metadata-manager", manager, PermissionSet.READ);
        this.register("entityType", "sys_job_ResourceCopyJobExecution", manager, PermissionSet.WRITE);
        this.register("entityType", "sys_job_ResourceDeleteJobExecution", manager, PermissionSet.WRITE);
    }

    public Multimap<ObjectIdentity, Pair<PermissionSet, Sid>> getPermissions() {
        return this.builder.build();
    }

    private void register(String objectType, String objectId, Sid sid, PermissionSet permissionSet) {
        this.builder.put((Object)new ObjectIdentityImpl(objectType, (Serializable)((Object)objectId)), (Object)new Pair((Object)permissionSet, (Object)sid));
    }
}

