/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.apps.model;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.stream.Stream;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.FileHeader;
import org.molgenis.apps.model.App;
import org.molgenis.data.AbstractRepositoryDecorator;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.data.validation.ConstraintViolation;
import org.molgenis.data.validation.MolgenisValidationException;
import org.molgenis.file.FileStore;
import org.molgenis.file.model.FileMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppRepositoryDecorator
extends AbstractRepositoryDecorator<App> {
    private static final Logger LOG = LoggerFactory.getLogger(AppRepositoryDecorator.class);
    private final FileStore fileStore;

    public AppRepositoryDecorator(Repository<App> delegateRepository, FileStore fileStore) {
        super(delegateRepository);
        this.fileStore = Objects.requireNonNull(fileStore);
    }

    public void add(App app) {
        this.addApp(app);
        super.add((Entity)app);
    }

    public Integer add(Stream<App> appStream) {
        return super.add(appStream.filter(app -> {
            this.addApp((App)((Object)app));
            return true;
        }));
    }

    public void update(App app) {
        this.updateApp(app, (App)this.findOneById(app.getId()));
        super.update((Entity)app);
    }

    public void update(Stream<App> appStream) {
        super.update(appStream.filter(app -> {
            this.updateApp((App)((Object)app), (App)this.findOneById(app.getId()));
            return true;
        }));
    }

    public void delete(App app) {
        this.deleteApp(app);
        super.delete((Entity)app);
    }

    public void deleteById(Object id) {
        this.deleteApp((App)this.findOneById(id));
        super.deleteById(id);
    }

    public void deleteAll() {
        this.query().findAll().forEach(this::deleteApp);
        super.deleteAll();
    }

    public void delete(Stream<App> appStream) {
        super.delete(appStream.filter(app -> {
            this.deleteApp((App)((Object)app));
            return true;
        }));
    }

    public void deleteAll(Stream<Object> ids) {
        super.deleteAll(ids.filter(id -> {
            this.deleteApp((App)this.findOneById(id));
            return true;
        }));
    }

    private void addApp(App app) {
        this.validateResourceZip(app);
        if (app.isActive()) {
            this.activateApp(app);
        }
    }

    private void updateApp(App app, App existingApp) {
        FileMeta appSourceFiles = app.getSourceFiles();
        FileMeta existingAppSourceFiles = existingApp.getSourceFiles();
        if (appSourceFiles != null) {
            if (existingAppSourceFiles != null) {
                if (!appSourceFiles.getId().equals(existingAppSourceFiles.getId())) {
                    this.validateResourceZip(app);
                    if (existingApp.isActive()) {
                        this.deactivateApp(existingApp);
                    }
                    if (app.isActive()) {
                        this.activateApp(app);
                    }
                } else if (app.isActive() && !existingApp.isActive()) {
                    this.activateApp(app);
                } else if (!app.isActive() && existingApp.isActive()) {
                    this.deactivateApp(app);
                }
            } else {
                this.validateResourceZip(app);
                if (app.isActive()) {
                    this.activateApp(app);
                }
            }
        } else if (existingAppSourceFiles != null && existingApp.isActive()) {
            this.deactivateApp(existingApp);
        }
    }

    private void deleteApp(App app) {
        if (app.isActive()) {
            this.deactivateApp(app);
        }
    }

    private void activateApp(App app) {
        FileMeta appSourceArchive = app.getSourceFiles();
        if (appSourceArchive != null) {
            File fileStoreFile = this.fileStore.getFile(appSourceArchive.getId());
            if (fileStoreFile == null) {
                LOG.error("Source archive '{}' for app '{}' missing in file store", (Object)appSourceArchive.getId(), (Object)app.getName());
                throw new RuntimeException("An error occurred trying to activate app");
            }
            try {
                FileHeader fileHeader;
                ZipFile zipFile = new ZipFile(fileStoreFile);
                if (!app.getUseFreemarkerTemplate().booleanValue() && (fileHeader = zipFile.getFileHeader("index.html")) == null) {
                    LOG.error("Missing index.html in {} while option Use freemarker template as index.html was set 'No'", (Object)app.getName());
                    throw new RuntimeException(String.format("Missing index.html in %s while option 'Use freemarker template as index.html' was set 'No'", app.getName()));
                }
                zipFile.extractAll(this.fileStore.getStorageDir() + File.separatorChar + "apps" + File.separatorChar + app.getId() + File.separatorChar);
            }
            catch (ZipException e) {
                LOG.error("", (Throwable)e);
                throw new RuntimeException(String.format("An error occurred activating app '%s'", app.getName()));
            }
        }
    }

    private void deactivateApp(App app) {
        try {
            this.fileStore.deleteDirectory("apps" + File.separatorChar + app.getId());
        }
        catch (IOException e) {
            LOG.error("", (Throwable)e);
            throw new RuntimeException(String.format("An error occurred deactivating app '%s'", app.getName()));
        }
    }

    private void validateResourceZip(App app) {
        FileMeta appZipMeta = app.getSourceFiles();
        if (appZipMeta != null) {
            ZipFile zipFile;
            File fileStoreFile = this.fileStore.getFile(appZipMeta.getId());
            if (fileStoreFile == null) {
                LOG.error("Resource zip '{}' for app '{}' missing in file store", (Object)appZipMeta.getId(), (Object)app.getName());
                throw new RuntimeException("An error occurred trying to create or update app");
            }
            try {
                zipFile = new ZipFile(fileStoreFile);
            }
            catch (ZipException e) {
                LOG.error("Error creating zip file object", (Throwable)e);
                throw new RuntimeException("An error occurred trying to create or update app");
            }
            if (!zipFile.isValidZipFile()) {
                throw new MolgenisValidationException(new ConstraintViolation(String.format("'%s' is not a valid zip file.", appZipMeta.getFilename())));
            }
        }
    }
}

