/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.apps;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletResponse;
import org.molgenis.apps.AppInfoDto;
import org.molgenis.apps.AppsException;
import org.molgenis.apps.model.App;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.Query;
import org.molgenis.data.system.core.FreemarkerTemplate;
import org.molgenis.file.FileStore;
import org.molgenis.security.core.Permission;
import org.molgenis.security.core.PermissionService;
import org.molgenis.util.ErrorMessageResponse;
import org.molgenis.web.PluginController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/plugin/apps"})
public class AppsController
extends PluginController {
    private static final Logger LOG = LoggerFactory.getLogger(AppsController.class);
    public static final String ID = "apps";
    public static final String URI = "/plugin/apps";
    private static final String VIEW_NAME = "view-apps";
    private final DataService dataService;
    private final FileStore fileStore;
    private final PermissionService permissionService;

    public AppsController(DataService dataService, FileStore fileStore, PermissionService permissionService) {
        super(URI);
        this.dataService = Objects.requireNonNull(dataService);
        this.fileStore = Objects.requireNonNull(fileStore);
        this.permissionService = Objects.requireNonNull(permissionService);
    }

    @GetMapping
    public String init(Model model) {
        model.addAttribute("appEntityTypeId", (Object)"sys_App");
        model.addAttribute(ID, this.getApps().map(this::toAppInfoDto).collect(Collectors.toList()));
        return VIEW_NAME;
    }

    private Stream<App> getApps() {
        Query query = this.dataService.query("sys_App", App.class);
        query.sort().on("name");
        Stream<App> apps = query.findAll();
        if (!this.permissionService.hasPermissionOnEntityType("sys_App", Permission.WRITE)) {
            apps = apps.filter(App::isActive);
        }
        return apps;
    }

    @GetMapping(value={"/{appId}/**"})
    public String viewApp(@PathVariable(value="appId") String appId, Model model, HttpServletResponse response) {
        App app = (App)this.dataService.findOneById("sys_App", (Object)appId, App.class);
        if (app == null) {
            model.addAttribute("errorMessage", (Object)String.format("Unknown app '%s'", appId));
            response.setStatus(400);
            return "forward:/plugin/apps";
        }
        if (!app.isActive()) {
            model.addAttribute("errorMessage", (Object)String.format("App '%s' is deactivated", app.getName()));
            response.setStatus(400);
            return "forward:/plugin/apps";
        }
        model.addAttribute("app", (Object)this.toAppInfoDto(app));
        if (app.getUseFreemarkerTemplate().booleanValue()) {
            FreemarkerTemplate htmlTemplate = app.getHtmlTemplate();
            return htmlTemplate.getNameWithoutExtension();
        }
        return "redirect:/apps/" + app.getId() + "/index.html";
    }

    @Transactional
    @PostMapping(value={"/{appId}/activate"})
    @ResponseStatus(value=HttpStatus.OK)
    public void activateApp(@PathVariable(value="appId") String appId) {
        App app = (App)this.dataService.findOneById("sys_App", (Object)appId, App.class);
        if (app == null) {
            throw new AppsException(String.format("Unknown app '%s'", appId));
        }
        if (app.isActive()) {
            throw new AppsException(String.format("App '%s' already activated", app.getName()));
        }
        app.setActive(true);
        this.dataService.update("sys_App", (Entity)app);
    }

    @PostMapping(value={"/{appId}/deactivate"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deactivateApp(@PathVariable(value="appId") String appId, Model model) {
        App app = (App)this.dataService.findOneById("sys_App", (Object)appId, App.class);
        if (app == null) {
            throw new AppsException(String.format("Unknown app '%s'", appId));
        }
        if (!app.isActive()) {
            throw new AppsException(String.format("App '%s' already deactivated", app.getName()));
        }
        app.setActive(false);
        this.dataService.update("sys_App", (Entity)app);
    }

    private AppInfoDto toAppInfoDto(App app) {
        URI iconHref;
        String iconHrefStr = app.getIconHref();
        if (iconHrefStr != null) {
            try {
                iconHref = new URI(app.getIconHref());
            }
            catch (URISyntaxException e) {
                LOG.error("App icon href '{}' is not a valid URI", (Object)iconHrefStr);
                throw new RuntimeException("An error occurred while retrieving app");
            }
        } else {
            iconHref = null;
        }
        return AppInfoDto.builder().setId(app.getId()).setName(app.getName()).setDescription(app.getDescription()).setActive(app.isActive()).setIconHref(iconHref).build();
    }

    @ExceptionHandler(value={AppsException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ErrorMessageResponse handleAppsException(AppsException e) {
        LOG.warn("Apps exception occurred", (Throwable)e);
        return new ErrorMessageResponse(new ErrorMessageResponse.ErrorMessage(e.getMessage()));
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public ErrorMessageResponse handleRuntimeException(RuntimeException e) {
        LOG.error("Runtime exception occurred.", (Throwable)e);
        return new ErrorMessageResponse(new ErrorMessageResponse.ErrorMessage(e.getMessage()));
    }
}

