/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.bootstrap.populate;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Objects;
import org.molgenis.data.DataService;
import org.molgenis.data.DatabaseAction;
import org.molgenis.data.Entity;
import org.molgenis.data.FileRepositoryCollectionFactory;
import org.molgenis.data.RepositoryCollection;
import org.molgenis.data.i18n.model.LanguageFactory;
import org.molgenis.data.importer.ImportService;
import org.molgenis.data.importer.ImportServiceFactory;
import org.molgenis.data.support.FileRepositoryCollection;
import org.molgenis.file.FileStore;
import org.molgenis.security.core.runas.RunAsSystemProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class I18nPopulator {
    private static final Logger LOG = LoggerFactory.getLogger(I18nPopulator.class);
    private final DataService dataService;
    private final LanguageFactory languageFactory;
    private final FileRepositoryCollectionFactory fileRepositoryCollectionFactory;
    private final ImportServiceFactory importServiceFactory;
    private final FileStore fileStore;

    @Autowired
    public I18nPopulator(DataService dataService, LanguageFactory languageFactory, FileRepositoryCollectionFactory fileRepositoryCollectionFactory, ImportServiceFactory importServiceFactory, FileStore fileStore) {
        this.dataService = Objects.requireNonNull(dataService);
        this.languageFactory = Objects.requireNonNull(languageFactory);
        this.fileRepositoryCollectionFactory = Objects.requireNonNull(fileRepositoryCollectionFactory);
        this.importServiceFactory = Objects.requireNonNull(importServiceFactory);
        this.fileStore = Objects.requireNonNull(fileStore);
    }

    public void populateI18nStrings() {
        String i18nFileName = "i18n.xlsx";
        InputStream is = I18nPopulator.class.getClassLoader().getResourceAsStream("i18n.xlsx");
        try {
            File fileInTempDir = this.fileStore.store(is, "i18n.xlsx");
            LOG.trace("Create temp file for {} : {}", (Object)"i18n.xlsx", (Object)fileInTempDir);
            FileRepositoryCollection repoCollection = this.fileRepositoryCollectionFactory.createFileRepositoryCollection(fileInTempDir);
            ImportService importService = this.importServiceFactory.getImportService(fileInTempDir, (RepositoryCollection)repoCollection);
            RunAsSystemProxy.runAsSystem(() -> importService.doImport((RepositoryCollection)repoCollection, DatabaseAction.ADD_IGNORE_EXISTING, "base"));
            if (fileInTempDir.exists()) {
                LOG.trace("Delete temp file for {} : {}", (Object)"i18n.xlsx", (Object)fileInTempDir);
                fileInTempDir.delete();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void populateLanguages() {
        this.dataService.add("sys_Language", (Entity)this.languageFactory.create("en", "English", true));
        this.dataService.add("sys_Language", (Entity)this.languageFactory.create("nl", new Locale("nl").getDisplayName(new Locale("nl")), false));
        this.dataService.add("sys_Language", (Entity)this.languageFactory.create("pt", new Locale("pt").getDisplayName(new Locale("pt")), false));
        this.dataService.add("sys_Language", (Entity)this.languageFactory.create("es", new Locale("es").getDisplayName(new Locale("es")), false));
        this.dataService.add("sys_Language", (Entity)this.languageFactory.create("de", new Locale("de").getDisplayName(new Locale("de")), false));
        this.dataService.add("sys_Language", (Entity)this.languageFactory.create("it", new Locale("it").getDisplayName(new Locale("it")), false));
        this.dataService.add("sys_Language", (Entity)this.languageFactory.create("fr", new Locale("fr").getDisplayName(new Locale("fr")), false));
        this.dataService.add("sys_Language", (Entity)this.languageFactory.create("xx", "My language", false));
    }
}

