/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.bootstrap.populate;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.molgenis.bootstrap.populate.SystemEntityRegistry;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.meta.EntityTypeDependencyResolver;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.util.stream.MultimapCollectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class SystemEntityPopulator {
    private final DataService dataService;
    private final EntityTypeDependencyResolver entityTypeDependencyResolver;

    @Autowired
    public SystemEntityPopulator(DataService dataService, EntityTypeDependencyResolver entityTypeDependencyResolver) {
        this.dataService = Objects.requireNonNull(dataService);
        this.entityTypeDependencyResolver = Objects.requireNonNull(entityTypeDependencyResolver);
    }

    void populate(ContextRefreshedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        SystemEntityRegistry systemEntityRegistry = (SystemEntityRegistry)applicationContext.getBean(SystemEntityRegistry.class);
        if (systemEntityRegistry != null) {
            this.populate(systemEntityRegistry);
        }
    }

    private void populate(SystemEntityRegistry systemEntityRegistry) {
        Multimap entityByTypeMap = (Multimap)systemEntityRegistry.getEntities().stream().collect(MultimapCollectors.toArrayListMultimap(Entity::getEntityType, Function.identity()));
        List sortedEntityTypes = this.entityTypeDependencyResolver.resolve((Collection)entityByTypeMap.keySet());
        sortedEntityTypes.forEach(entityType -> this.persist((EntityType)entityType, entityByTypeMap.get(entityType)));
    }

    private void persist(EntityType entityType, Collection<Entity> entities) {
        this.dataService.add(entityType.getFullyQualifiedName(), entities.stream());
    }
}

