/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.bootstrap;

import java.util.Objects;
import org.molgenis.data.EntityFactoryRegistrar;
import org.molgenis.data.RepositoryCollectionBootstrapper;
import org.molgenis.data.SystemRepositoryDecoratorFactoryRegistrar;
import org.molgenis.data.importer.ImportServiceRegistrar;
import org.molgenis.data.meta.system.SystemEntityTypeRegistrar;
import org.molgenis.data.meta.system.SystemPackageRegistrar;
import org.molgenis.script.ScriptRunnerRegistrar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class RegistryBootstrapper {
    private static final Logger LOG = LoggerFactory.getLogger(RegistryBootstrapper.class);
    private final RepositoryCollectionBootstrapper repoCollectionBootstrapper;
    private final SystemEntityTypeRegistrar systemEntityTypeRegistrar;
    private final SystemPackageRegistrar systemPackageRegistrar;
    private final EntityFactoryRegistrar entityFactoryRegistrar;
    private final SystemRepositoryDecoratorFactoryRegistrar systemRepositoryDecoratorFactoryRegistrar;
    private final ImportServiceRegistrar importServiceRegistrar;
    private final ScriptRunnerRegistrar scriptRunnerRegistrar;

    @Autowired
    public RegistryBootstrapper(RepositoryCollectionBootstrapper repoCollectionBootstrapper, SystemEntityTypeRegistrar systemEntityTypeRegistrar, SystemPackageRegistrar systemPackageRegistrar, EntityFactoryRegistrar entityFactoryRegistrar, SystemRepositoryDecoratorFactoryRegistrar systemRepositoryDecoratorFactoryRegistrar, ImportServiceRegistrar importServiceRegistrar, ScriptRunnerRegistrar scriptRunnerRegistrar) {
        this.repoCollectionBootstrapper = Objects.requireNonNull(repoCollectionBootstrapper);
        this.systemEntityTypeRegistrar = Objects.requireNonNull(systemEntityTypeRegistrar);
        this.systemPackageRegistrar = Objects.requireNonNull(systemPackageRegistrar);
        this.entityFactoryRegistrar = Objects.requireNonNull(entityFactoryRegistrar);
        this.systemRepositoryDecoratorFactoryRegistrar = Objects.requireNonNull(systemRepositoryDecoratorFactoryRegistrar);
        this.importServiceRegistrar = Objects.requireNonNull(importServiceRegistrar);
        this.scriptRunnerRegistrar = Objects.requireNonNull(scriptRunnerRegistrar);
    }

    public void bootstrap(ContextRefreshedEvent event) {
        LOG.trace("Registering repository collections ...");
        this.repoCollectionBootstrapper.bootstrap(event, "PostgreSQL");
        LOG.trace("Registered repository collections");
        LOG.trace("Registering system entity types ...");
        this.systemEntityTypeRegistrar.register(event);
        LOG.trace("Registered system entity types");
        LOG.trace("Registering system packages ...");
        this.systemPackageRegistrar.register(event);
        LOG.trace("Registered system packages");
        LOG.trace("Registering entity factories ...");
        this.entityFactoryRegistrar.register(event);
        LOG.trace("Registered entity factories");
        LOG.trace("Registering repository decorator factories ...");
        this.systemRepositoryDecoratorFactoryRegistrar.register(event);
        LOG.trace("Registered entity factories");
        LOG.trace("Registering importers ...");
        this.importServiceRegistrar.register(event);
        LOG.trace("Registered importers");
        LOG.trace("Registering script runners ...");
        this.scriptRunnerRegistrar.register(event);
        LOG.trace("Registered script runners");
    }
}

