/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.bootstrap.populate;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.i18n.LocalizationService;
import org.molgenis.data.i18n.PropertiesMessageSource;
import org.molgenis.data.i18n.model.LanguageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class I18nPopulator {
    private static final Logger LOG = LoggerFactory.getLogger(I18nPopulator.class);
    private final DataService dataService;
    private final LanguageFactory languageFactory;
    private final List<PropertiesMessageSource> localizationMessageSources;
    private final LocalizationService localizationService;

    @Autowired
    public I18nPopulator(DataService dataService, LanguageFactory languageFactory, List<PropertiesMessageSource> localizationMessageSources, LocalizationService localizationService) {
        this.languageFactory = Objects.requireNonNull(languageFactory);
        this.dataService = Objects.requireNonNull(dataService);
        this.localizationMessageSources = Objects.requireNonNull(localizationMessageSources);
        this.localizationService = Objects.requireNonNull(localizationService);
    }

    public void populateL10nStrings() {
        this.localizationMessageSources.forEach(arg_0 -> ((LocalizationService)this.localizationService).populateLocalizationStrings(arg_0));
    }

    public void populateLanguages() {
        this.dataService.add("sys_Language", (Entity)this.languageFactory.create("en", "English", true));
        this.dataService.add("sys_Language", (Entity)this.languageFactory.create("nl", new Locale("nl").getDisplayName(new Locale("nl")), false));
        this.dataService.add("sys_Language", (Entity)this.languageFactory.create("pt", new Locale("pt").getDisplayName(new Locale("pt")), false));
        this.dataService.add("sys_Language", (Entity)this.languageFactory.create("es", new Locale("es").getDisplayName(new Locale("es")), false));
        this.dataService.add("sys_Language", (Entity)this.languageFactory.create("de", new Locale("de").getDisplayName(new Locale("de")), false));
        this.dataService.add("sys_Language", (Entity)this.languageFactory.create("it", new Locale("it").getDisplayName(new Locale("it")), false));
        this.dataService.add("sys_Language", (Entity)this.languageFactory.create("fr", new Locale("fr").getDisplayName(new Locale("fr")), false));
        this.dataService.add("sys_Language", (Entity)this.languageFactory.create("xx", "My language", false));
    }
}

