/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.bootstrap.populate;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.molgenis.auth.Group;
import org.molgenis.auth.GroupAuthority;
import org.molgenis.auth.GroupAuthorityFactory;
import org.molgenis.auth.GroupFactory;
import org.molgenis.auth.User;
import org.molgenis.auth.UserAuthority;
import org.molgenis.auth.UserAuthorityFactory;
import org.molgenis.auth.UserFactory;
import org.molgenis.bootstrap.populate.UsersGroupsAuthoritiesPopulator;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.security.core.runas.RunAsSystem;
import org.molgenis.security.core.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UsersGroupsAuthoritiesPopulatorImpl
implements UsersGroupsAuthoritiesPopulator {
    private static final String USERNAME_ADMIN = "admin";
    private final DataService dataService;
    private final UserFactory userFactory;
    private final GroupFactory groupFactory;
    private final UserAuthorityFactory userAuthorityFactory;
    private final GroupAuthorityFactory groupAuthorityFactory;
    @Value(value="${admin.password:@null}")
    private String adminPassword;
    @Value(value="${admin.email:molgenis+admin@gmail.com}")
    private String adminEmail;
    @Value(value="${anonymous.email:molgenis+anonymous@gmail.com}")
    private String anonymousEmail;

    @Autowired
    UsersGroupsAuthoritiesPopulatorImpl(DataService dataService, UserFactory userFactory, GroupFactory groupFactory, UserAuthorityFactory userAuthorityFactory, GroupAuthorityFactory groupAuthorityFactory) {
        this.dataService = Objects.requireNonNull(dataService);
        this.userFactory = Objects.requireNonNull(userFactory);
        this.groupFactory = Objects.requireNonNull(groupFactory);
        this.userAuthorityFactory = Objects.requireNonNull(userAuthorityFactory);
        this.groupAuthorityFactory = Objects.requireNonNull(groupAuthorityFactory);
    }

    @Override
    @Transactional
    @RunAsSystem
    public void populate() {
        if (this.adminPassword == null) {
            throw new RuntimeException("please configure the admin.password property in your molgenis-server.properties");
        }
        User userAdmin = (User)this.userFactory.create();
        userAdmin.setUsername(USERNAME_ADMIN);
        userAdmin.setPassword(this.adminPassword);
        userAdmin.setEmail(this.adminEmail);
        userAdmin.setActive(Boolean.valueOf(true));
        userAdmin.setSuperuser(Boolean.valueOf(true));
        userAdmin.setChangePassword(Boolean.valueOf(false));
        User anonymousUser = (User)this.userFactory.create();
        anonymousUser.setUsername("anonymous");
        anonymousUser.setPassword("anonymous");
        anonymousUser.setEmail(this.anonymousEmail);
        anonymousUser.setActive(Boolean.valueOf(true));
        anonymousUser.setSuperuser(Boolean.valueOf(false));
        anonymousUser.setChangePassword(Boolean.valueOf(false));
        UserAuthority anonymousAuthority = (UserAuthority)this.userAuthorityFactory.create();
        anonymousAuthority.setUser(anonymousUser);
        anonymousAuthority.setRole("ROLE_ANONYMOUS");
        Group allUsersGroup = (Group)this.groupFactory.create();
        allUsersGroup.setName("All Users");
        GroupAuthority usersGroupUserAccountAuthority = (GroupAuthority)this.groupAuthorityFactory.create();
        usersGroupUserAccountAuthority.setGroup(allUsersGroup);
        usersGroupUserAccountAuthority.setRole(SecurityUtils.AUTHORITY_PLUGIN_WRITE_PREFIX + "useraccount");
        List<String> entityTypeIds = Arrays.asList("sys_md_EntityType", "sys_md_Attribute", "sys_md_Package", "sys_md_Tag", "sys_Language", "sys_L10nString", "sys_FileMeta", "sys_sec_Owned");
        Stream<GroupAuthority> entityGroupAuthorities = entityTypeIds.stream().map(entityTypeId -> {
            GroupAuthority usersGroupAuthority = (GroupAuthority)this.groupAuthorityFactory.create();
            usersGroupAuthority.setGroup(allUsersGroup);
            usersGroupAuthority.setRole(SecurityUtils.AUTHORITY_ENTITY_READ_PREFIX + entityTypeId);
            return usersGroupAuthority;
        });
        this.dataService.add("sys_sec_User", Stream.of(userAdmin, anonymousUser));
        this.dataService.add("sys_sec_UserAuthority", (Entity)anonymousAuthority);
        this.dataService.add("sys_sec_Group", (Entity)allUsersGroup);
        this.dataService.add("sys_sec_GroupAuthority", Stream.concat(Stream.of(usersGroupUserAccountAuthority), entityGroupAuthorities));
    }
}

