/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.bootstrap.populate;

import java.util.Objects;
import org.molgenis.bootstrap.populate.GenomeBrowserAttributesPopulator;
import org.molgenis.bootstrap.populate.I18nPopulator;
import org.molgenis.bootstrap.populate.SystemEntityPopulator;
import org.molgenis.bootstrap.populate.UsersGroupsAuthoritiesPopulator;
import org.molgenis.data.DataService;
import org.molgenis.data.settings.SettingsPopulator;
import org.molgenis.script.ScriptTypePopulator;
import org.molgenis.web.bootstrap.PluginPopulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class RepositoryPopulator {
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryPopulator.class);
    private final DataService dataService;
    private final UsersGroupsAuthoritiesPopulator usersGroupsAuthoritiesPopulator;
    private final SystemEntityPopulator systemEntityPopulator;
    private final PluginPopulator pluginPopulator;
    private final SettingsPopulator settingsPopulator;
    private final I18nPopulator i18nPopulator;
    private final ScriptTypePopulator scriptTypePopulator;
    private final GenomeBrowserAttributesPopulator genomeBrowserAttributesPopulator;

    public RepositoryPopulator(DataService dataService, UsersGroupsAuthoritiesPopulator usersGroupsAuthoritiesPopulator, SystemEntityPopulator systemEntityPopulator, PluginPopulator pluginPopulator, SettingsPopulator settingsPopulator, I18nPopulator i18nPopulator, ScriptTypePopulator scriptTypePopulator, GenomeBrowserAttributesPopulator genomeBrowserAttributesPopulator) {
        this.dataService = Objects.requireNonNull(dataService);
        this.usersGroupsAuthoritiesPopulator = Objects.requireNonNull(usersGroupsAuthoritiesPopulator);
        this.systemEntityPopulator = Objects.requireNonNull(systemEntityPopulator);
        this.pluginPopulator = Objects.requireNonNull(pluginPopulator);
        this.settingsPopulator = Objects.requireNonNull(settingsPopulator);
        this.i18nPopulator = Objects.requireNonNull(i18nPopulator);
        this.scriptTypePopulator = Objects.requireNonNull(scriptTypePopulator);
        this.genomeBrowserAttributesPopulator = Objects.requireNonNull(genomeBrowserAttributesPopulator);
    }

    public void populate(ContextRefreshedEvent event) {
        if (!this.isDatabasePopulated()) {
            LOG.trace("Populating database with users, groups and authorities ...");
            this.usersGroupsAuthoritiesPopulator.populate();
            LOG.trace("Populated database with users, groups and authorities");
            LOG.trace("Populating database with I18N strings ...");
            this.i18nPopulator.populateLanguages();
            LOG.trace("Populated database with I18N strings");
            LOG.trace("Populating database with application entities ...");
            this.systemEntityPopulator.populate(event);
            LOG.trace("Populated database with application entities");
        }
        LOG.trace("Populating plugin entities ...");
        this.pluginPopulator.populate(event.getApplicationContext());
        LOG.trace("Populated plugin entities");
        LOG.trace("Populating settings entities ...");
        this.settingsPopulator.initialize(event);
        LOG.trace("Populated settings entities");
        LOG.trace("Populating default genome browser attributes ...");
        this.genomeBrowserAttributesPopulator.populate();
        LOG.trace("Populated default genome browser attributes");
        LOG.trace("Populating database with I18N strings ...");
        this.i18nPopulator.populateL10nStrings();
        LOG.trace("Populated database with I18N strings");
        LOG.trace("Populating script type entities ...");
        this.scriptTypePopulator.populate();
        LOG.trace("Populated script type entities");
    }

    private boolean isDatabasePopulated() {
        return this.dataService.count("sys_sec_User") > 0L;
    }
}

