/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.bootstrap.populate;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.i18n.LocalizationPopulator;
import org.molgenis.data.i18n.model.LanguageFactory;
import org.molgenis.i18n.PropertiesMessageSource;
import org.molgenis.i18n.properties.AllPropertiesMessageSource;
import org.springframework.stereotype.Component;

@Component
public class I18nPopulator {
    private final DataService dataService;
    private final LanguageFactory languageFactory;
    private final LocalizationPopulator localizationPopulator;
    private final List<PropertiesMessageSource> localizationMessageSources;

    public I18nPopulator(DataService dataService, LanguageFactory languageFactory, LocalizationPopulator localizationPopulator, List<PropertiesMessageSource> localizationMessageSources) {
        this.languageFactory = Objects.requireNonNull(languageFactory);
        this.dataService = Objects.requireNonNull(dataService);
        this.localizationPopulator = Objects.requireNonNull(localizationPopulator);
        this.localizationMessageSources = Objects.requireNonNull(localizationMessageSources);
    }

    public void populateL10nStrings() {
        AllPropertiesMessageSource allPropertiesMessageSource = new AllPropertiesMessageSource();
        String[] namespaces = (String[])this.localizationMessageSources.stream().map(PropertiesMessageSource::getNamespace).toArray(String[]::new);
        allPropertiesMessageSource.addMolgenisNamespaces(namespaces);
        this.localizationPopulator.populateLocalizationStrings(allPropertiesMessageSource);
    }

    public void populateLanguages() {
        this.dataService.add("sys_Language", (Entity)this.languageFactory.create("en", "English", true));
        this.dataService.add("sys_Language", (Entity)this.languageFactory.create("nl", new Locale("nl").getDisplayName(new Locale("nl")), false));
        this.dataService.add("sys_Language", (Entity)this.languageFactory.create("pt", new Locale("pt").getDisplayName(new Locale("pt")), false));
        this.dataService.add("sys_Language", (Entity)this.languageFactory.create("es", new Locale("es").getDisplayName(new Locale("es")), false));
        this.dataService.add("sys_Language", (Entity)this.languageFactory.create("de", new Locale("de").getDisplayName(new Locale("de")), false));
        this.dataService.add("sys_Language", (Entity)this.languageFactory.create("it", new Locale("it").getDisplayName(new Locale("it")), false));
        this.dataService.add("sys_Language", (Entity)this.languageFactory.create("fr", new Locale("fr").getDisplayName(new Locale("fr")), false));
        this.dataService.add("sys_Language", (Entity)this.languageFactory.create("xx", "My language", false));
    }
}

