/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.bootstrap;

import java.util.Objects;
import org.molgenis.bootstrap.RegistryBootstrapper;
import org.molgenis.bootstrap.populate.PermissionPopulator;
import org.molgenis.bootstrap.populate.RepositoryPopulator;
import org.molgenis.core.ui.style.BootstrapThemePopulator;
import org.molgenis.data.event.BootstrappingEventPublisher;
import org.molgenis.data.index.bootstrap.IndexBootstrapper;
import org.molgenis.data.migrate.bootstrap.MolgenisUpgradeBootstrapper;
import org.molgenis.data.platform.bootstrap.SystemEntityTypeBootstrapper;
import org.molgenis.data.postgresql.identifier.EntityTypeRegistryPopulator;
import org.molgenis.data.transaction.TransactionExceptionTranslatorRegistrar;
import org.molgenis.jobs.JobBootstrapper;
import org.molgenis.security.acl.DataSourceAclTablesPopulator;
import org.molgenis.security.core.runas.RunAsSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.PriorityOrdered;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
class MolgenisBootstrapper
implements ApplicationListener<ContextRefreshedEvent>,
PriorityOrdered {
    private static final Logger LOG = LoggerFactory.getLogger(MolgenisBootstrapper.class);
    private final MolgenisUpgradeBootstrapper upgradeBootstrapper;
    private final DataSourceAclTablesPopulator dataSourceAclTablesPopulator;
    private final TransactionExceptionTranslatorRegistrar transactionExceptionTranslatorRegistrar;
    private final RegistryBootstrapper registryBootstrapper;
    private final SystemEntityTypeBootstrapper systemEntityTypeBootstrapper;
    private final RepositoryPopulator repositoryPopulator;
    private final PermissionPopulator systemPermissionPopulator;
    private final JobBootstrapper jobBootstrapper;
    private final IndexBootstrapper indexBootstrapper;
    private final EntityTypeRegistryPopulator entityTypeRegistryPopulator;
    private final BootstrapThemePopulator bootstrapThemePopulator;
    private final BootstrappingEventPublisher bootstrappingEventPublisher;

    public MolgenisBootstrapper(MolgenisUpgradeBootstrapper upgradeBootstrapper, DataSourceAclTablesPopulator dataSourceAclTablesPopulator, TransactionExceptionTranslatorRegistrar transactionExceptionTranslatorRegistrar, RegistryBootstrapper registryBootstrapper, SystemEntityTypeBootstrapper systemEntityTypeBootstrapper, RepositoryPopulator repositoryPopulator, PermissionPopulator systemPermissionPopulator, JobBootstrapper jobBootstrapper, IndexBootstrapper indexBootstrapper, EntityTypeRegistryPopulator entityTypeRegistryPopulator, BootstrapThemePopulator bootstrapThemePopulator, BootstrappingEventPublisher bootstrappingEventPublisher) {
        this.upgradeBootstrapper = Objects.requireNonNull(upgradeBootstrapper);
        this.dataSourceAclTablesPopulator = Objects.requireNonNull(dataSourceAclTablesPopulator);
        this.transactionExceptionTranslatorRegistrar = transactionExceptionTranslatorRegistrar;
        this.registryBootstrapper = Objects.requireNonNull(registryBootstrapper);
        this.systemEntityTypeBootstrapper = Objects.requireNonNull(systemEntityTypeBootstrapper);
        this.repositoryPopulator = Objects.requireNonNull(repositoryPopulator);
        this.systemPermissionPopulator = Objects.requireNonNull(systemPermissionPopulator);
        this.jobBootstrapper = Objects.requireNonNull(jobBootstrapper);
        this.indexBootstrapper = Objects.requireNonNull(indexBootstrapper);
        this.entityTypeRegistryPopulator = Objects.requireNonNull(entityTypeRegistryPopulator);
        this.bootstrapThemePopulator = Objects.requireNonNull(bootstrapThemePopulator);
        this.bootstrappingEventPublisher = Objects.requireNonNull(bootstrappingEventPublisher);
    }

    @Transactional
    @RunAsSystem
    public void onApplicationEvent(ContextRefreshedEvent event) {
        LOG.info("Bootstrapping application ...");
        this.bootstrappingEventPublisher.publishBootstrappingStartedEvent();
        LOG.trace("Updating MOLGENIS ...");
        this.upgradeBootstrapper.bootstrap();
        LOG.debug("Updated MOLGENIS");
        LOG.trace("Populating data source with ACL tables ...");
        this.dataSourceAclTablesPopulator.populate();
        LOG.debug("Populated data source with ACL tables");
        LOG.trace("Bootstrapping transaction exception translators ...");
        this.transactionExceptionTranslatorRegistrar.register(event.getApplicationContext());
        LOG.debug("Bootstrapped transaction exception translators");
        LOG.trace("Bootstrapping registries ...");
        this.registryBootstrapper.bootstrap(event);
        LOG.debug("Bootstrapped registries");
        LOG.trace("Bootstrapping system entity meta data ...");
        this.systemEntityTypeBootstrapper.bootstrap(event);
        LOG.debug("Bootstrapped system entity meta data");
        LOG.trace("Populating repositories ...");
        boolean wasDatabasePopulated = this.repositoryPopulator.populate(event);
        LOG.debug("Populated repositories");
        if (!wasDatabasePopulated) {
            LOG.trace("Populating permissions ...");
            this.systemPermissionPopulator.populate(event.getApplicationContext());
            LOG.debug("Populated permissions");
        }
        LOG.trace("Bootstrapping jobs ...");
        this.jobBootstrapper.bootstrap();
        LOG.debug("Bootstrapped jobs");
        LOG.trace("Bootstrapping index ...");
        this.indexBootstrapper.bootstrap();
        LOG.debug("Bootstrapped index");
        LOG.trace("Populating entity type registry ...");
        this.entityTypeRegistryPopulator.populate();
        LOG.debug("Populated entity type registry");
        LOG.trace("Populating bootstrap themes ...");
        this.bootstrapThemePopulator.populate();
        LOG.debug("Populated bootstrap themes");
        this.bootstrappingEventPublisher.publishBootstrappingFinishedEvent();
        LOG.info("Bootstrapping application completed");
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

