/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.bootstrap.populate;

import java.util.Collection;
import java.util.Objects;
import org.molgenis.bootstrap.populate.PermissionRegistry;
import org.molgenis.security.core.PermissionService;
import org.molgenis.security.core.PermissionSet;
import org.molgenis.util.Pair;
import org.springframework.context.ApplicationContext;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.Sid;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class PermissionPopulator {
    private final PermissionService permissionService;

    public PermissionPopulator(PermissionService permissionService) {
        this.permissionService = Objects.requireNonNull(permissionService);
    }

    @Transactional
    public void populate(ApplicationContext applicationContext) {
        Collection registries = applicationContext.getBeansOfType(PermissionRegistry.class).values();
        registries.forEach(this::populate);
    }

    private void populate(PermissionRegistry systemPermissionRegistry) {
        systemPermissionRegistry.getPermissions().asMap().forEach(this::populate);
    }

    private void populate(ObjectIdentity objectIdentity, Collection<Pair<PermissionSet, Sid>> pairs) {
        pairs.forEach(pair -> this.permissionService.grant(objectIdentity, (PermissionSet)pair.getA(), (Sid)pair.getB()));
    }
}

