/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.bootstrap.populate;

import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import org.molgenis.bootstrap.populate.UsersRolesPopulator;
import org.molgenis.data.DataService;
import org.molgenis.data.security.auth.GroupService;
import org.molgenis.data.security.auth.Role;
import org.molgenis.data.security.auth.RoleFactory;
import org.molgenis.data.security.auth.User;
import org.molgenis.data.security.auth.UserFactory;
import org.molgenis.security.core.SidUtils;
import org.molgenis.security.core.runas.RunAsSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UsersRolesPopulatorImpl
implements UsersRolesPopulator {
    private static final Logger LOG = LoggerFactory.getLogger(UsersRolesPopulatorImpl.class);
    private static final String USERNAME_ADMIN = "admin";
    private final DataService dataService;
    private final UserFactory userFactory;
    private final RoleFactory roleFactory;
    @Value(value="${admin.password:@null}")
    private String adminPassword;
    @Value(value="${admin.email:molgenis+admin@gmail.com}")
    private String adminEmail;
    @Value(value="${anonymous.email:molgenis+anonymous@gmail.com}")
    private String anonymousEmail;

    UsersRolesPopulatorImpl(DataService dataService, UserFactory userFactory, RoleFactory roleFactory) {
        this.dataService = Objects.requireNonNull(dataService);
        this.userFactory = Objects.requireNonNull(userFactory);
        this.roleFactory = Objects.requireNonNull(roleFactory);
    }

    @Override
    @Transactional
    @RunAsSystem
    public void populate() {
        boolean changeAdminPassword = false;
        if (this.adminPassword == null) {
            this.adminPassword = UUID.randomUUID().toString();
            changeAdminPassword = true;
            LOG.info("Password for user 'admin': {}", (Object)this.adminPassword);
        }
        User userAdmin = (User)this.userFactory.create();
        userAdmin.setUsername(USERNAME_ADMIN);
        userAdmin.setPassword(this.adminPassword);
        userAdmin.setEmail(this.adminEmail);
        userAdmin.setActive(Boolean.valueOf(true));
        userAdmin.setSuperuser(Boolean.valueOf(true));
        userAdmin.setChangePassword(Boolean.valueOf(changeAdminPassword));
        User anonymousUser = (User)this.userFactory.create();
        anonymousUser.setUsername("anonymous");
        anonymousUser.setPassword("anonymous");
        anonymousUser.setEmail(this.anonymousEmail);
        anonymousUser.setActive(Boolean.valueOf(true));
        anonymousUser.setSuperuser(Boolean.valueOf(false));
        anonymousUser.setChangePassword(Boolean.valueOf(false));
        Role userRole = (Role)this.roleFactory.create();
        userRole.setName(SidUtils.getRoleName((String)"ROLE_USER"));
        userRole.setLabel("User");
        userRole.setLabel("en", "User");
        userRole.setLabel("nl", "Gebruiker");
        userRole.setDescription("All authenticated users are a member of this Role.");
        userRole.setDescription("en", "All authenticated users are a member of this role.");
        userRole.setDescription("nl", "Alle geauthenticeerde gebruikers hebben deze rol.");
        Role viewer = (Role)this.roleFactory.create();
        viewer.setName(SidUtils.getRoleName((String)GroupService.AUTHORITY_VIEWER));
        viewer.setLabel("Viewer");
        viewer.setDescription("Role containing permissions needed to view data. This role is included in all group viewer roles.");
        Role editor = (Role)this.roleFactory.create();
        editor.setName(SidUtils.getRoleName((String)GroupService.AUTHORITY_EDITOR));
        editor.setLabel("Editor");
        editor.setDescription("Role containing permissions needed to edit data. This role is included in all group editor roles.");
        editor.setIncludes((Iterable)ImmutableList.of((Object)viewer));
        Role manager = (Role)this.roleFactory.create();
        manager.setName(SidUtils.getRoleName((String)GroupService.AUTHORITY_MANAGER));
        manager.setLabel("Manager");
        manager.setDescription("Role containing permissions needed to manage groups. This role is included in all group manager roles.");
        manager.setIncludes((Iterable)ImmutableList.of((Object)editor));
        Role aclTakeOwnership = (Role)this.roleFactory.create();
        aclTakeOwnership.setName(SidUtils.getRoleName((String)"ROLE_ACL_TAKE_OWNERSHIP"));
        aclTakeOwnership.setLabel("Take resource ownership");
        aclTakeOwnership.setDescription("Role granting the permission to change resource ownership.");
        Role aclModifyAuditing = (Role)this.roleFactory.create();
        aclModifyAuditing.setName(SidUtils.getRoleName((String)"ROLE_ACL_MODIFY_AUDITING"));
        aclModifyAuditing.setLabel("Modify access control auditing");
        aclModifyAuditing.setDescription("Role granting the permission to modify auditing details.");
        Role aclGeneralChanges = (Role)this.roleFactory.create();
        aclGeneralChanges.setName(SidUtils.getRoleName((String)"ROLE_ACL_GENERAL_CHANGES"));
        aclGeneralChanges.setLabel("General access control changes");
        aclGeneralChanges.setDescription("Role granting the permission to make general access control list changes.");
        Role su = (Role)this.roleFactory.create();
        su.setName(SidUtils.getRoleName((String)"ROLE_SU"));
        su.setLabel("Superuser");
        su.setDescription("Role granted to superusers.");
        su.setIncludes((Iterable)ImmutableList.of((Object)aclTakeOwnership, (Object)aclModifyAuditing, (Object)aclGeneralChanges));
        this.dataService.add("sys_sec_User", Stream.of(userAdmin, anonymousUser));
        this.dataService.add("sys_sec_Role", Stream.of(userRole, aclTakeOwnership, aclModifyAuditing, aclGeneralChanges, viewer, editor, manager, su));
    }
}

