/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.bootstrap.populate;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.Objects;
import org.molgenis.bootstrap.populate.PermissionRegistry;
import org.molgenis.security.core.PermissionService;
import org.molgenis.security.core.PermissionSet;
import org.molgenis.util.Pair;
import org.springframework.context.ApplicationContext;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.Sid;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class PermissionPopulator {
    private final PermissionService permissionService;

    PermissionPopulator(PermissionService permissionService) {
        this.permissionService = Objects.requireNonNull(permissionService);
    }

    @Transactional
    public void populate(ApplicationContext applicationContext) {
        Collection registries = applicationContext.getBeansOfType(PermissionRegistry.class).values();
        registries.forEach(this::populate);
    }

    private void populate(PermissionRegistry systemPermissionRegistry) {
        Multimap<ObjectIdentity, Pair<PermissionSet, Sid>> systemPermissions = systemPermissionRegistry.getPermissions();
        Multimap newSystemPermissions = Multimaps.filterEntries(systemPermissions, entry -> entry != null && this.isNewPermission((ObjectIdentity)entry.getKey(), (Pair<PermissionSet, Sid>)((Pair)entry.getValue())));
        newSystemPermissions.asMap().forEach(this::populate);
    }

    private boolean isNewPermission(ObjectIdentity objectIdentity, Pair<PermissionSet, Sid> permission) {
        return !this.permissionService.exists(objectIdentity, (Sid)permission.getB());
    }

    private void populate(ObjectIdentity objectIdentity, Collection<Pair<PermissionSet, Sid>> pairs) {
        pairs.forEach(pair -> this.permissionService.grant(objectIdentity, (PermissionSet)pair.getA(), (Sid)pair.getB()));
    }
}

