/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.bootstrap;

import java.util.Objects;
import org.molgenis.data.EntityFactoryRegistrar;
import org.molgenis.data.RepositoryCollectionBootstrapper;
import org.molgenis.data.SystemRepositoryDecoratorFactoryRegistrar;
import org.molgenis.data.decorator.DynamicRepositoryDecoratorFactoryRegistrar;
import org.molgenis.data.importer.ImportServiceRegistrar;
import org.molgenis.data.meta.system.SystemEntityTypeRegistrar;
import org.molgenis.data.meta.system.SystemPackageRegistrar;
import org.molgenis.jobs.JobFactoryRegistrar;
import org.molgenis.script.core.ScriptRunnerRegistrar;
import org.molgenis.web.exception.ExceptionResponseGeneratorRegistrar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class RegistryBootstrapper {
    private static final Logger LOG = LoggerFactory.getLogger(RegistryBootstrapper.class);
    private final RepositoryCollectionBootstrapper repoCollectionBootstrapper;
    private final SystemEntityTypeRegistrar systemEntityTypeRegistrar;
    private final SystemPackageRegistrar systemPackageRegistrar;
    private final EntityFactoryRegistrar entityFactoryRegistrar;
    private final SystemRepositoryDecoratorFactoryRegistrar systemRepositoryDecoratorFactoryRegistrar;
    private final DynamicRepositoryDecoratorFactoryRegistrar dynamicRepositoryDecoratorFactoryRegistrar;
    private final ImportServiceRegistrar importServiceRegistrar;
    private final ScriptRunnerRegistrar scriptRunnerRegistrar;
    private final JobFactoryRegistrar jobFactoryRegistrar;
    private final ExceptionResponseGeneratorRegistrar exceptionResponseGeneratorRegistrar;

    public RegistryBootstrapper(RepositoryCollectionBootstrapper repoCollectionBootstrapper, SystemEntityTypeRegistrar systemEntityTypeRegistrar, SystemPackageRegistrar systemPackageRegistrar, EntityFactoryRegistrar entityFactoryRegistrar, SystemRepositoryDecoratorFactoryRegistrar systemRepositoryDecoratorFactoryRegistrar, DynamicRepositoryDecoratorFactoryRegistrar dynamicRepositoryDecoratorFactoryRegistrar, ImportServiceRegistrar importServiceRegistrar, ScriptRunnerRegistrar scriptRunnerRegistrar, JobFactoryRegistrar jobFactoryRegistrar, ExceptionResponseGeneratorRegistrar exceptionResponseGeneratorRegistrar) {
        this.repoCollectionBootstrapper = Objects.requireNonNull(repoCollectionBootstrapper);
        this.systemEntityTypeRegistrar = Objects.requireNonNull(systemEntityTypeRegistrar);
        this.systemPackageRegistrar = Objects.requireNonNull(systemPackageRegistrar);
        this.entityFactoryRegistrar = Objects.requireNonNull(entityFactoryRegistrar);
        this.systemRepositoryDecoratorFactoryRegistrar = Objects.requireNonNull(systemRepositoryDecoratorFactoryRegistrar);
        this.dynamicRepositoryDecoratorFactoryRegistrar = Objects.requireNonNull(dynamicRepositoryDecoratorFactoryRegistrar);
        this.importServiceRegistrar = Objects.requireNonNull(importServiceRegistrar);
        this.scriptRunnerRegistrar = Objects.requireNonNull(scriptRunnerRegistrar);
        this.jobFactoryRegistrar = Objects.requireNonNull(jobFactoryRegistrar);
        this.exceptionResponseGeneratorRegistrar = Objects.requireNonNull(exceptionResponseGeneratorRegistrar);
    }

    public void bootstrap(ContextRefreshedEvent event) {
        LOG.trace("Registering repository collections ...");
        this.repoCollectionBootstrapper.bootstrap(event, "PostgreSQL");
        LOG.trace("Registered repository collections");
        LOG.trace("Registering system entity types ...");
        this.systemEntityTypeRegistrar.register(event);
        LOG.trace("Registered system entity types");
        LOG.trace("Registering system packages ...");
        this.systemPackageRegistrar.register(event);
        LOG.trace("Registered system packages");
        LOG.trace("Registering entity factories ...");
        this.entityFactoryRegistrar.register(event);
        LOG.trace("Registered entity factories");
        LOG.trace("Registering repository decorator factories ...");
        this.systemRepositoryDecoratorFactoryRegistrar.register(event);
        LOG.trace("Registered repository decorator factories");
        LOG.trace("Registering dynamic decorator factories ...");
        this.dynamicRepositoryDecoratorFactoryRegistrar.register(event.getApplicationContext());
        LOG.trace("Registered dynamic repository decorator factories");
        LOG.trace("Registering importers ...");
        this.importServiceRegistrar.register(event);
        LOG.trace("Registered importers");
        LOG.trace("Registering script runners ...");
        this.scriptRunnerRegistrar.register(event);
        LOG.trace("Registered script runners");
        LOG.trace("Registering job factories ...");
        this.jobFactoryRegistrar.register(event);
        LOG.trace("Registered job factories");
        LOG.trace("Registering exception response generators ...");
        this.exceptionResponseGeneratorRegistrar.register(event.getApplicationContext());
        LOG.trace("Registered exception response generators");
    }
}

