/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.bootstrap;

import io.micrometer.core.annotation.Timed;
import java.util.Objects;
import org.molgenis.bootstrap.Bootstrapper;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.PriorityOrdered;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
class BootstrapperListener
implements ApplicationListener<ContextRefreshedEvent>,
PriorityOrdered {
    private final Bootstrapper bootstrapper;

    BootstrapperListener(Bootstrapper bootstrapper) {
        this.bootstrapper = Objects.requireNonNull(bootstrapper);
    }

    @Timed(value="bootstrap", description="Timing information for the bootstrapping event.")
    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext().getParent() != null) {
            return;
        }
        this.bootstrapper.bootstrap(event);
        SecurityContextHolder.clearContext();
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

