/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.bootstrap.populate;

import java.util.List;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.molgenis.data.DataService;
import org.molgenis.data.meta.model.Tag;
import org.molgenis.data.meta.model.TagFactory;
import org.molgenis.data.semantic.Relation;
import org.molgenis.data.semantic.Vocabulary;
import org.springframework.stereotype.Component;

@Component
public class TagPopulator {
    private final TagFactory tagFactory;
    private final DataService dataService;

    public TagPopulator(TagFactory tagFactory, DataService dataService) {
        this.tagFactory = tagFactory;
        this.dataService = dataService;
    }

    public void populate() {
        Tag isAToken = (Tag)this.tagFactory.create((Object)"token");
        isAToken.setLabel("Token");
        isAToken.setObjectIri(XMLSchema.TOKEN.toString());
        isAToken.setRelationIri(Relation.type.getIRI());
        isAToken.setRelationLabel(Relation.type.getLabel());
        Tag isCaseSensitive = (Tag)this.tagFactory.create((Object)"case-sensitive");
        isCaseSensitive.setLabel("Case Sensitive");
        isCaseSensitive.setObjectIri(Vocabulary.CASE_SENSITIVE.toString());
        isCaseSensitive.setRelationIri(Relation.type.getIRI());
        isCaseSensitive.setRelationLabel(Relation.type.getLabel());
        this.dataService.getRepository("sys_md_Tag", Tag.class).upsertBatch(List.of(isAToken, isCaseSensitive));
    }
}

