/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.charts.svg;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.log4j.Logger;
import org.molgenis.charts.charttypes.HeatMapChart;

public class SVGEditor {
    private static final Logger logger = Logger.getLogger(SVGEditor.class);
    XMLEventFactory eventFactory = XMLEventFactory.newInstance();
    static final String G = "g";
    static final String PATH = "path";
    static final QName ID = new QName("id");
    private File inFile;
    private File outFile;

    public SVGEditor(File inFile, File outFile) throws FileNotFoundException, XMLStreamException, FactoryConfigurationError {
        this.inFile = inFile;
        this.outFile = outFile;
    }

    private void annotateHeatMapBlock(int nRow, int nCol, String blockId, XMLEventWriter writer, XMLEventReader reader) throws XMLStreamException {
        int counter = 0;
        int nPath = nRow * nCol;
        int currentRow = nRow;
        int currentCol = 1;
        while (counter < nPath) {
            XMLEvent event = (XMLEvent)reader.next();
            if (event.isStartElement() && event.asStartElement().getName().getLocalPart().equals(PATH)) {
                Iterator<Attribute> attributes = event.asStartElement().getAttributes();
                StartElement newSe = this.eventFactory.createStartElement(new QName(PATH), attributes, null);
                writer.add(newSe);
                writer.add(this.eventFactory.createAttribute(ID, blockId));
                writer.add(this.eventFactory.createAttribute(new QName("row"), Integer.toString(currentRow)));
                writer.add(this.eventFactory.createAttribute(new QName("col"), Integer.toString(currentCol)));
                if (--currentRow == 0) {
                    currentRow = nRow;
                    ++currentCol;
                }
                ++counter;
                continue;
            }
            writer.add(event);
        }
    }

    public void annotateHeatMap(HeatMapChart chart) throws XMLStreamException, FactoryConfigurationError, FileNotFoundException {
        StartElement newSe;
        Iterator<Attribute> attributes;
        XMLEvent event;
        XMLEvent event2;
        XMLEventReader reader = XMLInputFactory.newInstance().createXMLEventReader(new FileInputStream(this.inFile));
        FileOutputStream os = new FileOutputStream(this.outFile);
        XMLEventWriter writer = XMLOutputFactory.newInstance().createXMLEventWriter(os);
        int nRow = chart.getData().getRowTargets().size();
        int nCol = chart.getData().getColumnTargets().size();
        int nRowAnnotations = 0;
        int nColAnnotations = 0;
        while (true) {
            StartElement se;
            if ((event2 = (XMLEvent)reader.next()).isStartElement() && (se = event2.asStartElement()).getName().getLocalPart().equals(G) && se.getAttributeByName(ID) != null) break;
            writer.add(event2);
        }
        logger.info((Object)"<g id=\"\"> reached");
        writer.add(event2);
        if (nRowAnnotations > 0) {
            logger.info((Object)("parsing " + nRowAnnotations + " row annotations"));
            this.annotateHeatMapBlock(nRow, nRowAnnotations, "rowAnnotation", writer, reader);
        }
        if (nColAnnotations > 0) {
            logger.info((Object)("parsing " + nColAnnotations + " col annotations"));
            this.annotateHeatMapBlock(nColAnnotations, nCol, "colAnnotatation", writer, reader);
        }
        logger.info((Object)("parsing " + nRow * nCol + " matrix values"));
        this.annotateHeatMapBlock(nRow, nCol, "matrix", writer, reader);
        logger.info((Object)("parsing " + nCol + " column names"));
        int counter = 0;
        while (counter < nCol) {
            event = (XMLEvent)reader.next();
            if (event.isStartElement() && event.asStartElement().getName().getLocalPart().equals(G)) {
                attributes = event.asStartElement().getAttributes();
                newSe = this.eventFactory.createStartElement(new QName(G), attributes, null);
                writer.add(newSe);
                writer.add(this.eventFactory.createAttribute(ID, "colName"));
                writer.add(this.eventFactory.createAttribute(new QName("col"), Integer.toString(counter + 1)));
                ++counter;
                continue;
            }
            writer.add(event);
        }
        logger.info((Object)("parsing " + nRow + " row names"));
        counter = 0;
        while (counter < nRow) {
            event = (XMLEvent)reader.next();
            if (event.isStartElement() && event.asStartElement().getName().getLocalPart().equals(G)) {
                attributes = event.asStartElement().getAttributes();
                newSe = this.eventFactory.createStartElement(new QName(G), attributes, null);
                writer.add(newSe);
                writer.add(this.eventFactory.createAttribute(ID, "rowName"));
                writer.add(this.eventFactory.createAttribute(new QName("row"), Integer.toString(nRow - counter)));
                ++counter;
                continue;
            }
            writer.add(event);
        }
        while (reader.hasNext()) {
            event = (XMLEvent)reader.next();
            if (event.isEndElement() && event.asEndElement().getName().getLocalPart().equals(new QName("svg"))) {
                EndElement newEe = this.eventFactory.createEndElement(new QName(G), null);
                writer.add(newEe);
            }
            writer.add(event);
        }
        writer.close();
    }
}

