/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.charts.highcharts.convert;

import java.util.Arrays;
import org.molgenis.charts.AbstractChart;
import org.molgenis.charts.AbstractChartVisualizationService;
import org.molgenis.charts.BoxPlotChart;
import org.molgenis.charts.MolgenisAxisType;
import org.molgenis.charts.XYDataChart;
import org.molgenis.charts.highcharts.basic.AxisAlign;
import org.molgenis.charts.highcharts.basic.AxisTitle;
import org.molgenis.charts.highcharts.basic.AxisType;
import org.molgenis.charts.highcharts.basic.BasicChart;
import org.molgenis.charts.highcharts.basic.ChartAlign;
import org.molgenis.charts.highcharts.basic.ChartConstructorType;
import org.molgenis.charts.highcharts.basic.ChartTitle;
import org.molgenis.charts.highcharts.basic.ChartType;
import org.molgenis.charts.highcharts.basic.Credits;
import org.molgenis.charts.highcharts.basic.Legend;
import org.molgenis.charts.highcharts.basic.Options;
import org.molgenis.charts.highcharts.basic.XAxis;
import org.molgenis.charts.highcharts.basic.YAxis;
import org.molgenis.charts.highcharts.chart.Chart;
import org.molgenis.charts.highcharts.convert.HighchartSeriesUtil;
import org.molgenis.charts.highcharts.stockchart.StockChart;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.ui.Model;

@Component
public class HighchartService
extends AbstractChartVisualizationService {
    @Autowired
    private HighchartSeriesUtil highchartSeriesUtil;

    public HighchartService() {
        super(Arrays.asList(AbstractChart.MolgenisChartType.LINE_CHART, AbstractChart.MolgenisChartType.SCATTER_CHART, AbstractChart.MolgenisChartType.BOXPLOT_CHART));
    }

    @Override
    public Object renderChartInternal(AbstractChart chart, Model model) {
        if (AbstractChart.MolgenisChartType.SCATTER_CHART.equals((Object)chart.getType())) {
            return this.createScatterChart((XYDataChart)chart);
        }
        if (AbstractChart.MolgenisChartType.BOXPLOT_CHART.equals((Object)chart.getType())) {
            return this.createBoxPlotChart((BoxPlotChart)chart);
        }
        return null;
    }

    public Options createScatterChart(XYDataChart scatterChart) {
        ChartConstructorType chartConstructorType = MolgenisAxisType.DATETIME.equals((Object)scatterChart.getxAxisType()) ? ChartConstructorType.STOCKCHART : ChartConstructorType.CHART;
        return this.createXYDataChart(scatterChart, chartConstructorType);
    }

    protected Options createBoxPlotChart(BoxPlotChart boxPlotChart) {
        Options options = new Options();
        Chart chart = new Chart();
        chart.setType(ChartType.BOXPLOT).setWidth(boxPlotChart.getWidth()).setHeight(boxPlotChart.getHeight());
        XAxis xAxis = new XAxis();
        xAxis.setCategories(boxPlotChart.getCategories());
        xAxis.setTitle(new AxisTitle().setText(boxPlotChart.getxLabel()));
        YAxis yAxis = new YAxis();
        yAxis.setTitle(new AxisTitle().setText(boxPlotChart.getyLabel()));
        ChartTitle title = new ChartTitle().setText(boxPlotChart.getTitle()).setAlign(ChartAlign.CENTER);
        Legend legend = new Legend().setEnabled(true).setAlign("center").setLayout("horizontal").setVerticalAlign("bottom");
        options.setChart(chart);
        options.setTitle(title);
        options.addxAxis(xAxis);
        options.addyAxis(yAxis);
        options.setCredits(new Credits());
        options.setLegend(legend);
        options.addSeries(this.highchartSeriesUtil.parseToBoxPlotSeriesList(boxPlotChart.getBoxPlotSeries()));
        options.addSeries(this.highchartSeriesUtil.parseToXYDataSeriesList(boxPlotChart.getxYDataSeries()));
        return options;
    }

    protected Options createXYDataChart(XYDataChart xYDataChart, ChartConstructorType chartConstructorType) {
        Options options = new Options();
        BasicChart chart = ChartConstructorType.CHART.equals((Object)chartConstructorType) ? new Chart() : new StockChart();
        chart.setType(ChartType.getChartType(xYDataChart.getType())).setWidth(xYDataChart.getWidth()).setHeight(xYDataChart.getHeight());
        XAxis xAxis = new XAxis();
        xAxis.setTitle(new AxisTitle().setText(xYDataChart.getxAxisLabel()).setAlign(AxisAlign.MIDDLE)).setType(AxisType.valueOf(xYDataChart.getxAxisType().name())).setOrdinal(false);
        YAxis yAxis = new YAxis();
        yAxis.setTitle(new AxisTitle().setText(xYDataChart.getyAxisLabel()).setAlign(AxisAlign.MIDDLE)).setType(AxisType.valueOf(xYDataChart.getyAxisType().name()));
        ChartTitle title = new ChartTitle().setText(xYDataChart.getTitle()).setAlign(ChartAlign.CENTER);
        Legend legend = new Legend().setEnabled(true).setAlign("center").setLayout("horizontal").setVerticalAlign("bottom");
        options.setChart(chart);
        options.setTitle(title);
        options.addxAxis(xAxis);
        options.addyAxis(yAxis);
        options.setCredits(new Credits());
        options.setLegend(legend);
        options.setSeries(this.highchartSeriesUtil.parseToXYDataSeriesList(xYDataChart.getData()));
        return options;
    }
}

