/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.charts.data;

import java.util.Collections;
import java.util.List;
import org.molgenis.charts.data.Target;

public class DataMatrix {
    private final List<Target> columnTargets;
    private final List<Target> rowTargets;
    private final List<List<Number>> values;

    public DataMatrix(List<Target> columnTargets, List<Target> rowTargets, List<List<Number>> values) {
        if (columnTargets.size() != values.get(0).size()) {
            throw new IllegalArgumentException("Nr columnTargets not the same as the nr of columns of the values");
        }
        if (rowTargets.size() != values.size()) {
            throw new IllegalArgumentException("Nr rowTargets not the same as the nr of rows of the values");
        }
        for (int i = 0; i < columnTargets.size(); ++i) {
            if (values.get(i).size() == values.get(0).size()) continue;
            throw new IllegalArgumentException("Row [" + i + "] has a different length");
        }
        this.columnTargets = columnTargets;
        this.rowTargets = rowTargets;
        this.values = values;
    }

    public List<Target> getColumnTargets() {
        return Collections.unmodifiableList(this.columnTargets);
    }

    public List<Target> getRowTargets() {
        return Collections.unmodifiableList(this.rowTargets);
    }

    public List<List<Number>> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnTargets == null ? 0 : this.columnTargets.hashCode());
        result = 31 * result + (this.rowTargets == null ? 0 : this.rowTargets.hashCode());
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataMatrix other = (DataMatrix)obj;
        if (this.columnTargets == null ? other.columnTargets != null : !this.columnTargets.equals(other.columnTargets)) {
            return false;
        }
        if (this.rowTargets == null ? other.rowTargets != null : !this.rowTargets.equals(other.rowTargets)) {
            return false;
        }
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }

    public String toString() {
        return "DataMatrix [columnTargets=" + this.columnTargets + ", rowTargets=" + this.rowTargets + ", values=" + this.values + "]";
    }
}

