/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.charts.r;

import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.molgenis.charts.AbstractChart;
import org.molgenis.charts.AbstractChartVisualizationService;
import org.molgenis.charts.MolgenisChartException;
import org.molgenis.charts.charttypes.HeatMapChart;
import org.molgenis.charts.svg.SVGEditor;
import org.molgenis.r.ROutputHandler;
import org.molgenis.r.RScriptRunner;
import org.molgenis.r.StringROutputHandler;
import org.molgenis.util.FileStore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.ui.Model;

@Component
public class RChartService
extends AbstractChartVisualizationService {
    private static final Logger logger = Logger.getLogger(RChartService.class);
    private final FileStore fileStore;
    private RScriptRunner rScriptRunner;

    @Autowired
    public RChartService(FileStore fileStore, RScriptRunner rScriptRunner) {
        super(Arrays.asList(AbstractChart.MolgenisChartType.HEAT_MAP));
        if (fileStore == null) {
            throw new IllegalArgumentException("fileStore is null");
        }
        if (rScriptRunner == null) {
            throw new IllegalArgumentException("rScriptRunner is null");
        }
        this.fileStore = fileStore;
    }

    @Override
    protected Object renderChartInternal(AbstractChart chart, Model model) {
        String chartFileName;
        HeatMapChart heatMapChart = (HeatMapChart)chart;
        try {
            chartFileName = this.renderHeatMap(heatMapChart);
        }
        catch (Exception e) {
            throw new MolgenisChartException(e);
        }
        model.addAttribute("fileName", (Object)chartFileName);
        model.addAttribute("nRow", (Object)heatMapChart.getData().getRowTargets().size());
        model.addAttribute("nCol", (Object)heatMapChart.getData().getColumnTargets().size());
        return "heatmap";
    }

    private String renderHeatMap(HeatMapChart chart) throws IOException, TemplateException, XMLStreamException, FactoryConfigurationError {
        String fileName = UUID.randomUUID().toString();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("chart", chart);
        data.put("nRow", chart.getData().getRowTargets().size());
        data.put("nCol", chart.getData().getColumnTargets().size());
        data.put("wd", this.fileStore.getStorageDir());
        data.put("fileName", fileName);
        StringROutputHandler outputHandler = new StringROutputHandler();
        this.rScriptRunner.runRScript(fileName + ".r", "R_heatmap.ftl", data, (ROutputHandler)outputHandler);
        logger.info((Object)("R output:" + outputHandler.toString()));
        File in = this.fileStore.getFile(fileName + ".svg");
        File out = new File(this.fileStore.getStorageDir() + "/" + fileName + "_annotated.svg");
        SVGEditor svge = new SVGEditor(in, out);
        svge.annotateHeatMap(chart);
        return fileName;
    }
}

