/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.charts.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.charts.BoxPlotChart;
import org.molgenis.charts.ChartDataService;
import org.molgenis.charts.MolgenisAxisType;
import org.molgenis.charts.MolgenisChartException;
import org.molgenis.charts.MolgenisSerieType;
import org.molgenis.charts.XYDataChart;
import org.molgenis.charts.calculations.BoxPlotCalcUtil;
import org.molgenis.charts.data.BoxPlotSerie;
import org.molgenis.charts.data.DataMatrix;
import org.molgenis.charts.data.Target;
import org.molgenis.charts.data.XYData;
import org.molgenis.charts.data.XYDataSerie;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.Query;
import org.molgenis.data.QueryRule;
import org.molgenis.data.Repository;
import org.molgenis.data.Sort;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.support.QueryImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ChartDataServiceImpl
implements ChartDataService {
    private final DataService dataService;

    @Autowired
    public ChartDataServiceImpl(DataService dataService) {
        if (dataService == null) {
            throw new IllegalArgumentException("dataService is null");
        }
        this.dataService = dataService;
    }

    @Override
    public XYDataChart getXYDataChart(String entityName, String attributeNameXaxis, String attributeNameYaxis, String split, List<QueryRule> queryRules) {
        Repository repo = this.dataService.getRepository(entityName);
        EntityType entityType = repo.getEntityType();
        AttributeType attributeXFieldTypeEnum = entityType.getAttribute(attributeNameXaxis).getDataType();
        AttributeType attributeYFieldTypeEnum = entityType.getAttribute(attributeNameYaxis).getDataType();
        if (AttributeType.DECIMAL.equals((Object)attributeXFieldTypeEnum) || AttributeType.INT.equals((Object)attributeXFieldTypeEnum) || AttributeType.LONG.equals((Object)attributeXFieldTypeEnum) || AttributeType.DATE.equals((Object)attributeXFieldTypeEnum) || AttributeType.DATE_TIME.equals((Object)attributeXFieldTypeEnum) || AttributeType.DECIMAL.equals((Object)attributeYFieldTypeEnum) || AttributeType.INT.equals((Object)attributeYFieldTypeEnum) || AttributeType.LONG.equals((Object)attributeYFieldTypeEnum) || AttributeType.DATE.equals((Object)attributeYFieldTypeEnum) || AttributeType.DATE_TIME.equals((Object)attributeYFieldTypeEnum)) {
            List<XYDataSerie> xYDataSeries = !StringUtils.isNotBlank((CharSequence)split) ? Arrays.asList(this.getXYDataSerie((Repository<Entity>)repo, entityName, attributeNameXaxis, attributeNameYaxis, attributeXFieldTypeEnum, attributeYFieldTypeEnum, queryRules)) : this.getXYDataSeries((Repository<Entity>)repo, entityName, attributeNameXaxis, attributeNameYaxis, attributeXFieldTypeEnum, attributeYFieldTypeEnum, split, queryRules);
            return new XYDataChart(xYDataSeries, MolgenisAxisType.getType(attributeXFieldTypeEnum), MolgenisAxisType.getType(attributeYFieldTypeEnum));
        }
        throw new MolgenisChartException("For the x and the y axis selected datatype are wrong. Scatterplots can only handle Continuous data");
    }

    @Override
    public XYDataSerie getXYDataSerie(Repository<Entity> repo, String entityName, String attributeNameXaxis, String attributeNameYaxis, AttributeType attributeXFieldTypeEnum, AttributeType attributeYFieldTypeEnum, List<QueryRule> queryRules) {
        EntityType entityType = repo.getEntityType();
        XYDataSerie serie = new XYDataSerie();
        serie.setName(entityType.getAttribute(attributeNameXaxis).getLabel() + " vs " + entityType.getAttribute(attributeNameYaxis).getLabel());
        serie.setAttributeXFieldTypeEnum(attributeXFieldTypeEnum);
        serie.setAttributeYFieldTypeEnum(attributeYFieldTypeEnum);
        Sort sort = new Sort().on(attributeNameXaxis).on(attributeNameYaxis);
        Iterable<Entity> iterable = this.getIterable(entityName, repo, queryRules, sort);
        for (Entity entity : iterable) {
            Object x = this.getJavaValue(entity, attributeNameXaxis, attributeXFieldTypeEnum);
            Object y = this.getJavaValue(entity, attributeNameYaxis, attributeYFieldTypeEnum);
            serie.addData(new XYData(x, y));
        }
        return serie;
    }

    @Override
    public List<XYDataSerie> getXYDataSeries(Repository<Entity> repo, String entityName, String attributeNameXaxis, String attributeNameYaxis, AttributeType attributeXFieldTypeEnum, AttributeType attributeYFieldTypeEnum, String split, List<QueryRule> queryRules) {
        Sort sort = new Sort().on(attributeNameXaxis).on(attributeNameYaxis);
        Iterable<Entity> iterable = this.getIterable(entityName, repo, queryRules, sort);
        HashMap<String, XYDataSerie> xYDataSeriesMap = new HashMap<String, XYDataSerie>();
        for (Entity entity : iterable) {
            String splitValue = this.createSplitKey(entity, split);
            if (!xYDataSeriesMap.containsKey(splitValue)) {
                XYDataSerie serie = new XYDataSerie();
                serie.setName(splitValue);
                serie.setAttributeXFieldTypeEnum(attributeXFieldTypeEnum);
                serie.setAttributeYFieldTypeEnum(attributeYFieldTypeEnum);
                xYDataSeriesMap.put(splitValue, serie);
            }
            Object x = this.getJavaValue(entity, attributeNameXaxis, attributeXFieldTypeEnum);
            Object y = this.getJavaValue(entity, attributeNameYaxis, attributeYFieldTypeEnum);
            ((XYDataSerie)xYDataSeriesMap.get(splitValue)).addData(new XYData(x, y));
        }
        ArrayList<XYDataSerie> series = new ArrayList<XYDataSerie>();
        for (Map.Entry serie : xYDataSeriesMap.entrySet()) {
            series.add((XYDataSerie)serie.getValue());
        }
        return series;
    }

    private String getValueAsString(Entity entity, String split) {
        Object o = entity.get(split);
        if (o instanceof Entity) {
            Object labelValue = ((Entity)o).getLabelValue();
            return labelValue != null ? labelValue.toString() : null;
        }
        if (o instanceof List) {
            Iterable refObjects = (Iterable)o;
            StringBuilder strBuilder = new StringBuilder();
            for (Object ob : refObjects) {
                if (strBuilder.length() > 0) {
                    strBuilder.append(',');
                }
                if (ob instanceof Entity) {
                    Object labelValue = ((Entity)ob).getLabelValue();
                    strBuilder.append(labelValue != null ? labelValue.toString() : null);
                    continue;
                }
                strBuilder.append(ob.toString());
            }
            return strBuilder.toString();
        }
        return "" + o;
    }

    public String createSplitKey(Entity entity, String split) {
        return split + '(' + this.getValueAsString(entity, split) + ')';
    }

    @Override
    public BoxPlotChart getBoxPlotChart(String entityName, String attributeName, List<QueryRule> queryRules, String split, double scaleToCalcOutliers) {
        Repository repo = this.dataService.getRepository(entityName);
        EntityType entityType = repo.getEntityType();
        BoxPlotChart boxPlotChart = new BoxPlotChart();
        boxPlotChart.setyLabel(entityType.getAttribute(attributeName).getLabel());
        Sort sort = new Sort().on(attributeName);
        Iterable<Entity> iterable = this.getIterable(entityName, (Repository<Entity>)repo, queryRules, sort);
        Map<String, List<Double>> boxPlotDataListMap = this.getBoxPlotDataListMap(entityType, iterable, attributeName, split);
        BoxPlotSerie boxPlotSerie = new BoxPlotSerie();
        boxPlotSerie.setType(MolgenisSerieType.BOXPLOT);
        boxPlotSerie.setName("Boxplot");
        XYDataSerie xYDataSerie = new XYDataSerie();
        xYDataSerie.setType(MolgenisSerieType.SCATTER);
        xYDataSerie.setName("Outliers");
        ArrayList<String> categories = new ArrayList<String>();
        int count = 0;
        for (Map.Entry<String, List<Double>> entry : boxPlotDataListMap.entrySet()) {
            List<Double> list = entry.getValue();
            categories.add(entry.getKey());
            Double[] data = BoxPlotCalcUtil.calcBoxPlotValues(entry.getValue());
            double iqr = BoxPlotCalcUtil.iqr(data[3], data[1]);
            double step = iqr * scaleToCalcOutliers;
            double highBorder = step + data[3];
            double lowBorder = data[1] - step;
            ArrayList<XYData> outlierList = new ArrayList<XYData>();
            ArrayList<Double> normalList = new ArrayList<Double>();
            for (Double o : list) {
                if (null == o) continue;
                if (o < lowBorder || o > highBorder) {
                    outlierList.add(new XYData(count, o));
                    continue;
                }
                normalList.add(o);
            }
            xYDataSerie.addData(outlierList);
            data = BoxPlotCalcUtil.calcBoxPlotValues(normalList);
            boxPlotSerie.addData(data);
            ++count;
        }
        boxPlotChart.addBoxPlotSerie(boxPlotSerie);
        boxPlotChart.addXYDataSerie(xYDataSerie);
        boxPlotChart.setCategories(categories);
        return boxPlotChart;
    }

    private Map<String, List<Double>> getBoxPlotDataListMap(EntityType entityType, Iterable<Entity> iterable, String attributeName, String split) {
        HashMap<String, List<Double>> boxPlotDataListMap = new HashMap<String, List<Double>>();
        boolean splitList = StringUtils.isNotBlank((CharSequence)split);
        if (splitList) {
            for (Entity entity : iterable) {
                String key = this.createSplitKey(entity, split);
                if (!boxPlotDataListMap.containsKey(key)) {
                    boxPlotDataListMap.put(key, new ArrayList());
                }
                ((List)boxPlotDataListMap.get(key)).add(entity.getDouble(attributeName));
            }
        } else {
            String key = entityType.getAttribute(attributeName).getLabel();
            ArrayList<Double> list = new ArrayList<Double>();
            for (Entity entity : iterable) {
                list.add(entity.getDouble(attributeName));
            }
            boxPlotDataListMap.put(key, list);
        }
        return boxPlotDataListMap;
    }

    private Iterable<Entity> getIterable(String entityName, final Repository<Entity> repo, List<QueryRule> queryRules, Sort sort) {
        QueryImpl q = queryRules == null ? new QueryImpl() : new QueryImpl(queryRules);
        if (null != sort) {
            q.sort(sort);
        }
        return new Iterable<Entity>((Query)q){
            final /* synthetic */ Query val$q;
            {
                this.val$q = query;
            }

            @Override
            public Iterator<Entity> iterator() {
                return repo.findAll(this.val$q).iterator();
            }
        };
    }

    private Object getJavaValue(Entity entity, String attributeName, AttributeType attributeFieldTypeEnum) {
        if (AttributeType.DECIMAL.equals((Object)attributeFieldTypeEnum)) {
            return entity.getDouble(attributeName);
        }
        if (AttributeType.INT.equals((Object)attributeFieldTypeEnum)) {
            return entity.getInt(attributeName);
        }
        if (AttributeType.LONG.equals((Object)attributeFieldTypeEnum)) {
            return entity.getLong(attributeName);
        }
        if (AttributeType.DATE_TIME.equals((Object)attributeFieldTypeEnum)) {
            return entity.getUtilDate(attributeName);
        }
        if (AttributeType.DATE.equals((Object)attributeFieldTypeEnum)) {
            return entity.getDate(attributeName);
        }
        return entity.getString(attributeName);
    }

    @Override
    public DataMatrix getDataMatrix(String entityName, List<String> attributeNamesXaxis, String attributeNameYaxis, List<QueryRule> queryRules) {
        Object iterable = this.dataService.getRepository(entityName);
        if (queryRules != null && !queryRules.isEmpty()) {
            QueryImpl q = new QueryImpl();
            for (QueryRule queryRule : queryRules) {
                q.addRule(queryRule);
            }
            Repository AllEntitiesIterable = iterable;
            iterable = new Iterable<Entity>((Iterable)AllEntitiesIterable, q){
                final /* synthetic */ Iterable val$AllEntitiesIterable;
                final /* synthetic */ QueryImpl val$q;
                {
                    this.val$AllEntitiesIterable = iterable;
                    this.val$q = queryImpl;
                }

                @Override
                public Iterator<Entity> iterator() {
                    return ((Repository)this.val$AllEntitiesIterable).findAll((Query)this.val$q).iterator();
                }
            };
        }
        ArrayList<Target> rowTargets = new ArrayList<Target>();
        ArrayList<Target> columnTargets = new ArrayList<Target>();
        ArrayList<List<Number>> values = new ArrayList<List<Number>>();
        for (String columnTargetName : attributeNamesXaxis) {
            columnTargets.add(new Target(columnTargetName));
        }
        for (Entity entity : iterable) {
            String rowTargetName = entity.getString(attributeNameYaxis) != null ? entity.getString(attributeNameYaxis) : "";
            rowTargets.add(new Target(rowTargetName));
            ArrayList<Double> rowValues = new ArrayList<Double>();
            for (String attr : attributeNamesXaxis) {
                rowValues.add(entity.getDouble(attr));
            }
            values.add(rowValues);
        }
        return new DataMatrix(columnTargets, rowTargets, values);
    }
}

