/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.charts.highcharts.convert;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.molgenis.charts.MolgenisSerieType;
import org.molgenis.charts.data.BoxPlotSerie;
import org.molgenis.charts.data.XYData;
import org.molgenis.charts.data.XYDataSerie;
import org.molgenis.charts.highcharts.basic.Marker;
import org.molgenis.charts.highcharts.basic.Series;
import org.molgenis.charts.highcharts.basic.SeriesType;
import org.molgenis.data.meta.AttributeType;
import org.springframework.stereotype.Component;

@Component
public class HighchartSeriesUtil {
    public List<Series> parseToXYDataSeriesList(List<XYDataSerie> xYDataSeries) {
        ArrayList<Series> series = new ArrayList<Series>();
        for (XYDataSerie xYDataSerie : xYDataSeries) {
            series.add(this.parsexYDataSerieToSeries(xYDataSerie));
        }
        return series;
    }

    public List<Series> parseToBoxPlotSeriesList(List<BoxPlotSerie> boxPlotSeries) {
        ArrayList<Series> series = new ArrayList<Series>();
        for (BoxPlotSerie boxPlotSerie : boxPlotSeries) {
            series.add(this.parseBoxPlotSerieToSeries(boxPlotSerie));
        }
        return series;
    }

    public Series parsexYDataSerieToSeries(XYDataSerie xYDataSerie) {
        Series series = new Series();
        series.setName(xYDataSerie.getName());
        series.setType(SeriesType.getSeriesType(xYDataSerie.getType()));
        series.setData(this.parseXYDataToList(xYDataSerie.getData(), xYDataSerie.getAttributeXFieldTypeEnum(), xYDataSerie.getAttributeYFieldTypeEnum()));
        if (MolgenisSerieType.SCATTER.equals((Object)xYDataSerie.getType()) && (AttributeType.DATE.equals((Object)xYDataSerie.getAttributeXFieldTypeEnum()) || AttributeType.DATE_TIME.equals((Object)xYDataSerie.getAttributeXFieldTypeEnum()))) {
            series.setLineWidth(0);
            series.setMarker(new Marker(true, 4));
            series.setType(SeriesType.getSeriesType(MolgenisSerieType.LINE));
        }
        return series;
    }

    public Series parseBoxPlotSerieToSeries(BoxPlotSerie boxPlotSerie) {
        Series series = new Series();
        series.setName(boxPlotSerie.getName());
        series.setData(new ArrayList<Double[]>(boxPlotSerie.getData()));
        return series;
    }

    public List<Object> parseXYDataToList(List<XYData> xydata, AttributeType xValueFieldTypeEnum, AttributeType yValueFieldTypeEnum) {
        ArrayList<Object> data = new ArrayList<Object>();
        for (XYData xYData : xydata) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(this.convertValue(xValueFieldTypeEnum, xYData.getXvalue()));
            list.add(this.convertValue(yValueFieldTypeEnum, xYData.getYvalue()));
            data.add(list);
        }
        return data;
    }

    public Object convertValue(AttributeType fieldTypeEnum, Object value) {
        if (AttributeType.DATE_TIME.equals((Object)fieldTypeEnum)) {
            return this.convertDateTimeToMilliseconds((Date)value);
        }
        if (AttributeType.DATE.equals((Object)fieldTypeEnum)) {
            return this.convertDateToMilliseconds((Date)value);
        }
        return value;
    }

    public Long convertDateToMilliseconds(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Calendar calendarConverted = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.ENGLISH);
        calendarConverted.clear();
        calendarConverted.set(calendar.get(1), calendar.get(2), calendar.get(5));
        return calendarConverted.getTimeInMillis();
    }

    public Long convertDateTimeToMilliseconds(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Calendar calendarConverted = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.ENGLISH);
        calendarConverted.clear();
        calendarConverted.set(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
        return calendarConverted.getTimeInMillis();
    }
}

