/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.charts.calculations;

import java.util.List;
import org.molgenis.charts.MolgenisChartException;

public class BoxPlotCalcUtil {
    public static Double[] calcBoxPlotValues(List<Double> sortedDataAscendingOrder) {
        if (null == sortedDataAscendingOrder) {
            throw new MolgenisChartException("The sortedDataAscendingOrder list is null");
        }
        if (sortedDataAscendingOrder.isEmpty()) {
            return new Double[]{0.0, 0.0, 0.0, 0.0, 0.0};
        }
        Double[] plotBoxValues = new Double[]{BoxPlotCalcUtil.minimum(sortedDataAscendingOrder), BoxPlotCalcUtil.firstQuantile(sortedDataAscendingOrder), BoxPlotCalcUtil.median(sortedDataAscendingOrder), BoxPlotCalcUtil.thirdQuantile(sortedDataAscendingOrder), BoxPlotCalcUtil.maximum(sortedDataAscendingOrder)};
        return plotBoxValues;
    }

    public static double iqr(double thirdQuantile, double firstQuantile) {
        return thirdQuantile - firstQuantile;
    }

    public static Double minimum(List<Double> sortedDataAscendingOrder) {
        return BoxPlotCalcUtil.interpolateLinearlyQuantile(sortedDataAscendingOrder, 0.0);
    }

    public static Double maximum(List<Double> sortedDataAscendingOrder) {
        return BoxPlotCalcUtil.interpolateLinearlyQuantile(sortedDataAscendingOrder, 1.0);
    }

    public static Double median(List<Double> sortedDataAscendingOrder) {
        return BoxPlotCalcUtil.interpolateLinearlyQuantile(sortedDataAscendingOrder, 0.5);
    }

    public static Double firstQuantile(List<Double> sortedDataAscendingOrder) {
        return BoxPlotCalcUtil.interpolateLinearlyQuantile(sortedDataAscendingOrder, 0.25);
    }

    public static Double thirdQuantile(List<Double> sortedDataAscendingOrder) {
        return BoxPlotCalcUtil.interpolateLinearlyQuantile(sortedDataAscendingOrder, 0.75);
    }

    private static Double interpolateLinearlyQuantile(List<Double> sortedDataAscendingOrder, Double p) {
        Double quantile;
        int rightIndex;
        int n = sortedDataAscendingOrder.size();
        double position = 1.0 + p * (double)(n - 1);
        int leftIndex = (int)Math.floor(position) - 1;
        if (leftIndex == (rightIndex = (int)Math.ceil(position) - 1)) {
            quantile = sortedDataAscendingOrder.get(leftIndex);
        } else {
            Double leftIndexValue = sortedDataAscendingOrder.get(leftIndex);
            Double rightIndexValue = sortedDataAscendingOrder.get(rightIndex);
            quantile = leftIndexValue + 0.5 * (rightIndexValue - leftIndexValue);
        }
        return quantile;
    }
}

