/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.charts.highcharts.convert;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import org.molgenis.charts.MolgenisSerieType;
import org.molgenis.charts.data.BoxPlotSerie;
import org.molgenis.charts.data.XYData;
import org.molgenis.charts.data.XYDataSerie;
import org.molgenis.charts.highcharts.basic.Marker;
import org.molgenis.charts.highcharts.basic.Series;
import org.molgenis.charts.highcharts.basic.SeriesType;
import org.molgenis.data.meta.AttributeType;
import org.springframework.stereotype.Component;

@Component
public class HighchartSeriesUtil {
    public List<Series> parseToXYDataSeriesList(List<XYDataSerie> xYDataSeries) {
        ArrayList<Series> series = new ArrayList<Series>();
        for (XYDataSerie xYDataSerie : xYDataSeries) {
            series.add(this.parsexYDataSerieToSeries(xYDataSerie));
        }
        return series;
    }

    public List<Series> parseToBoxPlotSeriesList(List<BoxPlotSerie> boxPlotSeries) {
        ArrayList<Series> series = new ArrayList<Series>();
        for (BoxPlotSerie boxPlotSerie : boxPlotSeries) {
            series.add(this.parseBoxPlotSerieToSeries(boxPlotSerie));
        }
        return series;
    }

    public Series parsexYDataSerieToSeries(XYDataSerie xYDataSerie) {
        Series series = new Series();
        series.setName(xYDataSerie.getName());
        series.setType(SeriesType.getSeriesType(xYDataSerie.getType()));
        series.setData(this.parseXYDataToList(xYDataSerie.getData(), xYDataSerie.getAttributeXFieldTypeEnum(), xYDataSerie.getAttributeYFieldTypeEnum()));
        if (MolgenisSerieType.SCATTER.equals((Object)xYDataSerie.getType()) && (AttributeType.DATE.equals((Object)xYDataSerie.getAttributeXFieldTypeEnum()) || AttributeType.DATE_TIME.equals((Object)xYDataSerie.getAttributeXFieldTypeEnum()))) {
            series.setLineWidth(0);
            series.setMarker(new Marker(true, 4));
            series.setType(SeriesType.getSeriesType(MolgenisSerieType.LINE));
        }
        return series;
    }

    public Series parseBoxPlotSerieToSeries(BoxPlotSerie boxPlotSerie) {
        Series series = new Series();
        series.setName(boxPlotSerie.getName());
        series.setData(new ArrayList<Double[]>(boxPlotSerie.getData()));
        return series;
    }

    public List<Object> parseXYDataToList(List<XYData> xydata, AttributeType xValueFieldTypeEnum, AttributeType yValueFieldTypeEnum) {
        ArrayList<Object> data = new ArrayList<Object>();
        for (XYData xYData : xydata) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(this.convertValue(xValueFieldTypeEnum, xYData.getXvalue()));
            list.add(this.convertValue(yValueFieldTypeEnum, xYData.getYvalue()));
            data.add(list);
        }
        return data;
    }

    public Object convertValue(AttributeType attributeType, Object value) {
        if (AttributeType.DATE_TIME.equals((Object)attributeType)) {
            return ((Instant)value).toEpochMilli();
        }
        if (AttributeType.DATE.equals((Object)attributeType)) {
            return ((LocalDate)value).atStartOfDay(ZoneOffset.UTC).toInstant().toEpochMilli();
        }
        return value;
    }
}

