/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.charts;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.xml.stream.FactoryConfigurationError;
import org.molgenis.charts.AbstractChart;
import org.molgenis.charts.BoxPlotChart;
import org.molgenis.charts.ChartDataService;
import org.molgenis.charts.ChartVisualizationService;
import org.molgenis.charts.ChartVisualizationServiceFactory;
import org.molgenis.charts.MimeTypes;
import org.molgenis.charts.XYDataChart;
import org.molgenis.charts.charttypes.HeatMapChart;
import org.molgenis.charts.data.DataMatrix;
import org.molgenis.charts.highcharts.basic.Options;
import org.molgenis.charts.requests.BoxPlotChartRequest;
import org.molgenis.charts.requests.HeatMapRequest;
import org.molgenis.charts.requests.XYDataChartRequest;
import org.molgenis.data.Entity;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.file.FileStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/charts"})
public class ChartController {
    private static final Logger LOG = LoggerFactory.getLogger(ChartController.class);
    public static final String URI = "/charts";
    private final ChartDataService chartDataService;
    private final ChartVisualizationServiceFactory chartVisualizationServiceFactory;
    private final FileStore fileStore;

    public ChartController(ChartDataService chartDataService, ChartVisualizationServiceFactory chartVisualizationServiceFactory, FileStore fileStore) {
        if (chartDataService == null) {
            throw new IllegalArgumentException("chartDataService is null");
        }
        if (chartVisualizationServiceFactory == null) {
            throw new IllegalArgumentException("chartVisualizationServiceFactory is null");
        }
        if (fileStore == null) {
            throw new IllegalArgumentException("fileStore is null");
        }
        this.chartDataService = chartDataService;
        this.chartVisualizationServiceFactory = chartVisualizationServiceFactory;
        this.fileStore = fileStore;
    }

    @PostMapping(value={"/xydatachart"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public Options renderXYDataChart(@Valid @RequestBody XYDataChartRequest request, Model model) {
        QueryImpl<Entity> query = request.getQuery();
        XYDataChart xYDataChart = this.chartDataService.getXYDataChart(request.getEntity(), request.getX(), request.getY(), request.getSplit(), query != null ? query.getRules() : Collections.emptyList());
        xYDataChart.setTitle(request.getTitle());
        xYDataChart.setHeight(request.getHeight());
        xYDataChart.setWidth(request.getWidth());
        xYDataChart.setType(AbstractChart.MolgenisChartType.valueOf(request.getType()));
        xYDataChart.setxAxisLabel(request.getxAxisLabel());
        xYDataChart.setyAxisLabel(request.getyAxisLabel());
        ChartVisualizationService service = this.chartVisualizationServiceFactory.getVisualizationService(AbstractChart.MolgenisChartType.valueOf(request.getType()));
        return (Options)service.renderChart(xYDataChart, model);
    }

    @PostMapping(value={"/boxplot"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public Options renderPlotBoxChart(@Valid @RequestBody BoxPlotChartRequest request, Model model) {
        QueryImpl<Entity> query = request.getQuery();
        BoxPlotChart chart = this.chartDataService.getBoxPlotChart(request.getEntity(), request.getObservableFeature(), query != null ? query.getRules() : Collections.emptyList(), request.getSplit(), request.getScale());
        chart.setHeight(request.getHeight());
        chart.setWidth(request.getWidth());
        chart.setTitle(request.getTitle());
        ChartVisualizationService service = this.chartVisualizationServiceFactory.getVisualizationService(AbstractChart.MolgenisChartType.BOXPLOT_CHART);
        return (Options)service.renderChart(chart, model);
    }

    @GetMapping(value={"/get/{name}.{extension}"})
    public void getFile(OutputStream out, @PathVariable(value="name") String name, @PathVariable(value="extension") String extension, HttpServletResponse response) throws IOException {
        File f = this.fileStore.getFile(name + "." + extension);
        if (!f.exists()) {
            LOG.warn("Chart file not found [" + name + "]");
            response.sendError(404);
            return;
        }
        response.setContentType(MimeTypes.getContentType(extension));
        FileCopyUtils.copy((InputStream)new FileInputStream(f), (OutputStream)out);
    }

    @PostMapping(value={"/heatmap"}, consumes={"application/json"})
    @ResponseBody
    public String renderHeatMap(@Valid @RequestBody HeatMapRequest request, Model model) throws FactoryConfigurationError {
        DataMatrix matrix = this.chartDataService.getDataMatrix(request.getEntity(), request.getX(), request.getY(), request.getQueryRules());
        HeatMapChart chart = new HeatMapChart(matrix);
        chart.setTitle(request.getTitle());
        chart.setWidth(request.getWidth());
        chart.setHeight(request.getHeight());
        chart.setxLabel(request.getxLabel());
        chart.setyLabel(request.getyLabel());
        chart.setScale(request.getScale());
        ChartVisualizationService service = this.chartVisualizationServiceFactory.getVisualizationService(AbstractChart.MolgenisChartType.HEAT_MAP);
        return (String)service.renderChart(chart, model);
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Map<String, String> handleRuntimeException(RuntimeException e) {
        LOG.error(null, (Throwable)e);
        return Collections.singletonMap("errorMessage", "An error occurred. Please contact the administrator.<br />Message:" + e.getMessage());
    }
}

