/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.molgenis.util.ApplicationContextProvider;
import org.molgenis.util.ListEscapeUtils;
import org.springframework.core.convert.ConversionService;

public class DataConverter {
    private static ConversionService conversionService;

    public static <T> T convert(Object source, Class<T> targetType) {
        if (source == null) {
            return null;
        }
        if (targetType.isAssignableFrom(source.getClass())) {
            return (T)source;
        }
        if (conversionService == null) {
            conversionService = (ConversionService)ApplicationContextProvider.getApplicationContext().getBean(ConversionService.class);
        }
        return (T)conversionService.convert(source, targetType);
    }

    public static String toString(Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof String) {
            return (String)source;
        }
        return DataConverter.convert(source, String.class);
    }

    public static Integer toInt(Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof Integer) {
            return (Integer)source;
        }
        return DataConverter.convert(source, Integer.class);
    }

    public static Long toLong(Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof Long) {
            return (Long)source;
        }
        return DataConverter.convert(source, Long.class);
    }

    public static Boolean toBoolean(Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof Boolean) {
            return (Boolean)source;
        }
        return DataConverter.convert(source, Boolean.class);
    }

    public static Double toDouble(Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof Double) {
            return (Double)source;
        }
        return DataConverter.convert(source, Double.class);
    }

    public static Date toDate(Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof Date) {
            return (Date)source;
        }
        return DataConverter.convert(source, Date.class);
    }

    public static Timestamp toTimestamp(Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof Timestamp) {
            return (Timestamp)source;
        }
        if (source instanceof Date) {
            return new Timestamp(((Date)source).getTime());
        }
        return new Timestamp(DataConverter.convert(source, Date.class).getTime());
    }

    public static List<String> toList(Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof List) {
            return (List)source;
        }
        if (source instanceof String) {
            return ListEscapeUtils.toList((String)source);
        }
        return ListEscapeUtils.toList(source.toString());
    }

    public static List<Integer> toIntList(Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof List) {
            ArrayList<Integer> intList = new ArrayList<Integer>();
            for (Object o : (List)source) {
                if (o instanceof Integer) {
                    intList.add((Integer)o);
                    continue;
                }
                if (!(o instanceof String)) continue;
                intList.add(Integer.parseInt((String)o));
            }
            return intList;
        }
        if (source instanceof Integer) {
            return new ArrayList<Integer>(Arrays.asList((Integer)source));
        }
        return null;
    }
}

