/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.support;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.molgenis.data.EntitySource;
import org.molgenis.data.FileBasedEntitySourceFactory;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.io.processor.CellProcessor;
import org.springframework.util.StringUtils;

public abstract class AbstractFileBasedEntitySourceFactory
implements FileBasedEntitySourceFactory {
    private final String urlPrefix;
    private final List<String> fileExtensions;
    private List<CellProcessor> cellProcessors;

    protected AbstractFileBasedEntitySourceFactory(String urlPrefix, List<String> fileExtensions, List<CellProcessor> cellProcessors) {
        this.urlPrefix = urlPrefix;
        this.fileExtensions = fileExtensions;
        this.cellProcessors = cellProcessors;
    }

    @Override
    public String getUrlPrefix() {
        return this.urlPrefix;
    }

    @Override
    public void addCellProcessor(CellProcessor cellProcessor) {
        if (this.cellProcessors == null) {
            this.cellProcessors = new ArrayList<CellProcessor>();
        }
        this.cellProcessors.add(cellProcessor);
    }

    @Override
    public EntitySource create(String url) {
        try {
            return this.createInternal(url, this.cellProcessors);
        }
        catch (IOException e) {
            throw new MolgenisDataException("Error creating EntitySource using url [" + url + "]", e);
        }
    }

    @Override
    public EntitySource create(File file) {
        String extension = StringUtils.getFilenameExtension((String)file.getName());
        if (!this.fileExtensions.contains(extension)) {
            throw new MolgenisDataException("Unsupported file extension [" + extension + "]");
        }
        try {
            return this.createInternal(file, this.cellProcessors);
        }
        catch (IOException e) {
            throw new MolgenisDataException("Error creating EntitySource using file [" + file.getAbsolutePath() + "]", e);
        }
    }

    @Override
    public List<String> getFileExtensions() {
        return this.fileExtensions;
    }

    protected abstract EntitySource createInternal(String var1, List<CellProcessor> var2) throws IOException;

    protected abstract EntitySource createInternal(File var1, List<CellProcessor> var2) throws IOException;
}

